/*
 * Decompiled with CFR 0.152.
 */
package simulator.sampler;

import parser.ast.Expression;
import parser.ast.ExpressionTemporal;
import prism.ModelGenerator;
import prism.PrismException;
import simulator.Path;
import simulator.sampler.SamplerBoolean;

public class SamplerBoundedUntilDisc
extends SamplerBoolean {
    private Expression left;
    private Expression right;
    private int lb;
    private int ub;
    private boolean haveUpperBound;

    public SamplerBoundedUntilDisc(ExpressionTemporal expressionTemporal) throws PrismException {
        if (expressionTemporal.getOperator() != 2) {
            throw new PrismException("Error creating Sampler");
        }
        this.left = expressionTemporal.getOperand1();
        this.right = expressionTemporal.getOperand2();
        if (expressionTemporal.getLowerBound() != null) {
            this.lb = expressionTemporal.getLowerBound().evaluateInt();
            if (expressionTemporal.lowerBoundIsStrict()) {
                ++this.lb;
            }
        } else {
            this.lb = 0;
        }
        if (this.lb < 0) {
            throw new PrismException("Invalid lower bound in " + String.valueOf(expressionTemporal));
        }
        if (expressionTemporal.getUpperBound() != null) {
            this.haveUpperBound = true;
            this.ub = expressionTemporal.getUpperBound().evaluateInt();
            if (expressionTemporal.upperBoundIsStrict()) {
                --this.ub;
            }
            if (this.ub < 0) {
                throw new PrismException("Invalid upper bound in " + String.valueOf(expressionTemporal));
            }
        } else {
            this.haveUpperBound = false;
        }
        this.reset();
        this.resetStats();
    }

    @Override
    public boolean update(Path path, ModelGenerator modelGenerator) throws PrismException {
        if (this.valueKnown) {
            return true;
        }
        long l = path.size();
        if (this.haveUpperBound && l > (long)this.ub) {
            this.valueKnown = true;
            this.value = false;
        } else if (l < (long)this.lb) {
            if (!path.evaluateBooleanInCurrentState(this.left)) {
                this.valueKnown = true;
                this.value = false;
            }
        } else if (path.evaluateBooleanInCurrentState(this.right)) {
            this.valueKnown = true;
            this.value = true;
        } else if (!path.evaluateBooleanInCurrentState(this.left)) {
            this.valueKnown = true;
            this.value = false;
        } else if (modelGenerator != null && modelGenerator.isDeadlock()) {
            this.valueKnown = true;
            this.value = false;
        }
        return this.valueKnown;
    }

    @Override
    public boolean needsBoundedNumSteps() {
        return this.haveUpperBound;
    }
}

