/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.util.ArrayList;
import java.util.Observable;
import settings.Setting;
import settings.SettingDisplay;
import settings.SettingOwner;

public class DefaultSettingOwner
extends Observable
implements SettingOwner {
    private String name;
    private int id;
    private SettingDisplay display;
    private ArrayList<Setting> settings;

    public DefaultSettingOwner(String string, int n) {
        this.name = string;
        this.id = n;
        this.display = null;
        this.settings = new ArrayList();
    }

    public int compareTo(Object object) {
        if (object instanceof SettingOwner) {
            SettingOwner settingOwner = (SettingOwner)object;
            if (this.getSettingOwnerID() < settingOwner.getSettingOwnerID()) {
                return -1;
            }
            if (this.getSettingOwnerID() > settingOwner.getSettingOwnerID()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public SettingDisplay getDisplay() {
        return this.display;
    }

    @Override
    public int getNumSettings() {
        return this.settings.size();
    }

    @Override
    public Setting getSetting(int n) {
        return this.settings.get(n);
    }

    @Override
    public String getSettingOwnerClassName() {
        return "";
    }

    @Override
    public int getSettingOwnerID() {
        return this.id;
    }

    @Override
    public String getSettingOwnerName() {
        return this.name;
    }

    @Override
    public void notifySettingChanged(Setting setting) {
        this.setChanged();
        this.notifyObservers(setting);
    }

    @Override
    public void setDisplay(SettingDisplay settingDisplay) {
        this.display = settingDisplay;
    }

    public void addSetting(Setting setting) {
        this.settings.add(setting);
    }

    public Setting getFromKey(String string) {
        for (int i = 0; i < this.getNumSettings(); ++i) {
            if (!this.getSetting(i).equals(string)) continue;
            return this.getSetting(i);
        }
        return null;
    }
}

