/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.Arrays;
import java.util.Comparator;
import prism.Point;

public class PermutedLexicographicComparator
implements Comparator<Point> {
    private int[] permutation;
    private boolean[] increasing;

    public PermutedLexicographicComparator(int[] nArray, boolean[] blArray) {
        int[] nArray2 = (int[])nArray.clone();
        this.increasing = blArray;
        Arrays.sort(nArray2);
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] == i) continue;
            throw new IllegalArgumentException("The array is not a valid permutation");
        }
        this.permutation = nArray;
    }

    @Override
    public int compare(Point point, Point point2) {
        if (point.getDimension() > this.permutation.length || point2.getDimension() > this.permutation.length) {
            throw new ClassCastException("The dimension of the point is greater that comparator's dimension");
        }
        if (point.isCloseTo(point2)) {
            return 0;
        }
        return this.compare(point, point2, 0);
    }

    protected int compare(Point point, Point point2, int n) {
        int n2 = this.permutation[n];
        if (point.getCoord(n2) < point2.getCoord(n2)) {
            return this.increasing[n2] ? -1 : 1;
        }
        if (point.getCoord(n2) > point2.getCoord(n2)) {
            return this.increasing[n2] ? 1 : -1;
        }
        return this.compare(point, point2, n + 1);
    }
}

