/*
 * Decompiled with CFR 0.152.
 */
package parser.visitor;

import java.util.List;
import parser.ast.ConstantList;
import parser.ast.ExpressionConstant;
import parser.ast.ExpressionIdent;
import parser.type.Type;
import parser.visitor.ASTTraverseModify;
import prism.PrismLangException;

public class FindAllConstants
extends ASTTraverseModify {
    private ConstantList constantList;
    private List<String> constIdents;
    private List<Type> constTypes;

    public FindAllConstants(ConstantList constantList) {
        this.constantList = constantList;
    }

    public FindAllConstants(List<String> list, List<Type> list2) {
        this.constIdents = list;
        this.constTypes = list2;
    }

    private int getConstantIndex(String string) {
        if (this.constantList != null) {
            return this.constantList.getConstantIndex(string);
        }
        return this.constIdents.indexOf(string);
    }

    private Type getConstantType(int n) {
        if (this.constantList != null) {
            return this.constantList.getConstantType(n);
        }
        return this.constTypes.get(n);
    }

    @Override
    public Object visit(ExpressionIdent expressionIdent) throws PrismLangException {
        int n = this.getConstantIndex(expressionIdent.getName());
        if (n != -1) {
            ExpressionConstant expressionConstant = new ExpressionConstant(expressionIdent.getName(), this.getConstantType(n));
            expressionConstant.setPosition(expressionIdent);
            return expressionConstant;
        }
        return expressionIdent;
    }
}

