/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.List;
import parser.ast.ModulesFile;
import parser.ast.SystemDefn;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class SystemRename
extends SystemDefn {
    private SystemDefn operand;
    private ArrayList<String> from = new ArrayList();
    private ArrayList<String> to = new ArrayList();

    public SystemRename() {
    }

    public SystemRename(SystemDefn systemDefn) {
        this();
        this.operand = systemDefn;
    }

    public void setOperand(SystemDefn systemDefn) {
        this.operand = systemDefn;
    }

    public void addRename(String string, String string2) {
        this.from.add(string);
        this.to.add(string2);
    }

    public void setRename(int n, String string, String string2) {
        this.from.set(n, string);
        this.to.set(n, string2);
    }

    public SystemDefn getOperand() {
        return this.operand;
    }

    public int getNumRenames() {
        return this.from.size();
    }

    public String getFrom(int n) {
        return this.from.get(n);
    }

    public String getTo(int n) {
        return this.to.get(n);
    }

    public String getNewName(String string) {
        int n = this.from.indexOf(string);
        if (n == -1) {
            return string;
        }
        return this.to.get(n);
    }

    @Override
    public void getModules(List<String> list) {
        this.operand.getModules(list);
    }

    @Override
    public void getModules(List<String> list, ModulesFile modulesFile) {
        this.operand.getModules(list, modulesFile);
    }

    @Override
    public void getSynchs(List<String> list) {
        int n = this.getNumRenames();
        for (int i = 0; i < n; ++i) {
            String string = this.getTo(i);
            if (list.contains(string)) continue;
            list.add(string);
        }
        this.operand.getSynchs(list);
    }

    @Override
    public void getSynchs(List<String> list, ModulesFile modulesFile) {
        int n = this.getNumRenames();
        for (int i = 0; i < n; ++i) {
            String string = this.getTo(i);
            if (list.contains(string)) continue;
            list.add(string);
        }
        this.operand.getSynchs(list, modulesFile);
    }

    @Override
    public void getReferences(List<String> list) {
        this.operand.getReferences(list);
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        Object object = "";
        object = (String)object + String.valueOf(this.operand) + "{";
        int n = this.getNumRenames();
        for (int i = 0; i < n - 1; ++i) {
            object = (String)object + this.getFrom(i) + "<-" + this.getTo(i) + ",";
        }
        if (n > 0) {
            object = (String)object + this.getFrom(n - 1) + "<-" + this.getTo(n - 1);
        }
        object = (String)object + "}";
        return object;
    }

    @Override
    public SystemRename deepCopy(DeepCopy deepCopy) throws PrismLangException {
        this.operand = deepCopy.copy(this.operand);
        return this;
    }

    @Override
    public SystemRename clone() {
        SystemRename systemRename = (SystemRename)super.clone();
        systemRename.from = (ArrayList)this.from.clone();
        systemRename.to = (ArrayList)this.to.clone();
        return systemRename;
    }
}

