/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.List;
import parser.EvaluateContext;
import parser.IdentUsage;
import parser.Values;
import parser.ast.ASTElement;
import parser.ast.ConstantList;
import parser.ast.Expression;
import parser.ast.FormulaList;
import parser.ast.LabelList;
import parser.ast.ModulesFile;
import parser.ast.Property;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import parser.visitor.PropertiesSemanticCheck;
import prism.ModelInfo;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismUtils;

public class PropertiesFile
extends ASTElement {
    private ModulesFile modulesFile;
    private ModelInfo modelInfo;
    private FormulaList formulaList;
    private LabelList labelList;
    private LabelList combinedLabelList;
    private ConstantList constantList;
    private ArrayList<Property> properties;
    private IdentUsage identUsage;
    private IdentUsage quotedIdentUsage;
    private EvaluateContext ecUndefined;
    private Values constantValues;

    public PropertiesFile(ModelInfo modelInfo) {
        this.setModelInfo(modelInfo);
        this.formulaList = new FormulaList();
        this.labelList = new LabelList();
        this.combinedLabelList = new LabelList();
        this.constantList = new ConstantList();
        this.properties = new ArrayList();
        this.identUsage = new IdentUsage();
        this.quotedIdentUsage = new IdentUsage(true);
        this.ecUndefined = null;
        this.constantValues = null;
    }

    public void setModelInfo(ModelInfo modelInfo) {
        if (modelInfo == null) {
            this.modulesFile = new ModulesFile();
            this.modelInfo = this.modulesFile;
            this.modulesFile.setFormulaList(new FormulaList());
            this.modulesFile.setConstantList(new ConstantList());
        } else if (modelInfo instanceof ModulesFile) {
            this.modulesFile = (ModulesFile)modelInfo;
            this.modelInfo = this.modulesFile;
        } else {
            this.modelInfo = modelInfo;
            this.modulesFile = new ModulesFile();
            this.modulesFile.setFormulaList(new FormulaList());
            this.modulesFile.setConstantList(new ConstantList());
        }
    }

    public void setFormulaList(FormulaList formulaList) {
        this.formulaList = formulaList;
    }

    public void setLabelList(LabelList labelList) {
        this.labelList = labelList;
    }

    public void setConstantList(ConstantList constantList) {
        this.constantList = constantList;
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public void addProperty(Expression expression, String string) {
        this.properties.add(new Property(expression, null, string));
    }

    public void setPropertyObject(int n, Property property) {
        this.properties.set(n, property);
    }

    public void setPropertyExpression(int n, Expression expression) {
        this.properties.get(n).setExpression(expression);
    }

    public void insertPropertiesFile(PropertiesFile propertiesFile) throws PrismLangException {
        int n;
        FormulaList formulaList = propertiesFile.formulaList;
        int n2 = formulaList.size();
        for (n = 0; n < n2; ++n) {
            this.formulaList.addFormula(formulaList.getFormulaNameIdent(n), formulaList.getFormula(n));
        }
        LabelList labelList = propertiesFile.labelList;
        n2 = labelList.size();
        for (n = 0; n < n2; ++n) {
            this.labelList.addLabel(labelList.getLabelNameIdent(n), labelList.getLabel(n));
        }
        ConstantList constantList = propertiesFile.constantList;
        n2 = constantList.size();
        for (n = 0; n < n2; ++n) {
            this.constantList.addConstant(constantList.getConstantNameIdent(n), constantList.getConstant(n), constantList.getConstantType(n));
        }
        n2 = propertiesFile.properties.size();
        for (n = 0; n < n2; ++n) {
            this.properties.add(propertiesFile.properties.get(n));
        }
        this.tidyUp();
    }

    public FormulaList getFormulaList() {
        return this.formulaList;
    }

    public LabelList getLabelList() {
        return this.labelList;
    }

    public LabelList getCombinedLabelList() {
        return this.combinedLabelList;
    }

    public ConstantList getConstantList() {
        return this.constantList;
    }

    public int getNumProperties() {
        return this.properties.size();
    }

    public Property getPropertyObject(int n) {
        return this.properties.get(n);
    }

    public Expression getProperty(int n) {
        return this.properties.get(n).getExpression();
    }

    public String getPropertyName(int n) {
        return this.properties.get(n).getName();
    }

    public String getPropertyComment(int n) {
        return this.properties.get(n).getComment();
    }

    public Property getPropertyObjectByName(String string) {
        int n = this.getNumProperties();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.getPropertyName(i))) continue;
            return this.getPropertyObject(i);
        }
        return null;
    }

    public int getPropertyIndexByName(String string) {
        int n = this.getNumProperties();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.getPropertyName(i))) continue;
            return i;
        }
        return -1;
    }

    public Property lookUpPropertyObjectByName(String string) {
        return this.getPropertyObjectByName(string);
    }

    private void checkAndAddIdentifier(String string, ASTElement aSTElement, String string2) throws PrismLangException {
        this.modelInfo.checkIdent(string, aSTElement, string2);
        this.identUsage.checkAndAddIdentifier(string, aSTElement, string2, "the properties");
    }

    public boolean isIdentUsed(String string) {
        return this.identUsage.isIdentUsed(string);
    }

    private void checkAndAddQuotedIdentifier(String string, ASTElement aSTElement, String string2) throws PrismLangException {
        this.modelInfo.checkQuotedIdent(string, aSTElement, string2);
        this.quotedIdentUsage.checkAndAddIdentifier(string, aSTElement, string2, "the properties");
    }

    public void tidyUp() throws PrismLangException {
        this.identUsage.clear();
        this.checkFormulaIdents();
        this.findAllFormulas(this.modulesFile.getFormulaList());
        this.findAllFormulas(this.formulaList);
        this.formulaList.findCycles();
        this.expandFormulas(this.modulesFile.getFormulaList(), false);
        this.expandFormulas(this.formulaList, false);
        this.checkLabelIdents();
        this.checkConstantIdents();
        this.findAllConstants(this.modulesFile.getConstantList());
        this.findAllConstants(this.constantList);
        this.constantList.findCycles();
        this.checkPropertyNames();
        this.findAllVars(this.modelInfo.getVarNames(), this.modelInfo.getVarTypes());
        this.findAllObsRefs(this.modelInfo.getObservableNames(), this.modelInfo.getObservableTypes());
        this.findAllPropRefs(null, this);
        this.findCyclesInPropertyReferences();
        this.doSemanticChecks();
        this.typeCheck(this);
        this.setSomeUndefinedConstants(EvaluateContext.create());
    }

    private void checkFormulaIdents() throws PrismLangException {
        int n = this.formulaList.size();
        for (int i = 0; i < n; ++i) {
            String string = this.formulaList.getFormulaName(i);
            this.checkAndAddIdentifier(string, this.formulaList.getFormulaNameIdent(i), "formula");
        }
    }

    private void checkLabelIdents() throws PrismLangException {
        int n;
        int n2 = this.labelList.size();
        for (int i = 0; i < n2; ++i) {
            String string = this.labelList.getLabelName(i);
            this.checkAndAddQuotedIdentifier(string, this.labelList.getLabelNameIdent(i), "label");
        }
        this.combinedLabelList = new LabelList();
        LabelList labelList = this.modulesFile.getLabelList();
        n2 = labelList.size();
        for (n = 0; n < n2; ++n) {
            this.combinedLabelList.addLabel(labelList.getLabelNameIdent(n), labelList.getLabel(n).deepCopy());
        }
        n2 = this.labelList.size();
        for (n = 0; n < n2; ++n) {
            this.combinedLabelList.addLabel(this.labelList.getLabelNameIdent(n), this.labelList.getLabel(n));
        }
    }

    private void checkConstantIdents() throws PrismLangException {
        int n = this.constantList.size();
        for (int i = 0; i < n; ++i) {
            String string = this.constantList.getConstantName(i);
            this.checkAndAddIdentifier(string, this.constantList.getConstantNameIdent(i), "constant");
        }
    }

    private void checkPropertyNames() throws PrismLangException {
        int n = this.properties.size();
        for (int i = 0; i < n; ++i) {
            String string = this.properties.get(i).getName();
            if (string == null) continue;
            this.checkAndAddQuotedIdentifier(string, this.getPropertyObject(i), "property");
        }
    }

    public void findCyclesInPropertyReferences() throws PrismLangException {
        Object object;
        int n;
        int n2 = this.properties.size();
        boolean[][] blArray = new boolean[n2][n2];
        for (n = 0; n < n2; ++n) {
            object = this.properties.get(n).getExpression();
            List<String> list = ((ASTElement)object).getAllPropRefs();
            for (int i = 0; i < list.size(); ++i) {
                int n3 = this.getPropertyIndexByName(list.get(i));
                if (n3 == -1) continue;
                blArray[n][n3] = true;
            }
        }
        n = PrismUtils.findCycle(blArray);
        if (n != -1) {
            object = "Cyclic dependency in property references from property \"" + this.getPropertyName(n) + "\"";
            throw new PrismLangException((String)object, this.getPropertyObject(n));
        }
    }

    private void doSemanticChecks() throws PrismLangException {
        PropertiesSemanticCheck propertiesSemanticCheck = new PropertiesSemanticCheck(this, this.modelInfo);
        this.accept(propertiesSemanticCheck);
    }

    public List<String> getUndefinedConstants() {
        return this.constantList.getUndefinedConstants();
    }

    public List<String> getUndefinedConstantsUsedInLabels() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.labelList.size();
        for (int i = 0; i < n; ++i) {
            Expression expression = this.labelList.getLabel(i);
            List<String> list = expression.getAllUndefinedConstantsRecursively(this.constantList, this.combinedLabelList, null);
            for (String string : list) {
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public List<String> getUndefinedConstantsUsedInProperty(Property property) {
        return property.getExpression().getAllUndefinedConstantsRecursively(this.constantList, this.combinedLabelList, this);
    }

    public List<String> getUndefinedConstantsUsedInProperties(List<Property> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Property property : list) {
            List<String> list2 = property.getExpression().getAllUndefinedConstantsRecursively(this.constantList, this.combinedLabelList, this);
            for (String string : list2) {
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public void setSomeUndefinedConstants(EvaluateContext evaluateContext) throws PrismLangException {
        this.ecUndefined = evaluateContext == null ? EvaluateContext.create() : EvaluateContext.create(evaluateContext);
        EvaluateContext evaluateContext2 = EvaluateContext.create(this.ecUndefined).addConstantValues(this.modulesFile.getConstantValues());
        this.constantValues = this.constantList.evaluateSomeConstants(evaluateContext2);
    }

    public void setSomeUndefinedConstants(Values values) throws PrismException {
        this.setSomeUndefinedConstants(EvaluateContext.create(values));
    }

    @Deprecated
    public void setSomeUndefinedConstants(Values values, boolean bl) throws PrismException {
        this.setSomeUndefinedConstants(EvaluateContext.create(values, bl));
    }

    @Deprecated
    public void setUndefinedConstants(Values values) throws PrismException {
        this.setSomeUndefinedConstants(values);
    }

    public boolean isDefinedConstant(String string) {
        return this.constantList.isDefinedConstant(string);
    }

    public EvaluateContext getUndefinedEvaluateContext() {
        return this.ecUndefined;
    }

    public Values getConstantValues() {
        return this.constantValues;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        Object object = "";
        String string = String.valueOf(this.formulaList);
        if (string.length() > 0) {
            string = string + "\n";
        }
        object = (String)object + string;
        string = String.valueOf(this.labelList);
        if (string.length() > 0) {
            string = string + "\n";
        }
        object = (String)object + string;
        string = String.valueOf(this.constantList);
        if (string.length() > 0) {
            string = string + "\n";
        }
        object = (String)object + string;
        int n = this.getNumProperties();
        for (int i = 0; i < n; ++i) {
            object = (String)object + String.valueOf(this.getPropertyObject(i)) + ";\n";
            if (i >= n - 1) continue;
            object = (String)object + "\n";
        }
        return object;
    }

    @Override
    public PropertiesFile deepCopy(DeepCopy deepCopy) throws PrismLangException {
        this.quotedIdentUsage = new IdentUsage(true);
        this.labelList = deepCopy.copy(this.labelList);
        this.formulaList = deepCopy.copy(this.formulaList);
        this.constantList = deepCopy.copy(this.constantList);
        this.combinedLabelList = deepCopy.copy(this.combinedLabelList);
        this.identUsage = this.identUsage.deepCopy();
        deepCopy.copyAll(this.properties);
        return this;
    }

    @Override
    public PropertiesFile clone() {
        PropertiesFile propertiesFile = (PropertiesFile)super.clone();
        propertiesFile.properties = (ArrayList)this.properties.clone();
        if (this.constantValues != null) {
            propertiesFile.constantValues = this.constantValues.clone();
        }
        if (this.ecUndefined != null) {
            this.ecUndefined = EvaluateContext.create(this.ecUndefined);
        }
        return propertiesFile;
    }
}

