/*
 * Decompiled with CFR 0.152.
 */
package param;

import edu.jas.kern.ComputerThreads;
import explicit.Model;
import explicit.ModelSimple;
import explicit.rewards.ConstructRewards;
import explicit.rewards.Rewards;
import explicit.rewards.RewardsSimple;
import java.util.BitSet;
import java.util.List;
import param.BigRational;
import param.BoxRegionFactory;
import param.ConstraintChecker;
import param.Function;
import param.FunctionFactory;
import param.Lumper;
import param.Optimiser;
import param.ParamMode;
import param.ParamResult;
import param.Region;
import param.RegionFactory;
import param.RegionValues;
import param.StateEliminator;
import param.StateValues;
import param.ValueComputer;
import parser.EvaluateContext;
import parser.State;
import parser.Values;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionConstant;
import parser.ast.ExpressionExists;
import parser.ast.ExpressionFilter;
import parser.ast.ExpressionForAll;
import parser.ast.ExpressionFormula;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionITE;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionLiteral;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionProp;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionSS;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.ast.LabelList;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import parser.ast.RelOp;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import parser.type.TypePathBool;
import parser.type.TypePathDouble;
import prism.Accuracy;
import prism.Evaluator;
import prism.ModelInfo;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismNotSupportedException;
import prism.Result;
import prism.RewardGenerator;

public final class ParamModelChecker
extends PrismComponent {
    private ModelInfo modelInfo = null;
    private RewardGenerator<?> rewardGen = null;
    private Model<?> modelOrig = null;
    private PropertiesFile propertiesFile = null;
    private Values constantValues;
    private Result result;
    private ParamMode mode;
    private int verbosity = 0;
    private BigRational[] paramLower;
    private BigRational[] paramUpper;
    private FunctionFactory functionFactory;
    private RegionFactory regionFactory;
    private ConstraintChecker constraintChecker;
    private ValueComputer valueComputer;
    private BigRational precision;
    private int splitMethod;
    private StateEliminator.EliminationOrder eliminationOrder;
    private int numRandomPoints;
    private Lumper.BisimType bisimType;
    private boolean simplifyRegions;

    public ParamModelChecker(PrismComponent prismComponent, ParamMode paramMode) throws PrismException {
        super(prismComponent);
        this.mode = paramMode;
        if (this.settings != null) {
            this.verbosity = this.settings.getBoolean("prism.verbose") ? 10 : 1;
            this.precision = new BigRational(this.settings.getString("prism.param.precision"));
            String string = this.settings.getString("prism.param.split");
            if (string.equals("Longest")) {
                this.splitMethod = 1;
            } else if (string.equals("All")) {
                this.splitMethod = 2;
            } else {
                throw new PrismException("unknown region splitting method " + string);
            }
            String string2 = this.settings.getString("prism.param.elimOrder");
            if (string2.equals("Arbitrary")) {
                this.eliminationOrder = StateEliminator.EliminationOrder.ARBITRARY;
            } else if (string2.equals("Forward")) {
                this.eliminationOrder = StateEliminator.EliminationOrder.FORWARD;
            } else if (string2.equals("Forward-reversed")) {
                this.eliminationOrder = StateEliminator.EliminationOrder.FORWARD_REVERSED;
            } else if (string2.equals("Backward")) {
                this.eliminationOrder = StateEliminator.EliminationOrder.BACKWARD;
            } else if (string2.equals("Backward-reversed")) {
                this.eliminationOrder = StateEliminator.EliminationOrder.BACKWARD_REVERSED;
            } else if (string2.equals("Random")) {
                this.eliminationOrder = StateEliminator.EliminationOrder.RANDOM;
            } else {
                throw new PrismException("unknown state elimination order " + string2);
            }
            this.numRandomPoints = this.settings.getInteger("prism.param.randomPoints");
            String string3 = this.settings.getString("prism.param.bisim");
            if (string3.equals("Weak")) {
                this.bisimType = Lumper.BisimType.WEAK;
            } else if (string3.equals("Strong")) {
                this.bisimType = Lumper.BisimType.STRONG;
            } else if (string3.equals("None")) {
                this.bisimType = Lumper.BisimType.NULL;
            } else {
                throw new PrismException("unknown bisimulation type " + string3);
            }
            this.simplifyRegions = this.settings.getBoolean("prism.param.subsumeRegions");
        }
    }

    public void setModelCheckingInfo(ModelInfo modelInfo, PropertiesFile propertiesFile, RewardGenerator<?> rewardGenerator) {
        this.modelInfo = modelInfo;
        this.propertiesFile = propertiesFile;
        this.rewardGen = rewardGenerator;
        this.constantValues = new Values();
        this.constantValues.addValues(modelInfo.getConstantValues());
        if (propertiesFile != null) {
            this.constantValues.addValues(propertiesFile.getConstantValues());
        }
    }

    public ParamMode getMode() {
        return this.mode;
    }

    public Result check(Model<?> model, Expression expression) throws PrismException {
        this.modelOrig = model;
        if (this.mode == ParamMode.EXACT) {
            FunctionFactory functionFactory = FunctionFactory.createDummy(this.getSettings());
            Evaluator<Function> evaluator = Evaluator.forRationalFunction(functionFactory);
            model = ModelSimple.copy(model, functionFactory::fromBigRational, evaluator);
        }
        this.functionFactory = ((Evaluator.EvaluatorFunction)model.getEvaluator()).getFunctionFactory();
        this.constraintChecker = new ConstraintChecker(this.numRandomPoints);
        this.regionFactory = new BoxRegionFactory(this.functionFactory, this.constraintChecker, this.precision, model.getNumStates(), model.getFirstInitialState(), this.simplifyRegions, this.splitMethod);
        this.valueComputer = new ValueComputer(this, this.mode, this.regionFactory, this.precision, this.eliminationOrder, this.bisimType);
        long l = 0L;
        expression = (Expression)expression.deepCopy().expandLabels(this.propertiesFile.getCombinedLabelList());
        this.result = new Result();
        expression = ExpressionFilter.addDefaultFilterIfNeeded(expression, model.getNumInitialStates() == 1);
        l = System.currentTimeMillis();
        BitSet bitSet = new BitSet(model.getNumStates());
        bitSet.set(0, model.getNumStates());
        RegionValues regionValues = this.checkExpression(model, expression, bitSet);
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for model checking: " + (double)l / 1000.0 + " seconds.");
        if (this.constraintChecker.unsoundCheckWasUsed()) {
            this.mainLog.printWarning("Computation of Boolean values / parameter regions used heuristic sampling, results are potentially inaccurate.");
        }
        Object object = "Result";
        if (!"Result".equals(expression.getResultName())) {
            object = (String)object + " (" + expression.getResultName().toLowerCase() + ")";
        }
        object = (String)object + ": " + this.result.getResultAndAccuracy();
        this.mainLog.println("\n" + (String)object);
        return this.result;
    }

    private int parserBinaryOpToRegionOp(int n) throws PrismException {
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 5: {
                n2 = 5;
                break;
            }
            case 6: {
                n2 = 6;
                break;
            }
            case 7: {
                n2 = 7;
                break;
            }
            case 8: {
                n2 = 8;
                break;
            }
            case 9: {
                n2 = 9;
                break;
            }
            case 10: {
                n2 = 10;
                break;
            }
            case 11: {
                n2 = 11;
                break;
            }
            case 12: {
                n2 = 12;
                break;
            }
            case 13: {
                n2 = 13;
                break;
            }
            case 14: {
                n2 = 14;
                break;
            }
            case 15: {
                n2 = 23;
                break;
            }
            default: {
                throw new PrismNotSupportedException("operator \"" + ExpressionBinaryOp.opSymbols[n] + "\" not currently supported for " + String.valueOf((Object)this.mode) + " analyses");
            }
        }
        return n2;
    }

    private int parserUnaryOpToRegionOp(int n) throws PrismException {
        int n2;
        switch (n) {
            case 2: {
                n2 = 18;
                break;
            }
            case 1: {
                n2 = 19;
                break;
            }
            case 3: {
                n2 = 20;
                break;
            }
            default: {
                throw new PrismNotSupportedException("operator \"" + ExpressionBinaryOp.opSymbols[n] + "\" not currently supported for " + String.valueOf((Object)this.mode) + " analyses");
            }
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    RegionValues checkExpression(Model<?> model, Expression expression, BitSet bitSet) throws PrismException {
        if (expression instanceof ExpressionUnaryOp) {
            return this.checkExpressionUnaryOp(model, (ExpressionUnaryOp)expression, bitSet);
        }
        if (expression instanceof ExpressionBinaryOp) {
            return this.checkExpressionBinaryOp(model, (ExpressionBinaryOp)expression, bitSet);
        }
        if (expression instanceof ExpressionITE) {
            return this.checkExpressionITE(model, (ExpressionITE)expression, bitSet);
        }
        if (expression instanceof ExpressionLabel) {
            return this.checkExpressionLabel(model, (ExpressionLabel)expression, bitSet);
        }
        if (expression instanceof ExpressionFormula) {
            if (((ExpressionFormula)expression).getDefinition() == null) throw new PrismException("Unexpanded formula \"" + ((ExpressionFormula)expression).getName() + "\"");
            return this.checkExpression(model, ((ExpressionFormula)expression).getDefinition(), bitSet);
        }
        if (expression instanceof ExpressionProp) {
            return this.checkExpressionProp(model, (ExpressionProp)expression, bitSet);
        }
        if (expression instanceof ExpressionFilter) {
            if (!((ExpressionFilter)expression).isParam()) return this.checkExpressionFilter(model, (ExpressionFilter)expression, bitSet);
            return this.checkExpressionFilterParam(model, (ExpressionFilter)expression, bitSet);
        }
        if (expression instanceof ExpressionProb) {
            return this.checkExpressionProb(model, (ExpressionProb)expression, bitSet);
        }
        if (expression instanceof ExpressionReward) {
            return this.checkExpressionReward(model, (ExpressionReward)expression, bitSet);
        }
        if (expression instanceof ExpressionSS) {
            return this.checkExpressionSteadyState(model, (ExpressionSS)expression, bitSet);
        }
        if (expression instanceof ExpressionForAll) throw new PrismNotSupportedException("Non-probabilistic CTL model checking is currently not supported in the " + this.mode.engine());
        if (expression instanceof ExpressionExists) {
            throw new PrismNotSupportedException("Non-probabilistic CTL model checking is currently not supported in the " + this.mode.engine());
        }
        if (!(expression instanceof ExpressionFunc)) return this.checkExpressionAtomic(model, expression, bitSet);
        if (((ExpressionFunc)expression).getNameCode() != 8) return this.checkExpressionAtomic(model, expression, bitSet);
        throw new PrismNotSupportedException("Multi-objective model checking is not supported in the " + this.mode.engine());
    }

    private RegionValues checkExpressionAtomic(Model<?> model, Expression expression, BitSet bitSet) throws PrismException {
        int n;
        expression = (Expression)expression.deepCopy().replaceConstants(this.constantValues);
        int n2 = model.getNumStates();
        List<State> list = model.getStatesList();
        StateValues stateValues = new StateValues(n2, model.getFirstInitialState());
        int[] nArray = new int[list.get((int)0).varValues.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = n;
        }
        for (n = 0; n < n2; ++n) {
            Expression expression2 = (Expression)expression.deepCopy().evaluatePartially(list.get(n), nArray);
            if (bitSet.get(n)) {
                Expression expression3;
                if (expression2 instanceof ExpressionLiteral) {
                    expression3 = (ExpressionLiteral)expression2;
                    if (expression3.getType() instanceof TypeBool) {
                        stateValues.setStateValue(n, expression3.evaluateBoolean());
                        continue;
                    }
                    if (expression3.getType() instanceof TypeInt || expression3.getType() instanceof TypeDouble) {
                        String string = ((ExpressionLiteral)expression3).getString();
                        BigRational bigRational = new BigRational(string);
                        stateValues.setStateValue(n, this.functionFactory.fromBigRational(bigRational));
                        continue;
                    }
                    throw new PrismNotSupportedException("model checking expresssion " + String.valueOf(expression) + " not supported for " + String.valueOf((Object)this.mode) + " models");
                }
                if (expression2 instanceof ExpressionConstant) {
                    expression3 = (ExpressionConstant)expression2;
                    stateValues.setStateValue(n, this.functionFactory.getVar(((ExpressionConstant)expression3).getName()));
                    continue;
                }
                throw new PrismNotSupportedException("cannot handle expression " + String.valueOf(expression) + " in " + String.valueOf((Object)this.mode) + " analysis");
            }
            if (expression2.getType() instanceof TypeBool) {
                stateValues.setStateValue(n, false);
                continue;
            }
            stateValues.setStateValue(n, this.functionFactory.getZero());
        }
        return this.regionFactory.completeCover(stateValues);
    }

    protected RegionValues checkExpressionUnaryOp(Model<?> model, ExpressionUnaryOp expressionUnaryOp, BitSet bitSet) throws PrismException {
        RegionValues regionValues = this.checkExpression(model, expressionUnaryOp.getOperand(), bitSet);
        regionValues.clearNotNeeded(bitSet);
        return regionValues.unaryOp(this.parserUnaryOpToRegionOp(expressionUnaryOp.getOperator()));
    }

    protected RegionValues checkExpressionBinaryOp(Model<?> model, ExpressionBinaryOp expressionBinaryOp, BitSet bitSet) throws PrismException {
        RegionValues regionValues = this.checkExpression(model, expressionBinaryOp.getOperand1(), bitSet);
        RegionValues regionValues2 = this.checkExpression(model, expressionBinaryOp.getOperand2(), bitSet);
        regionValues.clearNotNeeded(bitSet);
        regionValues2.clearNotNeeded(bitSet);
        return regionValues.binaryOp(this.parserBinaryOpToRegionOp(expressionBinaryOp.getOperator()), regionValues2);
    }

    protected RegionValues checkExpressionITE(Model<?> model, ExpressionITE expressionITE, BitSet bitSet) throws PrismException {
        RegionValues regionValues = this.checkExpression(model, expressionITE.getOperand1(), bitSet);
        RegionValues regionValues2 = this.checkExpression(model, expressionITE.getOperand2(), bitSet);
        RegionValues regionValues3 = this.checkExpression(model, expressionITE.getOperand3(), bitSet);
        regionValues.clearNotNeeded(bitSet);
        regionValues2.clearNotNeeded(bitSet);
        regionValues3.clearNotNeeded(bitSet);
        return regionValues.ITE(regionValues2, regionValues3);
    }

    protected RegionValues checkExpressionLabel(Model<?> model, ExpressionLabel expressionLabel, BitSet bitSet) throws PrismException {
        if (expressionLabel.isDeadlockLabel()) {
            int n = model.getNumStates();
            StateValues stateValues = new StateValues(n, model.getFirstInitialState());
            for (int i = 0; i < n; ++i) {
                stateValues.setStateValue(i, model.isDeadlockState(i));
            }
            return this.regionFactory.completeCover(stateValues);
        }
        if (expressionLabel.isInitLabel()) {
            int n = model.getNumStates();
            StateValues stateValues = new StateValues(n, model.getFirstInitialState());
            for (int i = 0; i < n; ++i) {
                stateValues.setStateValue(i, model.isInitialState(i));
            }
            return this.regionFactory.completeCover(stateValues);
        }
        LabelList labelList = this.propertiesFile.getCombinedLabelList();
        int n = labelList.getLabelIndex(expressionLabel.getName());
        if (n == -1) {
            throw new PrismException("Unknown label \"" + expressionLabel.getName() + "\" in property");
        }
        return this.checkExpression(model, labelList.getLabel(n), bitSet);
    }

    protected RegionValues checkExpressionProp(Model<?> model, ExpressionProp expressionProp, BitSet bitSet) throws PrismException {
        Property property = this.propertiesFile.lookUpPropertyObjectByName(expressionProp.getName());
        if (property != null) {
            this.mainLog.println("\nModel checking : " + String.valueOf(property));
            return this.checkExpression(model, property.getExpression(), bitSet);
        }
        throw new PrismException("Unknown property reference " + String.valueOf(expressionProp));
    }

    protected RegionValues checkExpressionFilter(Model<?> model, ExpressionFilter expressionFilter, BitSet bitSet) throws PrismException {
        boolean bl;
        Expression expression = expressionFilter.getFilter();
        if (expression == null) {
            expression = Expression.True();
        }
        boolean bl2 = Expression.isTrue(expression);
        BitSet bitSet2 = new BitSet(bitSet.size());
        bitSet2.set(0, bitSet.size());
        RegionValues regionValues = this.checkExpression(model, expression, bitSet2);
        if (!regionValues.parameterIndependent()) {
            throw new PrismException("currently, parameter-dependent filters are not supported");
        }
        BitSet bitSet3 = regionValues.getStateValues().toBitSet();
        ExpressionFilter.FilterOperator filterOperator = expressionFilter.getOperatorType();
        if (filterOperator == ExpressionFilter.FilterOperator.STATE && bitSet3.cardinality() != 1) {
            Object object = "Filter should be satisfied in exactly 1 state";
            object = (String)object + " (but \"" + String.valueOf(expression) + "\" is true in " + bitSet3.cardinality() + " states)";
            throw new PrismException((String)object);
        }
        if (filterOperator == ExpressionFilter.FilterOperator.FIRST) {
            bitSet3.clear(bitSet3.nextSetBit(0) + 1, bitSet3.length());
        }
        RegionValues regionValues2 = this.checkExpression(model, expressionFilter.getOperand(), bitSet3);
        if (bitSet3.isEmpty()) {
            throw new PrismException("Filter satisfies no states");
        }
        boolean bl3 = bl = expression instanceof ExpressionLabel && ((ExpressionLabel)expression).isInitLabel();
        if (!bl) {
            this.mainLog.println("\nStates satisfying filter " + String.valueOf(expression) + ": " + bitSet3.cardinality());
        }
        RegionValues regionValues3 = null;
        switch (filterOperator) {
            case PRINT: 
            case PRINTALL: {
                if (expressionFilter.getType() instanceof TypeBool) {
                    this.mainLog.print("\nSatisfying states");
                    this.mainLog.println((String)(bl2 ? ":" : " that are also in filter " + String.valueOf(expression) + ":"));
                } else {
                    this.mainLog.println("\nResults (non-zero only) for filter " + String.valueOf(expression) + ":");
                }
                regionValues2.printFiltered(this.mainLog, this.mode, expressionFilter.getType(), bitSet3, model.getStatesList(), filterOperator == ExpressionFilter.FilterOperator.PRINT, true, true);
                regionValues3 = regionValues2;
                break;
            }
            case MIN: 
            case MAX: 
            case ARGMIN: 
            case ARGMAX: {
                throw new PrismNotSupportedException("operation not implemented for " + String.valueOf((Object)this.mode) + " models");
            }
            case COUNT: {
                regionValues3 = regionValues2.op(17, bitSet3);
                break;
            }
            case SUM: {
                regionValues3 = regionValues2.op(11, bitSet3);
                break;
            }
            case AVG: {
                regionValues3 = regionValues2.op(16, bitSet3);
                break;
            }
            case FIRST: {
                if (bitSet3.cardinality() < 1) {
                    throw new PrismException("Filter should be satisfied in at least 1 state.");
                }
                regionValues3 = regionValues2.op(15, bitSet3);
                break;
            }
            case RANGE: {
                throw new PrismNotSupportedException("operation not implemented for " + String.valueOf((Object)this.mode) + " models");
            }
            case FORALL: {
                regionValues3 = regionValues2.op(21, bitSet3);
                break;
            }
            case EXISTS: {
                regionValues3 = regionValues2.op(22, bitSet3);
                break;
            }
            case STATE: {
                regionValues3 = regionValues2.op(15, bitSet3);
                break;
            }
            default: {
                throw new PrismException("Unrecognised filter type \"" + expressionFilter.getOperatorName() + "\"");
            }
        }
        regionValues2.clearExceptInit();
        ParamResult paramResult = new ParamResult(this.mode, regionValues3, this.functionFactory);
        if (this.mode == ParamMode.EXACT) {
            this.result.setResult(paramResult.getSimpleResult(expressionFilter.getType()));
        } else {
            this.result.setResult(paramResult);
        }
        this.result.setAccuracy(new Accuracy(Accuracy.AccuracyLevel.EXACT));
        this.result.setExplanation(null);
        return regionValues3;
    }

    protected RegionValues checkExpressionFilterParam(Model<?> model, ExpressionFilter expressionFilter, BitSet bitSet) throws PrismException {
        Expression expression = expressionFilter.getFilter();
        if (expression == null) {
            expression = Expression.True();
        }
        RegionValues regionValues = this.checkExpression(model, expression, bitSet);
        RegionValues regionValues2 = this.checkExpression(model, expressionFilter.getOperand(), bitSet);
        Optimiser optimiser = new Optimiser(regionValues2, regionValues, expressionFilter.getOperatorType() == ExpressionFilter.FilterOperator.MIN);
        System.out.println("\n" + optimiser.optimise());
        return null;
    }

    protected RegionValues checkExpressionProb(Model<?> model, ExpressionProb expressionProb, BitSet bitSet) throws PrismException {
        BigRational bigRational = null;
        ModelType modelType = model.getModelType();
        boolean bl = false;
        RegionValues regionValues = null;
        RelOp relOp = expressionProb.getRelOp();
        Expression expression = expressionProb.getProb();
        if (expression != null && ((bigRational = expression.evaluateBigRational(EvaluateContext.create(this.constantValues, EvaluateContext.EvalMode.EXACT))).compareTo(0L) == -1 || bigRational.compareTo(1L) == 1)) {
            throw new PrismException("Invalid probability bound " + String.valueOf(bigRational) + " in P operator");
        }
        boolean bl2 = bl = relOp.isLowerBound() || relOp.isMin();
        if (!expressionProb.getExpression().isSimplePathFormula()) {
            throw new PrismNotSupportedException(this.mode.Engine() + " does not yet handle LTL-style path formulas");
        }
        regionValues = this.checkProbPathFormulaSimple(model, expressionProb.getExpression(), bl, bitSet);
        regionValues.clearNotNeeded(bitSet);
        if (this.verbosity > 5) {
            this.mainLog.print("\nProbabilities (non-zero only) for all states:\n");
            this.mainLog.print(regionValues);
        }
        if (expression == null) {
            return regionValues;
        }
        return regionValues.binaryOp(Region.getOp(relOp.toString()), bigRational);
    }

    private RegionValues checkProbPathFormulaSimple(Model<?> model, Expression expression, boolean bl, BitSet bitSet) throws PrismException {
        boolean bl2 = false;
        RegionValues regionValues = null;
        if ((expression = Expression.convertSimplePathFormulaToCanonicalForm(expression)) instanceof ExpressionUnaryOp && ((ExpressionUnaryOp)expression).getOperator() == 1) {
            bl2 = true;
            bl = !bl;
            expression = ((ExpressionUnaryOp)expression).getOperand();
        }
        if (expression instanceof ExpressionTemporal) {
            ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
            if (expressionTemporal.getOperator() == 1) {
                throw new PrismNotSupportedException("Next operator not supported by " + String.valueOf((Object)this.mode) + " engine");
            }
            if (expressionTemporal.getOperator() == 2) {
                BitSet bitSet2 = new BitSet(model.getNumStates());
                bitSet2.set(0, model.getNumStates());
                RegionValues regionValues2 = this.checkExpression(model, expressionTemporal.getOperand1(), bitSet2);
                RegionValues regionValues3 = this.checkExpression(model, expressionTemporal.getOperand2(), bitSet2);
                regionValues = expressionTemporal.hasBounds() ? this.checkProbBoundedUntil(model, regionValues2, regionValues3, bl) : this.checkProbUntil(model, regionValues2, regionValues3, bl, bitSet);
            }
        }
        if (regionValues == null) {
            throw new PrismException("Unrecognised path operator in P operator");
        }
        if (bl2) {
            regionValues = regionValues.binaryOp(new BigRational(1L, 1L), this.parserBinaryOpToRegionOp(12));
        }
        return regionValues;
    }

    private RegionValues checkProbUntil(Model<?> model, RegionValues regionValues, RegionValues regionValues2, boolean bl, BitSet bitSet) throws PrismException {
        if (model.getModelType() == ModelType.MDP && this.settings.getBoolean("prism.fairness")) {
            throw new PrismNotSupportedException("Model checking MDPs under fairness not supported by " + String.valueOf((Object)this.mode) + " engine\"");
        }
        return this.valueComputer.computeUnbounded(model, regionValues, regionValues2, bl, null);
    }

    private RegionValues checkProbBoundedUntil(Model<?> model, RegionValues regionValues, RegionValues regionValues2, boolean bl) throws PrismException {
        ModelType modelType = model.getModelType();
        switch (modelType) {
            case CTMC: {
                throw new PrismNotSupportedException("Bounded until operator not supported by " + String.valueOf((Object)this.mode) + " engine");
            }
            case DTMC: {
                throw new PrismNotSupportedException("Bounded until operator not supported by " + String.valueOf((Object)this.mode) + " engine");
            }
            case MDP: {
                throw new PrismNotSupportedException("Bounded until operator not supported by " + String.valueOf((Object)this.mode) + " engine");
            }
        }
        throw new PrismNotSupportedException("Cannot model check for a " + String.valueOf((Object)modelType));
    }

    protected RegionValues checkExpressionReward(Model<?> model, ExpressionReward expressionReward, BitSet bitSet) throws PrismException {
        BigRational bigRational = null;
        RegionValues regionValues = null;
        boolean bl = false;
        RelOp relOp = expressionReward.getRelOp();
        Expression expression = expressionReward.getReward();
        if (expression != null && (bigRational = expression.evaluateBigRational(EvaluateContext.create(this.constantValues, EvaluateContext.EvalMode.EXACT))).compareTo(0L) == -1) {
            throw new PrismException("Invalid reward bound " + String.valueOf(bigRational) + " in R[] formula");
        }
        bl = relOp.isLowerBound() || relOp.isMin();
        int n = expressionReward.getRewardStructIndexByIndexObject(this.rewardGen, this.constantValues);
        this.mainLog.println("Building reward structure...");
        Rewards<?> rewards = this.constructExpectedRewards(this.modelOrig, n);
        if (this.mode == ParamMode.EXACT) {
            rewards = new RewardsSimple<Function>(rewards, model, this.functionFactory::fromBigRational, model.getEvaluator());
        }
        regionValues = this.checkRewardFormula(model, rewards, expressionReward.getExpression(), bl, bitSet);
        if (this.verbosity > 5) {
            this.mainLog.print("\nProbabilities (non-zero only) for all states:\n");
            this.mainLog.print(regionValues);
        }
        regionValues.clearNotNeeded(bitSet);
        if (expression == null) {
            return regionValues;
        }
        return regionValues.binaryOp(Region.getOp(relOp.toString()), bigRational);
    }

    protected <Value> Rewards<Value> constructRewards(Model<Value> model, int n) throws PrismException {
        ConstructRewards constructRewards = new ConstructRewards(this);
        return constructRewards.buildRewardStructure(model, this.rewardGen, n);
    }

    protected <Value> Rewards<Value> constructExpectedRewards(Model<Value> model, int n) throws PrismException {
        ConstructRewards constructRewards = new ConstructRewards(this);
        constructRewards.setExpectedRewards(true);
        return constructRewards.buildRewardStructure(model, this.rewardGen, n);
    }

    private RegionValues checkRewardFormula(Model<?> model, Rewards<?> rewards, Expression expression, boolean bl, BitSet bitSet) throws PrismException {
        RegionValues regionValues = null;
        if (expression.getType() instanceof TypePathDouble) {
            ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
            switch (expressionTemporal.getOperator()) {
                case 14: {
                    regionValues = this.checkRewardSteady(model, rewards, expressionTemporal, bl, bitSet);
                    break;
                }
                default: {
                    throw new PrismNotSupportedException(this.mode.Engine() + " does not yet handle the " + expressionTemporal.getOperatorSymbol() + " operator in the R operator");
                }
            }
        } else if (expression.getType() instanceof TypePathBool || expression.getType() instanceof TypeBool) {
            regionValues = this.checkRewardPathFormula(model, rewards, expression, bl, bitSet);
        }
        if (regionValues == null) {
            throw new PrismException("Unrecognised operator in R operator");
        }
        return regionValues;
    }

    private RegionValues checkRewardPathFormula(Model<?> model, Rewards<?> rewards, Expression expression, boolean bl, BitSet bitSet) throws PrismException {
        if (Expression.isReach(expression)) {
            return this.checkRewardReach(model, rewards, (ExpressionTemporal)expression, bl, bitSet);
        }
        if (Expression.isCoSafeLTLSyntactic(expression, true)) {
            throw new PrismNotSupportedException(this.mode.Engine() + " does not yet support co-safe reward computation");
        }
        throw new PrismException("R operator contains a path formula that is not syntactically co-safe: " + String.valueOf(expression));
    }

    private RegionValues checkRewardReach(Model<?> model, Rewards<?> rewards, ExpressionTemporal expressionTemporal, boolean bl, BitSet bitSet) throws PrismException {
        RegionValues regionValues = this.regionFactory.completeCover(true);
        BitSet bitSet2 = new BitSet(bitSet.size());
        bitSet2.set(0, bitSet.size());
        RegionValues regionValues2 = this.checkExpression(model, expressionTemporal.getOperand2(), bitSet2);
        return this.valueComputer.computeUnbounded(model, regionValues, regionValues2, bl, rewards);
    }

    private RegionValues checkRewardSteady(Model<?> model, Rewards<?> rewards, ExpressionTemporal expressionTemporal, boolean bl, BitSet bitSet) throws PrismException {
        if (model.getModelType() != ModelType.DTMC && model.getModelType() != ModelType.CTMC) {
            throw new PrismNotSupportedException(this.mode.Engine() + " long-run average rewards are only supported for DTMCs and CTMCs");
        }
        RegionValues regionValues = this.regionFactory.completeCover(true);
        BitSet bitSet2 = new BitSet(bitSet.size());
        bitSet2.set(0, bitSet.size());
        return this.valueComputer.computeSteadyState(model, regionValues, bl, rewards);
    }

    protected RegionValues checkExpressionSteadyState(Model<?> model, ExpressionSS expressionSS, BitSet bitSet) throws PrismException {
        BigRational bigRational = null;
        ModelType modelType = model.getModelType();
        boolean bl = false;
        RegionValues regionValues = null;
        RelOp relOp = expressionSS.getRelOp();
        Expression expression = expressionSS.getProb();
        if (expression != null && ((bigRational = expression.evaluateBigRational(EvaluateContext.create(this.constantValues, EvaluateContext.EvalMode.EXACT))).compareTo(0L) == -1 || bigRational.compareTo(1L) == 1)) {
            throw new PrismException("Invalid probability bound " + String.valueOf(bigRational) + " in P operator");
        }
        bl = relOp.isLowerBound() || relOp.isMin();
        regionValues = this.checkProbSteadyState(model, expressionSS.getExpression(), bl, bitSet);
        if (this.verbosity > 5) {
            this.mainLog.print("\nProbabilities (non-zero only) for all states:\n");
            this.mainLog.print(regionValues);
        }
        regionValues.clearNotNeeded(bitSet);
        if (expression == null) {
            return regionValues;
        }
        return regionValues.binaryOp(Region.getOp(relOp.toString()), bigRational);
    }

    private RegionValues checkProbSteadyState(Model<?> model, Expression expression, boolean bl, BitSet bitSet) throws PrismException {
        BitSet bitSet2 = new BitSet(model.getNumStates());
        bitSet2.set(0, model.getNumStates());
        RegionValues regionValues = this.checkExpression(model, expression, bitSet2);
        if (model.getModelType() != ModelType.DTMC && model.getModelType() != ModelType.CTMC) {
            throw new PrismNotSupportedException(this.mode.Engine() + " currently only implements steady state for DTMCs and CTMCs.");
        }
        return this.valueComputer.computeSteadyState(model, regionValues, bl, null);
    }

    public static void closeDown() {
        ComputerThreads.terminate();
    }
}

