/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmctools.umbj;

import io.github.pmctools.umbj.UMBException;

public class UMBBitString {
    public byte[] bytes;

    public UMBBitString(int n) {
        this.bytes = new byte[n];
    }

    public void setInt(int n, int n2, int n3) throws UMBException {
        if (n2 > 32) {
            throw new UMBException("Cannot store integer of " + n2 + " bits (too large for Java int)");
        }
        for (int i = 0; i < n2; ++i) {
            char c = (char)((n3 >>> i & 1) << (n + i & 7));
            char c2 = (char)(1 << (n + i & 7));
            this.bytes[n + i >> 3] = (byte)(this.bytes[n + i >> 3] & ~c2 | c);
        }
    }

    public void setUInt(int n, int n2, int n3) throws UMBException {
        if (n2 >= 32) {
            throw new UMBException("Cannot store unsigned integer of " + n2 + " bits (too large for Java int)");
        }
        this.setInt(n, n2, n3);
    }

    public void setDouble(int n, int n2, double d) throws UMBException {
        if (n2 != 64) {
            throw new UMBException("Cannot store double of " + n2 + " bits (should be 64)");
        }
        long l = Double.doubleToLongBits(d);
        for (int i = 0; i < n2; ++i) {
            char c = (char)((l >>> i & 1L) << (n + i & 7));
            char c2 = (char)(1 << (n + i & 7));
            this.bytes[n + i >> 3] = (byte)(this.bytes[n + i >> 3] & ~c2 | c);
        }
    }

    public void setBoolean(int n, int n2, boolean bl) throws UMBException {
        if (n2 >= 32) {
            throw new UMBException("Cannot store unsigned integer of " + n2 + " bits (too large for Java int)");
        }
        this.setUInt(n, n2, bl ? 1 : 0);
    }

    public int getInt(int n, int n2) throws UMBException {
        if (n2 > 32) {
            throw new UMBException("Cannot extract integer of " + n2 + " bits (too large for Java int)");
        }
        int n3 = 0;
        for (int i = n + n2 - 1; i >= n; --i) {
            n3 = n3 << 1 | (((long)this.bytes[i >> 3] & 1L << (i & 7)) != 0L ? 1 : 0);
        }
        if ((n3 & 1 << n2 - 1) != 0) {
            n3 -= 1 << n2;
        }
        return n3;
    }

    public int getUInt(int n, int n2) throws UMBException {
        if (n2 >= 32) {
            throw new UMBException("Cannot extract unsigned integer of " + n2 + " bits (too large for Java int)");
        }
        int n3 = 0;
        for (int i = n + n2 - 1; i >= n; --i) {
            n3 = n3 << 1 | (((long)this.bytes[i >> 3] & 1L << (i & 7)) != 0L ? 1 : 0);
        }
        return n3;
    }

    public double getDouble(int n, int n2) throws UMBException {
        if (n2 != 64) {
            throw new UMBException("Cannot extract double of " + n2 + " bits (should be 64)");
        }
        long l = 0L;
        for (int i = n + n2 - 1; i >= n; --i) {
            l = l << 1 | (long)(((long)this.bytes[i >> 3] & 1L << (i & 7)) != 0L ? 1 : 0);
        }
        return Double.longBitsToDouble(l);
    }

    public boolean getBoolean(int n, int n2) throws UMBException {
        if (n2 >= 32) {
            throw new UMBException("Cannot extract boolean of " + n2 + " bits (too large for Java int)");
        }
        return this.getUInt(n, n2) != 0;
    }

    public String toString(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n + n2;
        for (int i = n3 - 1; i >= n; --i) {
            stringBuilder.append(((long)this.bytes[i >> 3] & 1L << (i & 7)) != 0L ? "1" : "0");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toString(0, this.bytes.length * 8);
    }
}

