/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableStateSet;
import explicit.MinMax;
import explicit.NondetModel;
import explicit.rewards.MDPRewards;
import java.util.BitSet;
import java.util.PrimitiveIterator;
import prism.ModelType;
import prism.PrismException;

public interface UMDP<Value>
extends NondetModel<Value> {
    @Override
    default public ModelType getModelType() {
        return ModelType.UMDP;
    }

    @Override
    default public void exportToPrismLanguage(String string, int n) throws PrismException {
        throw new UnsupportedOperationException("UMDP model export not implemented");
    }

    default public void checkLowerBoundsArePositive() throws PrismException {
        throw new UnsupportedOperationException();
    }

    default public void mvMultUnc(double[] dArray, MinMax minMax, double[] dArray2, BitSet bitSet, boolean bl, int[] nArray) {
        this.mvMultUnc(dArray, minMax, dArray2, new IterableStateSet(bitSet, this.getNumStates(), bl).iterator(), nArray);
    }

    default public void mvMultUnc(double[] dArray, MinMax minMax, double[] dArray2, PrimitiveIterator.OfInt ofInt, int[] nArray) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            dArray2[n] = this.mvMultUncSingle(n, dArray, minMax, nArray);
        }
    }

    default public double mvMultUncSingle(int n, double[] dArray, MinMax minMax, int[] nArray) {
        int n2 = -1;
        double d = 0.0;
        boolean bl = true;
        boolean bl2 = minMax.isMin();
        int n3 = this.getNumChoices(n);
        for (int i = 0; i < n3; ++i) {
            double d2 = this.mvMultUncSingle(n, i, dArray, minMax);
            if (bl || bl2 && d2 < d || !bl2 && d2 > d) {
                d = d2;
                if (nArray != null) {
                    n2 = i;
                }
            }
            bl = false;
        }
        if (nArray != null && !bl) {
            if (bl2) {
                nArray[n] = n2;
            } else if (nArray[n] == -1 || d > dArray[n]) {
                nArray[n] = n2;
            }
        }
        return d;
    }

    public double mvMultUncSingle(int var1, int var2, double[] var3, MinMax var4);

    default public void mvMultRewUnc(double[] dArray, MDPRewards<Double> mDPRewards, MinMax minMax, double[] dArray2, BitSet bitSet, boolean bl, int[] nArray) {
        this.mvMultRewUnc(dArray, mDPRewards, minMax, dArray2, new IterableStateSet(bitSet, this.getNumStates(), bl).iterator(), nArray);
    }

    default public void mvMultRewUnc(double[] dArray, MDPRewards<Double> mDPRewards, MinMax minMax, double[] dArray2, PrimitiveIterator.OfInt ofInt, int[] nArray) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            dArray2[n] = this.mvMultRewUncSingle(n, dArray, mDPRewards, minMax, nArray);
        }
    }

    default public double mvMultRewUncSingle(int n, double[] dArray, MDPRewards<Double> mDPRewards, MinMax minMax, int[] nArray) {
        int n2 = -1;
        double d = 0.0;
        boolean bl = true;
        boolean bl2 = minMax.isMin();
        int n3 = this.getNumChoices(n);
        for (int i = 0; i < n3; ++i) {
            double d2 = this.mvMultRewUncSingle(n, i, dArray, mDPRewards, minMax);
            if (bl || bl2 && d2 < d || !bl2 && d2 > d) {
                d = d2;
                if (nArray != null) {
                    n2 = i;
                }
            }
            bl = false;
        }
        if (nArray != null && !bl) {
            if (bl2) {
                nArray[n] = n2;
            } else if (nArray[n] == -1 || d > dArray[n]) {
                nArray[n] = n2;
            }
        }
        return d;
    }

    default public double mvMultRewUncSingle(int n, int n2, double[] dArray, MDPRewards<Double> mDPRewards, MinMax minMax) {
        double d = (Double)mDPRewards.getStateReward(n);
        d += ((Double)mDPRewards.getTransitionReward(n, n2)).doubleValue();
        return d += this.mvMultUncSingle(n, n2, dArray, minMax);
    }

    default public double mvMultUncGS(double[] dArray, MinMax minMax, PrimitiveIterator.OfInt ofInt, boolean bl, int[] nArray) {
        double d = 0.0;
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d2 = this.mvMultUncSingle(n, dArray, minMax, nArray);
            double d3 = bl ? Math.abs(d2 - dArray[n]) : Math.abs(d2 - dArray[n]) / d2;
            d = d3 > d ? d3 : d;
            dArray[n] = d2;
        }
        return d;
    }

    default public double mvMultRewUncGS(double[] dArray, MDPRewards<Double> mDPRewards, MinMax minMax, PrimitiveIterator.OfInt ofInt, boolean bl, int[] nArray) {
        double d = 0.0;
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d2 = this.mvMultRewUncSingle(n, dArray, mDPRewards, minMax, nArray);
            double d3 = bl ? Math.abs(d2 - dArray[n]) : Math.abs(d2 - dArray[n]) / d2;
            d = d3 > d ? d3 : d;
            dArray[n] = d2;
        }
        return d;
    }
}

