/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableStateSet;
import common.iterable.FunctionalPrimitiveIterator;
import explicit.Distribution;
import explicit.DistributionSet;
import explicit.MDPSimple;
import explicit.Model;
import explicit.ModelExplicit;
import explicit.NondetModelSimple;
import explicit.STPG;
import explicit.STPGModelChecker;
import explicit.SuccessorsIterator;
import explicit.rewards.STPGRewards;
import explicit.rewards.STPGRewardsNestedSimple;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import prism.PrismException;
import prism.PrismUtils;
import strat.MDStrategy;

public class STPGAbstrSimple<Value>
extends ModelExplicit<Value>
implements STPG<Value>,
NondetModelSimple<Value> {
    protected List<ArrayList<DistributionSet<Value>>> trans;
    public boolean allowDupes = false;
    protected int numDistrSets;
    protected int numDistrs;
    protected int numTransitions;
    protected int maxNumDistrSets;
    protected int maxNumDistrs;

    public STPGAbstrSimple() {
        this.initialise(0);
    }

    public STPGAbstrSimple(int n) {
        this.initialise(n);
    }

    public STPGAbstrSimple(MDPSimple<Value> mDPSimple) {
        this.initialise(mDPSimple.getNumStates());
        this.copyFrom(mDPSimple);
        for (int i = 0; i < this.numStates; ++i) {
            DistributionSet<Value> distributionSet = this.newDistributionSet(null);
            distributionSet.addAll(mDPSimple.getChoices(i));
            this.addDistributionSet(i, distributionSet);
        }
    }

    @Override
    public void initialise(int n) {
        super.initialise(n);
        this.numTransitions = 0;
        this.numDistrs = 0;
        this.numDistrSets = 0;
        this.maxNumDistrs = 0;
        this.maxNumDistrSets = 0;
        this.trans = new ArrayList<ArrayList<DistributionSet<Value>>>(n);
        for (int i = 0; i < n; ++i) {
            this.trans.add(new ArrayList());
        }
    }

    @Override
    public void clearState(int n) {
        if (n >= this.numStates || n < 0) {
            return;
        }
        List list = this.trans.get(n);
        this.numDistrSets -= list.size();
        for (DistributionSet distributionSet : list) {
            this.numDistrs -= distributionSet.size();
            for (Distribution distribution : distributionSet) {
                this.numTransitions -= distribution.size();
            }
        }
        this.trans.set(n, new ArrayList(0));
        this.actionList.markNeedsRecomputing();
    }

    @Override
    public int addState() {
        this.addStates(1);
        return this.numStates - 1;
    }

    @Override
    public void addStates(int n) {
        for (int i = 0; i < n; ++i) {
            this.trans.add(new ArrayList());
        }
        this.numStates += n;
    }

    @Override
    public void buildFromPrismExplicit(String string) throws PrismException {
        int n = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
            String string2 = bufferedReader.readLine();
            n = 1;
            if (string2 == null) {
                bufferedReader.close();
                throw new PrismException("Missing first line of .tra file");
            }
            String[] stringArray = string2.split(" ");
            int n2 = Integer.parseInt(stringArray[0]);
            this.initialise(n2);
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            DistributionSet<Value> distributionSet = null;
            Distribution distribution = null;
            string2 = bufferedReader.readLine();
            ++n;
            while (string2 != null) {
                if ((string2 = string2.trim()).length() > 0) {
                    stringArray = string2.split(" ");
                    int n6 = Integer.parseInt(stringArray[0]);
                    int n7 = Integer.parseInt(stringArray[1]);
                    int n8 = Integer.parseInt(stringArray[2]);
                    int n9 = Integer.parseInt(stringArray[3]);
                    Object Value2 = this.getEvaluator().fromString(stringArray[4]);
                    if (n6 != n3 || n7 != n4 || n8 != n5) {
                        if (distributionSet != null) {
                            distributionSet.add(distribution);
                        }
                        distribution = new Distribution(this.getEvaluator());
                        if (n6 != n3 || n7 != n4) {
                            if (distributionSet != null) {
                                this.addDistributionSet(n3, distributionSet);
                            }
                            distributionSet = this.newDistributionSet(null);
                        }
                    }
                    distribution.add(n9, Value2);
                    n3 = n6;
                    n4 = n7;
                    n5 = n8;
                }
                string2 = bufferedReader.readLine();
                ++n;
            }
            distributionSet.add(distribution);
            this.addDistributionSet(n3, distributionSet);
            bufferedReader.close();
            this.actionList.markNeedsRecomputing();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            System.exit(1);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Problem in .tra file (line " + n + ") for " + String.valueOf((Object)this.getModelType()));
        }
    }

    public DistributionSet<Value> newDistributionSet(Object object) {
        return new DistributionSet(object);
    }

    public int addDistributionSet(int n, DistributionSet<Value> distributionSet) {
        int n2;
        if (n >= this.numStates || n < 0) {
            return -1;
        }
        ArrayList<DistributionSet<Value>> arrayList = this.trans.get(n);
        if (!this.allowDupes && (n2 = arrayList.indexOf(distributionSet)) != -1) {
            return n2;
        }
        arrayList.add(distributionSet);
        ++this.numDistrSets;
        this.maxNumDistrSets = Math.max(this.maxNumDistrSets, arrayList.size());
        this.numDistrs += distributionSet.size();
        this.maxNumDistrs = Math.max(this.maxNumDistrs, distributionSet.size());
        for (Distribution distribution : distributionSet) {
            this.numTransitions += distribution.size();
        }
        this.actionList.markNeedsRecomputing();
        return arrayList.size() - 1;
    }

    @Override
    public int getNumTransitions() {
        return this.numTransitions;
    }

    @Override
    public Iterator<Integer> getSuccessorsIterator(int n) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (DistributionSet<Value> distributionSet : this.trans.get(n)) {
            for (Distribution distribution : distributionSet) {
                hashSet.addAll(distribution.getSupport());
            }
        }
        return hashSet.iterator();
    }

    @Override
    public boolean isSuccessor(int n, int n2) {
        for (DistributionSet<Value> distributionSet : this.trans.get(n)) {
            for (Distribution distribution : distributionSet) {
                if (!distribution.contains(n2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean allSuccessorsInSet(int n, BitSet bitSet) {
        for (DistributionSet<Value> distributionSet : this.trans.get(n)) {
            for (Distribution distribution : distributionSet) {
                if (distribution.isSubsetOf(bitSet)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean someSuccessorsInSet(int n, BitSet bitSet) {
        for (DistributionSet<Value> distributionSet : this.trans.get(n)) {
            for (Distribution distribution : distributionSet) {
                if (!distribution.isSubsetOf(bitSet)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
        int n = 0;
        for (int i = 0; i < this.numStates; ++i) {
            if (!this.trans.get(i).isEmpty()) continue;
            this.addDeadlockState(i);
            if (!bl) continue;
            DistributionSet<Value> distributionSet = this.newDistributionSet(null);
            Distribution distribution = new Distribution(this.getEvaluator());
            distribution.add(i, this.getEvaluator().one());
            distributionSet.add(distribution);
            this.addDistributionSet(i, distributionSet);
            ++n;
        }
        if (n > 0) {
            this.actionList.addAction(null);
        }
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
        for (int i = 0; i < this.numStates; ++i) {
            if (!this.trans.get(i).isEmpty() || bitSet != null && bitSet.get(i)) continue;
            throw new PrismException("STPG has a deadlock in state " + i);
        }
    }

    @Override
    public String infoString() {
        Object object = "";
        object = (String)object + this.numStates + " states (" + this.getNumInitialStates() + " initial)";
        object = (String)object + ", " + this.numTransitions + " transitions";
        object = (String)object + ", " + this.numDistrs + " choices";
        object = (String)object + ", " + this.numDistrSets + " choice sets";
        object = (String)object + ", p1max/avg = " + this.maxNumDistrSets + "/" + PrismUtils.formatDouble2dp((double)this.numDistrSets / (double)this.numStates);
        object = (String)object + ", p2max/avg = " + this.maxNumDistrs + "/" + PrismUtils.formatDouble2dp((double)this.numDistrs / (double)this.numDistrSets);
        return object;
    }

    @Override
    public String infoStringTable() {
        Object object = "";
        object = (String)object + "States:      " + this.numStates + " (" + this.getNumInitialStates() + " initial)\n";
        object = (String)object + "Transitions: " + this.numTransitions + "\n";
        object = (String)object + "Choices:     " + this.numDistrs + "\n";
        object = (String)object + "P1 max/avg:  " + this.maxNumDistrSets + "/" + PrismUtils.formatDouble2dp((double)this.numDistrSets / (double)this.numStates) + "\n";
        object = (String)object + "P2 max/avg:  " + this.maxNumDistrs + "/" + PrismUtils.formatDouble2dp((double)this.numDistrs / (double)this.numDistrSets) + "\n";
        return object;
    }

    @Override
    public int getNumChoices(int n) {
        return this.trans.get(n).size();
    }

    @Override
    public int getMaxNumChoices() {
        return this.maxNumDistrSets;
    }

    @Override
    public int getNumChoices() {
        return this.numDistrSets;
    }

    @Override
    public Object getAction(int n, int n2) {
        return null;
    }

    @Override
    public boolean allSuccessorsInSet(int n, int n2, BitSet bitSet) {
        return this.trans.get(n).get(n2).isSubsetOf(bitSet);
    }

    @Override
    public boolean someSuccessorsInSet(int n, int n2, BitSet bitSet) {
        return this.trans.get(n).get(n2).containsOneOf(bitSet);
    }

    @Override
    public SuccessorsIterator getSuccessors(final int n, final int n2) {
        return SuccessorsIterator.chain(new Iterator<SuccessorsIterator>(){
            private Iterator<Distribution<Value>> iterator;
            {
                this.iterator = STPGAbstrSimple.this.trans.get(n).get(n2).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public SuccessorsIterator next() {
                Distribution distribution = this.iterator.next();
                return SuccessorsIterator.from(distribution.getSupport().iterator(), true);
            }
        });
    }

    @Override
    public int getPlayer(int n) {
        return 1;
    }

    @Override
    public int getNumTransitions(int n, int n2) {
        return 0;
    }

    @Override
    public Iterator<Map.Entry<Integer, Value>> getTransitionsIterator(int n, int n2) {
        return null;
    }

    @Override
    public Model<Value> constructInducedModel(MDStrategy<Value> mDStrategy) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void prob0step(BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, BitSet bitSet3) {
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.numStates).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            boolean bl3 = bl;
            for (DistributionSet<Value> distributionSet : this.trans.get(n)) {
                boolean bl4 = bl2;
                for (Distribution distribution : distributionSet) {
                    boolean bl5 = distribution.containsOneOf(bitSet2);
                    if (bl2) {
                        if (bl5) continue;
                        bl4 = false;
                        continue;
                    }
                    if (!bl5) continue;
                    bl4 = true;
                }
                if (bl) {
                    if (bl4) continue;
                    bl3 = false;
                    continue;
                }
                if (!bl4) continue;
                bl3 = true;
            }
            bitSet3.set(n, bl3);
        }
    }

    @Override
    public void prob1step(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl, boolean bl2, BitSet bitSet4) {
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.numStates).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            boolean bl3 = bl;
            for (DistributionSet<Value> distributionSet : this.trans.get(n)) {
                boolean bl4 = bl2;
                for (Distribution distribution : distributionSet) {
                    boolean bl5;
                    boolean bl6 = bl5 = distribution.containsOneOf(bitSet3) && distribution.isSubsetOf(bitSet2);
                    if (bl2) {
                        if (bl5) continue;
                        bl4 = false;
                        continue;
                    }
                    if (!bl5) continue;
                    bl4 = true;
                }
                if (bl) {
                    if (bl4) continue;
                    bl3 = false;
                    continue;
                }
                if (!bl4) continue;
                bl3 = true;
            }
            bitSet4.set(n, bl3);
        }
    }

    @Override
    public void mvMultMinMax(double[] dArray, boolean bl, boolean bl2, double[] dArray2, BitSet bitSet, boolean bl3, int[] nArray) {
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.numStates, bl3).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            dArray2[n] = this.mvMultMinMaxSingle(n, dArray, bl, bl2);
        }
    }

    @Override
    public double mvMultMinMaxSingle(int n, double[] dArray, boolean bl, boolean bl2) {
        double d = 0.0;
        boolean bl3 = true;
        ArrayList<DistributionSet<Value>> arrayList = this.trans.get(n);
        for (DistributionSet<Value> distributionSet : arrayList) {
            double d2 = 0.0;
            boolean bl4 = true;
            for (Distribution distribution : distributionSet) {
                double d3 = 0.0;
                for (Map.Entry entry : distribution) {
                    int n2 = (Integer)entry.getKey();
                    double d4 = this.getEvaluator().toDouble(entry.getValue());
                    d3 += d4 * dArray[n2];
                }
                if (bl4 || bl2 && d3 < d2 || !bl2 && d3 > d2) {
                    d2 = d3;
                }
                bl4 = false;
            }
            if (bl3 || bl && d2 < d || !bl && d2 > d) {
                d = d2;
            }
            bl3 = false;
        }
        return d;
    }

    @Override
    public List<Integer> mvMultMinMaxSingleChoices(int n, double[] dArray, boolean bl, boolean bl2, double d) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = -1;
        ArrayList<DistributionSet<Value>> arrayList2 = this.trans.get(n);
        for (DistributionSet<Value> distributionSet : arrayList2) {
            ++n2;
            double d2 = 0.0;
            boolean bl3 = true;
            for (Distribution distribution : distributionSet) {
                double d3 = 0.0;
                for (Map.Entry entry : distribution) {
                    int n3 = (Integer)entry.getKey();
                    double d4 = this.getEvaluator().toDouble(entry.getValue());
                    d3 += d4 * dArray[n3];
                }
                if (bl3 || bl2 && d3 < d2 || !bl2 && d3 > d2) {
                    d2 = d3;
                }
                bl3 = false;
            }
            if (!PrismUtils.doublesAreEqual(d, d2)) continue;
            arrayList.add(n2);
        }
        return arrayList;
    }

    @Override
    public double mvMultGSMinMax(double[] dArray, boolean bl, boolean bl2, BitSet bitSet, boolean bl3, boolean bl4, int[] nArray) {
        double d = 0.0;
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.numStates, bl3).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            double d2 = this.mvMultJacMinMaxSingle(n, dArray, bl, bl2, nArray);
            double d3 = bl4 ? Math.abs(d2 - dArray[n]) : Math.abs(d2 - dArray[n]) / d2;
            d = d3 > d ? d3 : d;
            dArray[n] = d2;
        }
        return d;
    }

    @Override
    public double mvMultJacMinMaxSingle(int n, double[] dArray, boolean bl, boolean bl2, int[] nArray) {
        double d = 0.0;
        boolean bl3 = true;
        ArrayList<DistributionSet<Value>> arrayList = this.trans.get(n);
        for (DistributionSet<Value> distributionSet : arrayList) {
            double d2 = 0.0;
            boolean bl4 = true;
            for (Distribution distribution : distributionSet) {
                double d3 = 1.0;
                double d4 = 0.0;
                for (Map.Entry entry : distribution) {
                    int n2 = (Integer)entry.getKey();
                    double d5 = this.getEvaluator().toDouble(entry.getValue());
                    if (n2 != n) {
                        d4 += d5 * dArray[n2];
                    } else {
                        d3 -= d5;
                    }
                    if (!(d3 > 0.0)) continue;
                    d4 /= d3;
                }
                if (bl4 || bl2 && d4 < d2 || !bl2 && d4 > d2) {
                    d2 = d4;
                }
                bl4 = false;
            }
            if (bl3 || bl && d2 < d || !bl && d2 > d) {
                d = d2;
            }
            bl3 = false;
        }
        return d;
    }

    @Override
    public void mvMultRewMinMax(double[] dArray, STPGRewards<Double> sTPGRewards, boolean bl, boolean bl2, double[] dArray2, BitSet bitSet, boolean bl3, int[] nArray) {
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.numStates, bl3).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            dArray2[n] = this.mvMultRewMinMaxSingle(n, dArray, sTPGRewards, bl, bl2, nArray);
        }
    }

    @Override
    public double mvMultRewMinMaxSingle(int n, double[] dArray, STPGRewards<Double> sTPGRewards, boolean bl, boolean bl2, int[] nArray) {
        double d = 0.0;
        boolean bl3 = true;
        int n2 = -1;
        ArrayList<DistributionSet<Value>> arrayList = this.trans.get(n);
        for (DistributionSet<Value> distributionSet : arrayList) {
            ++n2;
            double d2 = 0.0;
            boolean bl4 = true;
            int n3 = -1;
            for (Distribution distribution : distributionSet) {
                double d3 = (Double)((STPGRewardsNestedSimple)sTPGRewards).getNestedTransitionReward(n, n2, ++n3);
                for (Map.Entry entry : distribution) {
                    int n4 = (Integer)entry.getKey();
                    double d4 = this.getEvaluator().toDouble(entry.getValue());
                    d3 += d4 * dArray[n4];
                }
                if (bl4 || bl2 && d3 < d2 || !bl2 && d3 > d2) {
                    d2 = d3;
                }
                bl4 = false;
            }
            d2 += ((Double)sTPGRewards.getTransitionReward(n, n2)).doubleValue();
            if (bl3 || bl && d2 < d || !bl && d2 > d) {
                d = d2;
            }
            bl3 = false;
        }
        return d;
    }

    @Override
    public List<Integer> mvMultRewMinMaxSingleChoices(int n, double[] dArray, STPGRewards<Double> sTPGRewards, boolean bl, boolean bl2, double d) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = -1;
        ArrayList<DistributionSet<Value>> arrayList2 = this.trans.get(n);
        for (DistributionSet<Value> distributionSet : arrayList2) {
            ++n2;
            double d2 = 0.0;
            boolean bl3 = true;
            int n3 = -1;
            for (Distribution distribution : distributionSet) {
                double d3 = (Double)((STPGRewardsNestedSimple)sTPGRewards).getNestedTransitionReward(n, n2, ++n3);
                for (Map.Entry entry : distribution) {
                    int n4 = (Integer)entry.getKey();
                    double d4 = this.getEvaluator().toDouble(entry.getValue());
                    d3 += d4 * dArray[n4];
                }
                if (bl3 || bl2 && d3 < d2 || !bl2 && d3 > d2) {
                    d2 = d3;
                }
                bl3 = false;
            }
            if (!PrismUtils.doublesAreEqual(d, d2 += ((Double)sTPGRewards.getTransitionReward(n, n2)).doubleValue())) continue;
            arrayList.add(n2);
        }
        return arrayList;
    }

    @Override
    public void mvMultRewMinMax(double[] dArray, STPGRewards<Double> sTPGRewards, boolean bl, boolean bl2, double[] dArray2, BitSet bitSet, boolean bl3, int[] nArray, double d) {
        throw new UnsupportedOperationException();
    }

    public boolean isChoiceNested(int n, int n2) {
        return true;
    }

    public int getNumNestedChoices(int n, int n2) {
        return this.trans.get(n).get(n2).size();
    }

    public Object getNestedAction(int n, int n2, int n3) {
        return this.trans.get(n).get(n2).getAction();
    }

    public int getNumNestedTransitions(int n, int n2, int n3) {
        int n4;
        DistributionSet<Value> distributionSet = this.trans.get(n).get(n2);
        Iterator iterator = distributionSet.iterator();
        Distribution distribution = null;
        for (n4 = 0; iterator.hasNext() && n4 <= n3; ++n4) {
            distribution = (Distribution)iterator.next();
        }
        if (n4 <= n3) {
            return 0;
        }
        return distribution.size();
    }

    public Iterator<Map.Entry<Integer, Value>> getNestedTransitionsIterator(int n, int n2, int n3) {
        int n4;
        DistributionSet<Value> distributionSet = this.trans.get(n).get(n2);
        Iterator iterator = distributionSet.iterator();
        Distribution distribution = null;
        for (n4 = 0; iterator.hasNext() && n4 <= n3; ++n4) {
            distribution = (Distribution)iterator.next();
        }
        if (n4 <= n3) {
            return null;
        }
        return distribution.iterator();
    }

    public List<DistributionSet<Value>> getChoices(int n) {
        return this.trans.get(n);
    }

    public DistributionSet<Value> getChoice(int n, int n2) {
        return this.trans.get(n).get(n2);
    }

    public int getNumPlayer1Choices() {
        return this.numDistrSets;
    }

    public int getNumPlayer2Choices() {
        return this.numDistrs;
    }

    public int getMaxNumPlayer1Choices() {
        return this.maxNumDistrSets;
    }

    public int getMaxNumPlayer2Choices() {
        return this.maxNumDistrs;
    }

    public String toStringGeneric() {
        Object object = "";
        boolean bl = true;
        object = "[ ";
        for (int i = 0; i < this.numStates; ++i) {
            if (bl) {
                bl = false;
            } else {
                object = (String)object + ", ";
            }
            object = (String)object + i + ": ";
            int n = this.getNumChoices(i);
            object = (String)object + "[";
            boolean bl2 = true;
            for (int j = 0; j < n; ++j) {
                Map.Entry<Integer, Value> entry;
                Iterator<Map.Entry<Integer, Value>> iterator = this.getTransitionsIterator(i, j);
                if (iterator == null) continue;
                if (bl2) {
                    bl2 = false;
                } else {
                    object = (String)object + ", ";
                }
                object = (String)object + "{";
                boolean bl3 = true;
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    if (bl3) {
                        bl3 = false;
                    } else {
                        object = (String)object + ", ";
                    }
                    object = (String)object + String.valueOf(entry.getKey()) + "=" + String.valueOf(entry.getValue());
                }
                object = (String)object + "}";
                int n2 = this.getNumNestedChoices(i, j);
                if (n2 == 0) continue;
                if (bl2) {
                    bl2 = false;
                } else {
                    object = (String)object + ", ";
                }
                object = (String)object + "[";
                for (int k = 0; k < n2; ++k) {
                    iterator = this.getNestedTransitionsIterator(i, j, k);
                    if (iterator == null) continue;
                    if (k > 0) {
                        object = (String)object + ", ";
                    }
                    object = (String)object + "{";
                    bl3 = true;
                    while (iterator.hasNext()) {
                        entry = iterator.next();
                        if (bl3) {
                            bl3 = false;
                        } else {
                            object = (String)object + ", ";
                        }
                        object = (String)object + String.valueOf(entry.getKey()) + "=" + String.valueOf(entry.getValue());
                    }
                    object = (String)object + "}";
                }
                object = (String)object + "]";
            }
            object = (String)object + "]";
        }
        object = (String)object + " ]";
        return object;
    }

    public String toString() {
        Object object = "";
        boolean bl = true;
        object = "[ ";
        for (int i = 0; i < this.numStates; ++i) {
            if (bl) {
                bl = false;
            } else {
                object = (String)object + ", ";
            }
            object = (String)object + i + ": " + String.valueOf(this.trans.get(i));
        }
        object = (String)object + " ]";
        return object;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof STPGAbstrSimple)) {
            return false;
        }
        STPGAbstrSimple sTPGAbstrSimple = (STPGAbstrSimple)object;
        if (this.numStates != sTPGAbstrSimple.numStates) {
            return false;
        }
        if (!this.initialStates.equals(sTPGAbstrSimple.initialStates)) {
            return false;
        }
        return this.trans.equals(sTPGAbstrSimple.trans);
    }

    public static void main(String[] stringArray) {
        try {
            STPGAbstrSimple<Double> sTPGAbstrSimple = new STPGAbstrSimple<Double>();
            sTPGAbstrSimple.addStates(4);
            DistributionSet distributionSet = sTPGAbstrSimple.newDistributionSet(null);
            Distribution<Double> distribution = Distribution.ofDouble();
            distribution.set(1, 1.0);
            distributionSet.add(distribution);
            sTPGAbstrSimple.addDistributionSet(0, distributionSet);
            distributionSet = sTPGAbstrSimple.newDistributionSet(null);
            distribution = Distribution.ofDouble();
            distribution.set(2, 1.0);
            distributionSet.add(distribution);
            distribution = Distribution.ofDouble();
            distribution.set(1, 1.0);
            distributionSet.add(distribution);
            sTPGAbstrSimple.addDistributionSet(1, distributionSet);
            distributionSet = sTPGAbstrSimple.newDistributionSet(null);
            distribution = Distribution.ofDouble();
            distribution.set(2, 0.5);
            distribution.set(3, 0.5);
            distributionSet.add(distribution);
            distribution = Distribution.ofDouble();
            distribution.set(3, 1.0);
            distributionSet.add(distribution);
            sTPGAbstrSimple.addDistributionSet(1, distributionSet);
            distributionSet = sTPGAbstrSimple.newDistributionSet(null);
            distribution = Distribution.ofDouble();
            distribution.set(2, 1.0);
            distributionSet.add(distribution);
            sTPGAbstrSimple.addDistributionSet(2, distributionSet);
            distributionSet = sTPGAbstrSimple.newDistributionSet(null);
            distribution = Distribution.ofDouble();
            distribution.set(3, 1.0);
            distributionSet.add(distribution);
            sTPGAbstrSimple.addDistributionSet(3, distributionSet);
            System.out.println(sTPGAbstrSimple);
            STPGModelChecker sTPGModelChecker = new STPGModelChecker(null);
            BitSet bitSet = new BitSet();
            bitSet.set(3);
            sTPGAbstrSimple.exportToDotFile("stpg.dot", bitSet);
            System.out.println("min min: " + sTPGModelChecker.computeReachProbs(sTPGAbstrSimple, (BitSet)bitSet, (boolean)true, (boolean)true).soln[0]);
            System.out.println("max min: " + sTPGModelChecker.computeReachProbs(sTPGAbstrSimple, (BitSet)bitSet, (boolean)false, (boolean)true).soln[0]);
            System.out.println("min max: " + sTPGModelChecker.computeReachProbs(sTPGAbstrSimple, (BitSet)bitSet, (boolean)true, (boolean)false).soln[0]);
            System.out.println("max max: " + sTPGModelChecker.computeReachProbs(sTPGAbstrSimple, (BitSet)bitSet, (boolean)false, (boolean)false).soln[0]);
        }
        catch (PrismException prismException) {
            System.out.println(prismException);
        }
    }
}

