/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.Distribution;
import explicit.MDPSimple;
import explicit.PPLSupport;
import explicit.Pareto;
import explicit.SMG;
import explicit.STPG;
import explicit.StateOwnersSimple;
import explicit.rewards.MDPRewards;
import explicit.rewards.Rewards;
import explicit.rewards.STPGRewards;
import io.ExplicitModelImporter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.fraction.BigFraction;
import parma_polyhedra_library.C_Polyhedron;
import parma_polyhedra_library.Coefficient;
import parma_polyhedra_library.Constraint;
import parma_polyhedra_library.Generator;
import parma_polyhedra_library.Generator_System;
import parma_polyhedra_library.Generator_Type;
import parma_polyhedra_library.Linear_Expression;
import parma_polyhedra_library.Linear_Expression_Coefficient;
import parma_polyhedra_library.Linear_Expression_Times;
import parma_polyhedra_library.Polyhedron;
import parma_polyhedra_library.Relation_Symbol;
import parma_polyhedra_library.Variable;
import prism.PlayerInfo;
import prism.PlayerInfoOwner;
import prism.PrismException;

public class SMGSimple<Value>
extends MDPSimple<Value>
implements SMG<Value> {
    protected StateOwnersSimple stateOwners;
    protected PlayerInfo playerInfo;

    public SMGSimple() {
    }

    public SMGSimple(int n) {
        super(n);
    }

    public SMGSimple(SMGSimple<Value> sMGSimple) {
        super(sMGSimple);
        this.stateOwners = new StateOwnersSimple(sMGSimple.stateOwners);
        this.playerInfo = new PlayerInfo(sMGSimple.playerInfo);
    }

    public SMGSimple(SMGSimple<Value> sMGSimple, int[] nArray) {
        super(sMGSimple, nArray);
        this.stateOwners = new StateOwnersSimple(sMGSimple.stateOwners, nArray);
        this.playerInfo = new PlayerInfo(sMGSimple.playerInfo);
    }

    @Override
    public void initialise(int n) {
        super.initialise(n);
        this.stateOwners = new StateOwnersSimple(n);
        this.playerInfo = new PlayerInfo();
    }

    @Override
    public void clearState(int n) {
        super.clearState(n);
        this.stateOwners.clearState(n);
    }

    @Override
    public void addStates(int n) {
        super.addStates(n);
        for (int i = 0; i < n; ++i) {
            this.stateOwners.addState(0);
        }
    }

    public int addState(int n) {
        int n2 = super.addState();
        this.stateOwners.setPlayer(n2, n);
        return n2;
    }

    public void setPlayer(int n, int n2) {
        this.stateOwners.setPlayer(n, n2);
    }

    @Override
    public void buildFromExplicitImport(ExplicitModelImporter explicitModelImporter) throws PrismException {
        super.buildFromExplicitImport(explicitModelImporter);
        explicitModelImporter.extractStateOwners(this::setPlayer);
    }

    public void copyPlayerInfo(PlayerInfoOwner playerInfoOwner) {
        this.playerInfo = new PlayerInfo(playerInfoOwner.getPlayerInfo());
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
        for (int i = 0; i < this.numStates; ++i) {
            if (!((List)this.trans.get(i)).isEmpty() || bitSet != null && bitSet.get(i)) continue;
            throw new PrismException("Game has a deadlock in state " + i + (String)(this.statesList == null ? "" : ": " + String.valueOf(this.statesList.get(i))));
        }
    }

    @Override
    public int getPlayer(int n) {
        return this.playerInfo.getPlayer(this.stateOwners.getPlayer(n));
    }

    @Override
    public void prob0step(BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, BitSet bitSet3) {
        boolean bl3 = false;
        for (int i = 0; i < this.numStates; ++i) {
            if (!bitSet.get(i)) continue;
            boolean bl4 = bl3 = this.getPlayer(i) == 0 ? bl : bl2;
            for (Distribution distribution : (List)this.trans.get(i)) {
                boolean bl5 = distribution.containsOneOf(bitSet2);
                if (bl3) {
                    if (bl5) continue;
                    bl4 = false;
                    continue;
                }
                if (!bl5) continue;
                bl4 = true;
            }
            bitSet3.set(i, bl4);
        }
    }

    @Override
    public void prob1step(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl, boolean bl2, BitSet bitSet4) {
        boolean bl3 = false;
        for (int i = 0; i < this.numStates; ++i) {
            if (!bitSet.get(i)) continue;
            boolean bl4 = bl3 = this.getPlayer(i) == 0 ? bl : bl2;
            for (Distribution distribution : (List)this.trans.get(i)) {
                boolean bl5;
                boolean bl6 = bl5 = distribution.containsOneOf(bitSet3) && distribution.isSubsetOf(bitSet2);
                if (bl3) {
                    if (bl5) continue;
                    bl4 = false;
                    continue;
                }
                if (!bl5) continue;
                bl4 = true;
            }
            bitSet4.set(i, bl4);
        }
    }

    @Override
    public void mvMultMinMax(double[] dArray, boolean bl, boolean bl2, double[] dArray2, BitSet bitSet, boolean bl3, int[] nArray) {
        boolean bl4 = false;
        if (bitSet == null) {
            for (int i = 0; i < this.numStates; ++i) {
                bl4 = this.getPlayer(i) == 0 ? bl : bl2;
                dArray2[i] = this.mvMultMinMaxSingle(i, dArray, bl4, nArray);
            }
        } else if (bl3) {
            int n = bitSet.nextClearBit(0);
            while (n < this.numStates) {
                bl4 = this.getPlayer(n) == 0 ? bl : bl2;
                dArray2[n] = this.mvMultMinMaxSingle(n, dArray, bl4, nArray);
                n = bitSet.nextClearBit(n + 1);
            }
        } else {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                bl4 = this.getPlayer(n) == 0 ? bl : bl2;
                dArray2[n] = this.mvMultMinMaxSingle(n, dArray, bl4, nArray);
                n = bitSet.nextSetBit(n + 1);
            }
        }
    }

    @Override
    public double mvMultMinMaxSingle(int n, double[] dArray, boolean bl, boolean bl2) {
        boolean bl3 = this.getPlayer(n) == 0 ? bl : bl2;
        return this.mvMultMinMaxSingle(n, dArray, bl3, null);
    }

    @Override
    public List<Integer> mvMultMinMaxSingleChoices(int n, double[] dArray, boolean bl, boolean bl2, double d) {
        boolean bl3 = this.getPlayer(n) == 0 ? bl : bl2;
        return this.mvMultMinMaxSingleChoices(n, dArray, bl3, d);
    }

    @Override
    public double mvMultGSMinMax(double[] dArray, boolean bl, boolean bl2, BitSet bitSet, boolean bl3, boolean bl4, int[] nArray) {
        double d = 0.0;
        if (bitSet == null) {
            for (int i = 0; i < this.numStates; ++i) {
                double d2 = this.mvMultJacMinMaxSingle(i, dArray, bl, bl2, nArray);
                double d3 = bl4 ? Math.abs(d2 - dArray[i]) : Math.abs(d2 - dArray[i]) / d2;
                d = d3 > d ? d3 : d;
                dArray[i] = d2;
            }
        } else if (bl3) {
            int n = bitSet.nextClearBit(0);
            while (n < this.numStates) {
                double d4 = this.mvMultJacMinMaxSingle(n, dArray, bl, bl2, nArray);
                double d5 = bl4 ? Math.abs(d4 - dArray[n]) : Math.abs(d4 - dArray[n]) / d4;
                d = d5 > d ? d5 : d;
                dArray[n] = d4;
                n = bitSet.nextClearBit(n + 1);
            }
        } else {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                double d6 = this.mvMultJacMinMaxSingle(n, dArray, bl, bl2, nArray);
                double d7 = bl4 ? Math.abs(d6 - dArray[n]) : Math.abs(d6 - dArray[n]) / d6;
                d = d7 > d ? d7 : d;
                dArray[n] = d6;
                n = bitSet.nextSetBit(n + 1);
            }
        }
        return d;
    }

    @Override
    public double mvMultJacMinMaxSingle(int n, double[] dArray, boolean bl, boolean bl2, int[] nArray) {
        boolean bl3 = this.getPlayer(n) == 0 ? bl : bl2;
        return this.mvMultJacMinMaxSingle(n, dArray, bl3, nArray);
    }

    @Override
    public void mvMultRewMinMax(double[] dArray, STPGRewards<Double> sTPGRewards, boolean bl, boolean bl2, double[] dArray2, BitSet bitSet, boolean bl3, int[] nArray) {
        boolean bl4 = false;
        if (bitSet == null) {
            for (int i = 0; i < this.numStates; ++i) {
                bl4 = this.getPlayer(i) == 0 ? bl : bl2;
                dArray2[i] = this.mvMultRewMinMaxSingle(i, dArray, sTPGRewards, bl4, nArray, 1.0);
            }
        } else if (bl3) {
            int n = bitSet.nextClearBit(0);
            while (n < this.numStates) {
                bl4 = this.getPlayer(n) == 0 ? bl : bl2;
                dArray2[n] = this.mvMultRewMinMaxSingle(n, dArray, sTPGRewards, bl4, nArray, 1.0);
                n = bitSet.nextClearBit(n + 1);
            }
        } else {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                bl4 = this.getPlayer(n) == 0 ? bl : bl2;
                dArray2[n] = this.mvMultRewMinMaxSingle(n, dArray, sTPGRewards, bl4, nArray, 1.0);
                n = bitSet.nextSetBit(n + 1);
            }
        }
    }

    @Override
    public double mvMultRewMinMaxSingle(int n, double[] dArray, STPGRewards<Double> sTPGRewards, boolean bl, boolean bl2, int[] nArray) {
        boolean bl3 = this.getPlayer(n) == 0 ? bl : bl2;
        return this.mvMultRewMinMaxSingle(n, dArray, sTPGRewards, bl3, nArray);
    }

    @Override
    public List<Integer> mvMultRewMinMaxSingleChoices(int n, double[] dArray, STPGRewards<Double> sTPGRewards, boolean bl, boolean bl2, double d) {
        boolean bl3 = this.getPlayer(n) == 0 ? bl : bl2;
        return this.mvMultRewMinMaxSingleChoices(n, dArray, sTPGRewards, bl3, d);
    }

    @Override
    public void mvMultRewMinMax(double[] dArray, STPGRewards<Double> sTPGRewards, boolean bl, boolean bl2, double[] dArray2, BitSet bitSet, boolean bl3, int[] nArray, double d) {
        boolean bl4 = false;
        if (bitSet == null) {
            for (int i = 0; i < this.numStates; ++i) {
                bl4 = this.getPlayer(i) == 0 ? bl : bl2;
                dArray2[i] = this.mvMultRewMinMaxSingle(i, dArray, sTPGRewards, bl4, nArray, d);
            }
        } else if (bl3) {
            int n = bitSet.nextClearBit(0);
            while (n < this.numStates) {
                bl4 = this.getPlayer(n) == 0 ? bl : bl2;
                dArray2[n] = this.mvMultRewMinMaxSingle(n, dArray, sTPGRewards, bl4, nArray, d);
                n = bitSet.nextClearBit(n + 1);
            }
        } else {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                bl4 = this.getPlayer(n) == 0 ? bl : bl2;
                dArray2[n] = this.mvMultRewMinMaxSingle(n, dArray, sTPGRewards, bl4, nArray, d);
                n = bitSet.nextSetBit(n + 1);
            }
        }
    }

    public double mvMultRewMinMaxSingle(int n3, double[] dArray, MDPRewards<Double> mDPRewards, boolean bl, int[] nArray, double d) {
        int n4 = -1;
        double d3 = 0.0;
        boolean bl2 = true;
        int n5 = this.getNumChoices(n3);
        for (int i = 0; i < n5; ++i) {
            double d4 = (Double)mDPRewards.getTransitionReward(n3, i);
            d4 += this.sumOverDoubleTransitions(n3, i, (n, n2, d2) -> d2 * dArray[n2] * d);
            if (bl2 || bl && d4 < d3 || !bl && d4 > d3) {
                d3 = d4;
                if (nArray != null) {
                    n4 = i;
                }
            }
            bl2 = false;
        }
        if (nArray != null & !bl2 && (nArray[n3] == -1 || bl && d3 < dArray[n3] || !bl && d3 > dArray[n3] || this instanceof STPG)) {
            nArray[n3] = n4;
        }
        return d3 += ((Double)mDPRewards.getStateReward(n3)).doubleValue();
    }

    @Override
    public PlayerInfo getPlayerInfo() {
        return this.playerInfo;
    }

    @Override
    public void reachpositivestep(BitSet bitSet, boolean bl, boolean bl2, BitSet bitSet2) {
        boolean bl3 = false;
        for (int i = 0; i < this.numStates; ++i) {
            if (!bitSet.get(i)) continue;
            bl3 = this.getPlayer(i) == 0 ? bl : bl2;
            HashSet<Integer> hashSet = null;
            boolean bl4 = true;
            for (Distribution distribution : (List)this.trans.get(i)) {
                if (bl4) {
                    hashSet = new HashSet<Integer>(distribution.getSupport());
                    bl4 = false;
                    continue;
                }
                if (!bl4 && bl3) {
                    hashSet.retainAll(distribution.getSupport());
                    continue;
                }
                if (!(!bl4 & !bl3)) continue;
                hashSet.addAll(distribution.getSupport());
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                bitSet2.set(n, true);
            }
        }
    }

    @Override
    public void subtreeStep(BitSet bitSet, int n, BitSet bitSet2) {
        for (int i = 0; i < this.numStates; ++i) {
            boolean bl;
            boolean bl2 = bl = this.getNumChoices(i) == 1 && this.getPlayer(i) != n;
            if (!bitSet.get(i) || this.getPlayer(i) != n && !bl) continue;
            for (Distribution distribution : (List)this.trans.get(i)) {
                for (int n2 : distribution.getSupport()) {
                    bitSet2.set(n2, true);
                }
            }
        }
    }

    @Override
    public Pareto[] pMultiObjective(Pareto[] paretoArray, List<Rewards<Double>> list, boolean bl, long l, double[] dArray, List<Pareto>[] listArray, boolean bl2, boolean bl3, boolean bl4, long l2) throws PrismException {
        Pareto[] paretoArray2 = new Pareto[paretoArray.length];
        Pareto[] paretoArray3 = bl ? null : new Pareto[paretoArray.length];
        System.arraycopy(paretoArray, 0, bl ? paretoArray2 : paretoArray3, 0, paretoArray.length);
        for (int i = 0; i < this.numStates; ++i) {
            ArrayList<Pareto> arrayList = new ArrayList<Pareto>(((List)this.trans.get(i)).size());
            paretoArray2[i] = this.pMultiObjectiveSingle(i, bl ? paretoArray2 : paretoArray3, list, l, dArray, arrayList, bl2, bl3, bl4, l2);
            if (listArray == null) continue;
            listArray[i] = arrayList;
        }
        return paretoArray2;
    }

    private Polyhedron round(Generator_System generator_System, long l, double[] dArray, boolean bl) throws PrismException {
        int n = dArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            long l2 = bl ? l : (long)((double)l / dArray[i]);
            lArray[i] = l2 < Long.MAX_VALUE && l2 > 0L ? l2 : Long.MAX_VALUE;
        }
        Generator_System generator_System2 = new Generator_System();
        for (Generator generator : generator_System) {
            if (generator.type() == Generator_Type.POINT) {
                Linear_Expression_Coefficient linear_Expression_Coefficient;
                Linear_Expression linear_Expression = generator.linear_expression();
                Coefficient coefficient = generator.divisor();
                HashMap<Variable, BigInteger> hashMap = new HashMap<Variable, BigInteger>();
                PPLSupport.getCoefficientsFromLinearExpression(linear_Expression, false, BigInteger.ONE, hashMap);
                Coefficient coefficient2 = new Coefficient(BigInteger.valueOf(l));
                if (hashMap.containsKey(null)) {
                    if (((BigInteger)hashMap.get(null)).compareTo(BigInteger.ZERO) != 0) {
                        throw new PrismException("Exception in Polyhedron presentation.");
                    }
                    linear_Expression_Coefficient = new Linear_Expression_Coefficient(new Coefficient((BigInteger)hashMap.get(null)));
                } else {
                    linear_Expression_Coefficient = new Linear_Expression_Coefficient(new Coefficient(BigInteger.ZERO));
                }
                for (Variable variable : hashMap.keySet()) {
                    if (variable == null) continue;
                    BigFraction bigFraction = new BigFraction((BigInteger)hashMap.get(variable), coefficient.getBigInteger());
                    long l3 = (long)(Math.floor(bigFraction.doubleValue() * (double)lArray[(int)variable.id()]) * (double)l / (double)lArray[(int)variable.id()]);
                    linear_Expression_Coefficient = linear_Expression_Coefficient.sum((Linear_Expression)new Linear_Expression_Times(new Coefficient(l3), variable));
                }
                generator_System2.add((Object)Generator.point((Linear_Expression)linear_Expression_Coefficient, (Coefficient)coefficient2));
                continue;
            }
            if (generator.type() != Generator_Type.RAY) continue;
            generator_System2.add((Object)generator);
        }
        Iterator iterator = new C_Polyhedron(generator_System2);
        if (iterator.space_dimension() != (long)n) {
            iterator.add_space_dimensions_and_project((long)n - iterator.space_dimension());
        }
        return iterator;
    }

    protected Pareto stochasticState(int n, Distribution<Value> distribution, int n2, Pareto[] paretoArray, List<Rewards<Double>> list, double[] dArray, boolean bl, long l) throws PrismException {
        Polyhedron polyhedron;
        int n3 = list.size();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(distribution.getSupport());
        int n4 = arrayList.size();
        Pareto pareto = null;
        if (n4 == 0) {
            throw new PrismException("Distribution " + n + ", " + n2 + " has no successors.");
        }
        if (n4 == 1) {
            pareto = paretoArray[arrayList.get(0)];
        } else {
            Linear_Expression_Coefficient linear_Expression_Coefficient;
            BigFraction bigFraction;
            BigFraction[] bigFractionArray = new BigFraction[n4];
            BigFraction bigFraction2 = BigFraction.ONE;
            int n5 = 0;
            for (Integer n6 : arrayList) {
                bigFractionArray[n5] = bigFraction = new BigFraction(this.getEvaluator().toDouble(distribution.get(n6)));
                bigFraction2 = bigFraction2.subtract(bigFraction);
                ++n5;
            }
            bigFractionArray[0] = bigFractionArray[0].add(bigFraction2);
            n5 = 0;
            for (Integer n6 : arrayList) {
                bigFraction = new C_Polyhedron((C_Polyhedron)paretoArray[n6].get());
                bigFraction.add_space_dimensions_and_embed((long)n4);
                BigFraction bigFraction3 = bigFractionArray[n5];
                for (int i = 0; i < n4; ++i) {
                    if (i == n5) {
                        polyhedron = new Linear_Expression_Times(new Coefficient(bigFraction3.getNumerator()), new Variable((long)(n3 + i)));
                        linear_Expression_Coefficient = new Linear_Expression_Coefficient(new Coefficient(bigFraction3.getDenominator()));
                    } else {
                        polyhedron = new Linear_Expression_Times(new Coefficient(BigInteger.ONE), new Variable((long)(n3 + i)));
                        linear_Expression_Coefficient = new Linear_Expression_Coefficient(new Coefficient(BigInteger.ZERO));
                    }
                    Constraint constraint = new Constraint((Linear_Expression)polyhedron, Relation_Symbol.EQUAL, (Linear_Expression)linear_Expression_Coefficient);
                    bigFraction.add_constraint(constraint);
                }
                if (pareto == null) {
                    pareto = new Pareto((Polyhedron)bigFraction);
                } else {
                    pareto.get().upper_bound_assign((Polyhedron)bigFraction);
                }
                ++n5;
            }
            n5 = 0;
            for (Integer n6 : arrayList) {
                polyhedron = new Linear_Expression_Times(new Coefficient(BigInteger.ONE), new Variable((long)(n3 + n5)));
                linear_Expression_Coefficient = new Linear_Expression_Coefficient(new Coefficient(BigInteger.ONE));
                bigFraction = new Constraint((Linear_Expression)polyhedron, Relation_Symbol.EQUAL, (Linear_Expression)linear_Expression_Coefficient);
                pareto.get().add_constraint((Constraint)bigFraction);
                ++n5;
            }
            pareto.get().remove_higher_space_dimensions((long)n3);
        }
        polyhedron = PPLSupport.add_rewards(pareto.get(), n, n2, list, dArray);
        if (bl) {
            PPLSupport.cutBox(polyhedron, l);
        }
        return new Pareto(polyhedron);
    }

    private Pareto pMultiObjectiveSingle(int n, Pareto[] paretoArray, List<Rewards<Double>> list, long l, double[] dArray, List<Pareto> list2, boolean bl, boolean bl2, boolean bl3, long l2) throws PrismException {
        Polyhedron polyhedron;
        int n2 = list.size();
        List list3 = (List)this.trans.get(n);
        int n3 = 0;
        for (Distribution distribution : list3) {
            list2.add(this.stochasticState(n, distribution, n3, paretoArray, list, null, bl3, l2));
            ++n3;
        }
        if (list2.size() > 0) {
            if (this.getPlayer(n) == 0) {
                polyhedron = new C_Polyhedron(list2.get(0).get().generators());
                int n4 = 0;
                for (n4 = 0; n4 < list2.size(); ++n4) {
                    if (list2.get(n4).get().is_empty()) continue;
                    polyhedron = new C_Polyhedron(list2.get(n4).get().generators());
                    break;
                }
                if (list2.get(0).get().space_dimension() > polyhedron.space_dimension()) {
                    polyhedron.add_space_dimensions_and_project(list2.get(0).get().space_dimension() - polyhedron.space_dimension());
                }
                for (int i = n4 + 1; i < list2.size(); ++i) {
                    if (list2.get(i).get().is_empty()) continue;
                    polyhedron.upper_bound_assign(list2.get(i).get());
                }
            } else {
                polyhedron = new C_Polyhedron(list2.get(0).get().generators());
                polyhedron.add_space_dimensions_and_project(list2.get(0).get().space_dimension() - polyhedron.space_dimension());
                for (int i = 1; i < list2.size(); ++i) {
                    if (!polyhedron.is_empty() && !list2.get(i).get().is_empty()) {
                        polyhedron.intersection_assign(list2.get(i).get());
                        continue;
                    }
                    if (polyhedron.is_empty()) continue;
                    polyhedron = new C_Polyhedron(list2.get(i).get().generators());
                }
            }
        } else {
            polyhedron = paretoArray[n].get();
        }
        polyhedron = PPLSupport.add_rewards(polyhedron, n, Integer.MIN_VALUE, list, null);
        if (bl) {
            polyhedron = this.round(polyhedron.generators(), l, dArray, bl3);
        }
        if (bl && bl2) {
            polyhedron.upper_bound_assign(paretoArray[n].get());
        }
        if (bl3) {
            PPLSupport.cutBox(polyhedron, l2);
        }
        if ((polyhedron = new C_Polyhedron(polyhedron.minimized_generators())).space_dimension() != (long)n2) {
            polyhedron.add_space_dimensions_and_project((long)n2 - polyhedron.space_dimension());
        }
        return new Pareto(polyhedron);
    }

    @Override
    public String toString() {
        Object object = "";
        object = "[ ";
        for (int i = 0; i < this.numStates; ++i) {
            if (i > 0) {
                object = (String)object + ", ";
            }
            object = this.statesList.size() > i ? (String)object + i + "(P-" + (this.stateOwners.getPlayer(i) + 1) + " " + String.valueOf(this.statesList.get(i)) + "): " : (String)object + i + "(P-" + (this.stateOwners.getPlayer(i) + 1) + "): ";
            object = (String)object + "[";
            int n = this.getNumChoices(i);
            for (int j = 0; j < n; ++j) {
                Object object2;
                if (j > 0) {
                    object = (String)object + ",";
                }
                if ((object2 = this.getAction(i, j)) != null) {
                    object = (String)object + String.valueOf(object2) + ":";
                }
                object = (String)object + String.valueOf(((List)this.trans.get(i)).get(j));
            }
            object = (String)object + "]";
        }
        object = (String)object + " ]\n";
        return object;
    }
}

