/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import com.microsoft.z3.AlgebraicNum;
import com.microsoft.z3.ArithExpr;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.IntNum;
import com.microsoft.z3.Model;
import com.microsoft.z3.Params;
import com.microsoft.z3.RatNum;
import com.microsoft.z3.Solver;
import com.microsoft.z3.Status;
import explicit.CSGModelCheckerEquilibria;
import explicit.CSGSupportEnumeration;
import explicit.Distribution;
import explicit.EquilibriumResult;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import prism.Pair;

public class CSGSupportEnumerationZ3
implements CSGSupportEnumeration {
    private HashMap<String, String> cfg;
    private Context ctx;
    private Solver s;
    private HashMap<Integer, HashMap<Integer, ArithExpr>> assertions;
    private ArrayList<ArrayList<ArithExpr>> strategies;
    private ArrayList<ArrayList<Integer>> indexes;
    private ArrayList<ArithExpr> payoffs;
    private IntNum zero;
    private IntNum one;
    private BitSet players;
    private BoolExpr support;
    private int numCoalitions;
    private Params params;
    private ArrayList<Distribution<Double>> strat;

    public CSGSupportEnumerationZ3() {
    }

    public CSGSupportEnumerationZ3(int[] nArray, int n) {
        this.cfg = new HashMap();
        this.cfg.put("model", "true");
        this.ctx = new Context(this.cfg);
        this.s = this.ctx.mkSolver();
        this.params = this.ctx.mkParams();
        this.params.add("timeout", 20);
        this.s.setParameters(this.params);
        this.assertions = new HashMap();
        this.strategies = new ArrayList();
        this.payoffs = new ArrayList();
        this.players = new BitSet();
        this.strat = new ArrayList();
        this.players.set(0, n);
        this.zero = this.ctx.mkInt(0);
        this.one = this.ctx.mkInt(1);
        for (int i = 0; i < n; ++i) {
            this.strategies.add(i, new ArrayList());
            this.payoffs.add(i, (ArithExpr)this.ctx.mkRealConst("v_" + i));
            for (int j = 0; j < nArray[i]; ++j) {
                this.strategies.get(i).add(j, (ArithExpr)this.ctx.mkRealConst("p_" + i + "_" + j));
                this.s.add(new Expr[]{this.ctx.mkGe((Expr)this.strategies.get(i).get(j), (Expr)this.zero)});
                this.s.add(new Expr[]{this.ctx.mkLe((Expr)this.strategies.get(i).get(j), (Expr)this.one)});
            }
        }
    }

    @Override
    public void computeConstraints(BitSet bitSet) {
        for (int i = 0; i < this.indexes.size(); ++i) {
            for (int j = 0; j < this.indexes.get(i).size(); ++j) {
                if (bitSet.get(this.indexes.get(i).get(j))) {
                    this.s.add(new Expr[]{this.ctx.mkEq((Expr)this.assertions.get(i).get(j), (Expr)this.payoffs.get(i))});
                    continue;
                }
                this.s.add(new Expr[]{this.ctx.mkLe((Expr)this.assertions.get(i).get(j), (Expr)this.payoffs.get(i))});
            }
        }
    }

    @Override
    public void computeSupport(BitSet bitSet, HashMap<Integer, int[]> hashMap) {
        this.support = this.ctx.mkTrue();
        for (int i = 0; i < this.indexes.size(); ++i) {
            for (int j = 0; j < this.indexes.get(i).size(); ++j) {
                this.support = bitSet.get(this.indexes.get(i).get(j)) ? this.ctx.mkAnd(new Expr[]{this.support, this.ctx.mkGt((Expr)this.strategies.get(i).get(j), (Expr)this.zero)}) : this.ctx.mkAnd(new Expr[]{this.support, this.ctx.mkEq((Expr)this.strategies.get(i).get(j), (Expr)this.zero)});
            }
        }
        this.s.add(new Expr[]{this.support});
    }

    @Override
    public EquilibriumResult computeEquilibria(BitSet bitSet, HashMap<Integer, int[]> hashMap) {
        int n;
        int n2;
        EquilibriumResult equilibriumResult = new EquilibriumResult();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        this.s.push();
        this.computeConstraints(bitSet);
        this.computeSupport(bitSet, hashMap);
        for (n2 = 0; n2 < this.numCoalitions; ++n2) {
            IntNum intNum = this.zero;
            for (n = 0; n < this.indexes.get(n2).size(); ++n) {
                intNum = this.ctx.mkAdd(new Expr[]{intNum, (Expr)this.strategies.get(n2).get(n)});
            }
            this.s.add(new Expr[]{this.ctx.mkEq((Expr)intNum, (Expr)this.one)});
        }
        Status status = this.s.check();
        this.strat.clear();
        if (status == Status.SATISFIABLE) {
            Model model = this.s.getModel();
            for (n2 = 0; n2 < this.numCoalitions; ++n2) {
                Distribution<Double> distribution = new Distribution<Double>();
                arrayList.add(n2, this.getDoubleValue(model, (Expr)this.payoffs.get(n2)));
                for (n = 0; n < this.strategies.get(n2).size(); ++n) {
                    double d = this.getDoubleValue(model, (Expr)this.strategies.get(n2).get(n));
                    if (!(d > 0.0)) continue;
                    distribution.add(n, d);
                }
                this.strat.add(distribution);
            }
        }
        this.s.pop();
        equilibriumResult.setStatus(status == Status.SATISFIABLE ? CSGModelCheckerEquilibria.CSGResultStatus.SAT : (status == Status.UNKNOWN ? CSGModelCheckerEquilibria.CSGResultStatus.UNKNOWN : CSGModelCheckerEquilibria.CSGResultStatus.UNSAT));
        equilibriumResult.setPayoffVector(new ArrayList<Double>(arrayList));
        equilibriumResult.setStrategy(new ArrayList<Distribution<Double>>(this.strat));
        return equilibriumResult;
    }

    @Override
    public void translateAssertions(HashMap<Integer, HashMap<Integer, ArrayList<Pair<BitSet, Double>>>> hashMap, HashMap<Integer, int[]> hashMap2) {
        this.assertions.clear();
        for (int i = 0; i < hashMap.keySet().size(); ++i) {
            this.assertions.put(i, new HashMap());
            for (int j = 0; j < hashMap.get(i).keySet().size(); ++j) {
                IntNum intNum = this.zero;
                for (Pair<BitSet, Double> pair : hashMap.get(i).get(j)) {
                    ArithExpr arithExpr = this.getRealValue((Double)pair.second);
                    int n = ((BitSet)pair.first).nextSetBit(0);
                    while (n >= 0) {
                        arithExpr = this.ctx.mkMul(new Expr[]{arithExpr, (Expr)this.strategies.get(hashMap2.get(n)[0]).get(hashMap2.get(n)[1])});
                        n = ((BitSet)pair.first).nextSetBit(n + 1);
                    }
                    intNum = this.ctx.mkAdd(new Expr[]{intNum, arithExpr});
                }
                this.assertions.get(i).put(j, (ArithExpr)intNum);
            }
        }
    }

    public double getDoubleValue(Model model, Expr expr) {
        if (model.getConstInterp(expr) instanceof RatNum) {
            RatNum ratNum = (RatNum)model.getConstInterp(expr);
            return ratNum.getBigIntNumerator().doubleValue() / ratNum.getBigIntDenominator().doubleValue();
        }
        if (model.getConstInterp(expr) instanceof AlgebraicNum) {
            AlgebraicNum algebraicNum = (AlgebraicNum)model.getConstInterp(expr);
            RatNum ratNum = algebraicNum.toUpper(9);
            return ratNum.getBigIntNumerator().doubleValue() / ratNum.getBigIntDenominator().doubleValue();
        }
        return Double.NaN;
    }

    public ArithExpr getRealValue(double d) {
        RatNum ratNum = null;
        try {
            ratNum = this.ctx.mkReal(String.valueOf(d));
        }
        catch (Exception exception) {
            System.out.println("Error converting value " + d + " to a real.");
            System.out.println("assertions: " + String.valueOf(this.assertions));
            exception.printStackTrace();
        }
        return ratNum;
    }

    @Override
    public ArrayList<Distribution<Double>> getStrat() {
        return new ArrayList<Distribution<Double>>(this.strat);
    }

    @Override
    public void setNumPlayers(int n) {
        this.numCoalitions = n;
    }

    @Override
    public void setIndexes(ArrayList<ArrayList<Integer>> arrayList) {
        this.indexes = arrayList;
    }

    @Override
    public void setGradient(HashMap<Integer, HashMap<Integer, ArrayList<Pair<BitSet, Double>>>> hashMap) {
    }

    @Override
    public void setAssertions(HashMap<Integer, HashMap<Integer, ArrayList<Pair<BitSet, Double>>>> hashMap) {
    }

    @Override
    public void setMap(HashMap<Integer, int[]> hashMap) {
    }

    @Override
    public void init() {
    }
}

