/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.PartiallyObservableModel;
import java.util.Arrays;
import java.util.List;
import parser.State;
import prism.PrismUtils;

public class Belief
implements Comparable<Belief> {
    public int so;
    public double[] bu;

    public Belief(int n, double[] dArray) {
        this.so = n;
        this.bu = dArray;
    }

    protected Belief(double[] dArray, PartiallyObservableModel<?> partiallyObservableModel) {
        this.so = -1;
        this.bu = new double[partiallyObservableModel.getNumUnobservations()];
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == 0.0) continue;
            this.so = partiallyObservableModel.getObservation(i);
            int n = partiallyObservableModel.getUnobservation(i);
            this.bu[n] = this.bu[n] + dArray[i];
        }
    }

    public static Belief pointDistribution(int n, PartiallyObservableModel<?> partiallyObservableModel) {
        int n2 = partiallyObservableModel.getObservation(n);
        double[] dArray = new double[partiallyObservableModel.getNumUnobservations()];
        dArray[partiallyObservableModel.getUnobservation((int)n)] = 1.0;
        return new Belief(n2, dArray);
    }

    public double[] toDistributionOverStates(PartiallyObservableModel<?> partiallyObservableModel) {
        double[] dArray = new double[partiallyObservableModel.getNumStates()];
        int n = partiallyObservableModel.getNumStates();
        for (int i = 0; i < n; ++i) {
            if (partiallyObservableModel.getObservation(i) != this.so) continue;
            int n2 = partiallyObservableModel.getUnobservation(i);
            dArray[i] = this.bu[n2];
        }
        PrismUtils.normalise(dArray);
        return dArray;
    }

    public int hashCode() {
        return 13 * Arrays.hashCode(this.bu) + this.so;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Belief belief = (Belief)object;
        if (this.so != belief.so) {
            return false;
        }
        if (this.bu.length != belief.bu.length) {
            return false;
        }
        for (int i = 0; i < belief.bu.length; ++i) {
            if (!(Math.abs(this.bu[i] - belief.bu[i]) > 1.0E-6)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Belief belief) {
        if (belief == null) {
            throw new NullPointerException();
        }
        int n = this.bu.length;
        double[] dArray = belief.bu;
        if (n != dArray.length) {
            throw new ClassCastException("Beliefs are different sizes");
        }
        if (this.so > belief.so) {
            return 1;
        }
        if (this.so < belief.so) {
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            if (this.bu[i] - dArray[i] > 1.0E-6) {
                return 1;
            }
            if (!(dArray[i] - this.bu[i] > 1.0E-6)) continue;
            return -1;
        }
        return 0;
    }

    public String toString(PartiallyObservableModel<?> partiallyObservableModel) {
        return Belief.toString(this.so, this.bu, partiallyObservableModel);
    }

    public static String toString(int n, double[] dArray, PartiallyObservableModel<?> partiallyObservableModel) {
        return partiallyObservableModel.getObservationsList().get(n).toString() + "," + Belief.toStringUnobs(dArray, partiallyObservableModel);
    }

    public static String toStringUnobs(double[] dArray, PartiallyObservableModel<?> partiallyObservableModel) {
        List<State> list = partiallyObservableModel.getUnobservationsList();
        Object object = "";
        boolean bl = true;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > 0.0)) continue;
            if (!bl) {
                object = (String)object + "+";
            }
            object = (String)object + dArray[i] + ":" + list.get(i).toString();
            bl = false;
        }
        return object;
    }

    public String toString() {
        return "{" + this.so + "}," + Arrays.toString(this.bu);
    }
}

