/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.functions.DoubleLongToDoubleFunction;
import common.functions.IntDoubleToIntFunction;
import common.functions.IntLongToIntFunction;
import common.functions.LongDoubleToLongFunction;
import common.functions.ObjDoubleFunction;
import common.functions.ObjIntFunction;
import common.functions.ObjLongFunction;
import common.iterable.ArrayIterator;
import common.iterable.ChainedIterator;
import common.iterable.FilteringIterator;
import common.iterable.FunctionalIterator;
import common.iterable.MappingIterator;
import common.iterable.PrimitiveReducible;
import java.util.Iterator;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

public interface FunctionalPrimitiveIterator<E, E_CONS>
extends PrimitiveReducible<E, Iterator<? extends E>, E_CONS>,
FunctionalIterator<E>,
PrimitiveIterator<E, E_CONS> {
    @Override
    default public void forEach(E_CONS E_CONS) {
        this.unwrap().forEachRemaining(E_CONS);
        this.release();
    }

    public PrimitiveIterator<E, E_CONS> unwrap();

    public static interface OfLong
    extends FunctionalPrimitiveIterator<Long, LongConsumer>,
    PrimitiveReducible.OfLong<Iterator<? extends Long>>,
    PrimitiveIterator.OfLong {
        @Override
        default public PrimitiveIterator.OfLong unwrap() {
            return this;
        }

        @Override
        default public FunctionalIterator<Long> concat(Iterator<? extends Long> iterator) {
            if (iterator instanceof PrimitiveIterator.OfLong) {
                return this.concat((PrimitiveIterator.OfLong)iterator);
            }
            return FunctionalPrimitiveIterator.super.concat(iterator);
        }

        default public OfLong concat(PrimitiveIterator.OfLong ofLong) {
            return new ChainedIterator.OfLong(this.unwrap(), (Iterator<? extends PrimitiveIterator.OfLong>)new ArrayIterator.Of<PrimitiveIterator.OfLong>(ofLong));
        }

        @Override
        default public OfLong dedupe() {
            return (OfLong)PrimitiveReducible.OfLong.super.dedupe();
        }

        @Override
        default public OfLong distinct() {
            return (OfLong)PrimitiveReducible.OfLong.super.distinct();
        }

        default public OfLong filter(LongPredicate longPredicate) {
            return new FilteringIterator.OfLong(this.unwrap(), longPredicate);
        }

        default public <T> FunctionalIterator<T> flatMap(LongFunction<? extends Iterator<? extends T>> longFunction) {
            return new ChainedIterator.Of(this.map(longFunction));
        }

        default public OfDouble flatMapToDouble(LongFunction<PrimitiveIterator.OfDouble> longFunction) {
            return new ChainedIterator.OfDouble((Iterator<? extends PrimitiveIterator.OfDouble>)((Object)this.map(longFunction)));
        }

        default public OfInt flatMapToInt(LongFunction<PrimitiveIterator.OfInt> longFunction) {
            return new ChainedIterator.OfInt((Iterator<? extends PrimitiveIterator.OfInt>)((Object)this.map(longFunction)));
        }

        default public OfLong flatMapToLong(LongFunction<PrimitiveIterator.OfLong> longFunction) {
            return new ChainedIterator.OfLong((Iterator<? extends PrimitiveIterator.OfLong>)((Object)this.map(longFunction)));
        }

        default public <T> FunctionalIterator<T> map(LongFunction<? extends T> longFunction) {
            return new MappingIterator.LongToObj<T>(this.unwrap(), longFunction);
        }

        default public OfDouble mapToDouble(LongToDoubleFunction longToDoubleFunction) {
            return new MappingIterator.LongToDouble(this.unwrap(), longToDoubleFunction);
        }

        default public OfInt mapToInt(LongToIntFunction longToIntFunction) {
            return new MappingIterator.LongToInt(this.unwrap(), longToIntFunction);
        }

        default public OfLong mapToLong(LongUnaryOperator longUnaryOperator) {
            return new MappingIterator.LongToLong(this.unwrap(), longUnaryOperator);
        }

        @Override
        default public OfLong nonNull() {
            return this;
        }

        @Override
        default public OfLong consume() {
            return (OfLong)PrimitiveReducible.OfLong.super.consume();
        }

        @Override
        default public boolean contains(Object object) {
            boolean bl = PrimitiveReducible.OfLong.super.contains(object);
            this.release();
            return bl;
        }

        @Override
        default public long detect(LongPredicate longPredicate) {
            return this.filter(longPredicate).nextLong();
        }

        @Override
        default public OptionalLong reduce(LongBinaryOperator longBinaryOperator) {
            Objects.requireNonNull(longBinaryOperator);
            if (!this.hasNext()) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(this.reduce(this.nextLong(), longBinaryOperator));
        }

        @Override
        default public <T> T reduce(T t, ObjLongFunction<T, T> objLongFunction) {
            Objects.requireNonNull(objLongFunction);
            PrimitiveIterator.OfLong ofLong = this.unwrap();
            T t2 = t;
            while (ofLong.hasNext()) {
                t2 = objLongFunction.apply(t2, ofLong.nextLong());
            }
            this.release();
            return t2;
        }

        @Override
        default public double reduce(double d, DoubleLongToDoubleFunction doubleLongToDoubleFunction) {
            Objects.requireNonNull(doubleLongToDoubleFunction);
            PrimitiveIterator.OfLong ofLong = this.unwrap();
            double d2 = d;
            while (ofLong.hasNext()) {
                d2 = doubleLongToDoubleFunction.applyAsDouble(d2, ofLong.nextLong());
            }
            this.release();
            return d2;
        }

        @Override
        default public int reduce(int n, IntLongToIntFunction intLongToIntFunction) {
            Objects.requireNonNull(intLongToIntFunction);
            PrimitiveIterator.OfLong ofLong = this.unwrap();
            int n2 = n;
            while (ofLong.hasNext()) {
                n2 = intLongToIntFunction.applyAsInt(n2, ofLong.nextLong());
            }
            this.release();
            return n2;
        }

        @Override
        default public long reduce(long l, LongBinaryOperator longBinaryOperator) {
            Objects.requireNonNull(longBinaryOperator);
            PrimitiveIterator.OfLong ofLong = this.unwrap();
            long l2 = l;
            while (ofLong.hasNext()) {
                l2 = longBinaryOperator.applyAsLong(l2, ofLong.nextLong());
            }
            this.release();
            return l2;
        }
    }

    public static interface OfInt
    extends FunctionalPrimitiveIterator<Integer, IntConsumer>,
    PrimitiveReducible.OfInt<Iterator<? extends Integer>>,
    PrimitiveIterator.OfInt {
        @Override
        default public PrimitiveIterator.OfInt unwrap() {
            return this;
        }

        @Override
        default public FunctionalIterator<Integer> concat(Iterator<? extends Integer> iterator) {
            if (iterator instanceof PrimitiveIterator.OfInt) {
                return this.concat((PrimitiveIterator.OfInt)iterator);
            }
            return FunctionalPrimitiveIterator.super.concat(iterator);
        }

        default public OfInt concat(PrimitiveIterator.OfInt ofInt) {
            return new ChainedIterator.OfInt(this.unwrap(), (Iterator<? extends PrimitiveIterator.OfInt>)new ArrayIterator.Of<PrimitiveIterator.OfInt>(ofInt));
        }

        @Override
        default public OfInt dedupe() {
            return (OfInt)PrimitiveReducible.OfInt.super.dedupe();
        }

        @Override
        default public OfInt distinct() {
            return (OfInt)PrimitiveReducible.OfInt.super.distinct();
        }

        default public OfInt filter(IntPredicate intPredicate) {
            return new FilteringIterator.OfInt(this.unwrap(), intPredicate);
        }

        default public <T> FunctionalIterator<T> flatMap(IntFunction<? extends Iterator<? extends T>> intFunction) {
            return new ChainedIterator.Of(this.map(intFunction));
        }

        default public OfDouble flatMapToDouble(IntFunction<PrimitiveIterator.OfDouble> intFunction) {
            return new ChainedIterator.OfDouble((Iterator<? extends PrimitiveIterator.OfDouble>)((Object)this.map(intFunction)));
        }

        default public OfInt flatMapToInt(IntFunction<PrimitiveIterator.OfInt> intFunction) {
            return new ChainedIterator.OfInt((Iterator<? extends PrimitiveIterator.OfInt>)((Object)this.map(intFunction)));
        }

        default public OfLong flatMapToLong(IntFunction<PrimitiveIterator.OfLong> intFunction) {
            return new ChainedIterator.OfLong((Iterator<? extends PrimitiveIterator.OfLong>)((Object)this.map(intFunction)));
        }

        default public <T> FunctionalIterator<T> map(IntFunction<? extends T> intFunction) {
            return new MappingIterator.IntToObj<T>(this.unwrap(), intFunction);
        }

        default public OfDouble mapToDouble(IntToDoubleFunction intToDoubleFunction) {
            return new MappingIterator.IntToDouble(this.unwrap(), intToDoubleFunction);
        }

        default public OfInt mapToInt(IntUnaryOperator intUnaryOperator) {
            return new MappingIterator.IntToInt(this.unwrap(), intUnaryOperator);
        }

        default public OfLong mapToLong(IntToLongFunction intToLongFunction) {
            return new MappingIterator.IntToLong(this.unwrap(), intToLongFunction);
        }

        @Override
        default public OfInt nonNull() {
            return this;
        }

        @Override
        default public OfInt consume() {
            return (OfInt)PrimitiveReducible.OfInt.super.consume();
        }

        @Override
        default public boolean contains(Object object) {
            boolean bl = PrimitiveReducible.OfInt.super.contains(object);
            this.release();
            return bl;
        }

        @Override
        default public int detect(IntPredicate intPredicate) {
            return this.filter(intPredicate).nextInt();
        }

        @Override
        default public OptionalDouble reduce(DoubleBinaryOperator doubleBinaryOperator) {
            Objects.requireNonNull(doubleBinaryOperator);
            if (!this.hasNext()) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(this.reduce((double)this.nextInt(), doubleBinaryOperator));
        }

        @Override
        default public OptionalInt reduce(IntBinaryOperator intBinaryOperator) {
            Objects.requireNonNull(intBinaryOperator);
            if (!this.hasNext()) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(this.reduce(this.nextInt(), intBinaryOperator));
        }

        @Override
        default public OptionalLong reduce(LongBinaryOperator longBinaryOperator) {
            Objects.requireNonNull(longBinaryOperator);
            if (!this.hasNext()) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(this.reduce((long)this.nextInt(), longBinaryOperator));
        }

        @Override
        default public <T> T reduce(T t, ObjIntFunction<T, T> objIntFunction) {
            Objects.requireNonNull(objIntFunction);
            PrimitiveIterator.OfInt ofInt = this.unwrap();
            T t2 = t;
            while (ofInt.hasNext()) {
                t2 = objIntFunction.apply(t2, ofInt.nextInt());
            }
            this.release();
            return t2;
        }

        @Override
        default public double reduce(double d, DoubleBinaryOperator doubleBinaryOperator) {
            Objects.requireNonNull(doubleBinaryOperator);
            PrimitiveIterator.OfInt ofInt = this.unwrap();
            double d2 = d;
            while (ofInt.hasNext()) {
                d2 = doubleBinaryOperator.applyAsDouble(d2, ofInt.nextInt());
            }
            this.release();
            return d2;
        }

        @Override
        default public int reduce(int n, IntBinaryOperator intBinaryOperator) {
            Objects.requireNonNull(intBinaryOperator);
            PrimitiveIterator.OfInt ofInt = this.unwrap();
            int n2 = n;
            while (ofInt.hasNext()) {
                n2 = intBinaryOperator.applyAsInt(n2, ofInt.nextInt());
            }
            this.release();
            return n2;
        }

        @Override
        default public long reduce(long l, LongBinaryOperator longBinaryOperator) {
            Objects.requireNonNull(longBinaryOperator);
            PrimitiveIterator.OfInt ofInt = this.unwrap();
            long l2 = l;
            while (ofInt.hasNext()) {
                l2 = longBinaryOperator.applyAsLong(l2, ofInt.nextInt());
            }
            this.release();
            return l2;
        }
    }

    public static interface OfDouble
    extends FunctionalPrimitiveIterator<Double, DoubleConsumer>,
    PrimitiveReducible.OfDouble<Iterator<? extends Double>>,
    PrimitiveIterator.OfDouble {
        @Override
        default public PrimitiveIterator.OfDouble unwrap() {
            return this;
        }

        @Override
        default public FunctionalIterator<Double> concat(Iterator<? extends Double> iterator) {
            if (iterator instanceof PrimitiveIterator.OfDouble) {
                return this.concat((PrimitiveIterator.OfDouble)iterator);
            }
            return FunctionalPrimitiveIterator.super.concat(iterator);
        }

        default public OfDouble concat(PrimitiveIterator.OfDouble ofDouble) {
            return new ChainedIterator.OfDouble(this.unwrap(), (Iterator<? extends PrimitiveIterator.OfDouble>)new ArrayIterator.Of<PrimitiveIterator.OfDouble>(ofDouble));
        }

        @Override
        default public OfDouble dedupe() {
            return (OfDouble)PrimitiveReducible.OfDouble.super.dedupe();
        }

        @Override
        default public OfDouble distinct() {
            return (OfDouble)PrimitiveReducible.OfDouble.super.distinct();
        }

        default public OfDouble filter(DoublePredicate doublePredicate) {
            return new FilteringIterator.OfDouble(this.unwrap(), doublePredicate);
        }

        default public <T> FunctionalIterator<T> flatMap(DoubleFunction<? extends Iterator<? extends T>> doubleFunction) {
            return new ChainedIterator.Of(this.map(doubleFunction));
        }

        default public OfDouble flatMapToDouble(DoubleFunction<PrimitiveIterator.OfDouble> doubleFunction) {
            return new ChainedIterator.OfDouble((Iterator<? extends PrimitiveIterator.OfDouble>)((Object)this.map(doubleFunction)));
        }

        default public OfInt flatMapToInt(DoubleFunction<PrimitiveIterator.OfInt> doubleFunction) {
            return new ChainedIterator.OfInt((Iterator<? extends PrimitiveIterator.OfInt>)((Object)this.map(doubleFunction)));
        }

        default public OfLong flatMapToLong(DoubleFunction<PrimitiveIterator.OfLong> doubleFunction) {
            return new ChainedIterator.OfLong((Iterator<? extends PrimitiveIterator.OfLong>)((Object)this.map(doubleFunction)));
        }

        default public <T> FunctionalIterator<T> map(DoubleFunction<? extends T> doubleFunction) {
            return new MappingIterator.DoubleToObj<T>(this.unwrap(), doubleFunction);
        }

        default public OfDouble mapToDouble(DoubleUnaryOperator doubleUnaryOperator) {
            return new MappingIterator.DoubleToDouble(this.unwrap(), doubleUnaryOperator);
        }

        default public OfInt mapToInt(DoubleToIntFunction doubleToIntFunction) {
            return new MappingIterator.DoubleToInt(this.unwrap(), doubleToIntFunction);
        }

        default public OfLong mapToLong(DoubleToLongFunction doubleToLongFunction) {
            return new MappingIterator.DoubleToLong(this.unwrap(), doubleToLongFunction);
        }

        @Override
        default public OfDouble nonNull() {
            return this;
        }

        @Override
        default public OfDouble consume() {
            return (OfDouble)PrimitiveReducible.OfDouble.super.consume();
        }

        @Override
        default public boolean contains(Object object) {
            boolean bl = PrimitiveReducible.OfDouble.super.contains(object);
            this.release();
            return bl;
        }

        @Override
        default public double detect(DoublePredicate doublePredicate) {
            return this.filter(doublePredicate).nextDouble();
        }

        @Override
        default public OptionalDouble reduce(DoubleBinaryOperator doubleBinaryOperator) {
            Objects.requireNonNull(doubleBinaryOperator);
            if (!this.hasNext()) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(this.reduce(this.nextDouble(), doubleBinaryOperator));
        }

        @Override
        default public <T> T reduce(T t, ObjDoubleFunction<T, T> objDoubleFunction) {
            Objects.requireNonNull(objDoubleFunction);
            PrimitiveIterator.OfDouble ofDouble = this.unwrap();
            T t2 = t;
            while (ofDouble.hasNext()) {
                t2 = objDoubleFunction.apply(t2, ofDouble.nextDouble());
            }
            this.release();
            return t2;
        }

        @Override
        default public double reduce(double d, DoubleBinaryOperator doubleBinaryOperator) {
            Objects.requireNonNull(doubleBinaryOperator);
            PrimitiveIterator.OfDouble ofDouble = this.unwrap();
            double d2 = d;
            while (ofDouble.hasNext()) {
                d2 = doubleBinaryOperator.applyAsDouble(d2, ofDouble.nextDouble());
            }
            this.release();
            return d2;
        }

        @Override
        default public int reduce(int n, IntDoubleToIntFunction intDoubleToIntFunction) {
            Objects.requireNonNull(intDoubleToIntFunction);
            PrimitiveIterator.OfDouble ofDouble = this.unwrap();
            int n2 = n;
            while (ofDouble.hasNext()) {
                n2 = intDoubleToIntFunction.applyAsInt(n2, ofDouble.nextDouble());
            }
            this.release();
            return n2;
        }

        @Override
        default public long reduce(long l, LongDoubleToLongFunction longDoubleToLongFunction) {
            Objects.requireNonNull(longDoubleToLongFunction);
            PrimitiveIterator.OfDouble ofDouble = this.unwrap();
            long l2 = l;
            while (ofDouble.hasNext()) {
                l2 = longDoubleToLongFunction.applyAsLong(l2, ofDouble.nextDouble());
            }
            this.release();
            return l2;
        }
    }
}

