/*
 * Decompiled with CFR 0.152.
 */
package common;

public class Timeout
implements Runnable {
    private final long timeoutTime;
    private final Runnable timeoutRunnable;

    public static void setTimeout(int n, Runnable runnable) {
        Timeout timeout = new Timeout(n, runnable);
        Thread thread = new Thread(timeout);
        thread.setDaemon(true);
        thread.start();
    }

    private Timeout(int n, Runnable runnable) {
        this.timeoutTime = System.currentTimeMillis() + (long)(n * 1000);
        this.timeoutRunnable = runnable;
    }

    @Override
    public void run() {
        while (true) {
            long l;
            if ((l = System.currentTimeMillis()) > this.timeoutTime) {
                this.timeoutRunnable.run();
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

