/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularNotInvertibleException;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.NotInvertibleException;

public final class ModLong
implements GcdRingElem<ModLong>,
Modular {
    public final ModLongRing ring;
    public final long val;

    public ModLong(ModLongRing modLongRing, java.math.BigInteger bigInteger) {
        this(modLongRing, bigInteger.mod(modLongRing.getModul()).longValue());
    }

    public ModLong(ModLongRing modLongRing, long l) {
        this.ring = modLongRing;
        long l2 = l % this.ring.modul;
        this.val = l2 >= 0L ? l2 : l2 + this.ring.modul;
    }

    public ModLong(ModLongRing modLongRing, Long l) {
        this(modLongRing, (long)l);
    }

    public ModLong(ModLongRing modLongRing, String string) {
        this(modLongRing, Long.valueOf(string.trim()));
    }

    public ModLong(ModLongRing modLongRing) {
        this(modLongRing, 0L);
    }

    public long getVal() {
        return this.val;
    }

    public long getModul() {
        return this.ring.modul;
    }

    public ModLongRing factory() {
        return this.ring;
    }

    public long getSymmetricVal() {
        if (this.val + this.val > this.ring.modul) {
            return this.val - this.ring.modul;
        }
        return this.val;
    }

    @Override
    public BigInteger getInteger() {
        return new BigInteger(this.val);
    }

    @Override
    public BigInteger getSymmetricInteger() {
        long l = this.val;
        if (this.val + this.val > this.ring.modul) {
            l = this.val - this.ring.modul;
        }
        return new BigInteger(l);
    }

    @Override
    public ModLong copy() {
        return new ModLong(this.ring, this.val);
    }

    @Override
    public boolean isZERO() {
        return this.val == 0L;
    }

    @Override
    public boolean isONE() {
        return this.val == 1L;
    }

    @Override
    public boolean isUnit() {
        if (this.isZERO()) {
            return false;
        }
        if (this.ring.isField()) {
            return true;
        }
        long l = this.gcd(this.ring.modul, this.val);
        return l == 1L || l == -1L;
    }

    public String toString() {
        return Long.toString(this.val);
    }

    @Override
    public String toScript() {
        return this.toString();
    }

    @Override
    public String toScriptFactory() {
        return this.factory().toScript();
    }

    @Override
    public int compareTo(ModLong modLong) {
        long l = modLong.val;
        if (this.ring != modLong.ring) {
            l %= this.ring.modul;
        }
        if (this.val > l) {
            return 1;
        }
        return this.val < l ? -1 : 0;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ModLong)) {
            return false;
        }
        return 0 == this.compareTo((ModLong)object);
    }

    @Override
    public int hashCode() {
        return (int)this.val;
    }

    @Override
    public ModLong abs() {
        return new ModLong(this.ring, this.val < 0L ? -this.val : this.val);
    }

    @Override
    public ModLong negate() {
        return new ModLong(this.ring, -this.val);
    }

    @Override
    public int signum() {
        if (this.val > 0L) {
            return 1;
        }
        return this.val < 0L ? -1 : 0;
    }

    @Override
    public ModLong subtract(ModLong modLong) {
        return new ModLong(this.ring, this.val - modLong.val);
    }

    @Override
    public ModLong divide(ModLong modLong) {
        try {
            return this.multiply(modLong.inverse());
        }
        catch (NotInvertibleException notInvertibleException) {
            try {
                if (this.val % modLong.val == 0L) {
                    return new ModLong(this.ring, this.val / modLong.val);
                }
                throw new NotInvertibleException(notInvertibleException.getCause());
            }
            catch (ArithmeticException arithmeticException) {
                throw new NotInvertibleException(arithmeticException.getCause());
            }
        }
    }

    @Override
    public ModLong inverse() {
        try {
            return new ModLong(this.ring, this.modInverse(this.val, this.ring.modul));
        }
        catch (ArithmeticException arithmeticException) {
            long l = this.gcd(this.val, this.ring.modul);
            long l2 = this.ring.modul / l;
            throw new ModularNotInvertibleException(arithmeticException, (GcdRingElem)new BigInteger(this.ring.modul), (GcdRingElem)new BigInteger(l), (GcdRingElem)new BigInteger(l2));
        }
    }

    @Override
    public ModLong remainder(ModLong modLong) {
        if (modLong == null || modLong.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        if (modLong.isONE()) {
            return this.ring.getZERO();
        }
        if (modLong.isUnit()) {
            return this.ring.getZERO();
        }
        return new ModLong(this.ring, this.val % modLong.val);
    }

    @Override
    public ModLong multiply(ModLong modLong) {
        return new ModLong(this.ring, this.val * modLong.val);
    }

    @Override
    public ModLong sum(ModLong modLong) {
        return new ModLong(this.ring, this.val + modLong.val);
    }

    @Override
    public ModLong gcd(ModLong modLong) {
        if (modLong.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return modLong;
        }
        if (this.isUnit() || modLong.isUnit()) {
            return this.ring.getONE();
        }
        return new ModLong(this.ring, this.gcd(this.val, modLong.val));
    }

    public ModLong[] egcd(ModLong modLong) {
        ModLong[] modLongArray = new ModLong[]{null, null, null};
        if (modLong == null || modLong.isZERO()) {
            modLongArray[0] = this;
            return modLongArray;
        }
        if (this.isZERO()) {
            modLongArray[0] = modLong;
            return modLongArray;
        }
        if (this.isUnit() || modLong.isUnit()) {
            modLongArray[0] = this.ring.getONE();
            if (this.isUnit() && modLong.isUnit()) {
                modLongArray[1] = this.ring.getONE();
                ModLong modLong2 = modLongArray[0].subtract(modLongArray[1].multiply(this));
                modLongArray[2] = modLong2.divide(modLong);
                return modLongArray;
            }
            if (this.isUnit()) {
                modLongArray[1] = this.inverse();
                modLongArray[2] = this.ring.getZERO();
                return modLongArray;
            }
            modLongArray[1] = this.ring.getZERO();
            modLongArray[2] = modLong.inverse();
            return modLongArray;
        }
        long l = this.val;
        long l2 = modLong.val;
        long l3 = 1L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 1L;
        while (l2 != 0L) {
            long l7 = l / l2;
            long l8 = l % l2;
            l = l7;
            long l9 = l3 - l * l4;
            long l10 = l5 - l * l6;
            l3 = l4;
            l5 = l6;
            l4 = l9;
            l6 = l10;
            l = l2;
            l2 = l8;
        }
        modLongArray[0] = new ModLong(this.ring, l);
        modLongArray[1] = new ModLong(this.ring, l3);
        modLongArray[2] = new ModLong(this.ring, l5);
        return modLongArray;
    }

    public long gcd(long l, long l2) {
        if (l2 == 0L) {
            return l;
        }
        if (l == 0L) {
            return l2;
        }
        long l3 = l;
        long l4 = l2;
        while (l4 != 0L) {
            long l5 = l3 % l4;
            l3 = l4;
            l4 = l5;
        }
        return l3;
    }

    public long[] hegcd(long l, long l2) {
        long[] lArray = new long[2];
        if (l2 == 0L) {
            lArray[0] = l;
            lArray[1] = 1L;
            return lArray;
        }
        if (l == 0L) {
            lArray[0] = l2;
            lArray[1] = 0L;
            return lArray;
        }
        long l3 = l;
        long l4 = l2;
        long l5 = 1L;
        long l6 = 0L;
        while (l4 != 0L) {
            long l7 = l3 / l4;
            long l8 = l3 % l4;
            l3 = l4;
            l4 = l8;
            long l9 = l5 - l7 * l6;
            l5 = l6;
            l6 = l9;
        }
        if (l5 < 0L) {
            l5 += l2;
        }
        lArray[0] = l3;
        lArray[1] = l5;
        return lArray;
    }

    public long modInverse(long l, long l2) {
        if (l == 0L) {
            throw new NotInvertibleException("zero is not invertible");
        }
        long[] lArray = this.hegcd(l, l2);
        long l3 = lArray[0];
        if (l3 != 1L && l3 != -1L) {
            throw new ModularNotInvertibleException("element not invertible, gcd != 1", (GcdRingElem)new BigInteger(l2), (GcdRingElem)new BigInteger(l3), (GcdRingElem)new BigInteger(l2 / l3));
        }
        long l4 = lArray[1];
        if (l4 == 0L) {
            throw new NotInvertibleException("element not invertible, divisible by modul");
        }
        if (l4 < 0L) {
            l4 += l2;
        }
        return l4;
    }

    public long bitLength() {
        return BigInteger.bitLength(this.val);
    }
}

