/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.SolvableIdeal;
import edu.jas.application.SolvableLocalResidue;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gbufd.SGBFactory;
import edu.jas.gbufd.SolvableSyzygyAbstract;
import edu.jas.gbufd.SolvableSyzygySeq;
import edu.jas.kern.StringUtil;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPairFactory;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SolvableLocalResidueRing<C extends GcdRingElem<C>>
implements RingFactory<SolvableLocalResidue<C>>,
QuotPairFactory<GenPolynomial<C>, SolvableLocalResidue<C>> {
    private static final Logger logger = LogManager.getLogger(SolvableLocalResidueRing.class);
    private static final boolean debug = logger.isDebugEnabled();
    public final GenSolvablePolynomialRing<C> ring;
    public final SolvableIdeal<C> ideal;
    public final SolvableSyzygyAbstract<C> engine;
    protected final SolvableGroebnerBaseAbstract<C> bb;
    protected int isField = -1;

    public SolvableLocalResidueRing(SolvableIdeal<C> solvableIdeal) {
        if (solvableIdeal == null) {
            throw new IllegalArgumentException("ideal may not be null");
        }
        this.ring = solvableIdeal.getRing();
        this.ideal = solvableIdeal.GB();
        if (this.ideal.isONE()) {
            throw new IllegalArgumentException("ideal may not be 1");
        }
        if (this.ideal.isMaximal()) {
            this.isField = 1;
        } else {
            logger.warn("ideal not maximal and not known to be prime");
        }
        this.engine = new SolvableSyzygySeq(this.ring.coFac);
        this.bb = SGBFactory.getImplementation(this.ring.coFac);
        logger.debug("solvable local residue ring constructed");
    }

    @Override
    public GenSolvablePolynomialRing<C> pairFactory() {
        return this.ring;
    }

    @Override
    public SolvableLocalResidue<C> create(GenPolynomial<C> genPolynomial) {
        return new SolvableLocalResidue(this, (GenSolvablePolynomial)genPolynomial);
    }

    @Override
    public SolvableLocalResidue<C> create(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        return new SolvableLocalResidue(this, (GenSolvablePolynomial)genPolynomial, (GenSolvablePolynomial)genPolynomial2);
    }

    @Override
    public boolean isFinite() {
        return this.ring.isFinite() && this.bb.commonZeroTest(this.ideal.getList()) <= 0;
    }

    @Override
    public SolvableLocalResidue<C> copy(SolvableLocalResidue<C> solvableLocalResidue) {
        return new SolvableLocalResidue(solvableLocalResidue.ring, solvableLocalResidue.num, solvableLocalResidue.den, true);
    }

    @Override
    public SolvableLocalResidue<C> getZERO() {
        return new SolvableLocalResidue(this, this.ring.getZERO());
    }

    @Override
    public SolvableLocalResidue<C> getONE() {
        return new SolvableLocalResidue(this, this.ring.getONE());
    }

    @Override
    public List<SolvableLocalResidue<C>> generators() {
        List list = PolynomialList.castToSolvableList(this.ring.generators());
        ArrayList<SolvableLocalResidue<C>> arrayList = new ArrayList<SolvableLocalResidue<C>>(list.size() * 2 - 1);
        GenPolynomial genPolynomial = this.ring.getONE();
        for (GenSolvablePolynomial genSolvablePolynomial : list) {
            SolvableLocalResidue solvableLocalResidue = new SolvableLocalResidue(this, genSolvablePolynomial);
            if (solvableLocalResidue.isZERO() || arrayList.contains(solvableLocalResidue)) continue;
            arrayList.add(solvableLocalResidue);
            if (genSolvablePolynomial.isONE() || this.ideal.contains(genSolvablePolynomial)) continue;
            solvableLocalResidue = new SolvableLocalResidue(this, genPolynomial, genSolvablePolynomial);
            arrayList.add(solvableLocalResidue);
        }
        return arrayList;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        if (!this.ring.isAssociative()) {
            return false;
        }
        List<SolvableLocalResidue<C>> list = this.generators();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            SolvableLocalResidue<C> solvableLocalResidue = list.get(i);
            for (int j = i + 1; j < n; ++j) {
                SolvableLocalResidue<SolvableLocalResidue<C>> solvableLocalResidue2 = list.get(j);
                for (int k = j + 1; k < n; ++k) {
                    SolvableLocalResidue<SolvableLocalResidue<SolvableLocalResidue<C>>> solvableLocalResidue3;
                    SolvableLocalResidue<SolvableLocalResidue<C>> solvableLocalResidue4;
                    SolvableLocalResidue<SolvableLocalResidue<SolvableLocalResidue<C>>> solvableLocalResidue5 = list.get(k);
                    if (solvableLocalResidue.num.degree() == 0L && solvableLocalResidue2.num.degree() == 0L && solvableLocalResidue5.num.degree() == 0L && solvableLocalResidue.den.degree() == 0L && solvableLocalResidue2.den.degree() == 0L && solvableLocalResidue5.den.degree() == 0L) continue;
                    try {
                        solvableLocalResidue4 = solvableLocalResidue5.multiply(solvableLocalResidue2).multiply((SolvableLocalResidue<SolvableLocalResidue<C>>)solvableLocalResidue);
                        solvableLocalResidue3 = solvableLocalResidue5.multiply(solvableLocalResidue2.multiply(solvableLocalResidue));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        illegalArgumentException.printStackTrace();
                        continue;
                    }
                    if (solvableLocalResidue4.num.equals(solvableLocalResidue3.num) && solvableLocalResidue4.den.equals(solvableLocalResidue3.den) || solvableLocalResidue4.equals(solvableLocalResidue3)) continue;
                    System.out.println("lr assoc: p = " + solvableLocalResidue4.toScript());
                    System.out.println("lr assoc: q = " + solvableLocalResidue3.toScript());
                    System.out.println("lr assoc: Xk = " + solvableLocalResidue5.toScript() + ", Xj = " + solvableLocalResidue2.toScript() + ", Xi = " + solvableLocalResidue.toScript());
                    logger.info("Xk = " + solvableLocalResidue5 + ", Xj = " + solvableLocalResidue2 + ", Xi = " + solvableLocalResidue);
                    logger.info("p = ( Xk * Xj ) * Xi = " + solvableLocalResidue4);
                    logger.info("q = Xk * ( Xj * Xi ) = " + solvableLocalResidue3);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public SolvableLocalResidue<C> fromInteger(BigInteger bigInteger) {
        return new SolvableLocalResidue(this, this.ring.fromInteger(bigInteger));
    }

    @Override
    public SolvableLocalResidue<C> fromInteger(long l) {
        return new SolvableLocalResidue(this, this.ring.fromInteger(l));
    }

    public String toString() {
        return "SolvableLocalResidueRing[ " + this.ideal.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "SLR(" + this.ideal.list.toScript() + ")";
    }

    public boolean equals(Object object) {
        if (!(object instanceof SolvableLocalResidueRing)) {
            return false;
        }
        SolvableLocalResidueRing solvableLocalResidueRing = null;
        try {
            solvableLocalResidueRing = (SolvableLocalResidueRing)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (solvableLocalResidueRing == null) {
            return false;
        }
        return this.ring.equals(solvableLocalResidueRing.ring);
    }

    public int hashCode() {
        int n = this.ideal.hashCode();
        return n;
    }

    @Override
    public SolvableLocalResidue<C> random(int n) {
        GenSolvablePolynomial<C> genSolvablePolynomial;
        GenSolvablePolynomial<C> genSolvablePolynomial2 = ((GenSolvablePolynomial)this.ring.random(n)).monic();
        genSolvablePolynomial2 = this.ideal.normalform(genSolvablePolynomial2);
        do {
            genSolvablePolynomial = ((GenSolvablePolynomial)this.ring.random(n)).monic();
        } while ((genSolvablePolynomial = this.ideal.normalform(genSolvablePolynomial)).isZERO());
        return new SolvableLocalResidue<C>(this, genSolvablePolynomial2, genSolvablePolynomial, false);
    }

    public SolvableLocalResidue<C> random(int n, int n2, int n3, float f) {
        GenSolvablePolynomial<C> genSolvablePolynomial;
        GenSolvablePolynomial<C> genSolvablePolynomial2 = ((GenSolvablePolynomial)this.ring.random(n, n2, n3, f)).monic();
        genSolvablePolynomial2 = this.ideal.normalform(genSolvablePolynomial2);
        do {
            genSolvablePolynomial = ((GenSolvablePolynomial)this.ring.random(n, n2, n3, f)).monic();
        } while ((genSolvablePolynomial = this.ideal.normalform(genSolvablePolynomial)).isZERO());
        return new SolvableLocalResidue<C>(this, genSolvablePolynomial2, genSolvablePolynomial, false);
    }

    @Override
    public SolvableLocalResidue<C> random(int n, Random random) {
        GenSolvablePolynomial<C> genSolvablePolynomial;
        GenSolvablePolynomial<C> genSolvablePolynomial2 = ((GenSolvablePolynomial)this.ring.random(n, random)).monic();
        genSolvablePolynomial2 = this.ideal.normalform(genSolvablePolynomial2);
        do {
            genSolvablePolynomial = ((GenSolvablePolynomial)this.ring.random(n, random)).monic();
        } while ((genSolvablePolynomial = this.ideal.normalform(genSolvablePolynomial)).isZERO());
        return new SolvableLocalResidue<C>(this, genSolvablePolynomial2, genSolvablePolynomial, false);
    }

    @Override
    public SolvableLocalResidue<C> parse(String string) {
        int n = string.indexOf("{");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf("}")) >= 0) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("|")) < 0) {
            GenPolynomial genPolynomial = this.ring.parse(string);
            return new SolvableLocalResidue(this, genPolynomial);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        GenPolynomial genPolynomial = this.ring.parse(string2);
        GenPolynomial genPolynomial2 = this.ring.parse(string3);
        return new SolvableLocalResidue(this, genPolynomial, genPolynomial2);
    }

    @Override
    public SolvableLocalResidue<C> parse(Reader reader) {
        String string = StringUtil.nextPairedString(reader, '{', '}');
        return this.parse(string);
    }
}

