/*
 * Decompiled with CFR 0.152.
 */
package userinterface;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import parser.State;
import parser.Values;
import parser.ast.Expression;
import parser.ast.ExpressionReward;
import parser.ast.ModulesFile;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeInt;
import prism.PrismException;
import prism.PrismSettings;
import simulator.method.APMCapproximation;
import simulator.method.APMCconfidence;
import simulator.method.APMCiterations;
import userinterface.GUIPrism;
import userinterface.SimulationInformation;

public class GUISimulationPicker
extends JDialog
implements KeyListener {
    private static final long serialVersionUID = 1L;
    public static final int NO_VALUES = 0;
    public static final int VALUES_DONE = 1;
    public static final int CANCELLED = 2;
    public static SimulationInformation lastSimulationInformation = null;
    private GUIPrism gui;
    private ModulesFile modulesFile;
    private SimulationInformation information;
    private boolean cancelled = true;
    private JTable initValuesTable;
    private DefineValuesTable initValuesModel;
    private String lastWidth;
    private String lastConf;
    private String lastNumSamples;
    private boolean atLeastOneRwd;
    private boolean atLeastOneQuant;
    JTextField widthField;
    JComboBox selectSimulationMethod;
    JComboBox automaticCalculateCombo;
    private JButton cancelButton;
    JTextField confidenceField;
    JTextField numberToDecide;
    JTextField numSamplesField;
    private JLabel jLabel2;
    private JLabel jLabelSSM;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JPanel jPanel17;
    private JPanel jPanel18;
    private JPanel jPanel19;
    private JPanel jPanel2;
    private JPanel jPanel20;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JButton okayButton;
    JTextField pathLengthField;
    JPanel topPanel;
    JCheckBox useDefaultInitialCheck;

    public GUISimulationPicker(GUIPrism gUIPrism, List<Expression> list, ModulesFile modulesFile, String string) throws PrismException {
        super(gUIPrism, "Simulation Parameters" + (String)(string != null ? " - " + string : ""), true);
        this.gui = gUIPrism;
        this.modulesFile = modulesFile;
        this.atLeastOneRwd = false;
        for (Expression expression : list) {
            if (!(expression instanceof ExpressionReward)) continue;
            this.atLeastOneRwd = true;
            break;
        }
        this.atLeastOneQuant = false;
        for (Expression expression : list) {
            if (!Expression.isQuantitative(expression)) continue;
            this.atLeastOneQuant = true;
            break;
        }
        PrismSettings prismSettings = gUIPrism.getPrism().getSettings();
        if (lastSimulationInformation == null || prismSettings.getString("simulator.fieldChoice").equals("Always use defaults")) {
            lastSimulationInformation = new SimulationInformation(prismSettings);
            lastSimulationInformation.setMethod(this.atLeastOneQuant ? SimulationInformation.Method.CI : SimulationInformation.Method.SPRT);
        }
        if (this.atLeastOneRwd && lastSimulationInformation.getMethod() == SimulationInformation.Method.APMC) {
            lastSimulationInformation.setMethod(SimulationInformation.Method.CI);
        }
        if (this.atLeastOneQuant && lastSimulationInformation.getMethod() == SimulationInformation.Method.SPRT) {
            lastSimulationInformation.setMethod(SimulationInformation.Method.CI);
        }
        lastSimulationInformation.setPropReward(this.atLeastOneRwd);
        this.lastWidth = "" + lastSimulationInformation.getWidth();
        this.lastConf = "" + lastSimulationInformation.getConfidence();
        this.lastNumSamples = "" + lastSimulationInformation.getNumSamples();
        this.initValuesModel = new DefineValuesTable();
        this.initValuesTable = new GreyableJTable();
        this.initValuesTable.setModel(this.initValuesModel);
        this.initValuesTable.setSelectionMode(1);
        this.initValuesTable.setCellSelectionEnabled(true);
        this.information = lastSimulationInformation;
        this.information.setInitialState(null);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okayButton);
        this.initTable();
        this.initValues();
        this.widthField.addKeyListener(this);
        this.confidenceField.addKeyListener(this);
        this.numSamplesField.addKeyListener(this);
        this.doEnablesAndCalculations(true);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.jPanel6 = new JPanel();
        this.okayButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel7 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.topPanel = new JPanel();
        this.jPanel10 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jPanel9 = new JPanel();
        this.jLabelSSM = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jPanel11 = new JPanel();
        this.jPanel12 = new JPanel();
        this.selectSimulationMethod = new JComboBox();
        this.automaticCalculateCombo = new JComboBox();
        this.jPanel13 = new JPanel();
        this.widthField = new JTextField();
        this.confidenceField = new JTextField();
        this.numberToDecide = new JTextField();
        this.numSamplesField = new JTextField();
        this.jPanel14 = new JPanel();
        this.jPanel15 = new JPanel();
        this.jPanel16 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel17 = new JPanel();
        this.pathLengthField = new JTextField();
        this.jPanel18 = new JPanel();
        this.jPanel19 = new JPanel();
        this.jPanel20 = new JPanel();
        this.useDefaultInitialCheck = new JCheckBox();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GUISimulationPicker.this.closeDialog(windowEvent);
            }
        });
        this.jPanel6.setLayout(new FlowLayout(2));
        this.okayButton.setText("Okay");
        this.okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulationPicker.this.okayButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel6.add(this.okayButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulationPicker.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel6.add(this.cancelButton);
        this.getContentPane().add((Component)this.jPanel6, "South");
        this.jPanel7.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder("Initial state"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel1.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.jPanel1.add((Component)this.jPanel5, gridBagConstraints);
        this.useDefaultInitialCheck.setText("Use default initial state");
        this.useDefaultInitialCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulationPicker.this.useDefaultInitialCheckActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.useDefaultInitialCheck, gridBagConstraints);
        this.topPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.topPanel, gridBagConstraints);
        this.jPanel7.add((Component)this.jPanel1, "Center");
        this.jPanel10.setLayout(new BoxLayout(this.jPanel10, 1));
        this.jPanel8.setLayout(new GridBagLayout());
        this.jPanel8.setBorder(new TitledBorder("Sampling parameters"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel8.add((Component)this.jPanel9, gridBagConstraints);
        this.jLabelSSM.setText("Simulation method:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.jPanel8.add((Component)this.jLabelSSM, gridBagConstraints);
        this.jLabel4.setText("Automatically calculate:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.jPanel8.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("Width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.jPanel8.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText("Confidence:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        this.jPanel8.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setText("Number of samples:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        this.jPanel8.add((Component)this.jLabel7, gridBagConstraints);
        this.jPanel11.setPreferredSize(new Dimension(10, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        this.jPanel8.add((Component)this.jPanel11, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.jPanel8.add((Component)this.jPanel12, gridBagConstraints);
        Vector<String> vector = new Vector<String>();
        vector.add("CI");
        vector.add("ACI");
        if (!this.atLeastOneRwd) {
            vector.add("APMC");
        }
        if (!this.atLeastOneQuant) {
            vector.add("SPRT");
        }
        this.selectSimulationMethod.setModel(new DefaultComboBoxModel(vector));
        this.selectSimulationMethod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulationPicker.this.selectSimulationMethodActionPerformed(actionEvent);
            }
        });
        this.automaticCalculateCombo.setModel(new DefaultComboBoxModel<String>(new String[0]));
        this.automaticCalculateCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulationPicker.this.automaticCalculateComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel8.add((Component)this.selectSimulationMethod, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel8.add((Component)this.automaticCalculateCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        this.jPanel8.add((Component)this.jPanel13, gridBagConstraints);
        this.widthField.setPreferredSize(new Dimension(65, 20));
        this.widthField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulationPicker.this.widthFieldActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel8.add((Component)this.widthField, gridBagConstraints);
        this.confidenceField.setPreferredSize(new Dimension(60, 20));
        this.confidenceField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulationPicker.this.confidenceFieldActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel8.add((Component)this.confidenceField, gridBagConstraints);
        this.numSamplesField.setPreferredSize(new Dimension(60, 20));
        this.numSamplesField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUISimulationPicker.this.numSamplesFieldActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel8.add((Component)this.numSamplesField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        this.jPanel8.add((Component)this.jPanel14, gridBagConstraints);
        this.jPanel10.add(this.jPanel8);
        this.jPanel15.setLayout(new GridBagLayout());
        this.jPanel15.setBorder(new TitledBorder("Path parameters"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel15.add((Component)this.jPanel16, gridBagConstraints);
        this.jLabel2.setText("Maximum path length:");
        this.jLabel2.setPreferredSize(new Dimension(150, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel15.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel15.add((Component)this.jPanel17, gridBagConstraints);
        this.pathLengthField.setPreferredSize(new Dimension(158, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel15.add((Component)this.pathLengthField, gridBagConstraints);
        this.jPanel18.setPreferredSize(new Dimension(118, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        this.jPanel15.add((Component)this.jPanel18, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        this.jPanel15.add((Component)this.jPanel19, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.jPanel15.add((Component)this.jPanel20, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel10.add(this.jPanel15);
        this.jPanel7.add((Component)this.jPanel10, "East");
        this.getContentPane().add((Component)this.jPanel7, "Center");
        this.pack();
    }

    private void numSamplesFieldActionPerformed(ActionEvent actionEvent) {
        this.doEnablesAndCalculations(false);
    }

    private void confidenceFieldActionPerformed(ActionEvent actionEvent) {
        this.doEnablesAndCalculations(false);
    }

    private void widthFieldActionPerformed(ActionEvent actionEvent) {
        this.doEnablesAndCalculations(false);
    }

    private void selectSimulationMethodActionPerformed(ActionEvent actionEvent) {
        this.doChangeSimulationMethod();
    }

    private void automaticCalculateComboActionPerformed(ActionEvent actionEvent) {
        this.doEnablesAndCalculations(true);
    }

    private static boolean isValidDoubleOrEmpty(String string) {
        if (string.isEmpty()) {
            return true;
        }
        try {
            Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private void doChangeSimulationMethod() {
        int n = this.automaticCalculateCombo.getSelectedIndex();
        this.information.setMethodByName((String)this.selectSimulationMethod.getSelectedItem());
        switch (this.information.getMethod()) {
            case CI: {
                this.jLabel5.setText("Width:");
                this.jLabel6.setText("Confidence:");
                this.automaticCalculateCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Width", "Confidence", "Number of samples"}));
                break;
            }
            case ACI: {
                this.jLabel5.setText("Width:");
                this.jLabel6.setText("Confidence:");
                this.automaticCalculateCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Width", "Confidence", "Number of samples"}));
                break;
            }
            case APMC: {
                this.jLabel5.setText("Approximation:");
                this.jLabel6.setText("Confidence:");
                this.automaticCalculateCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Approximation", "Confidence", "Number of samples"}));
                break;
            }
            case SPRT: {
                this.jLabel5.setText("Indifference:");
                this.jLabel6.setText("Type I/II error:");
                this.automaticCalculateCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Number of samples"}));
            }
        }
        if (n != -1) {
            if (n > this.automaticCalculateCombo.getItemCount() - 1) {
                n = 0;
            }
            this.automaticCalculateCombo.setSelectedIndex(n);
        }
    }

    private void doEnablesAndCalculations(boolean bl) {
        if (GUISimulationPicker.isValidDoubleOrEmpty(this.confidenceField.getText())) {
            this.lastConf = this.confidenceField.getText();
        }
        if (GUISimulationPicker.isValidDoubleOrEmpty(this.numSamplesField.getText())) {
            this.lastNumSamples = this.numSamplesField.getText();
        }
        if (GUISimulationPicker.isValidDoubleOrEmpty(this.widthField.getText())) {
            this.lastWidth = this.widthField.getText();
        }
        this.information.setUnknownByName((String)this.automaticCalculateCombo.getSelectedItem());
        this.widthField.setEnabled(true);
        this.confidenceField.setEnabled(true);
        this.numSamplesField.setEnabled(true);
        switch (this.information.getMethod()) {
            case CI: 
            case ACI: {
                switch (this.information.getUnknown()) {
                    case WIDTH: {
                        this.widthField.setEnabled(false);
                        this.widthField.setText("Unknown before sim.");
                        this.widthField.setCaretPosition(0);
                        if (!bl) break;
                        this.numSamplesField.setText(this.lastNumSamples);
                        this.numSamplesField.setCaretPosition(0);
                        this.confidenceField.setText(this.lastConf);
                        this.confidenceField.setCaretPosition(0);
                        break;
                    }
                    case CONFIDENCE: {
                        this.confidenceField.setEnabled(false);
                        this.confidenceField.setText("Unknown before sim.");
                        this.confidenceField.setCaretPosition(0);
                        if (!bl) break;
                        this.widthField.setText(this.lastWidth);
                        this.widthField.setCaretPosition(0);
                        this.numSamplesField.setText(this.lastNumSamples);
                        this.numSamplesField.setCaretPosition(0);
                        break;
                    }
                    case NUM_SAMPLES: {
                        this.numSamplesField.setEnabled(false);
                        this.numSamplesField.setText("Unknown before sim.");
                        this.numSamplesField.setCaretPosition(0);
                        if (!bl) break;
                        this.widthField.setText(this.lastWidth);
                        this.widthField.setCaretPosition(0);
                        this.confidenceField.setText(this.lastConf);
                        this.confidenceField.setCaretPosition(0);
                    }
                }
                break;
            }
            case APMC: {
                switch (this.information.getUnknown()) {
                    case WIDTH: {
                        this.widthField.setEnabled(false);
                        try {
                            double d = Double.parseDouble(this.confidenceField.getText());
                            int n = Integer.parseInt(this.numSamplesField.getText());
                            if (d > 0.0 && d < 1.0 && n > 0) {
                                this.widthField.setText(String.valueOf(new APMCapproximation(d, n).getMissingParameter()));
                                this.widthField.setCaretPosition(0);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                        catch (PrismException prismException) {
                            // empty catch block
                        }
                        if (!bl) break;
                        this.numSamplesField.setText(this.lastNumSamples);
                        this.numSamplesField.setCaretPosition(0);
                        this.confidenceField.setText(this.lastConf);
                        this.confidenceField.setCaretPosition(0);
                        break;
                    }
                    case CONFIDENCE: {
                        this.confidenceField.setEnabled(false);
                        try {
                            double d = Double.parseDouble(this.widthField.getText());
                            int n = Integer.parseInt(this.numSamplesField.getText());
                            if (d > 0.0 && n > 0) {
                                try {
                                    this.confidenceField.setText(String.valueOf(new APMCconfidence(d, n).getMissingParameter()));
                                    this.confidenceField.setCaretPosition(0);
                                }
                                catch (PrismException prismException) {
                                    this.confidenceField.setText("Incr. approx/samples");
                                    this.confidenceField.setCaretPosition(0);
                                }
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (!bl) break;
                        this.widthField.setText(this.lastWidth);
                        this.widthField.setCaretPosition(0);
                        this.numSamplesField.setText(this.lastNumSamples);
                        this.numSamplesField.setCaretPosition(0);
                        break;
                    }
                    case NUM_SAMPLES: {
                        this.numSamplesField.setEnabled(false);
                        try {
                            double d = Double.parseDouble(this.widthField.getText());
                            double d2 = Double.parseDouble(this.confidenceField.getText());
                            if (d > 0.0 && d2 > 0.0 && d2 < 1.0) {
                                this.numSamplesField.setText(String.valueOf(new APMCiterations(d2, d).getMissingParameter()));
                                this.numSamplesField.setCaretPosition(0);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                        catch (PrismException prismException) {
                            // empty catch block
                        }
                        if (!bl) break;
                        this.widthField.setText(this.lastWidth);
                        this.widthField.setCaretPosition(0);
                        this.confidenceField.setText(this.lastConf);
                        this.confidenceField.setCaretPosition(0);
                    }
                }
                break;
            }
            case SPRT: {
                this.numSamplesField.setEnabled(false);
                this.numSamplesField.setText("Unknown before sim.");
                this.numSamplesField.setCaretPosition(0);
                if (!bl) break;
                this.widthField.setText(this.lastWidth);
                this.widthField.setCaretPosition(0);
                this.confidenceField.setText(this.lastConf);
                this.confidenceField.setCaretPosition(0);
            }
        }
    }

    private void initTable() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.initValuesTable);
        this.topPanel.add(jScrollPane);
        this.topPanel.setPreferredSize(new Dimension(300, 300));
    }

    private void initValues() {
        if (this.information.getInitialState() == null) {
            this.useDefaultInitialCheck.setSelected(true);
            for (int i = 0; i < this.modulesFile.getNumVars(); ++i) {
                this.initValuesModel.addValue(new Value(this.modulesFile.getVarName(i), this.modulesFile.getVarType(i), null));
            }
            if (this.initValuesTable.getCellEditor() != null) {
                this.initValuesTable.getCellEditor().stopCellEditing();
            }
            this.initValuesTable.getSelectionModel().clearSelection();
            this.initValuesTable.setEnabled(false);
        } else {
            this.useDefaultInitialCheck.setSelected(false);
            for (int i = 0; i < this.modulesFile.getNumVars(); ++i) {
                this.initValuesModel.addValue(new Value(this.modulesFile.getVarName(i), this.modulesFile.getVarType(i), this.information.getInitialState().getValue(i)));
            }
            this.initValuesTable.setEnabled(true);
        }
        this.widthField.setText("" + this.information.getWidth());
        this.widthField.setCaretPosition(0);
        this.confidenceField.setText("" + this.information.getConfidence());
        this.confidenceField.setCaretPosition(0);
        this.numSamplesField.setText("" + this.information.getNumSamples());
        this.numSamplesField.setCaretPosition(0);
        this.selectSimulationMethod.setSelectedItem(this.information.getMethodName());
        this.automaticCalculateCombo.setSelectedItem(this.information.getUnknownName());
        this.pathLengthField.setText("" + this.information.getMaxPathLength());
    }

    public static SimulationInformation defineSimulationWithDialog(GUIPrism gUIPrism, List<Expression> list, ModulesFile modulesFile, String string) throws PrismException {
        return new GUISimulationPicker(gUIPrism, list, modulesFile, string).defineValues();
    }

    public static SimulationInformation defineSimulationWithDialog(GUIPrism gUIPrism, Expression expression, ModulesFile modulesFile, String string) throws PrismException {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(1);
        arrayList.add(expression);
        return new GUISimulationPicker(gUIPrism, arrayList, modulesFile, string).defineValues();
    }

    public SimulationInformation defineValues() {
        this.setVisible(true);
        if (this.cancelled) {
            return null;
        }
        return this.information;
    }

    private void okayButtonActionPerformed(ActionEvent actionEvent) {
        this.doEnablesAndCalculations(false);
        if (this.initValuesTable.getCellEditor() != null) {
            this.initValuesTable.getCellEditor().stopCellEditing();
        }
        String string = "";
        try {
            double d;
            if (this.widthField.isEnabled()) {
                string = this.jLabel5.getText().substring(0, this.jLabel5.getText().length() - 1);
                d = Double.parseDouble(this.widthField.getText());
                if (d <= 0.0) {
                    this.gui.errorDialog("Parameter \"" + string + "\" most be positive");
                    return;
                }
                this.information.setWidth(d);
            }
            if (this.confidenceField.isEnabled()) {
                string = this.jLabel6.getText().substring(0, this.jLabel6.getText().length() - 1);
                d = Double.parseDouble(this.confidenceField.getText());
                if (d <= 0.0 || d >= 1.0) {
                    this.gui.errorDialog("Parameter \"" + string + "\" most be between 0 and 1");
                    return;
                }
                this.information.setConfidence(d);
            }
            if (this.numSamplesField.isEnabled()) {
                string = "Number of samples";
                int n = Integer.parseInt(this.numSamplesField.getText());
                if (n <= 0) {
                    this.gui.errorDialog("Parameter \"" + string + "\" most be positive");
                    return;
                }
                this.information.setNumSamples(n);
            }
            try {
                this.information.createSimulationMethod().computeMissingParameterBeforeSim();
            }
            catch (PrismException prismException) {
                this.gui.errorDialog(prismException.getMessage());
                return;
            }
            string = "Maximum path length";
            long l = Long.parseLong(this.pathLengthField.getText());
            if (l <= 0L) {
                this.gui.errorDialog("Parameter \"" + string + "\" most be positive");
                return;
            }
            this.information.setMaxPathLength(l);
            if (this.useDefaultInitialCheck.isSelected()) {
                this.information.setInitialState(null);
            } else {
                Values values = new Values();
                for (int i = 0; i < this.initValuesModel.getNumValues(); ++i) {
                    string = this.initValuesModel.getValue((int)i).name;
                    Comparable<Boolean> comparable = null;
                    if (this.initValuesModel.getValue((int)i).type instanceof TypeBool) {
                        String string2 = this.initValuesModel.getValue((int)i).value.toString();
                        if (!string2.equals("true") && !string2.equals("false")) {
                            throw new NumberFormatException();
                        }
                        comparable = Boolean.valueOf(string2);
                    } else if (this.initValuesModel.getValue((int)i).type instanceof TypeInt) {
                        comparable = Integer.valueOf(this.initValuesModel.getValue((int)i).value.toString());
                    } else {
                        throw new NumberFormatException();
                    }
                    values.addValue(string, comparable);
                }
                this.information.setInitialState(values);
            }
            this.cancelled = false;
            lastSimulationInformation = this.information;
            this.dispose();
        }
        catch (NumberFormatException numberFormatException) {
            this.gui.errorDialog("Invalid value entered for parameter \"" + string + "\"");
        }
    }

    private void useDefaultInitialCheckActionPerformed(ActionEvent actionEvent) {
        if (this.useDefaultInitialCheck.isSelected()) {
            for (int i = 0; i < this.modulesFile.getNumVars(); ++i) {
                this.initValuesModel.getValue((int)i).value = null;
            }
            if (this.initValuesTable.getCellEditor() != null) {
                this.initValuesTable.getCellEditor().stopCellEditing();
            }
            this.initValuesTable.getSelectionModel().clearSelection();
            this.initValuesTable.setEnabled(false);
        } else {
            try {
                State state = this.modulesFile.getDefaultInitialState();
                if (state == null) {
                    throw new PrismException("");
                }
                for (int i = 0; i < this.modulesFile.getNumVars(); ++i) {
                    this.initValuesModel.getValue((int)i).value = state.varValues[i];
                }
            }
            catch (PrismException prismException) {
                for (int i = 0; i < this.modulesFile.getNumVars(); ++i) {
                    this.initValuesModel.getValue((int)i).value = null;
                }
            }
            this.initValuesTable.setEnabled(true);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.doEnablesAndCalculations(false);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    class DefineValuesTable
    extends AbstractTableModel {
        ArrayList<Value> values = new ArrayList();

        public void addValue(Value value) {
            this.values.add(value);
            this.fireTableRowsInserted(this.values.size() - 1, this.values.size() - 1);
        }

        public int getNumValues() {
            return this.values.size();
        }

        public Value getValue(int n) {
            return this.values.get(n);
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.values.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Value value = this.values.get(n);
            switch (n2) {
                case 0: {
                    return value.name;
                }
                case 1: {
                    return value.type.getTypeString();
                }
                case 2: {
                    return value.value == null ? "" : value.value.toString();
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Type";
                }
                case 2: {
                    return "Value";
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 2;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 2) {
                Value value = this.values.get(n);
                String string = (String)object;
                value.value = string;
                this.fireTableCellUpdated(n, n2);
            }
        }

        public String toString() {
            Object object = "";
            for (int i = 0; i < this.values.size(); ++i) {
                Value value = this.values.get(i);
                object = (String)object + value.toString();
                if (i == this.values.size() - 1) continue;
                object = (String)object + ",";
            }
            return object;
        }
    }

    public class GreyableJTable
    extends JTable {
        private static final long serialVersionUID = 1L;
        private TableCellRenderer tableCellRenderer = new TableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = GreyableJTable.super.getCellRenderer(n, n2).getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                component.setEnabled(jTable != null && jTable.isEnabled());
                return component;
            }
        };

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            return this.tableCellRenderer;
        }
    }

    class Value {
        String name;
        Type type;
        Object value;

        public Value(String string, Type type, Object object) {
            this.name = string;
            this.type = type;
            this.value = object;
        }

        public String toString() {
            return this.name + "=" + String.valueOf(this.value);
        }
    }
}

