/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.Color;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import settings.ColorConstraint;
import settings.ColorEditor;
import settings.ColorRenderer;
import settings.Setting;
import settings.SettingEditor;
import settings.SettingException;
import settings.SettingOwner;
import settings.SettingRenderer;

public class ColorSetting
extends Setting {
    private static ColorRenderer renderer;
    private static ColorEditor editor;

    public ColorSetting(String string, Color color, String string2, SettingOwner settingOwner, boolean bl) {
        super(string, (Object)color, string2, settingOwner, bl);
    }

    public ColorSetting(String string, Color color, String string2, SettingOwner settingOwner, boolean bl, ColorConstraint colorConstraint) {
        super(string, color, string2, settingOwner, bl, colorConstraint);
    }

    @Override
    public SettingEditor getSettingEditor() {
        if (editor == null) {
            editor = new ColorEditor();
        }
        return editor;
    }

    @Override
    public SettingRenderer getSettingRenderer() {
        if (renderer == null) {
            renderer = new ColorRenderer();
        }
        return renderer;
    }

    @Override
    public Class getValueClass() {
        return Color.class;
    }

    public Color getColorValue() {
        return (Color)this.getValue();
    }

    @Override
    public Object parseStringValue(String string) throws SettingException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            return new Color(n, n2, n3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SettingException("Error when parsing: " + string + " as a Color value.");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SettingException("Error when parsing: " + string + " as a Color value.");
        }
    }

    @Override
    public String toString() {
        Color color = this.getColorValue();
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }
}

