/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import param.BigRational;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import prism.PrismException;
import prism.PrismLangException;

public abstract class DefinedConstant<T> {
    public static final double DOUBLE_PRECISION_CORRECTION = 0.001;
    protected final String name;
    protected final Type type;
    protected final T low;
    protected final T high;
    protected final T step;
    protected final int numSteps;
    protected T value;

    private DefinedConstant(String string, Type type, T t, T t2, T t3, int n) {
        this.name = string;
        this.type = type;
        this.low = t;
        this.high = t2;
        this.step = t3;
        this.numSteps = n;
    }

    public boolean isDefined() {
        return this.low != null;
    }

    public Undefined clear() {
        return new Undefined(this.name, this.type);
    }

    public DefinedConstant<?> define(String string, String string2, String string3, boolean bl) throws PrismException {
        if (this.type instanceof TypeInt) {
            return DefinedConstant.defineInt(this.name, string, string2, string3);
        }
        if (this.type instanceof TypeDouble) {
            return bl ? DefinedConstant.defineBigRational(this.name, string, string2, string3) : DefinedConstant.defineDouble(this.name, string, string2, string3);
        }
        if (this.type instanceof TypeBool) {
            return DefinedConstant.defineBoolean(this.name, string, string2, string3);
        }
        throw new PrismException("Unknown type for undefined constant " + this.name);
    }

    public static DefinedInteger defineInt(String string, String string2, String string3, String string4) throws PrismException {
        int n;
        int n2;
        int n3;
        try {
            n3 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Value " + string2 + " for constant " + string + " is not a valid integer");
        }
        if (string3 == null) {
            n2 = n3;
            n = 1;
        } else {
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Value " + string3 + " for constant " + string + " is not a valid integer");
            }
            if (n2 < n3) {
                throw new PrismException("Low value " + n3 + " for constant " + string + " is higher than the high value " + n2);
            }
            if (string4 == null) {
                n = 1;
            } else {
                try {
                    n = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new PrismException("Value " + string4 + " for constant " + string + " is not a valid integer");
                }
                if (n == 0) {
                    throw new PrismException("Step value for constant " + string + " cannot be zero");
                }
                if (n < 0) {
                    throw new PrismException("Step value for constant " + string + " must be positive");
                }
                if (n > n2 - n3) {
                    throw new PrismException("Step value " + n + " for constant " + string + " is bigger than the difference between " + n3 + " and " + n2);
                }
            }
        }
        int n4 = 0;
        int n5 = n2;
        int n6 = n3;
        while (n6 <= n2) {
            n5 = n6;
            n6 = n3 + ++n4 * n;
        }
        return new DefinedInteger(string, n3, n5, n, n4);
    }

    public static DefinedDouble defineDouble(String string, String string2, String string3, String string4) throws PrismException {
        double d;
        double d2;
        double d3;
        try {
            d3 = DefinedConstant.parseDouble(string2);
            if (!Double.isFinite(d3)) {
                throw new NumberFormatException("Value is not finite");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Value " + string2 + " for constant " + string + " is not a valid double");
        }
        if (string3 == null) {
            d2 = d3;
            d = 1.0;
        } else {
            try {
                d2 = DefinedConstant.parseDouble(string3);
                if (!Double.isFinite(d2)) {
                    throw new NumberFormatException("Value is not finite");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Value " + string3 + " for constant " + string + " is not a valid double");
            }
            if (d2 < d3) {
                throw new PrismException("Low value " + d3 + " for constant " + string + " is higher than the high value " + d2);
            }
            if (string4 == null) {
                d = 1.0;
            } else {
                try {
                    d = DefinedConstant.parseDouble(string4);
                    if (!Double.isFinite(d)) {
                        throw new NumberFormatException("Value is not finite");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new PrismException("Value " + string4 + " for constant " + string + " is not a valid double");
                }
                if (d == 0.0) {
                    throw new PrismException("Step value for constant " + string + " cannot be zero");
                }
                if (d < 0.0) {
                    throw new PrismException("Step value for constant " + string + " must be positive");
                }
                if (d > d2 - d3) {
                    throw new PrismException("Step value " + d + " for constant " + string + " is bigger than the difference between " + d3 + " and " + d2);
                }
            }
        }
        int n = 0;
        double d4 = d2;
        double d5 = d3;
        while (d5 <= d2 + 0.001 * d) {
            d4 = d5;
            d5 = d3 + (double)(++n) * d;
        }
        return new DefinedDouble(string, d3, d4, d, n);
    }

    public static DefinedBigRational defineBigRational(String string, String string2, String string3, String string4) throws PrismException {
        BigRational bigRational;
        BigRational bigRational2;
        BigRational bigRational3;
        try {
            bigRational3 = BigRational.from(string2);
            if (bigRational3.isSpecial()) {
                throw new NumberFormatException("Value is not finite");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Value " + string2 + " for constant " + string + " is not a valid rational number");
        }
        if (string3 == null) {
            bigRational2 = bigRational3;
            bigRational = BigRational.from(1);
        } else {
            try {
                bigRational2 = BigRational.from(string3);
                if (bigRational2.isSpecial()) {
                    throw new NumberFormatException("Value is not finite");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Value " + string3 + " for constant " + string + " is not a valid rational number");
            }
            if (bigRational2.lessThan(bigRational3)) {
                throw new PrismException("Low value " + String.valueOf(bigRational3) + " for constant " + string + " is higher than the high value " + String.valueOf(bigRational2));
            }
            if (string4 == null) {
                bigRational = BigRational.from(1);
            } else {
                try {
                    bigRational = BigRational.from(string4);
                    if (bigRational.isSpecial()) {
                        throw new NumberFormatException("Value is not finite");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new PrismException("Value " + string4 + " for constant " + string + " is not a valid double");
                }
                if (bigRational.isZero()) {
                    throw new PrismException("Step value for constant " + string + " cannot be zero");
                }
                if (bigRational.lessThan(BigRational.ZERO)) {
                    throw new PrismException("Step value for constant " + string + " must be positive");
                }
                if (bigRational.greaterThan(bigRational2.subtract(bigRational3))) {
                    throw new PrismException("Step value " + String.valueOf(bigRational) + " for constant " + string + " is bigger than the difference between " + String.valueOf(bigRational3) + " and " + String.valueOf(bigRational2));
                }
            }
        }
        int n = 0;
        BigRational bigRational4 = bigRational2;
        BigRational bigRational5 = bigRational3;
        while (bigRational5.lessThanEquals(bigRational2)) {
            bigRational4 = bigRational5;
            bigRational5 = bigRational3.add(bigRational.multiply(++n));
        }
        return new DefinedBigRational(string, bigRational3, bigRational4, bigRational, n);
    }

    public static DefinedBoolean defineBoolean(String string, String string2, String string3, String string4) throws PrismException {
        if (string3 != null) {
            throw new PrismException("Cannot define ranges for Boolean constants");
        }
        if (string4 != null) {
            throw new PrismException("Cannot define ranges for Boolean constants");
        }
        if (string2.equals("true")) {
            return new DefinedBoolean(string, true);
        }
        if (string2.equals("false")) {
            return new DefinedBoolean(string, false);
        }
        throw new PrismException("Value " + string2 + " for constant " + string + " is not a valid Boolean");
    }

    public void setValue(T t) {
        this.value = t;
    }

    public Object getValue() {
        return this.value;
    }

    public abstract boolean incr();

    public abstract T getValue(int var1);

    public abstract int getValueIndex(T var1);

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public T getLow() {
        return this.low;
    }

    public T getHigh() {
        return this.high;
    }

    public T getStep() {
        return this.step;
    }

    public int getNumSteps() {
        return this.numSteps;
    }

    public String toString() {
        Object object = "";
        object = (String)object + this.name + "=";
        object = (String)object + String.valueOf(this.low);
        if (this.numSteps > 1) {
            object = (String)object + ":" + String.valueOf(this.step) + ":" + String.valueOf(this.high);
        }
        return object;
    }

    public static double parseDouble(String string) {
        int n = string.lastIndexOf(47);
        if (n < 0) {
            return Double.parseDouble(string);
        }
        if (n == 0 || n == string.length() - 1) {
            throw new NumberFormatException("Illegal fraction syntax");
        }
        double d = DefinedConstant.parseDouble(string.substring(0, n));
        double d2 = DefinedConstant.parseDouble(string.substring(n + 1));
        return d / d2;
    }

    public static boolean isValidDouble(String string) {
        try {
            DefinedConstant.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static class Undefined
    extends DefinedConstant<Object> {
        public Undefined(String string, Type type) {
            super(string, type, null, null, null, -1);
        }

        @Override
        public boolean incr() {
            throw new NullPointerException("Constant is not defined");
        }

        @Override
        public Object getValue(int n) {
            throw new NullPointerException("Constant is not defined");
        }

        @Override
        public int getValueIndex(Object object) {
            throw new NullPointerException("Constant is not defined");
        }
    }

    public static class DefinedInteger
    extends DefinedConstant<Integer> {
        public DefinedInteger(String string, int n, int n2, int n3, int n4) {
            super(string, TypeInt.getInstance(), n, n2, n3, n4);
        }

        @Override
        public boolean incr() {
            int n = (Integer)this.high;
            int n2 = (Integer)this.step;
            int n3 = (Integer)this.value;
            if (n3 + n2 <= n) {
                this.value = n3 + n2;
                return false;
            }
            this.value = this.low;
            return true;
        }

        @Override
        public Integer getValue(int n) {
            int n2 = (Integer)this.low;
            int n3 = (Integer)this.step;
            int n4 = n2;
            for (int i = 0; i < n; ++i) {
                n4 += n3;
            }
            return n4;
        }

        @Override
        public int getValueIndex(Integer n) {
            int n2 = (Integer)this.low;
            int n3 = (Integer)this.step;
            int n4 = n;
            return (n4 - n2) / n3;
        }
    }

    public static class DefinedBigRational
    extends DefinedConstant<BigRational> {
        public DefinedBigRational(String string, BigRational bigRational, BigRational bigRational2, BigRational bigRational3, int n) {
            super(string, TypeDouble.getInstance(), Objects.requireNonNull(bigRational), Objects.requireNonNull(bigRational2), Objects.requireNonNull(bigRational3), n);
        }

        @Override
        public boolean incr() {
            BigRational bigRational = (BigRational)this.low;
            BigRational bigRational2 = (BigRational)this.high;
            BigRational bigRational3 = (BigRational)this.step;
            BigRational bigRational4 = (BigRational)this.value;
            int n = this.getValueIndex((BigRational)this.value) + 1;
            bigRational4 = bigRational.add(bigRational3.multiply(n));
            if (bigRational4.lessThanEquals(bigRational2)) {
                this.value = bigRational4;
                return false;
            }
            this.value = this.low;
            return true;
        }

        @Override
        public BigRational getValue(int n) {
            BigRational bigRational = (BigRational)this.low;
            BigRational bigRational2 = (BigRational)this.low;
            BigRational bigRational3 = bigRational.add(bigRational2.multiply(n));
            return bigRational3;
        }

        @Override
        public int getValueIndex(BigRational bigRational) {
            BigRational bigRational2 = (BigRational)this.low;
            BigRational bigRational3 = (BigRational)this.step;
            BigRational bigRational4 = bigRational;
            BigRational bigRational5 = bigRational4.subtract(bigRational2).divide(bigRational3);
            try {
                return bigRational5.toInt();
            }
            catch (PrismLangException prismLangException) {
                throw new IllegalArgumentException("Can not compute value index, out of range: " + String.valueOf(prismLangException));
            }
        }
    }

    public static class DefinedDouble
    extends DefinedConstant<Double> {
        public DefinedDouble(String string, double d, double d2, double d3, int n) {
            super(string, TypeDouble.getInstance(), d, d2, d3, n);
        }

        @Override
        public boolean incr() {
            double d = (Double)this.low;
            double d2 = (Double)this.high;
            double d3 = (Double)this.step;
            double d4 = (Double)this.value;
            int n = this.getValueIndex((Double)this.value) + 1;
            d4 = d + (double)n * d3;
            if (d4 <= d2 + 0.001 * d3) {
                this.value = d4;
                return false;
            }
            this.value = this.low;
            return true;
        }

        @Override
        public Double getValue(int n) {
            double d = (Double)this.low;
            double d2 = (Double)this.step;
            double d3 = d + (double)n * d2;
            return d3;
        }

        @Override
        public int getValueIndex(Double d) {
            double d2 = (Double)this.low;
            double d3 = (Double)this.step;
            double d4 = d;
            return (int)Math.round((d4 - d2) / d3);
        }
    }

    public static class DefinedBoolean
    extends DefinedConstant<Boolean> {
        public DefinedBoolean(String string, boolean bl) {
            super(string, TypeBool.getInstance(), bl, null, null, 1);
        }

        @Override
        public boolean incr() {
            this.value = this.low;
            return true;
        }

        @Override
        public Boolean getValue(int n) {
            switch (n) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            return null;
        }

        @Override
        public int getValueIndex(Boolean bl) {
            return bl != false ? 1 : 0;
        }
    }

    public static class DefinedDomain<T extends Number>
    extends DefinedConstant<T> {
        private final T[] domain;

        public static <T extends Number> DefinedDomain<T> fromValues(String string, Type type, Collection<T> collection, T[] TArray) {
            if (collection.size() < 1) {
                throw new IllegalArgumentException("expected at least one element in domain");
            }
            if (!(collection instanceof Set)) {
                collection = new HashSet<T>(collection);
            }
            Object[] objectArray = (Number[])collection.toArray(TArray);
            Arrays.sort(objectArray);
            return new DefinedDomain(string, type, (Number[])objectArray);
        }

        protected DefinedDomain(String string, Type type, T[] TArray) {
            super(string, type, TArray[0], TArray[TArray.length - 1], null, TArray.length);
            this.domain = TArray;
            this.checkType();
        }

        protected void checkType() {
            Class<?> clazz = this.domain[0].getClass();
            if (clazz == Integer.class && !(this.type instanceof TypeInt)) {
                throw new IllegalArgumentException("expected TypeInt but got" + String.valueOf(this.type));
            }
            if (clazz == Double.class && !(this.type instanceof TypeDouble)) {
                throw new IllegalArgumentException("expected TypeDouble but got" + String.valueOf(this.type));
            }
            if (clazz == BigRational.class && !(this.type instanceof TypeDouble)) {
                throw new IllegalArgumentException("expected TypeDouble but got" + String.valueOf(this.type));
            }
        }

        @Override
        public boolean incr() {
            int n = this.getValueIndex((T)((Number)this.value));
            if (n == this.numSteps - 1) {
                return true;
            }
            this.value = this.domain[n + 1];
            return false;
        }

        @Override
        public T getValue(int n) {
            return this.domain[n];
        }

        @Override
        public void setValue(T t) {
            if (this.getValueIndex(t) < 0) {
                throw new IllegalArgumentException("expected value from domain");
            }
            super.setValue(t);
        }

        @Override
        public int getValueIndex(T t) {
            return Arrays.binarySearch(this.domain, t);
        }

        @Override
        public String toString() {
            return this.name + "=" + Arrays.toString(this.domain);
        }
    }
}

