/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import prism.PrismUtils;

public class Coalition {
    protected boolean allPlayers;
    protected List<String> players;

    public Coalition() {
        this.allPlayers = false;
        this.players = new ArrayList<String>();
    }

    public Coalition(List<String> list) {
        this();
        this.setPlayers(list);
    }

    public Coalition(Coalition coalition) {
        this.allPlayers = coalition.isAllPlayers();
        this.players = new ArrayList<String>(coalition.players);
    }

    public void setAllPlayers() {
        this.allPlayers = true;
        this.players.clear();
    }

    public void setPlayers(List<String> list) {
        this.allPlayers = false;
        this.players.clear();
        this.players.addAll(list);
    }

    public boolean isAllPlayers() {
        return this.allPlayers;
    }

    public boolean isEmpty() {
        return !this.allPlayers && this.players.isEmpty();
    }

    public List<String> getPlayers() {
        return this.allPlayers ? null : this.players;
    }

    public boolean isPlayerIndexInCoalition(int n, List<String> list) {
        if (this.allPlayers) {
            return true;
        }
        if (this.players.contains("" + (n + 1))) {
            return true;
        }
        String string = list.get(n);
        return string != null && !"".equals(string) && this.players.contains(string);
    }

    public boolean isPlayerIndexInCoalition(int n, Map<Integer, String> map) {
        if (this.allPlayers) {
            return true;
        }
        if (this.players.contains("" + (n + 1))) {
            return true;
        }
        String string = map.get(n + 1);
        return string != null && !"".equals(string) && this.players.contains(string);
    }

    public String toString() {
        return this.allPlayers ? "*" : PrismUtils.joinString(this.players, ",");
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.allPlayers ? 1231 : 1237);
        n = 31 * n + (this.players == null ? 0 : this.players.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Coalition coalition = (Coalition)object;
        if (this.allPlayers != coalition.allPlayers) {
            return false;
        }
        return !(this.players == null ? coalition.players != null : !this.players.equals(coalition.players));
    }
}

