/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import parser.EvaluateContext;
import parser.State;
import parser.Values;
import parser.ast.Declaration;
import parser.ast.DeclarationBool;
import parser.ast.DeclarationClock;
import parser.ast.DeclarationDoubleUnbounded;
import parser.ast.DeclarationInt;
import parser.ast.DeclarationIntUnbounded;
import parser.ast.DeclarationType;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeInt;
import prism.ModelInfo;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismUtils;

public class VarList {
    private List<Var> vars;
    private Map<String, Integer> nameMap;
    private int totalNumBits;
    private EvaluateContext ec;

    public VarList() {
        this.setEvaluateContext(EvaluateContext.create());
        this.vars = new ArrayList<Var>();
        this.nameMap = new HashMap<String, Integer>();
        this.totalNumBits = 0;
    }

    public VarList(ModelInfo modelInfo) throws PrismException {
        this();
        this.setEvaluateContext(modelInfo.getEvaluateContext());
        int n = modelInfo.getNumVars();
        for (int i = 0; i < n; ++i) {
            DeclarationType declarationType = modelInfo.getVarDeclarationType(i);
            int n2 = modelInfo.getVarModuleIndex(i);
            this.addVar(modelInfo.getVarName(i), declarationType, n2);
        }
    }

    public void setEvaluateContext(EvaluateContext evaluateContext) {
        this.ec = evaluateContext;
    }

    public void addVar(Declaration declaration, int n) throws PrismLangException {
        this.addVar(declaration.getName(), declaration.getDeclType(), n);
    }

    public void addVarAtStart(Declaration declaration, int n) throws PrismLangException {
        this.addVar(0, declaration, n);
    }

    public void addVar(int n, Declaration declaration, int n2) throws PrismLangException {
        Var var = this.createVar(declaration.getName(), declaration.getDeclType(), n2);
        this.vars.add(n, var);
        this.totalNumBits += this.getRangeLogTwo(n);
        int n3 = this.getNumVars();
        this.nameMap = new HashMap<String, Integer>(n3);
        for (int i = 0; i < n3; ++i) {
            this.nameMap.put(this.getName(i), i);
        }
    }

    public void addVar(String string, DeclarationType declarationType, int n) throws PrismLangException {
        Var var = this.createVar(string, declarationType, n);
        this.vars.add(var);
        this.totalNumBits += this.getRangeLogTwo(this.vars.size() - 1);
        this.nameMap.put(string, this.vars.size() - 1);
    }

    private Var createVar(String string, DeclarationType declarationType, int n) throws PrismLangException {
        int n2;
        int n3;
        Var var = new Var(string, declarationType.getType());
        var.declType = declarationType;
        var.module = n;
        if (declarationType instanceof DeclarationInt) {
            DeclarationInt declarationInt = (DeclarationInt)declarationType;
            n3 = declarationInt.getLow().evaluateInt(this.ec);
            n2 = declarationInt.getHigh().evaluateInt(this.ec);
            if (n2 - n3 <= 0) {
                String string2 = "Invalid range (" + n3 + "-" + n2 + ") for variable \"" + string + "\"";
                throw new PrismLangException(string2, declarationType);
            }
            if ((long)n2 - (long)n3 >= Integer.MAX_VALUE) {
                String string3 = "Range for variable \"" + string + "\" (" + n3 + "-" + n2 + ") is too big";
                throw new PrismLangException(string3, declarationType);
            }
        } else if (declarationType instanceof DeclarationBool) {
            n3 = 0;
            n2 = 1;
        } else if (declarationType instanceof DeclarationClock) {
            n3 = 0;
            n2 = 1;
        } else if (declarationType instanceof DeclarationIntUnbounded) {
            n3 = 0;
            n2 = 1;
        } else if (declarationType instanceof DeclarationDoubleUnbounded) {
            n3 = 0;
            n2 = 1;
        } else {
            throw new PrismLangException("Unknown variable type \"" + String.valueOf(declarationType) + "\" in declaration", declarationType);
        }
        var.low = n3;
        var.high = n2;
        return var;
    }

    public int getNumVars() {
        return this.vars.size();
    }

    public int getIndex(String string) {
        Integer n = this.nameMap.get(string);
        return n == null ? -1 : n;
    }

    public boolean exists(String string) {
        return this.getIndex(string) != -1;
    }

    public DeclarationType getDeclarationType(int n) {
        return this.vars.get((int)n).declType;
    }

    public String getName(int n) {
        return this.vars.get((int)n).name;
    }

    public Type getType(int n) {
        return this.vars.get((int)n).type;
    }

    public int getModule(int n) {
        return this.vars.get((int)n).module;
    }

    public int getLow(int n) {
        return this.vars.get((int)n).low;
    }

    public int getHigh(int n) {
        return this.vars.get((int)n).high;
    }

    public int getRange(int n) {
        return this.vars.get((int)n).high - this.vars.get((int)n).low + 1;
    }

    public int getRangeLogTwo(int n) {
        return (int)Math.ceil(PrismUtils.log2(this.getRange(n)));
    }

    public int getTotalNumBits() {
        return this.totalNumBits;
    }

    public Object decodeFromInt(int n, int n2) {
        try {
            Type type = this.getType(n);
            if (type instanceof TypeInt) {
                return type.castValueTo(n2 + this.getLow(n), this.ec.getEvaluationMode());
            }
            if (type instanceof TypeBool) {
                return n2 != 0;
            }
            return null;
        }
        catch (PrismLangException prismLangException) {
            return null;
        }
    }

    public int encodeToInt(int n, Object object) throws PrismLangException {
        Type type = this.getType(n);
        try {
            if (type instanceof TypeInt) {
                int n2 = ((TypeInt)type).castValueTo(object).intValue();
                if (n2 < this.getLow(n) || n2 > this.getHigh(n)) {
                    throw new PrismLangException("Value " + String.valueOf(object) + " out of range for variable " + this.getName(n));
                }
                return n2 - this.getLow(n);
            }
            if (type instanceof TypeBool) {
                return ((TypeBool)type).castValueTo(object) != false ? 1 : 0;
            }
            throw new PrismLangException("Unsupported type " + String.valueOf(type) + " for variable " + this.getName(n));
        }
        catch (ClassCastException classCastException) {
            throw new PrismLangException("Value " + String.valueOf(object) + " is wrong type for variable " + this.getName(n));
        }
    }

    public int encodeToIntFromString(int n, String string) throws PrismLangException {
        Type type = this.getType(n);
        if (type instanceof TypeInt) {
            try {
                int n2 = Integer.parseInt(string);
                if (n2 < this.getLow(n) || n2 > this.getHigh(n)) {
                    throw new PrismLangException("Value " + n2 + " out of range for variable " + this.getName(n));
                }
                return n2 - this.getLow(n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismLangException("\"" + string + "\" is not a valid integer value");
            }
        }
        if (type instanceof TypeBool) {
            if (string.equals("true")) {
                return 1;
            }
            if (string.equals("false")) {
                return 0;
            }
            throw new PrismLangException("\"" + string + "\" is not a valid Boolean value");
        }
        throw new PrismLangException("Unsupported type " + String.valueOf(type) + " for variable " + this.getName(n));
    }

    public List<Values> getAllValues(List<String> list) throws PrismLangException {
        Vector<Values> vector = new Vector<Values>();
        vector.add(new Values());
        for (String string : list) {
            Values values;
            Values values2;
            int n;
            int n2;
            int n3 = this.getIndex(string);
            if (this.getType(n3) instanceof TypeBool) {
                n2 = vector.size();
                for (n = 0; n < n2; ++n) {
                    values2 = vector.get(n);
                    values = new Values(values2);
                    values.setValue(string, true);
                    vector.add(values);
                    values2.addValue(string, false);
                }
                continue;
            }
            if (this.getType(n3) instanceof TypeInt) {
                int n4 = this.getLow(n3);
                int n5 = this.getHigh(n3);
                n2 = vector.size();
                for (n = 0; n < n2; ++n) {
                    values2 = vector.get(n);
                    for (int i = n4 + 1; i < n5 + 1; ++i) {
                        values = new Values(values2);
                        values.setValue(string, this.getType(n3).castValueTo(i, this.ec.getEvaluationMode()));
                        vector.add(values);
                    }
                    values2.addValue(string, this.getType(n3).castValueTo(n4, this.ec.getEvaluationMode()));
                }
                continue;
            }
            throw new PrismLangException("Cannot determine all values for a variable of type " + String.valueOf(this.getType(n3)));
        }
        return vector;
    }

    public List<State> getAllStates() throws PrismLangException {
        int n = this.getNumVars();
        ArrayList<State> arrayList = new ArrayList<State>();
        arrayList.add(new State(n));
        for (int i = 0; i < n; ++i) {
            State state;
            State state2;
            int n2;
            int n3;
            if (this.getType(i) instanceof TypeBool) {
                n3 = arrayList.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    state2 = (State)arrayList.get(n2);
                    state = new State(state2);
                    state.setValue(i, true);
                    state2.setValue(i, false);
                    arrayList.add(state);
                }
                continue;
            }
            if (this.getType(i) instanceof TypeInt) {
                n3 = this.getLow(i);
                n2 = this.getHigh(i);
                int n4 = arrayList.size();
                for (int j = 0; j < n4; ++j) {
                    state2 = (State)arrayList.get(j);
                    for (int k = n3 + 1; k < n2 + 1; ++k) {
                        state = new State(state2);
                        state.setValue(i, this.getType(i).castValueTo(k, this.ec.getEvaluationMode()));
                        arrayList.add(state);
                    }
                    state2.setValue(i, this.getType(i).castValueTo(n3, this.ec.getEvaluationMode()));
                }
                continue;
            }
            throw new PrismLangException("Cannot determine all values for a variable of type " + String.valueOf(this.getType(i)));
        }
        return arrayList;
    }

    public State convertBitSetToState(BitSet bitSet) {
        State state = new State(this.getNumVars());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.totalNumBits;
        for (int i = 0; i < n4; ++i) {
            if (bitSet.get(i)) {
                n2 += 1 << this.getRangeLogTwo(n3) - n - 1;
            }
            if (n >= this.getRangeLogTwo(n3) - 1) {
                state.setValue(n3, this.decodeFromInt(n3, n2));
                ++n3;
                n2 = 0;
                n = 0;
                continue;
            }
            ++n;
        }
        return state;
    }

    public Object clone() {
        int n = this.getNumVars();
        VarList varList = new VarList();
        varList.setEvaluateContext(this.ec);
        varList.vars = new ArrayList<Var>(n);
        varList.nameMap = new HashMap<String, Integer>(n);
        for (int i = 0; i < n; ++i) {
            varList.vars.add(new Var(this.vars.get(i)));
            varList.nameMap.put(this.getName(i), i);
        }
        return varList;
    }

    class Var {
        public String name;
        public Type type;
        public DeclarationType declType;
        public int module;
        public int low;
        public int high;

        public Var(String string, Type type) {
            this.name = string;
            this.type = type;
        }

        public Var(Var var) {
            this.name = var.name;
            this.type = var.type;
            this.declType = (DeclarationType)var.declType.deepCopy();
            this.module = var.module;
            this.low = var.low;
            this.high = var.high;
        }
    }
}

