/*
 * Decompiled with CFR 0.152.
 */
package param;

import param.BigRational;
import param.FunctionFactory;
import param.Point;
import param.StateValue;
import parser.ast.Expression;
import prism.PrismException;

public abstract class Function
extends StateValue {
    protected FunctionFactory factory;

    protected Function(FunctionFactory functionFactory) {
        this.factory = functionFactory;
    }

    public abstract Function add(Function var1);

    public abstract Function negate();

    public abstract Function multiply(Function var1);

    public abstract Function divide(Function var1);

    public abstract Function pow(int var1);

    public abstract Function star();

    public abstract Function toConstraint();

    public abstract BigRational evaluate(Point var1, boolean var2);

    public abstract BigRational asBigRational();

    public abstract Expression asExpression() throws PrismException;

    public abstract boolean isNaN();

    public abstract boolean isInf();

    public abstract boolean isMInf();

    public abstract boolean isOne();

    public abstract boolean isZero();

    public abstract boolean isConstant();

    public Function multiply(int n) {
        Function function = this.factory.fromLong(n);
        return this.multiply(function);
    }

    public Function divide(int n) {
        Function function = this.factory.fromLong(n);
        return this.divide(function);
    }

    public FunctionFactory getFactory() {
        return this.factory;
    }

    public Function subtract(Function function) {
        return this.add(function.negate());
    }

    public BigRational evaluate(Point point) {
        return this.evaluate(point, true);
    }

    boolean check(Point point, boolean bl) {
        BigRational bigRational = this.evaluate(point, false);
        int n = bigRational.signum();
        return bl ? n > 0 : n >= 0;
    }
}

