/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import java.io.PrintStream;
import java.util.Vector;
import jltl2ba.MyBitSet;

public class SCCs {
    public Vector<MyBitSet> _sccs = new Vector();
    public Vector<Integer> _state_to_scc = new Vector();
    public Vector<MyBitSet> _dag = new Vector();
    public Vector<Integer> _topological_order = new Vector();
    public Vector<MyBitSet> _reachability = new Vector();
    public boolean _graph_is_disjoint = false;

    public MyBitSet get(int n) {
        return this._sccs.get(n);
    }

    public int countSCCs() {
        return this._sccs.size();
    }

    public int state2scc(int n) {
        return this._state_to_scc.get(n);
    }

    Vector<Integer> topologicalOrder() {
        return this._topological_order;
    }

    MyBitSet successors(int n) {
        return this._dag.get(n);
    }

    public boolean stateIsReachable(int n, int n2) {
        return this.isReachable(this.state2scc(n), this.state2scc(n2));
    }

    public boolean isReachable(int n, int n2) {
        return this._reachability.get(n).get(n2);
    }

    public void print(PrintStream printStream) {
        printStream.println("SCC:");
        for (int i = 0; i < this.countSCCs(); ++i) {
            int n = this._topological_order.get(i);
            printStream.println(n + " : " + String.valueOf(this.get(n)));
        }
    }

    public Vector<MyBitSet> getReachabilityForAllStates() {
        Vector<MyBitSet> vector = new Vector<MyBitSet>();
        vector.setSize(this._state_to_scc.size());
        for (int i = 0; i < this._state_to_scc.size(); ++i) {
            int n = this.state2scc(i);
            MyBitSet myBitSet = this._reachability.get(n);
            MyBitSet myBitSet2 = new MyBitSet();
            for (Integer n2 : myBitSet) {
                myBitSet2.or(this._sccs.get(n2));
            }
            vector.set(i, myBitSet2);
        }
        return vector;
    }

    public int addSCC(MyBitSet myBitSet) {
        this._sccs.add(myBitSet);
        return this._sccs.size() - 1;
    }

    public void setState2SCC(int n, int n2) {
        if (this._state_to_scc.size() <= n) {
            this._state_to_scc.setSize(n + 1);
        }
        this._state_to_scc.set(n, n2);
    }

    public void setGraphIsDisjoint() {
        this._graph_is_disjoint = true;
    }

    public boolean getGraphIsDisjoint() {
        return this._graph_is_disjoint;
    }
}

