/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmctools.umbj;

import io.github.pmctools.umbj.UMBIndex;
import java.util.Objects;

public class UMBType {
    public Type type;
    public Integer size;

    public static UMBType create(Type type) {
        UMBType uMBType = new UMBType();
        uMBType.type = type;
        uMBType.size = type.defaultSize();
        return uMBType;
    }

    public static UMBType create(Type type, Integer n) {
        UMBType uMBType = new UMBType();
        uMBType.type = type;
        uMBType.size = n;
        return uMBType;
    }

    public static UMBType contNum(boolean bl) {
        return UMBType.contNum(bl, false);
    }

    public static UMBType contNum(boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                return UMBType.create(Type.RATIONAL_INTERVAL);
            }
            return UMBType.create(Type.RATIONAL);
        }
        if (bl2) {
            return UMBType.create(Type.DOUBLE_INTERVAL);
        }
        return UMBType.create(Type.DOUBLE);
    }

    public boolean isDefaultSize() {
        return this.size == null || Objects.equals(this.size, this.type.defaultSize());
    }

    public static enum Type implements UMBIndex.UMBField
    {
        BOOL,
        INT,
        UINT,
        INT_INTERVAL,
        UINT_INTERVAL,
        DOUBLE,
        DOUBLE_INTERVAL,
        RATIONAL,
        RATIONAL_INTERVAL,
        STRING;


        public String toString() {
            return this.description();
        }

        public boolean isContinuousNumeric() {
            switch (this) {
                case DOUBLE: 
                case DOUBLE_INTERVAL: 
                case RATIONAL: 
                case RATIONAL_INTERVAL: {
                    return true;
                }
            }
            return false;
        }

        public boolean isDouble() {
            switch (this) {
                case DOUBLE: 
                case DOUBLE_INTERVAL: {
                    return true;
                }
            }
            return false;
        }

        public boolean isRational() {
            switch (this) {
                case RATIONAL: 
                case RATIONAL_INTERVAL: {
                    return true;
                }
            }
            return false;
        }

        public boolean isInterval() {
            switch (this) {
                case DOUBLE_INTERVAL: 
                case RATIONAL_INTERVAL: {
                    return true;
                }
            }
            return false;
        }

        public Integer defaultSize() {
            switch (this) {
                case BOOL: {
                    return 1;
                }
                case DOUBLE: 
                case INT: 
                case UINT: {
                    return 64;
                }
                case DOUBLE_INTERVAL: 
                case INT_INTERVAL: 
                case UINT_INTERVAL: {
                    return 128;
                }
                case RATIONAL: {
                    return 128;
                }
                case RATIONAL_INTERVAL: {
                    return 256;
                }
                case STRING: {
                    return 64;
                }
            }
            return null;
        }
    }
}

