/*
 * Decompiled with CFR 0.152.
 */
package io;

import common.Interval;
import common.SafeCast;
import io.ExplicitModelImporter;
import io.IOUtils;
import io.ModelAccess;
import io.github.pmctools.umbj.UMBBitPacking;
import io.github.pmctools.umbj.UMBBitString;
import io.github.pmctools.umbj.UMBException;
import io.github.pmctools.umbj.UMBIndex;
import io.github.pmctools.umbj.UMBReader;
import io.github.pmctools.umbj.UMBType;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.stream.IntStream;
import parser.VarList;
import parser.ast.DeclarationBool;
import parser.ast.DeclarationDoubleUnbounded;
import parser.ast.DeclarationInt;
import parser.ast.DeclarationType;
import parser.ast.Expression;
import prism.BasicModelInfo;
import prism.BasicRewardInfo;
import prism.Evaluator;
import prism.ModelInfo;
import prism.ModelType;
import prism.Prism;
import prism.PrismException;
import prism.RewardInfo;

public class UMBImporter
extends ExplicitModelImporter {
    private File umbFile;
    private UMBReader umbReader;
    private UMBIndex umbIndex;
    private BasicModelInfo basicModelInfo;
    private List<String> labelIDs;
    private List<String> rewardIDs;
    private List<String> varIDs;
    private int numStates = 0;
    private int numChoices = 0;
    private int numTransitions = 0;
    private int numObservations = 0;
    private BasicRewardInfo basicRewardInfo;

    public UMBImporter(File file) throws PrismException {
        this.umbFile = file;
        try {
            this.umbReader = new UMBReader(file);
            this.umbIndex = this.umbReader.getUMBIndex();
            this.numStates = SafeCast.toIntExact(this.umbIndex.getNumStates());
            this.numChoices = SafeCast.toIntExact(this.umbIndex.getNumChoices());
            this.numTransitions = SafeCast.toIntExact(this.umbIndex.getNumBranches());
            this.numObservations = SafeCast.toIntExact(this.umbIndex.getNumObservations());
        }
        catch (ArithmeticException arithmeticException) {
            throw new PrismException("UMB model is too large to be imported");
        }
        catch (UMBException uMBException) {
            throw new PrismException("Error importing from UMB: " + uMBException.getMessage());
        }
    }

    @Override
    public boolean modelIsExact() {
        return this.umbIndex.getBranchProbabilityType() != null && this.umbIndex.getBranchProbabilityType().type.isRational();
    }

    @Override
    public boolean providesStates() {
        return this.umbIndex.hasValuations(UMBIndex.UMBEntity.STATES);
    }

    @Override
    public boolean providesObservations() {
        return this.umbIndex.hasValuations(UMBIndex.UMBEntity.OBSERVATIONS);
    }

    @Override
    public boolean providesLabels() {
        return this.umbIndex.hasAPAnnotations();
    }

    @Override
    public String sourceString() {
        return "\"" + this.umbFile.getName() + "\"";
    }

    @Override
    public ModelInfo getModelInfo() throws PrismException {
        if (this.basicModelInfo == null) {
            this.buildModelInfo();
        }
        return this.basicModelInfo;
    }

    @Override
    public int getNumStates() throws PrismException {
        return this.numStates;
    }

    @Override
    public int getNumChoices() throws PrismException {
        return this.numChoices;
    }

    @Override
    public int getNumTransitions() throws PrismException {
        return this.numTransitions;
    }

    @Override
    public int getNumObservations() throws PrismException {
        return this.numObservations;
    }

    @Override
    public BitSet getDeadlockStates() throws PrismException {
        return new BitSet();
    }

    @Override
    public int getNumDeadlockStates() throws PrismException {
        return 0;
    }

    @Override
    public RewardInfo getRewardInfo() throws PrismException {
        if (this.basicRewardInfo == null) {
            this.buildRewardInfo();
        }
        return this.basicRewardInfo;
    }

    private void buildModelInfo() throws PrismException {
        Object object;
        ModelType modelType = UMBImporter.getModelTypeFromIndex(this.umbIndex);
        this.basicModelInfo = new BasicModelInfo(modelType);
        if (modelType.multiplePlayers()) {
            this.basicModelInfo.getPlayerNameList().addAll(this.umbIndex.getPlayerNames());
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            if (modelType.nondeterministic()) {
                if (this.umbReader.hasChoiceActionStrings()) {
                    this.umbReader.extractChoiceActionStrings(arrayList::add);
                } else {
                    IntStream.rangeClosed(1, this.umbIndex.getNumChoiceActions()).mapToObj(n -> "_" + n).forEach(arrayList::add);
                }
            } else if (this.umbReader.hasBranchActionStrings()) {
                this.umbReader.extractBranchActionStrings(arrayList::add);
            } else {
                IntStream.rangeClosed(1, this.umbIndex.getNumBranchActions()).mapToObj(n -> "_" + n).forEach(arrayList::add);
            }
            if (arrayList.isEmpty()) {
                arrayList.add(null);
            }
        }
        catch (UMBException uMBException) {
            throw new PrismException("Could not extract actions from UMB file");
        }
        this.basicModelInfo.setActionList(arrayList);
        VarList varList = this.basicModelInfo.getVarList();
        if (this.providesStates()) {
            this.buildVarInfo(UMBIndex.UMBEntity.STATES, varList);
        } else {
            varList.addVar(this.defaultVariableName(), this.defaultVariableDeclarationType(), -1);
        }
        if (this.providesObservations()) {
            object = new VarList();
            ((VarList)object).setEvaluateContext(this.basicModelInfo.getEvaluateContext());
            this.buildVarInfo(UMBIndex.UMBEntity.OBSERVATIONS, (VarList)object);
            for (int i = 0; i < ((VarList)object).getNumVars(); ++i) {
                this.basicModelInfo.getObservableNames().add(((VarList)object).getName(i));
                this.basicModelInfo.getObservableTypeList().add(((VarList)object).getType(i));
            }
        } else {
            this.basicModelInfo.getObservableNames().add(this.defaultObservableName());
            this.basicModelInfo.getObservableTypeList().add(this.defaultObservableType());
        }
        this.labelIDs = new ArrayList<String>();
        object = this.basicModelInfo.getLabelNameList();
        for (UMBIndex.Annotation annotation : this.umbIndex.getAPAnnotationsList()) {
            String string = annotation.getName();
            if (string.equals("deadlock")) continue;
            this.labelIDs.add(annotation.id);
            Object object2 = Prism.toIdentifier(string);
            while (object.contains(object2)) {
                object2 = "_" + (String)object2;
            }
            object.add(object2);
        }
    }

    private static ModelType getModelTypeFromIndex(UMBIndex uMBIndex) throws PrismException {
        UMBIndex.ModelType modelType = uMBIndex.getModelType();
        if (modelType == null) {
            throw new PrismException("Unsupported model type in UMB file");
        }
        switch (modelType) {
            case DTMC: {
                return ModelType.DTMC;
            }
            case CTMC: {
                return ModelType.CTMC;
            }
            case MDP: {
                return ModelType.MDP;
            }
            case POMDP: {
                return ModelType.POMDP;
            }
            case LTS: {
                return ModelType.LTS;
            }
            case IDTMC: {
                return ModelType.IDTMC;
            }
            case IMDP: {
                return ModelType.IMDP;
            }
            case IPOMDP: {
                return ModelType.IPOMDP;
            }
            case TSG: {
                return ModelType.SMG;
            }
        }
        throw new PrismException("Unsupported model type " + String.valueOf(modelType) + " in UMB file");
    }

    private void buildRewardInfo() throws PrismException {
        ModelType modelType = this.getModelInfo().getModelType();
        this.basicRewardInfo = new BasicRewardInfo();
        int n = this.umbIndex.getNumRewardAnnotations();
        for (int i = 0; i < n; ++i) {
            this.basicRewardInfo.addReward(this.umbIndex.getRewardAnnotation(i).getName());
            this.basicRewardInfo.setHasStateRewards(i, this.umbIndex.hasStateRewards(i));
            if (modelType.nondeterministic()) {
                this.basicRewardInfo.setHasTransitionRewards(i, this.umbIndex.hasChoiceRewards(i));
                continue;
            }
            this.basicRewardInfo.setHasTransitionRewards(i, this.umbIndex.hasBranchRewards(i));
        }
    }

    private void buildVarInfo(UMBIndex.UMBEntity uMBEntity, VarList varList) throws PrismException {
        try {
            if (!this.umbIndex.hasValuations(uMBEntity)) {
                throw new PrismException("Missing UMB valuation data for " + String.valueOf(uMBEntity));
            }
            if (this.umbIndex.getNumValuationClasses(uMBEntity) > 1) {
                throw new PrismException("Import of multiple valuation classes not yet supported");
            }
            if (!this.umbIndex.areValuationsUnique(uMBEntity)) {
                throw new PrismException("UMB valuations for " + String.valueOf(uMBEntity) + " are not unique");
            }
            UMBBitPacking uMBBitPacking = this.umbIndex.getValuationBitPacking(uMBEntity);
            int n = uMBBitPacking.getNumVariables();
            for (int i = 0; i < n; ++i) {
                UMBBitPacking.BitPackedVariable bitPackedVariable = uMBBitPacking.getVariable(i);
                Object object = Prism.toIdentifier(bitPackedVariable.name);
                while (varList.getIndex((String)object) != -1) {
                    object = "_" + (String)object;
                }
                DeclarationType declarationType = null;
                switch (bitPackedVariable.getType().type) {
                    case BOOL: {
                        declarationType = new DeclarationBool();
                        break;
                    }
                    case INT: 
                    case UINT: {
                        int n2;
                        int n3;
                        boolean bl = true;
                        if (bl) {
                            UMBReader.IntRange intRange = this.umbReader.getValuationIntRange(uMBEntity, uMBBitPacking, i);
                            n3 = intRange.getMin();
                            n2 = intRange.getMax();
                        } else if (bitPackedVariable.getType().type == UMBType.Type.INT) {
                            n3 = -(1 << uMBBitPacking.getVariableSize(i) - 1);
                            n2 = (1 << uMBBitPacking.getVariableSize(i) - 1) - 1;
                        } else {
                            n3 = 0;
                            n2 = (1 << uMBBitPacking.getVariableSize(i)) - 1;
                        }
                        if (n3 == n2) {
                            ++n2;
                        }
                        declarationType = new DeclarationInt(Expression.Int(n3), Expression.Int(n2));
                        break;
                    }
                    case DOUBLE: {
                        declarationType = new DeclarationDoubleUnbounded();
                        break;
                    }
                    default: {
                        throw new PrismException("Unknown variable type in UMB index: " + String.valueOf(bitPackedVariable.getType().type));
                    }
                }
                varList.addVar((String)object, declarationType, -1);
            }
        }
        catch (UMBException uMBException) {
            throw new RuntimeException(uMBException);
        }
    }

    @Override
    public void extractStates(IOUtils.StateDefnConsumer stateDefnConsumer) throws PrismException {
        if (!this.providesStates()) {
            super.extractStates(stateDefnConsumer);
            return;
        }
        try {
            UMBBitPacking uMBBitPacking = this.umbIndex.getValuationBitPacking(UMBIndex.UMBEntity.STATES);
            AtomicInteger atomicInteger = new AtomicInteger(0);
            int n = uMBBitPacking.getNumVariables();
            this.umbReader.extractStateValuations(uMBBitString -> {
                try {
                    for (int i = 0; i < n; ++i) {
                        stateDefnConsumer.accept(atomicInteger.get(), i, uMBBitPacking.getVariableValue((UMBBitString)uMBBitString, i));
                    }
                    atomicInteger.incrementAndGet();
                }
                catch (UMBException | PrismException exception) {
                    throw new RuntimeException(exception.getMessage());
                }
            });
        }
        catch (UMBException | RuntimeException exception) {
            throw new PrismException("UMB import problem: " + exception.getMessage());
        }
    }

    @Override
    public void extractObservationDefinitions(IOUtils.StateDefnConsumer stateDefnConsumer) throws PrismException {
        if (!this.providesObservations()) {
            super.extractObservationDefinitions(stateDefnConsumer);
            return;
        }
        try {
            UMBBitPacking uMBBitPacking = this.umbIndex.getValuationBitPacking(UMBIndex.UMBEntity.OBSERVATIONS);
            AtomicInteger atomicInteger = new AtomicInteger(0);
            int n = uMBBitPacking.getNumVariables();
            this.umbReader.extractObservationValuations(uMBBitString -> {
                try {
                    for (int i = 0; i < n; ++i) {
                        stateDefnConsumer.accept(atomicInteger.get(), i, uMBBitPacking.getVariableValue((UMBBitString)uMBBitString, i));
                    }
                    atomicInteger.incrementAndGet();
                }
                catch (UMBException | PrismException exception) {
                    throw new RuntimeException(exception.getMessage());
                }
            });
        }
        catch (UMBException | RuntimeException exception) {
            throw new PrismException("UMB import problem: " + exception.getMessage());
        }
    }

    @Override
    public void extractStateOwners(IOUtils.StateValueConsumer<Integer> stateValueConsumer) throws PrismException {
        try {
            IntArrayList intArrayList = new IntArrayList(this.numStates);
            this.umbReader.extractStatePlayers(arg_0 -> ((IntList)intArrayList).add(arg_0));
            for (int i = 0; i < this.numStates; ++i) {
                stateValueConsumer.accept(i, intArrayList.getInt(i));
            }
        }
        catch (UMBException uMBException) {
            throw new PrismException("UMB import problem: " + uMBException.getMessage());
        }
    }

    @Override
    public int computeMaxNumChoices() throws PrismException {
        try {
            return SafeCast.toInt(this.umbReader.extractMaxStateChoiceCount());
        }
        catch (UMBException uMBException) {
            throw new PrismException("UMB import problem: " + uMBException.getMessage());
        }
    }

    @Override
    public <Value> void extractMCTransitions(IOUtils.MCTransitionConsumer<Value> mCTransitionConsumer, Evaluator<Value> evaluator) throws PrismException {
        try {
            boolean bl;
            IntArrayList intArrayList = new IntArrayList(this.numChoices + 1);
            this.umbReader.extractChoiceBranchOffsets(arg_0 -> UMBImporter.lambda$extractMCTransitions$4((IntList)intArrayList, arg_0));
            IntArrayList intArrayList2 = new IntArrayList(this.numTransitions);
            this.umbReader.extractBranchTargets(arg_0 -> UMBImporter.lambda$extractMCTransitions$5((IntList)intArrayList2, arg_0));
            ModelAccess.ValueListFromPrimitives<Value> valueListFromPrimitives = new ModelAccess.ValueListFromPrimitives<Value>(evaluator, this.numTransitions);
            List list = valueListFromPrimitives.valueList;
            this.umbReader.extractBranchProbabilities(valueListFromPrimitives.primitiveConsumer);
            List list2 = null;
            boolean bl2 = bl = this.getModelInfo().getModelType() == ModelType.CTMC;
            if (bl) {
                valueListFromPrimitives = new ModelAccess.ValueListFromPrimitives<Value>(evaluator, this.numStates);
                list2 = valueListFromPrimitives.valueList;
                this.umbReader.extractExitRates(valueListFromPrimitives.primitiveConsumer);
            }
            Object object = this.getModelInfo().getActions().get(0);
            IntArrayList intArrayList3 = null;
            boolean bl3 = this.umbReader.hasBranchActionIndices();
            if (bl3) {
                intArrayList3 = new IntArrayList(this.numTransitions);
                this.umbReader.extractBranchActionIndices(arg_0 -> ((IntList)intArrayList3).add(arg_0));
            }
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.numStates; ++i) {
                n = n2;
                n2 = intArrayList.getInt(i + 1);
                for (int j = n; j < n2; ++j) {
                    Object object2;
                    Object object3;
                    Object object4 = object3 = bl3 ? this.getModelInfo().getActions().get(intArrayList3.getInt(j)) : object;
                    if (this.getModelInfo().getModelType() == ModelType.IDTMC) {
                        object2 = new Interval<Double>((Double)list.get(2 * j), (Double)list.get(2 * j + 1));
                        mCTransitionConsumer.accept(i, intArrayList2.getInt(j), object2, object3);
                        continue;
                    }
                    object2 = list.get(j);
                    if (bl) {
                        object2 = evaluator.multiply(object2, list2.get(i));
                    }
                    mCTransitionConsumer.accept(i, intArrayList2.getInt(j), object2, object3);
                }
            }
        }
        catch (UMBException uMBException) {
            throw new PrismException("UMB import problem: " + uMBException.getMessage());
        }
    }

    @Override
    public <Value> void extractMDPTransitions(IOUtils.MDPTransitionConsumer<Value> mDPTransitionConsumer, Evaluator<Value> evaluator) throws PrismException {
        try {
            IntArrayList intArrayList = new IntArrayList(this.numStates + 1);
            this.umbReader.extractStateChoiceOffsets(arg_0 -> UMBImporter.lambda$extractMDPTransitions$6((IntList)intArrayList, arg_0));
            IntArrayList intArrayList2 = new IntArrayList(this.numChoices + 1);
            this.umbReader.extractChoiceBranchOffsets(arg_0 -> UMBImporter.lambda$extractMDPTransitions$7((IntList)intArrayList2, arg_0));
            IntArrayList intArrayList3 = new IntArrayList(this.numTransitions);
            this.umbReader.extractBranchTargets(arg_0 -> UMBImporter.lambda$extractMDPTransitions$8((IntList)intArrayList3, arg_0));
            ModelAccess.ValueListFromPrimitives<Value> valueListFromPrimitives = new ModelAccess.ValueListFromPrimitives<Value>(evaluator, this.numTransitions);
            List list = valueListFromPrimitives.valueList;
            this.umbReader.extractBranchProbabilities(valueListFromPrimitives.primitiveConsumer);
            Object object = this.getModelInfo().getActions().get(0);
            IntArrayList intArrayList4 = null;
            boolean bl = this.umbReader.hasChoiceActionIndices();
            if (bl) {
                intArrayList4 = new IntArrayList(this.numChoices);
                this.umbReader.extractChoiceActionIndices(arg_0 -> ((IntList)intArrayList4).add(arg_0));
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < this.numStates; ++i) {
                n = n2;
                n2 = intArrayList.getInt(i + 1);
                int n5 = 0;
                for (int j = n; j < n2; ++j) {
                    n3 = n4;
                    n4 = intArrayList2.getInt(j + 1);
                    for (int k = n3; k < n4; ++k) {
                        Object object2;
                        Object object3;
                        Object object4 = object3 = bl ? this.getModelInfo().getActions().get(intArrayList4.getInt(j)) : object;
                        if (this.getModelInfo().getModelType().intervals()) {
                            object2 = new Interval(list.get(2 * k), list.get(2 * k + 1));
                            mDPTransitionConsumer.accept(i, n5, intArrayList3.getInt(k), object2, object3);
                            continue;
                        }
                        object2 = list.get(k);
                        mDPTransitionConsumer.accept(i, n5, intArrayList3.getInt(k), object2, object3);
                    }
                    ++n5;
                }
            }
        }
        catch (UMBException uMBException) {
            throw new PrismException("UMB import problem: " + uMBException.getMessage());
        }
    }

    @Override
    public void extractLTSTransitions(IOUtils.LTSTransitionConsumer lTSTransitionConsumer) throws PrismException {
        try {
            IntArrayList intArrayList = new IntArrayList(this.numStates + 1);
            this.umbReader.extractStateChoiceOffsets(arg_0 -> UMBImporter.lambda$extractLTSTransitions$9((IntList)intArrayList, arg_0));
            IntArrayList intArrayList2 = new IntArrayList(this.numTransitions);
            this.umbReader.extractBranchTargets(arg_0 -> UMBImporter.lambda$extractLTSTransitions$10((IntList)intArrayList2, arg_0));
            Object object = this.getModelInfo().getActions().get(0);
            IntArrayList intArrayList3 = null;
            boolean bl = this.umbReader.hasChoiceActionIndices();
            if (bl) {
                intArrayList3 = new IntArrayList(this.numChoices);
                this.umbReader.extractChoiceActionIndices(arg_0 -> ((IntList)intArrayList3).add(arg_0));
            }
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.numStates; ++i) {
                n = n2;
                n2 = intArrayList.getInt(i + 1);
                int n3 = 0;
                for (int j = n; j < n2; ++j) {
                    Object object2 = bl ? this.getModelInfo().getActions().get(intArrayList3.getInt(j)) : object;
                    lTSTransitionConsumer.accept(i, n3, intArrayList2.getInt(j), object2);
                    ++n3;
                }
            }
        }
        catch (UMBException uMBException) {
            throw new PrismException("UMB import problem: " + uMBException.getMessage());
        }
    }

    @Override
    public void extractLabelsAndInitialStates(BiConsumer<Integer, Integer> biConsumer, Consumer<Integer> consumer, Consumer<Integer> consumer2) throws PrismException {
        try {
            this.umbReader.extractInitialStates(l -> consumer.accept(SafeCast.toIntExact(l)));
            int n = this.labelIDs.size();
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.umbReader.extractStateAP(this.labelIDs.get(i), l -> biConsumer.accept(SafeCast.toIntExact(l), n2));
            }
            if (consumer2 != null) {
                String string = null;
                if (this.umbIndex.hasAPAnnotationWithAlias("deadlock")) {
                    string = this.umbIndex.getAPAnnotationByAlias((String)"deadlock").id;
                } else if (this.umbIndex.getAPAnnotations().get("deadlock") != null) {
                    string = "deadlock";
                }
                if (string != null) {
                    this.umbReader.extractStateAP(string, l -> consumer2.accept(SafeCast.toIntExact(l)));
                }
            }
        }
        catch (UMBException uMBException) {
            throw new PrismException("UMB import problem: " + uMBException.getMessage());
        }
    }

    @Override
    public void extractObservations(IOUtils.StateIntConsumer stateIntConsumer) throws PrismException {
        try {
            IntArrayList intArrayList = new IntArrayList(this.numStates);
            this.umbReader.extractStateObservations(arg_0 -> UMBImporter.lambda$extractObservations$14((IntList)intArrayList, arg_0));
            for (int i = 0; i < this.numStates; ++i) {
                stateIntConsumer.accept(i, intArrayList.getInt(i));
            }
        }
        catch (UMBException uMBException) {
            throw new PrismException("UMB import problem: " + uMBException.getMessage());
        }
    }

    @Override
    public <Value> void extractStateRewards(int n, BiConsumer<Integer, Value> biConsumer, Evaluator<Value> evaluator) throws PrismException {
        try {
            if (!this.basicRewardInfo.rewardStructHasStateRewards(n)) {
                return;
            }
            this.umbReader.extractStateRewards(n, ModelAccess.primitivesToValues(evaluator, new IndexedConsumer<Value>(biConsumer)));
        }
        catch (UMBException uMBException) {
            throw new PrismException("UMB import problem: " + uMBException.getMessage());
        }
    }

    @Override
    public <Value> void extractMCTransitionRewards(int n, IOUtils.TransitionRewardConsumer<Value> transitionRewardConsumer, Evaluator<Value> evaluator) throws PrismException {
        if (!this.basicRewardInfo.rewardStructHasTransitionRewards(n)) {
            return;
        }
        try {
            ModelAccess.ValueListFromPrimitives<Value> valueListFromPrimitives = new ModelAccess.ValueListFromPrimitives<Value>(evaluator, this.numTransitions);
            List list = valueListFromPrimitives.valueList;
            this.umbReader.extractBranchRewards(n, valueListFromPrimitives.primitiveConsumer);
            if (this.modelLookup != null) {
                ModelAccess modelAccess = ModelAccess.wrap(this.modelLookup);
                int n2 = 0;
                int n3 = 0;
                for (int i = 0; i < this.numStates; ++i) {
                    n2 = n3;
                    n3 = n2 + modelAccess.getNumTransitions(i, 0);
                    block11: for (int j = n2; j < n3; ++j) {
                        Object Value2 = list.get(j);
                        if (!evaluator.gt(Value2, evaluator.zero())) continue;
                        switch (this.transitionRewardIndexing) {
                            case STATE: {
                                transitionRewardConsumer.accept(i, modelAccess.getTransitionSuccessor(i, 0, j - n2), Value2);
                                continue block11;
                            }
                            case OFFSET: {
                                transitionRewardConsumer.accept(i, j - n2, Value2);
                                continue block11;
                            }
                            default: {
                                throw new PrismException("Unknown transition reward indexing " + String.valueOf((Object)this.transitionRewardIndexing));
                            }
                        }
                    }
                }
            } else {
                IntArrayList intArrayList;
                IntArrayList intArrayList2 = new IntArrayList(this.numStates + 1);
                this.umbReader.extractChoiceBranchOffsets(arg_0 -> UMBImporter.lambda$extractMCTransitionRewards$15((IntList)intArrayList2, arg_0));
                if (this.transitionRewardIndexing == ExplicitModelImporter.TransitionRewardIndexing.STATE) {
                    intArrayList = new IntArrayList(this.numTransitions);
                    this.umbReader.extractBranchTargets(arg_0 -> UMBImporter.lambda$extractMCTransitionRewards$16((IntList)intArrayList, arg_0));
                } else {
                    intArrayList = null;
                }
                int n4 = 0;
                int n5 = 0;
                for (int i = 0; i < this.numStates; ++i) {
                    n4 = n5;
                    n5 = intArrayList2.getInt(i + 1);
                    block13: for (int j = n4; j < n5; ++j) {
                        Object Value3 = list.get(j);
                        if (!evaluator.gt(Value3, evaluator.zero())) continue;
                        switch (this.transitionRewardIndexing) {
                            case STATE: {
                                transitionRewardConsumer.accept(i, intArrayList.getInt(j), Value3);
                                continue block13;
                            }
                            case OFFSET: {
                                transitionRewardConsumer.accept(i, j - n4, Value3);
                                continue block13;
                            }
                            default: {
                                throw new PrismException("Unknown transition reward indexing " + String.valueOf((Object)this.transitionRewardIndexing));
                            }
                        }
                    }
                }
            }
        }
        catch (UMBException uMBException) {
            throw new PrismException("UMB import problem: " + uMBException.getMessage());
        }
    }

    @Override
    public <Value> void extractMDPTransitionRewards(int n, IOUtils.TransitionRewardConsumer<Value> transitionRewardConsumer, Evaluator<Value> evaluator) throws PrismException {
        if (!this.basicRewardInfo.rewardStructHasTransitionRewards(n)) {
            return;
        }
        try {
            IntArrayList intArrayList;
            ModelAccess.ValueListFromPrimitives<Value> valueListFromPrimitives = new ModelAccess.ValueListFromPrimitives<Value>(evaluator, this.numChoices);
            List list = valueListFromPrimitives.valueList;
            this.umbReader.extractChoiceRewards(n, valueListFromPrimitives.primitiveConsumer);
            ModelAccess modelAccess = null;
            if (this.modelLookup != null) {
                intArrayList = null;
                modelAccess = ModelAccess.wrap(this.modelLookup);
            } else {
                intArrayList = new IntArrayList(this.numStates + 1);
                this.umbReader.extractStateChoiceOffsets(arg_0 -> UMBImporter.lambda$extractMDPTransitionRewards$17((IntList)intArrayList, arg_0));
            }
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < this.numStates; ++i) {
                n2 = n3;
                n3 = this.modelLookup != null ? n2 + modelAccess.getNumChoices(i) : intArrayList.getInt(i + 1);
                for (int j = n2; j < n3; ++j) {
                    Object Value2 = list.get(j);
                    if (!evaluator.gt(Value2, evaluator.zero())) continue;
                    transitionRewardConsumer.accept(i, j - n2, Value2);
                }
            }
        }
        catch (UMBException uMBException) {
            throw new PrismException("UMB import problem: " + uMBException.getMessage());
        }
    }

    private static /* synthetic */ void lambda$extractMDPTransitionRewards$17(IntList intList, long l) {
        intList.add((int)l);
    }

    private static /* synthetic */ void lambda$extractMCTransitionRewards$16(IntList intList, long l) {
        intList.add((int)l);
    }

    private static /* synthetic */ void lambda$extractMCTransitionRewards$15(IntList intList, long l) {
        intList.add((int)l);
    }

    private static /* synthetic */ void lambda$extractObservations$14(IntList intList, long l) {
        intList.add((int)l);
    }

    private static /* synthetic */ void lambda$extractLTSTransitions$10(IntList intList, long l) {
        intList.add((int)l);
    }

    private static /* synthetic */ void lambda$extractLTSTransitions$9(IntList intList, long l) {
        intList.add((int)l);
    }

    private static /* synthetic */ void lambda$extractMDPTransitions$8(IntList intList, long l) {
        intList.add((int)l);
    }

    private static /* synthetic */ void lambda$extractMDPTransitions$7(IntList intList, long l) {
        intList.add((int)l);
    }

    private static /* synthetic */ void lambda$extractMDPTransitions$6(IntList intList, long l) {
        intList.add((int)l);
    }

    private static /* synthetic */ void lambda$extractMCTransitions$5(IntList intList, long l) {
        intList.add((int)l);
    }

    private static /* synthetic */ void lambda$extractMCTransitions$4(IntList intList, long l) {
        intList.add((int)l);
    }

    private static class IndexedConsumer<Value>
    implements Consumer<Value> {
        BiConsumer<Integer, Value> out;
        int index;

        IndexedConsumer(BiConsumer<Integer, Value> biConsumer) {
            this.out = biConsumer;
        }

        @Override
        public void accept(Value Value2) {
            this.out.accept(this.index++, Value2);
        }
    }

    private static class IndexedDoubleConsumer
    implements DoubleConsumer {
        BiConsumer<Integer, Double> out;
        int index;

        IndexedDoubleConsumer(BiConsumer<Integer, Double> biConsumer) {
            this.out = biConsumer;
        }

        @Override
        public void accept(double d) {
            this.out.accept(this.index++, d);
        }
    }

    private static class LongConsumerToIntConsumer
    implements LongConsumer {
        IntConsumer out;

        LongConsumerToIntConsumer(IntConsumer intConsumer) {
            this.out = intConsumer;
        }

        @Override
        public void accept(long l) {
            this.out.accept(SafeCast.toIntExact(l));
        }
    }
}

