/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.MultiParameters;
import explicit.Pareto;
import explicit.rewards.Rewards;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.fraction.BigFraction;
import parma_polyhedra_library.C_Polyhedron;
import parma_polyhedra_library.Coefficient;
import parma_polyhedra_library.Constraint;
import parma_polyhedra_library.Constraint_System;
import parma_polyhedra_library.Generator;
import parma_polyhedra_library.Generator_System;
import parma_polyhedra_library.Generator_Type;
import parma_polyhedra_library.Linear_Expression;
import parma_polyhedra_library.Linear_Expression_Coefficient;
import parma_polyhedra_library.Linear_Expression_Difference;
import parma_polyhedra_library.Linear_Expression_Sum;
import parma_polyhedra_library.Linear_Expression_Times;
import parma_polyhedra_library.Linear_Expression_Unary_Minus;
import parma_polyhedra_library.Linear_Expression_Variable;
import parma_polyhedra_library.Parma_Polyhedra_Library;
import parma_polyhedra_library.Polyhedron;
import parma_polyhedra_library.Relation_Symbol;
import parma_polyhedra_library.Variable;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismUtils;

public class PPLSupport {
    public static void initPPL() throws PrismException {
        try {
            System.loadLibrary("ppl_java");
            Parma_Polyhedra_Library.initialize_library();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("\nError loading Parma Polyhedra Library:");
            System.err.println(unsatisfiedLinkError);
            throw new PrismException("Parma Polyhedra Library could not be loaded/initialised");
        }
        catch (Exception exception) {
            System.err.println("\nError loading Parma Polyhedra Library:");
            System.err.println(exception);
            throw new PrismException("Parma Polyhedra Library could not be loaded/initialised");
        }
    }

    public static List<Double> getGeneratorAsVector(Generator generator, int n) throws PrismException {
        BigInteger bigInteger = generator.divisor().getBigInteger();
        HashMap<Variable, BigInteger> hashMap = new HashMap<Variable, BigInteger>();
        PPLSupport.getCoefficientsFromLinearExpression(generator.linear_expression(), false, BigInteger.ONE, hashMap);
        ArrayList<Double> arrayList = new ArrayList<Double>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(0.0);
        }
        for (Variable variable : hashMap.keySet()) {
            if (variable == null) continue;
            BigFraction bigFraction = new BigFraction((BigInteger)hashMap.get(variable), bigInteger);
            arrayList.set((int)variable.id(), bigFraction.doubleValue());
        }
        return arrayList;
    }

    public static Generator generatorFromPoint(double[] dArray) throws PrismException {
        int n = dArray.length;
        if (n == 0) {
            throw new PrismException("Generator cannot have zero dimensions.");
        }
        Linear_Expression_Times linear_Expression_Times = null;
        BigInteger bigInteger = BigInteger.ONE;
        for (int i = 0; i < n; ++i) {
            BigFraction bigFraction = new BigFraction(dArray[i]);
            BigInteger bigInteger2 = bigFraction.getNumerator();
            BigInteger bigInteger3 = bigFraction.getDenominator();
            if (linear_Expression_Times == null) {
                linear_Expression_Times = new Linear_Expression_Times(new Coefficient(bigInteger2), new Variable((long)i));
                bigInteger = bigInteger3;
                continue;
            }
            Linear_Expression_Times linear_Expression_Times2 = new Linear_Expression_Times(new Coefficient(bigInteger2.multiply(bigInteger)), new Variable((long)i));
            if (bigInteger3.compareTo(BigInteger.ONE) == 0) {
                linear_Expression_Times = new Linear_Expression_Sum((Linear_Expression)linear_Expression_Times, (Linear_Expression)linear_Expression_Times2);
                continue;
            }
            linear_Expression_Times = new Linear_Expression_Sum(linear_Expression_Times.times(new Coefficient(bigInteger3)), (Linear_Expression)linear_Expression_Times2);
            bigInteger = bigInteger.multiply(bigInteger3);
        }
        return Generator.point(linear_Expression_Times, (Coefficient)new Coefficient(bigInteger));
    }

    public static Map<Integer, BigInteger> getCoefficients(Linear_Expression linear_Expression) {
        HashMap<Variable, BigInteger> hashMap = new HashMap<Variable, BigInteger>();
        PPLSupport.getCoefficientsFromLinearExpression(linear_Expression, false, BigInteger.ONE, hashMap);
        HashMap<Integer, BigInteger> hashMap2 = new HashMap<Integer, BigInteger>();
        for (Variable variable : hashMap.keySet()) {
            if (variable == null) continue;
            hashMap2.put((int)variable.id(), (BigInteger)hashMap.get(variable));
        }
        return hashMap2;
    }

    public static void getCoefficientsFromLinearExpression(Linear_Expression linear_Expression, boolean bl, BigInteger bigInteger, Map<Variable, BigInteger> map) {
        if (linear_Expression instanceof Linear_Expression_Coefficient) {
            if (map.containsKey(null)) {
                map.put(null, bl ? map.get(null).multiply(((Linear_Expression_Coefficient)linear_Expression).argument().getBigInteger().multiply(bigInteger).negate()) : map.get(null).multiply(((Linear_Expression_Coefficient)linear_Expression).argument().getBigInteger().multiply(bigInteger)));
            } else {
                map.put(null, bl ? ((Linear_Expression_Coefficient)linear_Expression).argument().getBigInteger().multiply(bigInteger).negate() : ((Linear_Expression_Coefficient)linear_Expression).argument().getBigInteger().multiply(bigInteger));
            }
        } else if (linear_Expression instanceof Linear_Expression_Difference) {
            PPLSupport.getCoefficientsFromLinearExpression(((Linear_Expression_Difference)linear_Expression).left_hand_side(), bl, bigInteger, map);
            PPLSupport.getCoefficientsFromLinearExpression(((Linear_Expression_Difference)linear_Expression).right_hand_side(), !bl, bigInteger, map);
        } else if (linear_Expression instanceof Linear_Expression_Sum) {
            PPLSupport.getCoefficientsFromLinearExpression(((Linear_Expression_Sum)linear_Expression).left_hand_side(), bl, bigInteger, map);
            PPLSupport.getCoefficientsFromLinearExpression(((Linear_Expression_Sum)linear_Expression).right_hand_side(), bl, bigInteger, map);
        } else if (linear_Expression instanceof Linear_Expression_Times) {
            PPLSupport.getCoefficientsFromLinearExpression(((Linear_Expression_Times)linear_Expression).linear_expression(), bl, bigInteger.multiply(((Linear_Expression_Times)linear_Expression).coefficient().getBigInteger()), map);
        } else if (linear_Expression instanceof Linear_Expression_Unary_Minus) {
            PPLSupport.getCoefficientsFromLinearExpression(((Linear_Expression_Unary_Minus)linear_Expression).argument(), !bl, bigInteger, map);
        } else if (linear_Expression instanceof Linear_Expression_Variable) {
            if (map.containsKey(((Linear_Expression_Variable)linear_Expression).argument())) {
                map.put(((Linear_Expression_Variable)linear_Expression).argument(), bl ? map.get(((Linear_Expression_Variable)linear_Expression).argument()).multiply(bigInteger).negate() : map.get(((Linear_Expression_Variable)linear_Expression).argument()).multiply(bigInteger));
            } else {
                map.put(((Linear_Expression_Variable)linear_Expression).argument(), bl ? bigInteger.negate() : bigInteger);
            }
        }
    }

    public static Map.Entry<double[], double[][]> getConstraintSystem(Constraint_System constraint_System, int n) throws PrismException {
        int n2 = constraint_System.size();
        double[][] dArray = new double[n2][n];
        double[] dArray2 = new double[n2];
        int n3 = 0;
        for (Constraint constraint : constraint_System) {
            HashMap<Variable, BigInteger> hashMap = new HashMap<Variable, BigInteger>();
            PPLSupport.getCoefficientsFromLinearExpression(constraint.left_hand_side(), false, BigInteger.ONE, hashMap);
            HashMap<Variable, BigInteger> hashMap2 = new HashMap<Variable, BigInteger>();
            PPLSupport.getCoefficientsFromLinearExpression(constraint.right_hand_side(), false, BigInteger.ONE, hashMap2);
            switch (constraint.kind()) {
                case EQUAL: {
                    throw new PrismException("Equality constraints not supported");
                }
                case LESS_THAN: 
                case LESS_OR_EQUAL: {
                    for (Map.Entry entry : hashMap.entrySet()) {
                        if (entry.getKey() != null) {
                            double[] dArray3 = dArray[n3];
                            int n4 = (int)((Variable)entry.getKey()).id();
                            dArray3[n4] = dArray3[n4] + ((BigInteger)entry.getValue()).doubleValue();
                            continue;
                        }
                        int n5 = n3;
                        dArray2[n5] = dArray2[n5] - ((BigInteger)entry.getValue()).doubleValue();
                    }
                    for (Map.Entry entry : hashMap2.entrySet()) {
                        if (entry.getKey() != null) {
                            double[] dArray4 = dArray[n3];
                            int n6 = (int)((Variable)entry.getKey()).id();
                            dArray4[n6] = dArray4[n6] - ((BigInteger)entry.getValue()).doubleValue();
                            continue;
                        }
                        int n7 = n3;
                        dArray2[n7] = dArray2[n7] + ((BigInteger)entry.getValue()).doubleValue();
                    }
                    break;
                }
                case GREATER_THAN: 
                case GREATER_OR_EQUAL: {
                    for (Map.Entry entry : hashMap.entrySet()) {
                        if (entry.getKey() != null) {
                            double[] dArray5 = dArray[n3];
                            int n8 = (int)((Variable)entry.getKey()).id();
                            dArray5[n8] = dArray5[n8] - ((BigInteger)entry.getValue()).doubleValue();
                            continue;
                        }
                        int n9 = n3;
                        dArray2[n9] = dArray2[n9] + ((BigInteger)entry.getValue()).doubleValue();
                    }
                    for (Map.Entry entry : hashMap2.entrySet()) {
                        if (entry.getKey() != null) {
                            double[] dArray6 = dArray[n3];
                            int n10 = (int)((Variable)entry.getKey()).id();
                            dArray6[n10] = dArray6[n10] + ((BigInteger)entry.getValue()).doubleValue();
                            continue;
                        }
                        int n11 = n3;
                        dArray2[n11] = dArray2[n11] - ((BigInteger)entry.getValue()).doubleValue();
                    }
                    break;
                }
                default: {
                    throw new PrismException("Unexpected relation symbol");
                }
            }
            ++n3;
        }
        return new AbstractMap.SimpleEntry<double[], double[][]>(dArray2, dArray);
    }

    public static boolean checkBound(Pareto pareto, double[] dArray, MultiParameters multiParameters) {
        for (Polyhedron polyhedron : pareto.getSets()) {
            if (!PPLSupport.checkBound(polyhedron, dArray, multiParameters)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkBound(Pareto pareto, List<Double> list, MultiParameters multiParameters) {
        for (Polyhedron polyhedron : pareto.getSets()) {
            if (!PPLSupport.checkBound(polyhedron, list, multiParameters)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkBound(Polyhedron polyhedron, double[] dArray, MultiParameters multiParameters) {
        BigFraction bigFraction;
        if (polyhedron.is_empty()) {
            return false;
        }
        Linear_Expression_Times linear_Expression_Times = null;
        BigInteger bigInteger = null;
        for (int i = 0; i < dArray.length; ++i) {
            bigFraction = new BigFraction(dArray[i]);
            BigInteger bigInteger2 = bigFraction.getNumerator();
            BigInteger bigInteger3 = bigFraction.getDenominator();
            if (linear_Expression_Times == null) {
                linear_Expression_Times = new Linear_Expression_Times(new Coefficient(bigInteger2), new Variable((long)i));
                bigInteger = bigInteger3;
                continue;
            }
            linear_Expression_Times = new Linear_Expression_Sum(linear_Expression_Times.times(new Coefficient(bigInteger3)), (Linear_Expression)new Linear_Expression_Times(new Coefficient(bigInteger2.multiply(bigInteger)), new Variable((long)i)));
            bigInteger = bigInteger3.multiply(bigInteger);
        }
        Generator generator = Generator.point(linear_Expression_Times, (Coefficient)new Coefficient(bigInteger));
        bigFraction = new Generator_System();
        bigFraction.add((Object)generator);
        return polyhedron.contains((Polyhedron)new C_Polyhedron((Generator_System)bigFraction));
    }

    public static boolean checkBound(Polyhedron polyhedron, List<Double> list, MultiParameters multiParameters) {
        BigFraction bigFraction;
        if (polyhedron.is_empty()) {
            return false;
        }
        Linear_Expression_Times linear_Expression_Times = null;
        BigInteger bigInteger = null;
        for (int i = 0; i < list.size(); ++i) {
            bigFraction = new BigFraction(list.get(i).doubleValue());
            BigInteger bigInteger2 = bigFraction.getNumerator();
            BigInteger bigInteger3 = bigFraction.getDenominator();
            if (linear_Expression_Times == null) {
                linear_Expression_Times = new Linear_Expression_Times(new Coefficient(bigInteger2), new Variable((long)i));
                bigInteger = bigInteger3;
                continue;
            }
            linear_Expression_Times = new Linear_Expression_Sum(linear_Expression_Times.times(new Coefficient(bigInteger3)), (Linear_Expression)new Linear_Expression_Times(new Coefficient(bigInteger2.multiply(bigInteger)), new Variable((long)i)));
            bigInteger = bigInteger3.multiply(bigInteger);
        }
        Generator generator = Generator.point(linear_Expression_Times, (Coefficient)new Coefficient(bigInteger));
        bigFraction = new Generator_System();
        bigFraction.add((Object)generator);
        return polyhedron.contains((Polyhedron)new C_Polyhedron((Generator_System)bigFraction));
    }

    public static BitSet checkBounds(Pareto[] paretoArray, List<Double> list, MultiParameters multiParameters) {
        BitSet bitSet = new BitSet(paretoArray.length);
        for (int i = 0; i < paretoArray.length; ++i) {
            bitSet.set(i, PPLSupport.checkBound(paretoArray[i], list, multiParameters));
        }
        return bitSet;
    }

    public static BitSet checkBounds(Pareto[] paretoArray, List<Double> list, Map<Integer, Integer> map, MultiParameters multiParameters) {
        BitSet bitSet = new BitSet(map.size());
        for (int i = 0; i < map.size(); ++i) {
            bitSet.set(i, PPLSupport.checkBound(paretoArray[map.get(i)], list, multiParameters));
        }
        return bitSet;
    }

    public static void printReachabilityPolyhedron(Pareto[] paretoArray, int n, int n2, PrismLog prismLog) throws PrismException {
        if (paretoArray == null || paretoArray.length == 0) {
            return;
        }
        int n3 = 0;
        for (int i = 0; i < paretoArray.length; ++i) {
            Pareto pareto = paretoArray[i];
            if (pareto == null || pareto.size() <= 0) continue;
            for (int j = 0; j < pareto.size(); ++j) {
                int n4;
                if (pareto.get(j).is_empty() || (n4 = paretoArray[i].get(j).minimized_generators().size()) <= n3) continue;
                n3 = n4;
            }
        }
        Pareto pareto = paretoArray[n2];
        if (prismLog != null) {
            prismLog.print(String.format("maxcorners=%d. state %d:\n", n3, n2));
            if (pareto == null) {
                prismLog.print("[]\n");
            } else {
                if (pareto.size() > 1) {
                    prismLog.print("[\n");
                }
                for (int i = 0; i < pareto.size(); ++i) {
                    prismLog.print(String.format("%s\n", PPLSupport.reachabilityPolyhedronToString(pareto.get(i), n)));
                }
                if (pareto.size() > 1) {
                    prismLog.print("]\n");
                }
            }
            prismLog.flush();
        } else {
            System.out.printf("maxcorners=%d. state %d:\n", n3, n2);
            if (pareto == null) {
                System.out.printf("[]\n", new Object[0]);
            } else {
                if (pareto.size() > 1) {
                    System.out.printf("[\n", new Object[0]);
                }
                for (int i = 0; i < pareto.size(); ++i) {
                    System.out.printf("%s\n", PPLSupport.reachabilityPolyhedronToString(pareto.get(i), n));
                }
                if (pareto.size() > 1) {
                    System.out.printf("]\n", new Object[0]);
                }
            }
        }
    }

    public static void printReachabilityPolyhedra(Pareto[] paretoArray, List<Pareto>[] listArray, int n, PrismLog prismLog) throws PrismException {
        for (int i = 0; i < paretoArray.length; ++i) {
            prismLog.print(String.format("state=%d: ", i));
            prismLog.print(PPLSupport.reachabilityPolyhedronToString(paretoArray[i].get(), n) + "\n");
            if (listArray == null || listArray[i] == null) continue;
            for (int j = 0; j < listArray[i].size(); ++j) {
                prismLog.print(String.format("    -> %d:" + PPLSupport.reachabilityPolyhedronToString(listArray[i].get(j).get(), n) + "\n", j));
            }
        }
    }

    public static String reachabilityPolyhedronToString(Polyhedron polyhedron, int n) throws PrismException {
        if (polyhedron == null) {
            return "[]";
        }
        Object object = String.format("[", new Object[0]);
        for (Generator generator : polyhedron.minimized_generators()) {
            if (generator.type() == Generator_Type.RAY) {
                object = (String)object + "r:";
            } else if (generator.type() == Generator_Type.LINE) {
                object = (String)object + "l:";
            }
            object = (String)object + "[";
            BigInteger bigInteger = null;
            HashMap<Variable, BigInteger> hashMap = new HashMap<Variable, BigInteger>();
            PPLSupport.getCoefficientsFromLinearExpression(generator.linear_expression(), false, BigInteger.ONE, hashMap);
            if (generator.type() == Generator_Type.RAY | generator.type() == Generator_Type.LINE) {
                bigInteger = BigInteger.ONE;
                for (Variable variable : hashMap.keySet()) {
                    if (!(variable != null & bigInteger.compareTo(((BigInteger)hashMap.get(variable)).abs()) < 0)) continue;
                    bigInteger = ((BigInteger)hashMap.get(variable)).abs();
                }
            } else {
                bigInteger = generator.divisor().getBigInteger();
            }
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                if (!bl) {
                    object = (String)object + ", ";
                }
                bl = false;
                boolean bl2 = false;
                for (Variable variable : hashMap.keySet()) {
                    if (variable == null || (long)i != variable.id()) continue;
                    BigFraction bigFraction = new BigFraction((BigInteger)hashMap.get(variable), bigInteger);
                    object = (String)object + String.format("%.4f", bigFraction.doubleValue());
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                object = (String)object + String.format("%.4f", 0.0);
            }
            object = (String)object + "]";
        }
        object = (String)object + "]";
        return object;
    }

    public static void printMatlab(Map<Integer, Polyhedron> map, long l, int n) {
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < map.size(); ++n3) {
            n2 = map.get(n3).minimized_generators().size();
            if (n2 <= n4) continue;
            n4 = n2;
        }
        System.out.printf("maxpoints{%d} = %d;\n", n + 1, (long)n4 - l);
        for (n3 = 0; n3 < map.size(); ++n3) {
            System.out.printf("m{%d, %d} = [", n + 1, n3 + 1);
            n2 = 1;
            for (Generator generator : map.get(n3).generators()) {
                if (generator.type() == Generator_Type.RAY | generator.type() == Generator_Type.LINE) continue;
                if (n2 == 0) {
                    System.out.printf(" ; ", new Object[0]);
                }
                n2 = 0;
                BigInteger bigInteger = generator.divisor().getBigInteger();
                HashMap<Variable, BigInteger> hashMap = new HashMap<Variable, BigInteger>();
                PPLSupport.getCoefficientsFromLinearExpression(generator.linear_expression(), false, BigInteger.ONE, hashMap);
                boolean bl = true;
                int n5 = 0;
                while ((long)n5 < l) {
                    if (!bl) {
                        System.out.printf(", ", new Object[0]);
                    }
                    bl = false;
                    boolean bl2 = false;
                    for (Variable variable : hashMap.keySet()) {
                        if (variable == null || (long)n5 != variable.id()) continue;
                        BigFraction bigFraction = new BigFraction((BigInteger)hashMap.get(variable), bigInteger);
                        System.out.printf("%.4f", bigFraction.doubleValue());
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        System.out.printf("%.4f", 0.0);
                    }
                    ++n5;
                }
            }
            System.out.printf("];\n", new Object[0]);
        }
    }

    public static void discountPareto(Pareto[] paretoArray, double[] dArray) throws PrismException {
        for (int i = 0; i < dArray.length; ++i) {
            if (!(Math.abs(dArray[i] - 1.0) >= PrismUtils.epsilonDouble)) continue;
            Variable variable = new Variable((long)i);
            BigFraction bigFraction = new BigFraction(dArray[i]);
            Linear_Expression_Times linear_Expression_Times = new Linear_Expression_Times(new Coefficient(bigFraction.getNumerator()), variable);
            Coefficient coefficient = new Coefficient(bigFraction.getDenominator());
            for (int j = 0; j < paretoArray.length; ++j) {
                paretoArray[j].get().affine_image(variable, (Linear_Expression)linear_Expression_Times, coefficient);
            }
        }
    }

    public static void discountPareto(List<Pareto>[] listArray, double[] dArray) throws PrismException {
        if (listArray == null) {
            return;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (!(Math.abs(dArray[i] - 1.0) >= PrismUtils.epsilonDouble)) continue;
            Variable variable = new Variable((long)i);
            BigFraction bigFraction = new BigFraction(dArray[i]);
            Linear_Expression_Times linear_Expression_Times = new Linear_Expression_Times(new Coefficient(bigFraction.getNumerator()), variable);
            Coefficient coefficient = new Coefficient(bigFraction.getDenominator());
            for (int j = 0; j < listArray.length; ++j) {
                for (Pareto pareto : listArray[j]) {
                    pareto.get().affine_image(variable, (Linear_Expression)linear_Expression_Times, coefficient);
                }
            }
        }
    }

    public static Polyhedron add_rewards(Polyhedron polyhedron, int n, int n2, List<Rewards<Double>> list, double[] dArray) {
        BigInteger bigInteger;
        BigFraction bigFraction;
        Linear_Expression_Times linear_Expression_Times;
        int n3 = list != null ? list.size() : dArray.length;
        boolean bl = true;
        Iterator<Rewards<Double>> iterator = list != null ? list.iterator() : null;
        for (int i = 0; i < n3; ++i) {
            double d;
            Linear_Expression_Times linear_Expression_Times2 = linear_Expression_Times = iterator != null ? iterator.next() : null;
            if (n2 < 0) {
                d = (linear_Expression_Times == null ? 0.0 : linear_Expression_Times.getStateReward(n)) + (dArray == null ? 0.0 : dArray[i]);
                if (PrismUtils.doublesAreEqual(d, 0.0)) continue;
                bl = false;
                break;
            }
            d = (linear_Expression_Times == null ? 0.0 : linear_Expression_Times.getTransitionReward(n, n2)) + (dArray == null ? 0.0 : dArray[i]);
            if (PrismUtils.doublesAreEqual(d, 0.0)) continue;
            bl = false;
            break;
        }
        if (bl) {
            return polyhedron;
        }
        Generator_System generator_System = new Generator_System();
        linear_Expression_Times = null;
        Coefficient coefficient = new Coefficient(BigInteger.ONE);
        iterator = list != null ? list.iterator() : null;
        for (int i = 0; i < n3; ++i) {
            double d;
            Generator generator;
            Generator generator2 = generator = iterator != null ? iterator.next() : null;
            if (n2 < 0) {
                d = (generator == null ? 0.0 : generator.getStateReward(n)) + (dArray == null ? 0.0 : dArray[i]);
                bigFraction = new BigFraction(d);
            } else {
                d = (generator == null ? 0.0 : (Double)generator.getTransitionReward(n, n2)) + (dArray == null ? 0.0 : dArray[i]);
                bigFraction = new BigFraction(d);
            }
            bigInteger = bigFraction.getNumerator();
            BigInteger bigInteger2 = bigFraction.getDenominator();
            if (linear_Expression_Times == null) {
                linear_Expression_Times = new Linear_Expression_Times(new Coefficient(bigInteger), new Variable((long)i));
                coefficient = new Coefficient(bigInteger2);
                continue;
            }
            linear_Expression_Times = new Linear_Expression_Sum(linear_Expression_Times.times(new Coefficient(bigInteger2)), (Linear_Expression)new Linear_Expression_Times(new Coefficient(bigInteger.multiply(coefficient.getBigInteger())), new Variable((long)i)));
            coefficient = new Coefficient(bigInteger2.multiply(coefficient.getBigInteger()));
        }
        for (Generator generator : polyhedron.generators()) {
            if (generator.type() == Generator_Type.POINT) {
                bigFraction = new Linear_Expression_Sum(linear_Expression_Times.times(generator.divisor()), generator.linear_expression().times(coefficient));
                bigInteger = new Coefficient(generator.divisor().getBigInteger().multiply(coefficient.getBigInteger()));
                generator_System.add((Object)Generator.point((Linear_Expression)bigFraction, (Coefficient)bigInteger));
                continue;
            }
            generator_System.add((Object)generator);
        }
        return new C_Polyhedron(generator_System);
    }

    public static void cutPositive(Polyhedron polyhedron) {
        long l = polyhedron.space_dimension();
        int n = 0;
        while ((long)n < l) {
            Linear_Expression_Times linear_Expression_Times = new Linear_Expression_Times(new Coefficient(BigInteger.ONE), new Variable((long)n));
            Linear_Expression_Coefficient linear_Expression_Coefficient = new Linear_Expression_Coefficient(new Coefficient(BigInteger.ZERO));
            Constraint constraint = new Constraint((Linear_Expression)linear_Expression_Times, Relation_Symbol.LESS_OR_EQUAL, (Linear_Expression)linear_Expression_Coefficient);
            polyhedron.add_constraint(constraint);
            ++n;
        }
    }

    public static void cutBox(Polyhedron polyhedron, long l) throws PrismException {
        Linear_Expression_Times linear_Expression_Times;
        long l2 = polyhedron.space_dimension();
        int n = 0;
        while ((long)n < l2) {
            linear_Expression_Times = new Linear_Expression_Times(new Coefficient(BigInteger.ONE), new Variable((long)n));
            Linear_Expression_Coefficient linear_Expression_Coefficient = new Linear_Expression_Coefficient(new Coefficient(BigInteger.ZERO));
            Constraint constraint = new Constraint((Linear_Expression)linear_Expression_Times, Relation_Symbol.LESS_OR_EQUAL, (Linear_Expression)linear_Expression_Coefficient);
            polyhedron.add_constraint(constraint);
            Linear_Expression_Times linear_Expression_Times2 = new Linear_Expression_Times(new Coefficient(BigInteger.ONE), new Variable((long)n));
            Linear_Expression_Coefficient linear_Expression_Coefficient2 = new Linear_Expression_Coefficient(new Coefficient(BigInteger.valueOf(-l)));
            Constraint constraint2 = new Constraint((Linear_Expression)linear_Expression_Times2, Relation_Symbol.GREATER_OR_EQUAL, (Linear_Expression)linear_Expression_Coefficient2);
            polyhedron.add_constraint(constraint2);
            ++n;
        }
        if (!polyhedron.is_empty()) {
            n = 0;
            while ((long)n < l2) {
                linear_Expression_Times = new Linear_Expression_Times(new Coefficient(BigInteger.ONE.negate()), new Variable((long)n));
                polyhedron.add_generator(Generator.ray((Linear_Expression)linear_Expression_Times));
                ++n;
            }
        }
    }
}

