/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import acceptance.AcceptanceReach;
import acceptance.AcceptanceType;
import common.IntSet;
import common.IterableBitSet;
import common.IterableStateSet;
import common.StopWatch;
import common.iterable.FunctionalPrimitiveIterator;
import explicit.BasicModelTransformation;
import explicit.DTMCFromMDPMemorylessAdversary;
import explicit.DTMCModelChecker;
import explicit.DijkstraSweepMPI;
import explicit.ECComputer;
import explicit.ExportIterations;
import explicit.IterationMethod;
import explicit.IterationMethodGS;
import explicit.IterationMethodPower;
import explicit.LTLModelChecker;
import explicit.MDP;
import explicit.MDPSimple;
import explicit.MDPSparse;
import explicit.MinMax;
import explicit.Model;
import explicit.ModelCheckerResult;
import explicit.NondetModel;
import explicit.ProbModelChecker;
import explicit.SCCComputer;
import explicit.SCCInfo;
import explicit.StateModelChecker;
import explicit.StateValues;
import explicit.Utils;
import explicit.ZeroRewardECQuotient;
import explicit.modelviews.EquivalenceRelationInteger;
import explicit.modelviews.MDPDroppedAllChoices;
import explicit.modelviews.MDPEquiv;
import explicit.rewards.MCRewardsFromMDPRewards;
import explicit.rewards.MDPRewards;
import explicit.rewards.Rewards;
import io.ModelExportFormat;
import java.io.File;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import parser.ast.Expression;
import parser.type.TypeDouble;
import prism.AccuracyFactory;
import prism.OptionsIntervalIteration;
import prism.PrismComponent;
import prism.PrismDevNullLog;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.PrismUtils;
import strat.FMDStrategyProduct;
import strat.FMDStrategyStep;
import strat.MDStrategy;
import strat.MDStrategyArray;
import strat.Strategy;

public class MDPModelChecker
extends ProbModelChecker {
    public MDPModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    @Override
    protected StateValues checkProbPathFormulaLTL(Model<?> model, Expression expression, boolean bl, MinMax minMax, BitSet bitSet) throws PrismException {
        Object object2;
        BitSet bitSet2;
        if (minMax.isMin()) {
            expression = Expression.Not(Expression.Parenth(expression.deepCopy()));
        }
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this);
        AcceptanceType[] acceptanceTypeArray = new AcceptanceType[]{AcceptanceType.BUCHI, AcceptanceType.RABIN, AcceptanceType.GENERALIZED_RABIN, AcceptanceType.REACH};
        LTLModelChecker.LTLProduct<MDP> lTLProduct = lTLModelChecker.constructDAProductForLTLFormula(this, (MDP)model, expression, bitSet, acceptanceTypeArray);
        this.doProductExports(lTLProduct);
        if (lTLProduct.getAcceptance() instanceof AcceptanceReach) {
            this.mainLog.println("\nSkipping accepting MEC computation since acceptance is defined via goal states...");
            bitSet2 = ((AcceptanceReach)lTLProduct.getAcceptance()).getGoalStates();
        } else {
            this.mainLog.println("\nFinding accepting MECs...");
            bitSet2 = lTLModelChecker.findAcceptingECStates((NondetModel)lTLProduct.getProductModel(), lTLProduct.getAcceptance());
        }
        this.mainLog.println("\nComputing reachability probabilities...");
        MDPModelChecker mDPModelChecker = new MDPModelChecker(this);
        mDPModelChecker.inheritSettings(this);
        ModelCheckerResult modelCheckerResult = mDPModelChecker.computeReachProbs((MDP)lTLProduct.getProductModel(), bitSet2, false);
        StateValues stateValues = StateValues.createFromArrayResult(modelCheckerResult, lTLProduct.getProductModel());
        if (minMax.isMin()) {
            stateValues.applyFunction(TypeDouble.getInstance(), object -> 1.0 - (Double)object);
        }
        if (this.getExportProductVector()) {
            this.mainLog.println("\nExporting product solution vector matrix to file \"" + this.getExportProductVectorFilename() + "\"...");
            object2 = new PrismFileLog(this.getExportProductVectorFilename());
            stateValues.print((PrismLog)object2, false, false, false, false);
            ((PrismFileLog)object2).close();
        }
        if (modelCheckerResult.strat != null) {
            object2 = new FMDStrategyProduct(lTLProduct, (MDStrategy)modelCheckerResult.strat);
            this.result.setStrategy((Strategy<?>)object2);
        }
        object2 = lTLProduct.projectToOriginalModel(stateValues);
        stateValues.clear();
        return object2;
    }

    @Override
    protected StateValues checkRewardCoSafeLTL(Model<?> model, Rewards<?> rewards, Expression expression, MinMax minMax, BitSet bitSet) throws PrismException {
        Object object;
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this);
        LTLModelChecker.LTLProduct<MDP> lTLProduct = lTLModelChecker.constructDFAProductForCosafetyReward(this, (MDP)model, expression, bitSet);
        Rewards rewards2 = ((MDPRewards)rewards).liftFromModel(lTLProduct);
        this.doProductExports(lTLProduct);
        BitSet bitSet2 = ((AcceptanceReach)lTLProduct.getAcceptance()).getGoalStates();
        this.mainLog.println("\nComputing reachability rewards...");
        MDPModelChecker mDPModelChecker = new MDPModelChecker(this);
        mDPModelChecker.inheritSettings(this);
        ModelCheckerResult modelCheckerResult = mDPModelChecker.computeReachRewards((MDP)lTLProduct.getProductModel(), (MDPRewards<Double>)rewards2, bitSet2, minMax.isMin());
        StateValues stateValues = StateValues.createFromArrayResult(modelCheckerResult, lTLProduct.getProductModel());
        if (this.getExportProductVector()) {
            this.mainLog.println("\nExporting product solution vector matrix to file \"" + this.getExportProductVectorFilename() + "\"...");
            object = new PrismFileLog(this.getExportProductVectorFilename());
            stateValues.print((PrismLog)object, false, false, false, false);
            ((PrismFileLog)object).close();
        }
        if (modelCheckerResult.strat != null) {
            object = new FMDStrategyProduct(lTLProduct, (MDStrategy)modelCheckerResult.strat);
            this.result.setStrategy((Strategy<?>)object);
        }
        object = lTLProduct.projectToOriginalModel(stateValues);
        stateValues.clear();
        return object;
    }

    public ModelCheckerResult computeNextProbs(MDP<Double> mDP, BitSet bitSet, boolean bl) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        long l = System.currentTimeMillis();
        int n = mDP.getNumStates();
        double[] dArray = Utils.bitsetToDoubleArray(bitSet, n);
        double[] dArray2 = new double[n];
        int[] nArray = null;
        if (this.genStrat) {
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = bitSet.get(i) ? -2 : -1;
            }
        }
        mDP.mvMultMinMax(dArray, bl, dArray2, null, false, nArray);
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.accuracy = AccuracyFactory.boundedNumericalIterations();
        modelCheckerResult.soln = dArray2;
        modelCheckerResult.numIters = 1;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        if (this.genStrat) {
            modelCheckerResult.strat = new MDStrategyArray<Double>(mDP, nArray);
        }
        return modelCheckerResult;
    }

    public double[] computeRestrictedNext(MDP<Double> mDP, BitSet bitSet, double[] dArray, boolean bl) {
        int n = mDP.getNumStates();
        double[] dArray2 = new double[n];
        mDP.mvMultMinMax(dArray, bl, dArray2, bitSet, false, null);
        return dArray2;
    }

    public ModelCheckerResult computeReachProbs(MDP<Double> mDP, BitSet bitSet, boolean bl) throws PrismException {
        return this.computeReachProbs(mDP, null, bitSet, bl, null, null);
    }

    public ModelCheckerResult computeUntilProbs(MDP<Double> mDP, BitSet bitSet, BitSet bitSet2, boolean bl) throws PrismException {
        return this.computeReachProbs(mDP, bitSet, bitSet2, bl, null, null);
    }

    public ModelCheckerResult computeReachProbs(MDP<Double> mDP, BitSet bitSet, BitSet bitSet2, boolean bl, double[] dArray, BitSet bitSet3) throws PrismException {
        Object object;
        BitSet bitSet4;
        ModelCheckerResult modelCheckerResult = null;
        int[] nArray = null;
        ProbModelChecker.MDPSolnMethod mDPSolnMethod = this.mdpSolnMethod;
        boolean bl2 = this.doPmaxQuotient;
        if (mDPSolnMethod == ProbModelChecker.MDPSolnMethod.LINEAR_PROGRAMMING) {
            mDPSolnMethod = ProbModelChecker.MDPSolnMethod.GAUSS_SEIDEL;
            this.mainLog.printWarning("Switching to MDP solution method \"" + mDPSolnMethod.fullName() + "\"");
        }
        if (mDPSolnMethod == ProbModelChecker.MDPSolnMethod.VALUE_ITERATION && this.valIterDir == ProbModelChecker.ValIterDir.ABOVE) {
            if (!this.precomp || !this.prob0) {
                throw new PrismException("Precomputation (Prob0) must be enabled for value iteration from above");
            }
            if (!bl) {
                throw new PrismException("Value iteration from above only works for minimum probabilities");
            }
        }
        if (this.doIntervalIteration) {
            if (!bl && this.genStrat) {
                throw new PrismNotSupportedException("Currently, explicit engine does not support adversary construction for interval iteration and Pmax");
            }
            if (mDPSolnMethod != ProbModelChecker.MDPSolnMethod.VALUE_ITERATION && mDPSolnMethod != ProbModelChecker.MDPSolnMethod.GAUSS_SEIDEL) {
                throw new PrismNotSupportedException("Currently, explicit engine only supports interval iteration with value iteration or Gauss-Seidel for MDPs");
            }
            if (dArray != null) {
                throw new PrismNotSupportedException("Interval iteration currently not supported with provided initial values");
            }
            if (!(this.precomp && this.prob0 && this.prob1)) {
                throw new PrismNotSupportedException("Precomputations (Prob0 & Prob1) must be enabled for interval iteration");
            }
            if (!bl) {
                bl2 = true;
            }
        }
        if ((mDPSolnMethod == ProbModelChecker.MDPSolnMethod.POLICY_ITERATION || mDPSolnMethod == ProbModelChecker.MDPSolnMethod.MODIFIED_POLICY_ITERATION) && bitSet3 != null) {
            throw new PrismException("Policy iteration methods cannot be passed 'known' values for some states");
        }
        if (bl2 && bl) {
            bl2 = false;
        }
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("\nStarting probabilistic reachability (" + (bl ? "min" : "max") + ")...");
        }
        mDP.checkForDeadlocks(bitSet2);
        int n = mDP.getNumStates();
        if (dArray != null && bitSet3 != null && !bitSet3.isEmpty()) {
            bitSet4 = (BitSet)bitSet2.clone();
            object = new IterableBitSet(bitSet3).iterator();
            while (object.hasNext()) {
                int n2 = (Integer)object.next();
                if (dArray[n2] != 1.0) continue;
                bitSet4.set(n2);
            }
            bitSet2 = bitSet4;
        }
        if (this.getExportTarget()) {
            bitSet4 = new BitSet(n);
            for (int i = 0; i < n; ++i) {
                bitSet4.set(i, mDP.isInitialState(i));
            }
            object = Arrays.asList(bitSet4, bitSet2);
            List<String> list = Arrays.asList("init", "target");
            this.mainLog.println("\nExporting target states info to file \"" + this.getExportTargetFilename() + "\"...");
            this.exportLabels(mDP, list, (List<BitSet>)object, new File(this.getExportTargetFilename()), ModelExportFormat.EXPLICIT);
        }
        if (this.genStrat) {
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = bitSet2.get(i) ? -2 : -1;
            }
        }
        long l2 = System.currentTimeMillis();
        BitSet bitSet5 = this.precomp && this.prob0 ? this.prob0(mDP, bitSet, bitSet2, bl, nArray) : new BitSet();
        l2 = System.currentTimeMillis() - l2;
        long l3 = System.currentTimeMillis();
        BitSet bitSet6 = this.precomp && this.prob1 ? this.prob1(mDP, bitSet, bitSet2, bl, nArray) : (BitSet)bitSet2.clone();
        l3 = System.currentTimeMillis() - l3;
        int n3 = bitSet6.cardinality();
        int n4 = bitSet5.cardinality();
        if (this.verbosity >= 1) {
            this.mainLog.println("target=" + bitSet2.cardinality() + ", yes=" + n3 + ", no=" + n4 + ", maybe=" + (n - (n3 + n4)));
        }
        if (this.genStrat) {
            if (bl) {
                int n5 = bitSet6.nextSetBit(0);
                while (n5 >= 0) {
                    if (!bitSet2.get(n5)) {
                        nArray[n5] = -2;
                    }
                    n5 = bitSet6.nextSetBit(n5 + 1);
                }
            } else {
                int n6 = bitSet5.nextSetBit(0);
                while (n6 >= 0) {
                    nArray[n6] = -2;
                    n6 = bitSet5.nextSetBit(n6 + 1);
                }
            }
        }
        if (n3 + n4 < n) {
            if (!bl && bl2) {
                MDPEquiv<Double> mDPEquiv = this.maxQuotient(mDP, bitSet6, bitSet5);
                object = new BitSet();
                ((BitSet)object).set(mDPEquiv.mapStateToRestrictedModel(bitSet6.nextSetBit(0)));
                BitSet bitSet7 = new BitSet();
                bitSet7.set(mDPEquiv.mapStateToRestrictedModel(bitSet5.nextSetBit(0)));
                bitSet7.or(mDPEquiv.getNonRepresentativeStates());
                MDPSparse mDPSparse = new MDPSparse(mDPEquiv);
                ModelCheckerResult modelCheckerResult2 = this.computeReachProbsNumeric(mDPSparse, mDPSolnMethod, bitSet7, (BitSet)object, bl, dArray, bitSet3, nArray);
                modelCheckerResult = new ModelCheckerResult();
                modelCheckerResult.numIters = modelCheckerResult2.numIters;
                modelCheckerResult.timeTaken = modelCheckerResult2.timeTaken;
                modelCheckerResult.soln = new double[mDP.getNumStates()];
                for (int i = 0; i < n; ++i) {
                    modelCheckerResult.soln[i] = bitSet6.get(i) ? 1.0 : (bitSet5.get(i) ? 0.0 : modelCheckerResult2.soln[mDPEquiv.mapStateToRestrictedModel(i)]);
                }
                modelCheckerResult.accuracy = modelCheckerResult2.accuracy;
            } else {
                modelCheckerResult = this.computeReachProbsNumeric(mDP, mDPSolnMethod, bitSet5, bitSet6, bl, dArray, bitSet3, nArray);
            }
        } else {
            modelCheckerResult = new ModelCheckerResult();
            modelCheckerResult.soln = Utils.bitsetToDoubleArray(bitSet6, n);
            modelCheckerResult.accuracy = AccuracyFactory.doublesFromQualitative();
        }
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.println("Probabilistic reachability took " + (double)l / 1000.0 + " seconds.");
        }
        if (this.genStrat) {
            modelCheckerResult.strat = new MDStrategyArray<Double>(mDP, nArray);
        }
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timeProb0 = (double)l2 / 1000.0;
        modelCheckerResult.timePre = (double)(l2 + l3) / 1000.0;
        return modelCheckerResult;
    }

    protected ModelCheckerResult computeReachProbsNumeric(MDP<Double> mDP, ProbModelChecker.MDPSolnMethod mDPSolnMethod, BitSet bitSet, BitSet bitSet2, boolean bl, double[] dArray, BitSet bitSet3, int[] nArray) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        IterationMethod iterationMethod = null;
        switch (mDPSolnMethod) {
            case VALUE_ITERATION: {
                iterationMethod = new IterationMethodPower(this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, this.termCritParam);
                break;
            }
            case GAUSS_SEIDEL: {
                iterationMethod = new IterationMethodGS(this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, this.termCritParam, false);
                break;
            }
            case POLICY_ITERATION: {
                if (this.doIntervalIteration) {
                    throw new PrismNotSupportedException("Interval iteration currently not supported for policy iteration");
                }
                modelCheckerResult = this.computeReachProbsPolIter(mDP, bitSet, bitSet2, bl, nArray);
                break;
            }
            case MODIFIED_POLICY_ITERATION: {
                if (this.doIntervalIteration) {
                    throw new PrismNotSupportedException("Interval iteration currently not supported for policy iteration");
                }
                modelCheckerResult = this.computeReachProbsModPolIter(mDP, bitSet, bitSet2, bl, nArray);
                break;
            }
            default: {
                throw new PrismException("Unknown MDP solution method " + this.mdpSolnMethod.fullName());
            }
        }
        if (modelCheckerResult == null) {
            modelCheckerResult = !this.doIntervalIteration ? this.doValueIterationReachProbs(mDP, bitSet, bitSet2, bl, dArray, bitSet3, iterationMethod, this.getDoTopologicalValueIteration(), nArray) : this.doIntervalIterationReachProbs(mDP, bitSet, bitSet2, bl, dArray, bitSet3, iterationMethod, this.getDoTopologicalValueIteration(), nArray);
        }
        return modelCheckerResult;
    }

    public BitSet prob0(NondetModel<?> nondetModel, BitSet bitSet, BitSet bitSet2, boolean bl, int[] nArray) {
        long l = System.currentTimeMillis();
        if (!this.silentPrecomputations) {
            this.mainLog.println("Starting Prob0 (" + (bl ? "min" : "max") + ")...");
        }
        if (bitSet2.cardinality() == 0) {
            BitSet bitSet3 = new BitSet(nondetModel.getNumStates());
            bitSet3.set(0, nondetModel.getNumStates());
            if (bl && nArray != null) {
                Arrays.fill(nArray, -2);
            }
            return bitSet3;
        }
        int n = nondetModel.getNumStates();
        BitSet bitSet4 = new BitSet(n);
        BitSet bitSet5 = new BitSet(n);
        BitSet bitSet6 = new BitSet();
        bitSet6.set(0, n);
        bitSet6.andNot(bitSet2);
        if (bitSet != null) {
            bitSet6.and(bitSet);
        }
        int n2 = 0;
        boolean bl2 = false;
        bitSet4.or(bitSet2);
        bitSet5.or(bitSet2);
        while (!bl2) {
            ++n2;
            nondetModel.prob0step(bitSet6, bitSet4, bl, bitSet5);
            bl2 = bitSet5.equals(bitSet4);
            bitSet4.clear();
            bitSet4.or(bitSet5);
        }
        bitSet4.flip(0, n);
        l = System.currentTimeMillis() - l;
        if (!this.silentPrecomputations) {
            this.mainLog.print("Prob0 (" + (bl ? "min" : "max") + ")");
            this.mainLog.println(" took " + n2 + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        if (nArray != null) {
            int n3 = bitSet4.nextSetBit(0);
            while (n3 >= 0) {
                int n4 = nondetModel.getNumChoices(n3);
                for (int i = 0; i < n4; ++i) {
                    if (!nondetModel.allSuccessorsInSet(n3, i, bitSet4)) continue;
                    nArray[n3] = i;
                }
                n3 = bitSet4.nextSetBit(n3 + 1);
            }
        }
        return bitSet4;
    }

    public BitSet prob1(NondetModel<?> nondetModel, BitSet bitSet, BitSet bitSet2, boolean bl, int[] nArray) {
        boolean bl2;
        long l = System.currentTimeMillis();
        if (!this.silentPrecomputations) {
            this.mainLog.println("Starting Prob1 (" + (bl ? "min" : "max") + ")...");
        }
        if (bitSet2.cardinality() == 0) {
            return new BitSet(nondetModel.getNumStates());
        }
        int n = nondetModel.getNumStates();
        BitSet bitSet3 = new BitSet(n);
        BitSet bitSet4 = new BitSet(n);
        BitSet bitSet5 = new BitSet(n);
        BitSet bitSet6 = new BitSet();
        bitSet6.set(0, n);
        bitSet6.andNot(bitSet2);
        if (bitSet != null) {
            bitSet6.and(bitSet);
        }
        int n2 = 0;
        boolean bl3 = false;
        bitSet3.set(0, n);
        while (!bl3) {
            bl2 = false;
            bitSet4.clear();
            bitSet4.or(bitSet2);
            bitSet5.clear();
            bitSet5.or(bitSet2);
            while (!bl2) {
                ++n2;
                if (bl) {
                    nondetModel.prob1Astep(bitSet6, bitSet3, bitSet4, bitSet5);
                } else {
                    nondetModel.prob1Estep(bitSet6, bitSet3, bitSet4, bitSet5, null);
                }
                bl2 = bitSet5.equals(bitSet4);
                bitSet4.clear();
                bitSet4.or(bitSet5);
            }
            bl3 = bitSet4.equals(bitSet3);
            bitSet3.clear();
            bitSet3.or(bitSet4);
        }
        bitSet6.and(bitSet3);
        if (!bl && nArray != null) {
            bl2 = false;
            bitSet4.clear();
            bitSet4.or(bitSet2);
            bitSet5.clear();
            bitSet5.or(bitSet2);
            while (!bl2) {
                nondetModel.prob1Estep(bitSet6, bitSet3, bitSet4, bitSet5, nArray);
                bl2 = bitSet5.equals(bitSet4);
                bitSet4.clear();
                bitSet4.or(bitSet5);
            }
            bl3 = bitSet4.equals(bitSet3);
        }
        l = System.currentTimeMillis() - l;
        if (!this.silentPrecomputations) {
            this.mainLog.print("Prob1 (" + (bl ? "min" : "max") + ")");
            this.mainLog.println(" took " + n2 + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        return bitSet3;
    }

    protected ModelCheckerResult computeReachProbsValIter(MDP<Double> mDP, BitSet bitSet, BitSet bitSet2, boolean bl, double[] dArray, BitSet bitSet3, int[] nArray) throws PrismException {
        IterationMethodPower iterationMethodPower = new IterationMethodPower(this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, this.termCritParam);
        return this.doValueIterationReachProbs(mDP, bitSet, bitSet2, bl, dArray, bitSet3, iterationMethodPower, false, nArray);
    }

    protected ModelCheckerResult doValueIterationReachProbs(MDP<Double> mDP, BitSet bitSet, BitSet bitSet2, boolean bl, double[] dArray2, BitSet bitSet3, IterationMethod iterationMethod, boolean bl2, int[] nArray) throws PrismException {
        double d;
        long l = System.currentTimeMillis();
        String string = (bl ? "min" : "max") + (bl2 ? ", topological" : "") + ", with " + iterationMethod.getDescriptionShort();
        this.mainLog.println("Starting value iteration (" + string + ")...");
        ExportIterations exportIterations = null;
        if (this.settings.getBoolean("prism.exportIterations")) {
            exportIterations = new ExportIterations("Explicit MDP ReachProbs value iteration (" + string + ")");
            this.mainLog.println("Exporting iterations to " + exportIterations.getFileName());
        }
        int n2 = mDP.getNumStates();
        double d2 = d = this.valIterDir == ProbModelChecker.ValIterDir.BELOW ? 0.0 : 1.0;
        if (dArray2 != null) {
            if (bitSet3 != null) {
                for (int i = 0; i < n2; ++i) {
                    dArray2[i] = bitSet3.get(i) ? dArray2[i] : (bitSet2.get(i) ? 1.0 : (bitSet.get(i) ? 0.0 : dArray2[i]));
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    dArray2[i] = bitSet2.get(i) ? 1.0 : (bitSet.get(i) ? 0.0 : dArray2[i]);
                }
            }
        } else {
            dArray2 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray2[i] = bitSet2.get(i) ? 1.0 : (bitSet.get(i) ? 0.0 : d);
            }
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n2);
        bitSet4.andNot(bitSet2);
        bitSet4.andNot(bitSet);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        if (exportIterations != null) {
            exportIterations.exportVector(dArray2, 0);
        }
        IterationMethod.IterationValIter iterationValIter = iterationMethod.forMvMultMinMax(mDP, bl, nArray);
        iterationValIter.init(dArray2);
        IntSet intSet = IntSet.asIntSet(bitSet4);
        if (bl2) {
            SCCInfo sCCInfo = SCCComputer.computeTopologicalOrdering(this, mDP, true, bitSet4::get);
            IterationMethod.SingletonSCCSolver singletonSCCSolver = (n, dArray) -> {
                dArray[n] = mDP.mvMultJacMinMaxSingle(n, dArray, bl, nArray);
            };
            return iterationMethod.doTopologicalValueIteration(this, string, sCCInfo, iterationValIter, singletonSCCSolver, l, exportIterations);
        }
        return iterationMethod.doValueIteration(this, string, iterationValIter, intSet, l, exportIterations);
    }

    protected ModelCheckerResult doIntervalIterationReachProbs(MDP<Double> mDP, BitSet bitSet, BitSet bitSet2, boolean bl, double[] dArray2, BitSet bitSet3, IterationMethod iterationMethod, boolean bl2, int[] nArray) throws PrismException {
        long l = System.currentTimeMillis();
        String string = (bl ? "min" : "max") + (bl2 ? ", topological" : "") + ", with " + iterationMethod.getDescriptionShort();
        this.mainLog.println("Starting interval iteration (" + string + ")...");
        ExportIterations exportIterations = null;
        if (this.settings.getBoolean("prism.exportIterations")) {
            exportIterations = new ExportIterations("Explicit MDP ReachProbs interval iteration (" + string + ")");
            this.mainLog.println("Exporting iterations to " + exportIterations.getFileName());
        }
        int n2 = mDP.getNumStates();
        double[] dArray3 = dArray2 == null ? new double[n2] : dArray2;
        double[] dArray4 = new double[n2];
        if (bitSet3 != null && dArray2 != null) {
            for (int i = 0; i < n2; ++i) {
                double d = bitSet3.get(i) ? dArray2[i] : (bitSet2.get(i) ? 1.0 : (dArray3[i] = bitSet.get(i) ? 0.0 : 0.0));
                dArray4[i] = bitSet3.get(i) ? dArray2[i] : (bitSet2.get(i) ? 1.0 : (bitSet.get(i) ? 0.0 : 1.0));
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                double d = bitSet2.get(i) ? 1.0 : (dArray3[i] = bitSet.get(i) ? 0.0 : 0.0);
                dArray4[i] = bitSet2.get(i) ? 1.0 : (bitSet.get(i) ? 0.0 : 1.0);
            }
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n2);
        bitSet4.andNot(bitSet2);
        bitSet4.andNot(bitSet);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        if (exportIterations != null) {
            exportIterations.exportVector(dArray3, 0);
            exportIterations.exportVector(dArray4, 1);
        }
        OptionsIntervalIteration optionsIntervalIteration = OptionsIntervalIteration.from(this);
        boolean bl3 = optionsIntervalIteration.isEnforceMonotonicityFromBelow();
        boolean bl4 = optionsIntervalIteration.isEnforceMonotonicityFromAbove();
        boolean bl5 = optionsIntervalIteration.isCheckMonotonicity();
        if (!bl4) {
            this.getLog().println("Note: Interval iteration is configured to not enforce monotonicity from above.");
        }
        if (!bl3) {
            this.getLog().println("Note: Interval iteration is configured to not enforce monotonicity from below.");
        }
        IterationMethod.IterationIntervalIter iterationIntervalIter = iterationMethod.forMvMultMinMaxInterval(mDP, bl, nArray, true, bl3, bl5);
        IterationMethod.IterationIntervalIter iterationIntervalIter2 = iterationMethod.forMvMultMinMaxInterval(mDP, bl, nArray, false, bl4, bl5);
        iterationIntervalIter.init(dArray3);
        iterationIntervalIter2.init(dArray4);
        IntSet intSet = IntSet.asIntSet(bitSet4);
        if (bl2) {
            SCCInfo sCCInfo = SCCComputer.computeTopologicalOrdering(this, mDP, true, bitSet4::get);
            IterationMethod.SingletonSCCSolver singletonSCCSolver = (n, dArray) -> {
                dArray[n] = mDP.mvMultJacMinMaxSingle(n, dArray, bl, nArray);
            };
            return iterationMethod.doTopologicalIntervalIteration(this, string, sCCInfo, iterationIntervalIter, iterationIntervalIter2, singletonSCCSolver, l, exportIterations);
        }
        return iterationMethod.doIntervalIteration(this, string, iterationIntervalIter, iterationIntervalIter2, intSet, l, exportIterations);
    }

    protected ModelCheckerResult computeReachProbsGaussSeidel(MDP<Double> mDP, BitSet bitSet, BitSet bitSet2, boolean bl, double[] dArray, BitSet bitSet3, int[] nArray) throws PrismException {
        IterationMethodGS iterationMethodGS = new IterationMethodGS(this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, this.termCritParam, false);
        return this.doValueIterationReachProbs(mDP, bitSet, bitSet2, bl, dArray, bitSet3, iterationMethodGS, false, nArray);
    }

    protected ModelCheckerResult computeReachProbsPolIter(MDP<Double> mDP, BitSet bitSet, BitSet bitSet2, boolean bl, int[] nArray) throws PrismException {
        ModelCheckerResult modelCheckerResult;
        int n;
        boolean bl2 = true;
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting policy iteration (" + (bl ? "min" : "max") + ")...");
        DTMCModelChecker dTMCModelChecker = new DTMCModelChecker(this);
        dTMCModelChecker.inheritSettings(this);
        dTMCModelChecker.setLog(new PrismDevNullLog());
        int n2 = mDP.getNumStates();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray2[n] = bitSet2.get(n) ? 1.0 : 0.0;
            dArray[n] = dArray2[n];
        }
        if (nArray == null) {
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = 0;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                if (bitSet.get(n) || bitSet2.get(n)) continue;
                nArray[n] = 0;
            }
        }
        boolean bl3 = this.linEqMethod == ProbModelChecker.LinEqMethod.BACKWARDS_GAUSS_SEIDEL;
        int n3 = 0;
        int n4 = 0;
        boolean bl4 = false;
        while (!bl4) {
            ++n4;
            DTMCFromMDPMemorylessAdversary<Double> dTMCFromMDPMemorylessAdversary = new DTMCFromMDPMemorylessAdversary<Double>(mDP, nArray);
            modelCheckerResult = dTMCModelChecker.computeReachProbsGaussSeidel(dTMCFromMDPMemorylessAdversary, bitSet, bitSet2, (double[])(bl2 ? dArray : null), null, bl3);
            dArray = modelCheckerResult.soln;
            n3 += modelCheckerResult.numIters;
            mDP.mvMultMinMax(dArray, bl, dArray2, null, false, null);
            bl4 = true;
            for (n = 0; n < n2; ++n) {
                if (bitSet.get(n) || bitSet2.get(n) || PrismUtils.doublesAreClose(dArray[n], dArray2[n], this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE)) continue;
                bl4 = false;
                List<Integer> list = mDP.mvMultMinMaxSingleChoices(n, dArray, bl, dArray2[n]);
                if (list.contains(nArray[n])) continue;
                nArray[n] = list.get(0);
            }
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Policy iteration");
        this.mainLog.println(" took " + n4 + " cycles (" + n3 + " iterations in total) and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray;
        modelCheckerResult.numIters = n3;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    protected ModelCheckerResult computeReachProbsModPolIter(MDP<Double> mDP, BitSet bitSet, BitSet bitSet2, boolean bl, int[] nArray) throws PrismException {
        ModelCheckerResult modelCheckerResult;
        int n;
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting modified policy iteration (" + (bl ? "min" : "max") + ")...");
        DTMCModelChecker dTMCModelChecker = new DTMCModelChecker(this);
        dTMCModelChecker.inheritSettings(this);
        dTMCModelChecker.setLog(new PrismDevNullLog());
        dTMCModelChecker.setMaxIters(100);
        dTMCModelChecker.setErrorOnNonConverge(false);
        int n2 = mDP.getNumStates();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray2[n] = bitSet2.get(n) ? 1.0 : 0.0;
            dArray[n] = dArray2[n];
        }
        if (nArray == null) {
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = 0;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                if (bitSet.get(n) || bitSet2.get(n)) continue;
                nArray[n] = 0;
            }
        }
        boolean bl2 = this.linEqMethod == ProbModelChecker.LinEqMethod.BACKWARDS_GAUSS_SEIDEL;
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = false;
        while (!bl3) {
            ++n4;
            DTMCFromMDPMemorylessAdversary<Double> dTMCFromMDPMemorylessAdversary = new DTMCFromMDPMemorylessAdversary<Double>(mDP, nArray);
            modelCheckerResult = dTMCModelChecker.computeReachProbsGaussSeidel(dTMCFromMDPMemorylessAdversary, bitSet, bitSet2, dArray, null, bl2);
            dArray = modelCheckerResult.soln;
            n3 += modelCheckerResult.numIters;
            mDP.mvMultMinMax(dArray, bl, dArray2, null, false, null);
            bl3 = true;
            for (n = 0; n < n2; ++n) {
                if (bitSet.get(n) || bitSet2.get(n) || PrismUtils.doublesAreClose(dArray[n], dArray2[n], this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE)) continue;
                bl3 = false;
                List<Integer> list = mDP.mvMultMinMaxSingleChoices(n, dArray, bl, dArray2[n]);
                nArray[n] = list.get(0);
            }
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Modified policy iteration");
        this.mainLog.println(" took " + n4 + " cycles (" + n3 + " iterations in total) and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray;
        modelCheckerResult.numIters = n3;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public List<Integer> probReachStrategy(MDP<Double> mDP, int n, BitSet bitSet, boolean bl, double[] dArray) throws PrismException {
        double d = mDP.mvMultMinMaxSingle(n, dArray, bl, null);
        return mDP.mvMultMinMaxSingleChoices(n, dArray, bl, d);
    }

    public ModelCheckerResult computeBoundedReachProbs(MDP<Double> mDP, BitSet bitSet, int n, boolean bl) throws PrismException {
        return this.computeBoundedReachProbs(mDP, null, bitSet, n, bl, null, null);
    }

    public ModelCheckerResult computeBoundedUntilProbs(MDP<Double> mDP, BitSet bitSet, BitSet bitSet2, int n, boolean bl) throws PrismException {
        return this.computeBoundedReachProbs(mDP, bitSet, bitSet2, n, bl, null, null);
    }

    public ModelCheckerResult computeBoundedReachProbs(MDP<Double> mDP, BitSet bitSet, BitSet bitSet2, int n, boolean bl, double[] dArray, double[] dArray2) throws PrismException {
        int n2;
        double[] dArray3;
        ModelCheckerResult modelCheckerResult = null;
        int[] nArray = null;
        FMDStrategyStep<Double> fMDStrategyStep = null;
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("\nStarting bounded probabilistic reachability (" + (bl ? "min" : "max") + ")...");
        }
        int n3 = mDP.getNumStates();
        double[] dArray4 = new double[n3];
        double[] dArray5 = dArray3 = dArray == null ? new double[n3] : dArray;
        if (this.genStrat) {
            nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = bitSet2.get(n2) ? -2 : -1;
            }
            fMDStrategyStep = new FMDStrategyStep<Double>(mDP, n);
        }
        if (dArray != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray3[n2] = bitSet2.get(n2) ? 1.0 : dArray[n2];
                dArray4[n2] = dArray3[n2];
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray3[n2] = bitSet2.get(n2) ? 1.0 : 0.0;
                dArray4[n2] = dArray3[n2];
            }
        }
        if (dArray2 != null) {
            dArray2[0] = Utils.minMaxOverArraySubset(dArray3, mDP.getInitialStates(), true);
        }
        BitSet bitSet3 = new BitSet();
        bitSet3.set(0, n3);
        bitSet3.andNot(bitSet2);
        if (bitSet != null) {
            bitSet3.and(bitSet);
        }
        int n4 = 0;
        while (n4 < n) {
            ++n4;
            mDP.mvMultMinMax(dArray4, bl, dArray3, bitSet3, false, nArray);
            if (this.genStrat) {
                fMDStrategyStep.setStepChoices(n - n4, nArray);
            }
            if (dArray2 != null) {
                dArray2[n4] = Utils.minMaxOverArraySubset(dArray3, mDP.getInitialStates(), true);
            }
            double[] dArray6 = dArray4;
            dArray4 = dArray3;
            dArray3 = dArray6;
        }
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.print("Bounded probabilistic reachability (" + (bl ? "min" : "max") + ")");
            this.mainLog.println(" took " + n4 + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray4;
        modelCheckerResult.lastSoln = dArray3;
        modelCheckerResult.accuracy = AccuracyFactory.boundedNumericalIterations();
        modelCheckerResult.numIters = n4;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = 0.0;
        if (this.genStrat) {
            modelCheckerResult.strat = fMDStrategyStep;
        }
        return modelCheckerResult;
    }

    public ModelCheckerResult computeCumulativeRewards(MDP<Double> mDP, MDPRewards<Double> mDPRewards, int n, boolean bl) throws PrismException {
        int n2;
        ModelCheckerResult modelCheckerResult = null;
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting expected cumulative reward (" + (bl ? "min" : "max") + ")...");
        int n3 = mDP.getNumStates();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray2[i] = 0.0;
            dArray[i] = 0.0;
        }
        for (n2 = 0; n2 < n; ++n2) {
            mDP.mvMultRewMinMax(dArray, mDPRewards, bl, dArray2, null, false, null);
            double[] dArray3 = dArray;
            dArray = dArray2;
            dArray2 = dArray3;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Expected cumulative reward (" + (bl ? "min" : "max") + ")");
        this.mainLog.println(" took " + n2 + " iterations and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray;
        modelCheckerResult.accuracy = AccuracyFactory.boundedNumericalIterations();
        modelCheckerResult.numIters = n2;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    double computeReachRewardsMaxUpperBound(MDP<Double> mDP, MDPRewards<Double> mDPRewards, BitSet bitSet, BitSet bitSet2, BitSet bitSet3) throws PrismException {
        if (bitSet2.isEmpty()) {
            this.mainLog.println("Skipping upper bound computation, no unknown states...");
            return 0.0;
        }
        BitSet bitSet4 = (BitSet)bitSet.clone();
        bitSet4.or(bitSet3);
        MDPDroppedAllChoices<Double> mDPDroppedAllChoices = new MDPDroppedAllChoices<Double>(mDP, bitSet4);
        OptionsIntervalIteration optionsIntervalIteration = OptionsIntervalIteration.from(this);
        double d = 0.0;
        String string = null;
        switch (optionsIntervalIteration.getBoundMethod()) {
            case VARIANT_1_COARSE: {
                d = this.computeReachRewardsMaxUpperBoundVariant1Coarse(mDPDroppedAllChoices, mDPRewards, bitSet, bitSet2, bitSet3);
                string = "variant 1, coarse";
                break;
            }
            case VARIANT_1_FINE: {
                d = this.computeReachRewardsMaxUpperBoundVariant1Fine(mDPDroppedAllChoices, mDPRewards, bitSet, bitSet2, bitSet3);
                string = "variant 1, fine";
                break;
            }
            case DEFAULT: 
            case VARIANT_2: {
                d = this.computeReachRewardsMaxUpperBoundVariant2(mDPDroppedAllChoices, mDPRewards, bitSet, bitSet2, bitSet3);
                string = "variant 2";
                break;
            }
            case DSMPI: {
                throw new PrismNotSupportedException("Dijkstra Sweep MPI upper bound heuristic can not be used for Rmax");
            }
        }
        if (string == null) {
            throw new PrismException("Unknown upper bound heuristic");
        }
        this.mainLog.println("Upper bound for max expectation (" + string + "): " + d);
        return d;
    }

    double computeReachRewardsMinUpperBound(MDP<Double> mDP, MDPRewards<Double> mDPRewards, BitSet bitSet, BitSet bitSet2, BitSet bitSet3) throws PrismException {
        BitSet bitSet4 = (BitSet)bitSet.clone();
        bitSet4.or(bitSet3);
        MDPDroppedAllChoices<Double> mDPDroppedAllChoices = new MDPDroppedAllChoices<Double>(mDP, bitSet4);
        OptionsIntervalIteration optionsIntervalIteration = OptionsIntervalIteration.from(this);
        double d = 0.0;
        String string = null;
        switch (optionsIntervalIteration.getBoundMethod()) {
            case DEFAULT: 
            case DSMPI: {
                d = DijkstraSweepMPI.computeUpperBound(this, mDP, mDPRewards, bitSet, bitSet2);
                string = "Dijkstra Sweep MPI";
                break;
            }
            case VARIANT_1_COARSE: {
                d = this.computeReachRewardsMaxUpperBoundVariant1Coarse(mDPDroppedAllChoices, mDPRewards, bitSet, bitSet2, bitSet3);
                string = "using Rmax upper bound via variant 1, coarse";
                break;
            }
            case VARIANT_1_FINE: {
                d = this.computeReachRewardsMaxUpperBoundVariant1Fine(mDPDroppedAllChoices, mDPRewards, bitSet, bitSet2, bitSet3);
                string = "using Rmax upper bound via variant 1, fine";
                break;
            }
            case VARIANT_2: {
                d = this.computeReachRewardsMaxUpperBoundVariant2(mDPDroppedAllChoices, mDPRewards, bitSet, bitSet2, bitSet3);
                string = "using Rmax upper bound via variant 2";
            }
        }
        if (string == null) {
            throw new PrismException("Unknown upper bound heuristic");
        }
        this.mainLog.println("Upper bound for min expectation (" + string + "): " + d);
        return d;
    }

    private boolean isContracting(MDP<?> mDP, BitSet bitSet, BitSet bitSet2) {
        BitSet bitSet3 = this.prob1(mDP, bitSet, bitSet2, true, null);
        BitSet bitSet4 = (BitSet)bitSet.clone();
        bitSet4.andNot(bitSet3);
        return bitSet4.isEmpty();
    }

    double computeReachRewardsMaxUpperBoundVariant1Coarse(MDP<Double> mDP, MDPRewards<Double> mDPRewards, BitSet bitSet, BitSet bitSet2, BitSet bitSet3) throws PrismException {
        double d;
        int n;
        double[] dArray = new double[mDP.getNumStates()];
        double[] dArray2 = new double[mDP.getNumStates()];
        int[] nArray = new int[mDP.getNumStates()];
        StopWatch stopWatch = new StopWatch(this.getLog());
        stopWatch.start("computing an upper bound for maximal expected reward");
        SCCInfo sCCInfo = SCCComputer.computeTopologicalOrdering(this, mDP, true, null);
        BitSet bitSet4 = new BitSet();
        double d2 = 0.0;
        int n2 = sCCInfo.getNumSCCs();
        for (int i = 0; i < n2; ++i) {
            IntSet intSet = sCCInfo.getStatesForSCC(i);
            int n3 = Math.toIntExact(intSet.cardinality());
            FunctionalPrimitiveIterator.OfInt ofInt = intSet.iterator();
            while (ofInt.hasNext()) {
                n = ofInt.nextInt();
                nArray[n] = n3;
                boolean bl = false;
                for (int j = 0; j < mDP.getNumChoices(n); ++j) {
                    d = 0.0;
                    boolean bl2 = true;
                    Iterator<Map.Entry<Integer, Double>> iterator = mDP.getTransitionsIterator(n, j);
                    while (iterator.hasNext()) {
                        Map.Entry<Integer, Double> entry = iterator.next();
                        if (intSet.get(entry.getKey())) {
                            d += entry.getValue().doubleValue();
                            bl = true;
                            continue;
                        }
                        bl2 = false;
                    }
                    if (bl2) continue;
                    d2 = Math.max(d2, d);
                }
                if (n3 != 1 || bl) continue;
                bitSet4.set(n);
            }
        }
        double d3 = 1.0;
        for (int i = 0; i < mDP.getNumStates(); ++i) {
            double d4 = 0.0;
            for (n = 0; n < mDP.getNumChoices(i); ++n) {
                Iterator<Map.Entry<Integer, Double>> iterator = mDP.getTransitionsIterator(i, n);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Double> entry = iterator.next();
                    d3 = Math.min(d3, entry.getValue());
                    d = (Double)mDPRewards.getStateReward(i) + (Double)mDPRewards.getTransitionReward(i, n);
                    d4 = Math.max(d4, d);
                }
            }
            dArray2[i] = d4;
        }
        double d5 = 0.0;
        for (int i = 0; i < mDP.getNumStates(); ++i) {
            if (bitSet.get(i) || bitSet3.get(i)) {
                dArray[i] = 0.0;
                continue;
            }
            if (!bitSet2.get(i)) continue;
            dArray[i] = bitSet4.get(i) ? 1.0 : 1.0 / (Math.pow(d3, nArray[i] - 1) * (1.0 - d2));
            d5 += dArray[i] * dArray2[i];
        }
        if (OptionsIntervalIteration.from(this).isBoundComputationVerbose()) {
            this.mainLog.println("Upper bound for max expectation computation (variant 1, coarse):");
            this.mainLog.println("p = " + d3);
            this.mainLog.println("q = " + d2);
            this.mainLog.println("|Ct| = " + Arrays.toString(nArray));
            this.mainLog.println("\u03b6* = " + Arrays.toString(dArray));
            this.mainLog.println("maxRews = " + Arrays.toString(dArray2));
        }
        stopWatch.stop();
        if (!Double.isFinite(d5)) {
            throw new PrismException("Problem computing an upper bound for the expectation, did not get finite result");
        }
        return d5;
    }

    double computeReachRewardsMaxUpperBoundVariant1Fine(MDP<Double> mDP, MDPRewards<Double> mDPRewards, BitSet bitSet, BitSet bitSet2, BitSet bitSet3) throws PrismException {
        int n;
        double[] dArray = new double[mDP.getNumStates()];
        double[] dArray2 = new double[mDP.getNumStates()];
        double[] dArray3 = new double[mDP.getNumStates()];
        double[] dArray4 = new double[mDP.getNumStates()];
        int[] nArray = new int[mDP.getNumStates()];
        StopWatch stopWatch = new StopWatch(this.getLog());
        stopWatch.start("computing an upper bound for maximal expected reward");
        SCCInfo sCCInfo = SCCComputer.computeTopologicalOrdering(this, mDP, true, null);
        BitSet bitSet4 = new BitSet();
        int n2 = sCCInfo.getNumSCCs();
        for (n = 0; n < n2; ++n) {
            int n3;
            IntSet intSet = sCCInfo.getStatesForSCC(n);
            double d = 0.0;
            double d2 = 1.0;
            int n4 = Math.toIntExact(intSet.cardinality());
            FunctionalPrimitiveIterator.OfInt ofInt = intSet.iterator();
            while (ofInt.hasNext()) {
                int n5 = ofInt.nextInt();
                nArray[n5] = n4;
                n3 = 0;
                for (int i = 0; i < mDP.getNumChoices(n5); ++i) {
                    double d3 = 0.0;
                    boolean bl = true;
                    Iterator<Map.Entry<Integer, Double>> iterator = mDP.getTransitionsIterator(n5, i);
                    while (iterator.hasNext()) {
                        Map.Entry<Integer, Double> entry = iterator.next();
                        if (intSet.get(entry.getKey())) {
                            d3 += entry.getValue().doubleValue();
                            d2 = Math.min(d2, entry.getValue());
                            n3 = 1;
                            continue;
                        }
                        bl = false;
                    }
                    if (bl) continue;
                    d = Math.max(d, d3);
                }
                if (n4 != 1 || n3 != 0) continue;
                bitSet4.set(n5);
            }
            FunctionalPrimitiveIterator.OfInt ofInt2 = intSet.iterator();
            while (ofInt2.hasNext()) {
                n3 = (Integer)ofInt2.next();
                dArray2[n3] = d;
                dArray3[n3] = d2;
            }
        }
        for (n = 0; n < mDP.getNumStates(); ++n) {
            double d = 0.0;
            for (int i = 0; i < mDP.getNumChoices(n); ++i) {
                double d4 = (Double)mDPRewards.getStateReward(n) + (Double)mDPRewards.getTransitionReward(n, i);
                d = Math.max(d, d4);
            }
            dArray4[n] = d;
        }
        double d = 0.0;
        for (int i = 0; i < mDP.getNumStates(); ++i) {
            if (bitSet.get(i) || bitSet3.get(i)) {
                dArray[i] = 0.0;
                continue;
            }
            if (!bitSet2.get(i)) continue;
            dArray[i] = bitSet4.get(i) ? 1.0 : 1.0 / (Math.pow(dArray3[i], nArray[i] - 1) * (1.0 - dArray2[i]));
            d += dArray[i] * dArray4[i];
        }
        stopWatch.stop();
        if (OptionsIntervalIteration.from(this).isBoundComputationVerbose()) {
            this.mainLog.println("Upper bound for max expectation computation (variant 1, fine):");
            this.mainLog.println("pt = " + Arrays.toString(dArray3));
            this.mainLog.println("qt = " + Arrays.toString(dArray2));
            this.mainLog.println("|Ct| = " + Arrays.toString(nArray));
            this.mainLog.println("\u03b6* = " + Arrays.toString(dArray));
            this.mainLog.println("maxRews = " + Arrays.toString(dArray4));
        }
        if (!Double.isFinite(d)) {
            throw new PrismException("Problem computing an upper bound for the expectation, did not get finite result");
        }
        return d;
    }

    double computeReachRewardsMaxUpperBoundVariant2(MDP<Double> mDP, MDPRewards<Double> mDPRewards, BitSet bitSet, BitSet bitSet2, BitSet bitSet3) throws PrismException {
        int n;
        double[] dArray = new double[mDP.getNumStates()];
        double[] dArray2 = new double[mDP.getNumStates()];
        double[] dArray3 = new double[mDP.getNumStates()];
        StopWatch stopWatch = new StopWatch(this.getLog());
        stopWatch.start("computing an upper bound for expected reward");
        SCCInfo sCCInfo = SCCComputer.computeTopologicalOrdering(this, mDP, true, bitSet2::get);
        BitSet bitSet4 = (BitSet)bitSet.clone();
        int n4 = 0;
        while (true) {
            int n5;
            BitSet bitSet5 = new BitSet();
            ++n4;
            FunctionalPrimitiveIterator.OfInt ofInt = IterableBitSet.getClearBits(bitSet4, mDP.getNumStates() - 1).iterator();
            while (ofInt.hasNext()) {
                n5 = ofInt.nextInt();
                n = 1;
                int n6 = mDP.getNumChoices(n5);
                for (int i = 0; i < n6; ++i) {
                    if (mDP.someSuccessorsInSet(n5, i, bitSet4)) continue;
                    n = 0;
                    break;
                }
                if (n == 0) continue;
                bitSet5.set(n5);
            }
            if (bitSet5.isEmpty()) break;
            ofInt = IterableBitSet.getSetBits(bitSet5).iterator();
            while (ofInt.hasNext()) {
                n5 = ofInt.nextInt();
                n = sCCInfo.getSCCIndex(n5);
                double d2 = Double.POSITIVE_INFINITY;
                int n7 = mDP.getNumChoices(n5);
                for (int i = 0; i < n7; ++i) {
                    double d3 = mDP.sumOverDoubleTransitions(n5, i, (n2, n3, d) -> {
                        if (!bitSet4.get(n3)) {
                            return 0.0;
                        }
                        boolean bl = sCCInfo.getSCCIndex(n3) == n;
                        double d2 = bl ? dArray[n3] : 1.0;
                        return d2 * d;
                    });
                    if (!(d3 < d2)) continue;
                    d2 = d3;
                }
                dArray[n5] = d2;
            }
            bitSet4.or(bitSet5);
        }
        for (int i = 0; i < mDP.getNumStates(); ++i) {
            double d4 = 0.0;
            for (n = 0; n < mDP.getNumChoices(i); ++n) {
                double d5 = (Double)mDPRewards.getStateReward(i) + (Double)mDPRewards.getTransitionReward(i, n);
                d4 = Math.max(d4, d5);
            }
            dArray3[i] = d4;
        }
        double d6 = 0.0;
        FunctionalPrimitiveIterator.OfInt ofInt = IterableBitSet.getSetBits(bitSet2).iterator();
        while (ofInt.hasNext()) {
            n = ofInt.nextInt();
            dArray2[n] = 1.0 / dArray[n];
            d6 += dArray2[n] * dArray3[n];
        }
        stopWatch.stop();
        if (OptionsIntervalIteration.from(this).isBoundComputationVerbose()) {
            this.mainLog.println("Upper bound for max expectation computation (variant 2):");
            this.mainLog.println("d_t = " + Arrays.toString(dArray));
            this.mainLog.println("\u03b6* = " + Arrays.toString(dArray2));
        }
        if (!Double.isFinite(d6)) {
            throw new PrismException("Problem computing an upper bound for the expectation, did not get finite result");
        }
        return d6;
    }

    public ModelCheckerResult computeInstantaneousRewards(MDP<Double> mDP, MDPRewards<Double> mDPRewards, int n, boolean bl) {
        int n2;
        ModelCheckerResult modelCheckerResult = null;
        int n3 = mDP.getNumStates();
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting backwards instantaneous rewards computation...");
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray[i] = (Double)mDPRewards.getStateReward(i);
        }
        for (n2 = 0; n2 < n; ++n2) {
            mDP.mvMultMinMax(dArray, bl, dArray2, null, false, null);
            double[] dArray3 = dArray;
            dArray = dArray2;
            dArray2 = dArray3;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Backwards transient instantaneous rewards computation");
        this.mainLog.println(" took " + n2 + " iters and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray;
        modelCheckerResult.lastSoln = dArray2;
        modelCheckerResult.accuracy = AccuracyFactory.boundedNumericalIterations();
        modelCheckerResult.numIters = n2;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = 0.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeTotalRewards(MDP<Double> mDP, MDPRewards<Double> mDPRewards, boolean bl) throws PrismException {
        if (bl) {
            throw new PrismNotSupportedException("Minimum total expected reward not supported in explicit engine");
        }
        return this.computeTotalRewardsMax(mDP, mDPRewards, false);
    }

    public ModelCheckerResult computeTotalRewardsMax(MDP<Double> mDP, MDPRewards<Double> mDPRewards, boolean bl) throws PrismException {
        long l;
        BitSet bitSet;
        ModelCheckerResult modelCheckerResult = null;
        int[] nArray = null;
        ProbModelChecker.MDPSolnMethod mDPSolnMethod = this.mdpSolnMethod;
        if (mDPSolnMethod != ProbModelChecker.MDPSolnMethod.VALUE_ITERATION && mDPSolnMethod != ProbModelChecker.MDPSolnMethod.GAUSS_SEIDEL && mDPSolnMethod != ProbModelChecker.MDPSolnMethod.POLICY_ITERATION) {
            mDPSolnMethod = ProbModelChecker.MDPSolnMethod.GAUSS_SEIDEL;
            this.mainLog.printWarning("Switching to MDP solution method \"" + mDPSolnMethod.fullName() + "\"");
        }
        if (this.getDoIntervalIteration()) {
            throw new PrismNotSupportedException("Interval iteration for total rewards is currently not supported");
        }
        long l2 = System.currentTimeMillis();
        this.mainLog.println("\nStarting total expected reward (max)...");
        int n = mDP.getNumStates();
        if (this.genStrat) {
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = -1;
            }
        }
        if (bl) {
            bitSet = new BitSet();
            l = 0L;
        } else {
            this.mainLog.println("Precomputation: Find positive end components...");
            l = System.currentTimeMillis();
            ECComputer eCComputer = ECComputer.createECComputer(this, mDP);
            eCComputer.computeMECStates();
            BitSet bitSet2 = new BitSet();
            for (BitSet bitSet3 : eCComputer.getMECStates()) {
                boolean bl2 = false;
                FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet3, n).iterator();
                block7: while (ofInt.hasNext()) {
                    int n2 = (Integer)ofInt.next();
                    if ((Double)mDPRewards.getStateReward(n2) > 0.0) {
                        bl2 = true;
                        break;
                    }
                    int n3 = mDP.getNumChoices(n2);
                    for (int i = 0; i < n3; ++i) {
                        if (!((Double)mDPRewards.getTransitionReward(n2, i) > 0.0) || !mDP.allSuccessorsInSet(n2, i, bitSet3)) continue;
                        bl2 = true;
                        continue block7;
                    }
                }
                if (!bl2) continue;
                bitSet2.or(bitSet3);
            }
            bitSet = this.prob0(mDP, null, bitSet2, false, nArray);
            bitSet.flip(0, n);
            l = System.currentTimeMillis() - l;
            this.mainLog.println("Precomputation took " + (double)l / 1000.0 + " seconds, " + bitSet.cardinality() + " infinite states, " + (n - bitSet.cardinality()) + " states remaining.");
        }
        switch (mDPSolnMethod) {
            case VALUE_ITERATION: {
                modelCheckerResult = this.computeReachRewardsValIter(mDP, mDPRewards, new BitSet(), bitSet, false, null, null, nArray);
                break;
            }
            case GAUSS_SEIDEL: {
                modelCheckerResult = this.computeReachRewardsGaussSeidel(mDP, mDPRewards, new BitSet(), bitSet, false, null, null, nArray);
                break;
            }
            case POLICY_ITERATION: {
                modelCheckerResult = this.computeReachRewardsPolIter(mDP, mDPRewards, new BitSet(), bitSet, false, nArray);
                break;
            }
            default: {
                throw new PrismException("Unknown MDP solution method " + mDPSolnMethod.fullName());
            }
        }
        if (this.genStrat) {
            modelCheckerResult.strat = new MDStrategyArray<Double>(mDP, nArray);
        }
        l2 = System.currentTimeMillis() - l2;
        this.mainLog.println("Expected total reward took " + (double)l2 / 1000.0 + " seconds.");
        modelCheckerResult.timeTaken = (double)l2 / 1000.0;
        modelCheckerResult.timePre = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeReachRewards(MDP<Double> mDP, MDPRewards<Double> mDPRewards, BitSet bitSet, boolean bl) throws PrismException {
        return this.computeReachRewards(mDP, mDPRewards, bitSet, bl, null, null);
    }

    public ModelCheckerResult computeReachRewards(MDP<Double> mDP, MDPRewards<Double> mDPRewards, BitSet bitSet, boolean bl, double[] dArray, BitSet bitSet2) throws PrismException {
        Object object;
        BitSet bitSet3;
        ModelCheckerResult modelCheckerResult = null;
        int[] nArray = null;
        ProbModelChecker.MDPSolnMethod mDPSolnMethod = this.mdpSolnMethod;
        if (mDPSolnMethod != ProbModelChecker.MDPSolnMethod.VALUE_ITERATION && mDPSolnMethod != ProbModelChecker.MDPSolnMethod.GAUSS_SEIDEL && mDPSolnMethod != ProbModelChecker.MDPSolnMethod.POLICY_ITERATION) {
            mDPSolnMethod = ProbModelChecker.MDPSolnMethod.GAUSS_SEIDEL;
            this.mainLog.printWarning("Switching to MDP solution method \"" + mDPSolnMethod.fullName() + "\"");
        }
        if (mDPSolnMethod == ProbModelChecker.MDPSolnMethod.POLICY_ITERATION && bitSet2 != null) {
            throw new PrismException("Policy iteration methods cannot be passed 'known' values for some states");
        }
        if (this.doIntervalIteration && mDPSolnMethod != ProbModelChecker.MDPSolnMethod.VALUE_ITERATION && mDPSolnMethod != ProbModelChecker.MDPSolnMethod.GAUSS_SEIDEL) {
            throw new PrismNotSupportedException("Currently, explicit engine only supports interval iteration with value iteration or Gauss-Seidel for MDPs");
        }
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting expected reachability (" + (bl ? "min" : "max") + ")...");
        mDP.checkForDeadlocks(bitSet);
        int n = mDP.getNumStates();
        if (dArray != null && bitSet2 != null && !bitSet2.isEmpty()) {
            bitSet3 = (BitSet)bitSet.clone();
            object = new IterableBitSet(bitSet2).iterator();
            while (object.hasNext()) {
                int n2 = (Integer)object.next();
                if (dArray[n2] != 1.0) continue;
                bitSet3.set(n2);
            }
            bitSet = bitSet3;
        }
        if (this.getExportTarget()) {
            bitSet3 = new BitSet(n);
            for (int i = 0; i < n; ++i) {
                bitSet3.set(i, mDP.isInitialState(i));
            }
            object = Arrays.asList(bitSet3, bitSet);
            List<String> list = Arrays.asList("init", "target");
            this.mainLog.println("\nExporting target states info to file \"" + this.getExportTargetFilename() + "\"...");
            this.exportLabels(mDP, list, (List<BitSet>)object, new File(this.getExportTargetFilename()), ModelExportFormat.EXPLICIT);
        }
        if (this.genStrat || mDPSolnMethod == ProbModelChecker.MDPSolnMethod.POLICY_ITERATION) {
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = bitSet.get(i) ? -2 : -1;
            }
        }
        long l2 = System.currentTimeMillis();
        BitSet bitSet4 = this.prob1(mDP, null, bitSet, !bl, nArray);
        bitSet4.flip(0, n);
        l2 = System.currentTimeMillis() - l2;
        int n3 = bitSet.cardinality();
        int n4 = bitSet4.cardinality();
        this.mainLog.println("target=" + n3 + ", inf=" + n4 + ", rest=" + (n - (n3 + n4)));
        if (this.genStrat || mDPSolnMethod == ProbModelChecker.MDPSolnMethod.POLICY_ITERATION) {
            if (bl) {
                int n5 = bitSet4.nextSetBit(0);
                while (n5 >= 0) {
                    nArray[n5] = -2;
                    n5 = bitSet4.nextSetBit(n5 + 1);
                }
            } else {
                int n6 = bitSet4.nextSetBit(0);
                while (n6 >= 0) {
                    int n7 = mDP.getNumChoices(n6);
                    for (int i = 0; i < n7; ++i) {
                        if (!mDP.someSuccessorsInSet(n6, i, bitSet4)) continue;
                        nArray[n6] = i;
                    }
                    n6 = bitSet4.nextSetBit(n6 + 1);
                }
            }
        }
        if (n3 + n4 < n) {
            ZeroRewardECQuotient<Double> zeroRewardECQuotient = null;
            boolean bl2 = true;
            if (bl & bl2) {
                StopWatch stopWatch = new StopWatch(this.mainLog);
                stopWatch.start("checking for zero-reward ECs");
                this.mainLog.println("For Rmin, checking for zero-reward ECs...");
                BitSet bitSet5 = (BitSet)bitSet4.clone();
                bitSet5.flip(0, mDP.getNumStates());
                bitSet5.andNot(bitSet);
                zeroRewardECQuotient = ZeroRewardECQuotient.getQuotient(this, mDP, bitSet5, mDPRewards);
                if (zeroRewardECQuotient == null) {
                    stopWatch.stop("no zero-reward ECs found, proceeding normally");
                } else {
                    stopWatch.stop("built quotient MDP with " + zeroRewardECQuotient.getNumberOfZeroRewardMECs() + " zero-reward MECs");
                    if (nArray != null) {
                        throw new PrismException("Constructing a strategy for Rmin in the presence of zero-reward ECs is currently not supported");
                    }
                }
            }
            if (zeroRewardECQuotient != null) {
                BitSet bitSet6 = (BitSet)bitSet4.clone();
                bitSet6.or(zeroRewardECQuotient.getNonRepresentativeStates());
                int n8 = zeroRewardECQuotient.getModel().getNumStates() - bitSet6.cardinality();
                this.mainLog.println("Computing Rmin in zero-reward EC quotient model (" + n8 + " relevant states)...");
                modelCheckerResult = this.computeReachRewardsNumeric(zeroRewardECQuotient.getModel(), zeroRewardECQuotient.getRewards(), mDPSolnMethod, bitSet, bitSet6, bl, dArray, bitSet2, nArray);
                zeroRewardECQuotient.mapResults(modelCheckerResult.soln);
            } else {
                modelCheckerResult = this.computeReachRewardsNumeric(mDP, mDPRewards, mDPSolnMethod, bitSet, bitSet4, bl, dArray, bitSet2, nArray);
            }
        } else {
            modelCheckerResult = new ModelCheckerResult();
            modelCheckerResult.soln = Utils.bitsetToDoubleArray(bitSet4, n, Double.POSITIVE_INFINITY);
            modelCheckerResult.accuracy = AccuracyFactory.doublesFromQualitative();
        }
        if (this.genStrat) {
            modelCheckerResult.strat = new MDStrategyArray<Double>(mDP, nArray);
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Expected reachability took " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = (double)l2 / 1000.0;
        return modelCheckerResult;
    }

    protected ModelCheckerResult computeReachRewardsNumeric(MDP<Double> mDP, MDPRewards<Double> mDPRewards, ProbModelChecker.MDPSolnMethod mDPSolnMethod, BitSet bitSet, BitSet bitSet2, boolean bl, double[] dArray, BitSet bitSet3, int[] nArray) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        IterationMethod iterationMethod = null;
        switch (mDPSolnMethod) {
            case VALUE_ITERATION: {
                iterationMethod = new IterationMethodPower(this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, this.termCritParam);
                break;
            }
            case GAUSS_SEIDEL: {
                iterationMethod = new IterationMethodGS(this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, this.termCritParam, false);
                break;
            }
            case POLICY_ITERATION: {
                if (this.doIntervalIteration) {
                    throw new PrismNotSupportedException("Interval iteration currently not supported for policy iteration");
                }
                modelCheckerResult = this.computeReachRewardsPolIter(mDP, mDPRewards, bitSet, bitSet2, bl, nArray);
                break;
            }
            default: {
                throw new PrismException("Unknown MDP solution method " + mDPSolnMethod.fullName());
            }
        }
        if (modelCheckerResult == null) {
            modelCheckerResult = !this.doIntervalIteration ? this.doValueIterationReachRewards(mDP, mDPRewards, iterationMethod, bitSet, bitSet2, bl, dArray, bitSet3, this.getDoTopologicalValueIteration(), nArray) : this.doIntervalIterationReachRewards(mDP, mDPRewards, iterationMethod, bitSet, bitSet2, bl, dArray, bitSet3, this.getDoTopologicalValueIteration(), nArray);
        }
        return modelCheckerResult;
    }

    protected ModelCheckerResult computeReachRewardsValIter(MDP<Double> mDP, MDPRewards<Double> mDPRewards, BitSet bitSet, BitSet bitSet2, boolean bl, double[] dArray, BitSet bitSet3, int[] nArray) throws PrismException {
        IterationMethodPower iterationMethodPower = new IterationMethodPower(this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, this.termCritParam);
        return this.doValueIterationReachRewards(mDP, mDPRewards, iterationMethodPower, bitSet, bitSet2, bl, dArray, bitSet3, false, nArray);
    }

    protected ModelCheckerResult doValueIterationReachRewards(MDP<Double> mDP, MDPRewards<Double> mDPRewards, IterationMethod iterationMethod, BitSet bitSet, BitSet bitSet2, boolean bl, double[] dArray2, BitSet bitSet3, boolean bl2, int[] nArray) throws PrismException {
        long l = System.currentTimeMillis();
        String string = (bl ? "min" : "max") + (bl2 ? ", topological" : "") + ", with " + iterationMethod.getDescriptionShort();
        this.mainLog.println("Starting value iteration (" + string + ")...");
        ExportIterations exportIterations = null;
        if (this.settings.getBoolean("prism.exportIterations")) {
            exportIterations = new ExportIterations("Explicit MDP ReachRewards value iteration (" + string + ")");
            this.mainLog.println("Exporting iterations to " + exportIterations.getFileName());
        }
        int n2 = mDP.getNumStates();
        if (dArray2 != null) {
            if (bitSet3 != null) {
                for (int i = 0; i < n2; ++i) {
                    dArray2[i] = bitSet3.get(i) ? dArray2[i] : (bitSet.get(i) ? 0.0 : (bitSet2.get(i) ? Double.POSITIVE_INFINITY : dArray2[i]));
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    dArray2[i] = bitSet.get(i) ? 0.0 : (bitSet2.get(i) ? Double.POSITIVE_INFINITY : dArray2[i]);
                }
            }
        } else {
            dArray2 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray2[i] = bitSet.get(i) ? 0.0 : (bitSet2.get(i) ? Double.POSITIVE_INFINITY : 0.0);
            }
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n2);
        bitSet4.andNot(bitSet);
        bitSet4.andNot(bitSet2);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        if (exportIterations != null) {
            exportIterations.exportVector(dArray2, 0);
        }
        IterationMethod.IterationValIter iterationValIter = iterationMethod.forMvMultRewMinMax(mDP, mDPRewards, bl, nArray);
        iterationValIter.init(dArray2);
        IntSet intSet = IntSet.asIntSet(bitSet4);
        if (bl2) {
            SCCInfo sCCInfo = SCCComputer.computeTopologicalOrdering(this, mDP, true, bitSet4::get);
            IterationMethod.SingletonSCCSolver singletonSCCSolver = (n, dArray) -> {
                dArray[n] = mDP.mvMultRewJacMinMaxSingle(n, dArray, mDPRewards, bl, nArray);
            };
            return iterationMethod.doTopologicalValueIteration(this, string, sCCInfo, iterationValIter, singletonSCCSolver, l, exportIterations);
        }
        return iterationMethod.doValueIteration(this, string, iterationValIter, intSet, l, exportIterations);
    }

    protected ModelCheckerResult computeReachRewardsGaussSeidel(MDP<Double> mDP, MDPRewards<Double> mDPRewards, BitSet bitSet, BitSet bitSet2, boolean bl, double[] dArray, BitSet bitSet3, int[] nArray) throws PrismException {
        IterationMethodGS iterationMethodGS = new IterationMethodGS(this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, this.termCritParam, false);
        return this.doValueIterationReachRewards(mDP, mDPRewards, iterationMethodGS, bitSet, bitSet2, bl, dArray, bitSet3, false, nArray);
    }

    protected ModelCheckerResult doIntervalIterationReachRewards(MDP<Double> mDP, MDPRewards<Double> mDPRewards, IterationMethod iterationMethod, BitSet bitSet, BitSet bitSet2, boolean bl, double[] dArray2, BitSet bitSet3, boolean bl2, int[] nArray) throws PrismException {
        ModelCheckerResult modelCheckerResult;
        int n2;
        double d;
        double d2;
        OptionsIntervalIteration optionsIntervalIteration;
        int n3 = mDP.getNumStates();
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n3);
        bitSet4.andNot(bitSet);
        bitSet4.andNot(bitSet2);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        if ((optionsIntervalIteration = OptionsIntervalIteration.from(this)).hasManualUpperBound()) {
            d2 = optionsIntervalIteration.getManualUpperBound();
            this.getLog().printWarning("Upper bound for interval iteration manually set to " + d2);
        } else {
            d2 = bl ? this.computeReachRewardsMinUpperBound(mDP, mDPRewards, bitSet, bitSet4, bitSet2) : this.computeReachRewardsMaxUpperBound(mDP, mDPRewards, bitSet, bitSet4, bitSet2);
        }
        if (optionsIntervalIteration.hasManualLowerBound()) {
            d = optionsIntervalIteration.getManualLowerBound();
            this.getLog().printWarning("Lower bound for interval iteration manually set to " + d);
        } else {
            d = 0.0;
        }
        if (bl) {
            if (!this.isContracting(mDP, bitSet4, bitSet)) {
                throw new PrismNotSupportedException("Interval iteration for Rmin and non-contracting MDP currently not supported");
            }
            this.mainLog.println("Relevant sub-MDP is contracting, proceed...");
        }
        long l = System.currentTimeMillis();
        String string = (bl ? "min" : "max") + (bl2 ? ", topological" : "") + ", with " + iterationMethod.getDescriptionShort();
        this.mainLog.println("Starting interval iteration (" + string + ")...");
        ExportIterations exportIterations = null;
        if (this.settings.getBoolean("prism.exportIterations")) {
            exportIterations = new ExportIterations("Explicit MDP ReachRewards interval iteration (" + string + ")");
            this.mainLog.println("Exporting iterations to " + exportIterations.getFileName());
        }
        double[] dArray3 = dArray2 == null ? new double[n3] : dArray2;
        double[] dArray4 = new double[n3];
        if (dArray2 != null && bitSet3 != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray3[n2] = bitSet3.get(n2) ? dArray2[n2] : (bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : d));
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray3[n2] = bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : d);
            }
        }
        if (dArray2 != null && bitSet3 != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray4[n2] = bitSet3.get(n2) ? dArray2[n2] : (bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : d2));
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray4[n2] = bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : d2);
            }
        }
        if (exportIterations != null) {
            exportIterations.exportVector(dArray3, 0);
            exportIterations.exportVector(dArray4, 1);
        }
        boolean bl3 = optionsIntervalIteration.isEnforceMonotonicityFromBelow();
        boolean bl4 = optionsIntervalIteration.isEnforceMonotonicityFromAbove();
        boolean bl5 = optionsIntervalIteration.isCheckMonotonicity();
        if (!bl4) {
            this.getLog().println("Note: Interval iteration is configured to not enforce monotonicity from above.");
        }
        if (!bl3) {
            this.getLog().println("Note: Interval iteration is configured to not enforce monotonicity from below.");
        }
        IterationMethod.IterationIntervalIter iterationIntervalIter = iterationMethod.forMvMultRewMinMaxInterval(mDP, mDPRewards, bl, nArray, true, bl3, bl5);
        IterationMethod.IterationIntervalIter iterationIntervalIter2 = iterationMethod.forMvMultRewMinMaxInterval(mDP, mDPRewards, bl, nArray, false, bl4, bl5);
        iterationIntervalIter.init(dArray3);
        iterationIntervalIter2.init(dArray4);
        IntSet intSet = IntSet.asIntSet(bitSet4);
        if (bl2) {
            SCCInfo sCCInfo = SCCComputer.computeTopologicalOrdering(this, mDP, true, bitSet4::get);
            IterationMethod.SingletonSCCSolver singletonSCCSolver = (n, dArray) -> {
                dArray[n] = mDP.mvMultRewJacMinMaxSingle(n, dArray, mDPRewards, bl, nArray);
            };
            modelCheckerResult = iterationMethod.doTopologicalIntervalIteration(this, string, sCCInfo, iterationIntervalIter, iterationIntervalIter2, singletonSCCSolver, l, exportIterations);
        } else {
            modelCheckerResult = iterationMethod.doIntervalIteration(this, string, iterationIntervalIter, iterationIntervalIter2, intSet, l, exportIterations);
        }
        double d3 = PrismUtils.findMaxFinite(modelCheckerResult.soln, intSet.iterator());
        if (d3 != Double.NEGATIVE_INFINITY) {
            this.mainLog.println("Maximum finite value in solution vector at end of interval iteration: " + d3);
        }
        return modelCheckerResult;
    }

    protected ModelCheckerResult computeReachRewardsPolIter(MDP<Double> mDP, MDPRewards<Double> mDPRewards, BitSet bitSet, BitSet bitSet2, boolean bl, int[] nArray) throws PrismException {
        ModelCheckerResult modelCheckerResult;
        int n;
        boolean bl2 = true;
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting policy iteration (" + (bl ? "min" : "max") + ")...");
        DTMCModelChecker dTMCModelChecker = new DTMCModelChecker(this);
        dTMCModelChecker.inheritSettings(this);
        dTMCModelChecker.setLog(new PrismDevNullLog());
        int n2 = mDP.getNumStates();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray2[n] = bitSet.get(n) ? 0.0 : (bitSet2.get(n) ? Double.POSITIVE_INFINITY : 0.0);
            dArray[n] = dArray2[n];
        }
        if (nArray == null) {
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = 0;
            }
        }
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = false;
        while (!bl3 && n4 < this.maxIters) {
            ++n4;
            DTMCFromMDPMemorylessAdversary<Double> dTMCFromMDPMemorylessAdversary = new DTMCFromMDPMemorylessAdversary<Double>(mDP, nArray);
            MCRewardsFromMDPRewards<Double> mCRewardsFromMDPRewards = new MCRewardsFromMDPRewards<Double>(mDPRewards, nArray);
            modelCheckerResult = dTMCModelChecker.computeReachRewardsValIter(dTMCFromMDPMemorylessAdversary, mCRewardsFromMDPRewards, bitSet, bitSet2, (double[])(bl2 ? dArray : null), null);
            dArray = modelCheckerResult.soln;
            n3 += modelCheckerResult.numIters;
            mDP.mvMultRewMinMax(dArray, mDPRewards, bl, dArray2, null, false, null);
            bl3 = true;
            for (n = 0; n < n2; ++n) {
                if (bitSet.get(n) || bitSet2.get(n) || PrismUtils.doublesAreClose(dArray[n], dArray2[n], this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE)) continue;
                bl3 = false;
                List<Integer> list = mDP.mvMultRewMinMaxSingleChoices(n, dArray, mDPRewards, bl, dArray2[n]);
                if (list.contains(nArray[n])) continue;
                nArray[n] = list.get(0);
            }
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Policy iteration");
        this.mainLog.println(" took " + n4 + " cycles (" + n3 + " iterations in total) and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray;
        modelCheckerResult.numIters = n3;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public List<Integer> expReachStrategy(MDP<Double> mDP, MDPRewards<Double> mDPRewards, int n, BitSet bitSet, boolean bl, double[] dArray) throws PrismException {
        double d = mDP.mvMultRewMinMaxSingle(n, dArray, mDPRewards, bl, null);
        return mDP.mvMultRewMinMaxSingleChoices(n, dArray, mDPRewards, bl, d);
    }

    public <Value> void restrictStrategyToReachableStates(MDP<Value> mDP, int[] nArray) {
        int n2;
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        for (int n2 : mDP.getInitialStates()) {
            bitSet.set(n2);
            bitSet2.set(n2);
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            n2 = bitSet2.nextSetBit(0);
            while (n2 >= 0) {
                bitSet2.set(n2, false);
                if (nArray[n2] >= 0) {
                    Iterator<Map.Entry<Integer, Value>> iterator = mDP.getTransitionsIterator(n2, nArray[n2]);
                    while (iterator.hasNext()) {
                        Map.Entry<Integer, Value> entry = iterator.next();
                        int n3 = entry.getKey();
                        if (bitSet.get(n3)) continue;
                        bl = true;
                        bitSet.set(n3);
                        bitSet2.set(n3);
                    }
                }
                n2 = bitSet2.nextSetBit(n2 + 1);
            }
        }
        n2 = mDP.getNumStates();
        int n4 = bitSet.nextClearBit(0);
        while (n4 < n2) {
            nArray[n4] = -3;
            n4 = bitSet.nextClearBit(n4 + 1);
        }
    }

    private <Value> MDPEquiv<Value> maxQuotient(MDP<Value> mDP, BitSet bitSet, BitSet bitSet2) throws PrismException {
        BitSet bitSet3 = new BitSet();
        bitSet3.set(0, mDP.getNumStates());
        bitSet3.andNot(bitSet);
        bitSet3.andNot(bitSet2);
        ECComputer eCComputer = ECComputer.createECComputer(this, mDP);
        eCComputer.computeMECStates(bitSet3);
        List<BitSet> list = eCComputer.getMECStates();
        list.add(bitSet);
        list.add(bitSet2);
        EquivalenceRelationInteger equivalenceRelationInteger = new EquivalenceRelationInteger(list);
        BasicModelTransformation<MDP<Value>, MDPEquiv<Value>> basicModelTransformation = MDPEquiv.transformDroppingLoops(mDP, equivalenceRelationInteger);
        MDPEquiv<Value> mDPEquiv = basicModelTransformation.getTransformedModel();
        int n = mDPEquiv.getNumStates() - mDPEquiv.getNonRepresentativeStates().cardinality();
        this.mainLog.println("Max-Quotient MDP: " + n + " equivalence classes / non-trap states.");
        return mDPEquiv;
    }

    public static void main(String[] stringArray) {
        boolean bl = true;
        try {
            MDPModelChecker mDPModelChecker = new MDPModelChecker(null);
            MDPSimple<Double> mDPSimple = new MDPSimple<Double>();
            mDPSimple.buildFromPrismExplicit(stringArray[0]);
            mDPSimple.addInitialState(0);
            Map<String, BitSet> map = StateModelChecker.loadLabelsFile(stringArray[1]);
            BitSet bitSet = map.get("init");
            BitSet bitSet2 = map.get(stringArray[2]);
            if (bitSet2 == null) {
                throw new PrismException("Unknown label \"" + stringArray[2] + "\"");
            }
            for (int i = 3; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-min")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-max")) {
                    bl = false;
                    continue;
                }
                if (!stringArray[i].equals("-nopre")) continue;
                mDPModelChecker.setPrecomp(false);
            }
            ModelCheckerResult modelCheckerResult = mDPModelChecker.computeReachProbs(mDPSimple, bitSet2, bl);
            System.out.println(modelCheckerResult.soln[bitSet.nextSetBit(0)]);
        }
        catch (PrismException prismException) {
            System.out.println(prismException);
        }
    }
}

