/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import java.util.Arrays;
import prism.PrismException;

public class HyperplaneSelector {
    private double[][] y;
    private int[] exclude;
    private double start;
    private double step;
    private int CONJUNCTS;
    private int[] DISJUNCTS;

    public HyperplaneSelector(int n, int[] nArray) {
        this.CONJUNCTS = n;
        this.DISJUNCTS = nArray;
        this.start = 0.0;
        this.step = 1.0;
        this.init_next_hyperplane();
    }

    public double getStart() {
        return this.start;
    }

    public int[] getExclude() {
        int[] nArray = new int[this.exclude.length];
        System.arraycopy(this.exclude, 0, nArray, 0, this.exclude.length);
        return nArray;
    }

    private double[][] init_next_hyperplane() {
        this.exclude = new int[this.CONJUNCTS];
        double[][] dArrayArray = new double[this.CONJUNCTS][];
        for (int i = 0; i < this.CONJUNCTS; ++i) {
            dArrayArray[i] = new double[this.DISJUNCTS[i]];
            Arrays.fill(dArrayArray[i], 1.0 - this.start);
        }
        this.y = dArrayArray;
        return dArrayArray;
    }

    public double[][] next_hyperplane() throws PrismException {
        try {
            return this.next_hyperplane(this.y);
        }
        catch (PrismException prismException) {
            if (this.start > 0.0) {
                this.step = this.start;
                this.start /= 2.0;
            } else {
                this.step = 1.0;
                this.start = 0.5;
            }
            return this.init_next_hyperplane();
        }
    }

    private double[][] next_hyperplane(double[][] dArray) throws PrismException {
        int n;
        int n2 = 0;
        for (n = 0; n < dArray.length; ++n) {
            n2 += dArray[n].length;
        }
        n = 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = true;
        while (bl) {
            bl = false;
            if (this.exclude[n3] != n4) continue;
            ++n5;
            if (++n4 < dArray[n3].length) continue;
            n4 = 0;
            bl = true;
            if (++n3 < dArray.length) continue;
            this.exclude[0] = this.exclude[0] + 1;
            boolean bl2 = true;
            int n6 = 0;
            while (bl2) {
                bl2 = false;
                if (this.exclude[n6] < dArray[n6].length) continue;
                this.exclude[n6] = 0;
                if (++n6 >= dArray.length) {
                    throw new PrismException("Done iterating");
                }
                int n7 = n6;
                this.exclude[n7] = this.exclude[n7] + 1;
                bl2 = true;
            }
            return this.next_hyperplane(dArray);
        }
        while (n != 0) {
            n = 0;
            double[] dArray2 = dArray[n3];
            int n8 = n4;
            dArray2[n8] = dArray2[n8] - this.step;
            if (!(dArray[n3][n4] < -1.0E-8)) continue;
            n = 1;
            dArray[n3][n4] = 1.0 - this.start;
            ++n5;
            if (++n4 >= dArray[n3].length) {
                n4 = 0;
                if (++n3 >= dArray.length) {
                    this.exclude[0] = this.exclude[0] + 1;
                    boolean bl3 = true;
                    int n9 = 0;
                    while (bl3) {
                        bl3 = false;
                        if (this.exclude[n9] < dArray[n9].length) continue;
                        this.exclude[n9] = 0;
                        if (++n9 >= dArray.length) {
                            throw new PrismException("Done iterating");
                        }
                        int n10 = n9;
                        this.exclude[n10] = this.exclude[n10] + 1;
                        bl3 = true;
                    }
                    return this.next_hyperplane(dArray);
                }
            }
            bl = true;
            while (bl) {
                bl = false;
                if (this.exclude[n3] != n4) continue;
                ++n5;
                if (++n4 < dArray[n3].length) continue;
                n4 = 0;
                bl = true;
                if (++n3 < dArray.length) continue;
                this.exclude[0] = this.exclude[0] + 1;
                boolean bl4 = true;
                int n11 = 0;
                while (bl4) {
                    bl4 = false;
                    if (this.exclude[n11] < dArray[n11].length) continue;
                    this.exclude[n11] = 0;
                    if (++n11 >= dArray.length) {
                        throw new PrismException("Done iterating");
                    }
                    int n12 = n11;
                    this.exclude[n12] = this.exclude[n12] + 1;
                    bl4 = true;
                }
                return this.next_hyperplane(dArray);
            }
        }
        return dArray;
    }
}

