/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import java.util.Vector;
import prism.PrismException;

public final class FoxGlynn {
    private double underflow;
    private double overflow;
    private double accuracy;
    private double q_tmax;
    private int left;
    private int right;
    private double totalWeight;
    private double[] weights;

    public FoxGlynn(double d, double d2, double d3, double d4) throws PrismException {
        this.q_tmax = d;
        this.underflow = d2;
        this.overflow = d3;
        this.accuracy = d4;
        this.run();
    }

    public final double[] getWeights() {
        return this.weights;
    }

    public final int getLeftTruncationPoint() {
        return this.left;
    }

    public final int getRightTruncationPoint() {
        return this.right;
    }

    public final double getTotalWeight() {
        return this.totalWeight;
    }

    private final void run() throws PrismException {
        if (this.q_tmax == 0.0) {
            throw new PrismException("Overflow: TA parameter qtmax = time * maxExitRate = 0");
        }
        if (this.accuracy < 1.0E-10) {
            throw new PrismException("Overflow: Accuracy is smaller than Fox Glynn can handle (must be at least 1e-10)");
        }
        if (this.q_tmax < 400.0) {
            double d;
            double d2 = Math.exp(-this.q_tmax);
            double d3 = (1.0 - this.accuracy / 2.0) / d2;
            Vector<Double> vector = new Vector<Double>();
            double d4 = d = 1.0;
            vector.add(d * d2);
            int n = 1;
            do {
                vector.add(d * d2);
            } while ((d4 += (d *= this.q_tmax / (double)(++n))) < d3);
            this.left = 0;
            this.right = n - 1;
            this.weights = new double[n];
            for (int i = 0; i < vector.size(); ++i) {
                this.weights[i] = (Double)vector.get(i);
            }
            this.totalWeight = 1.0;
        } else {
            int n;
            double d;
            double d5;
            int n2 = (int)this.q_tmax;
            double d6 = Math.sqrt(this.q_tmax);
            double d7 = (1.0 + 1.0 / this.q_tmax) * Math.exp(0.0625) * 1.414213562373095;
            double d8 = (1.0 + 1.0 / this.q_tmax) * Math.exp(0.125 / this.q_tmax);
            double d9 = 1.0 / (2.82842712474619 * this.q_tmax);
            double d10 = d6 / 2.82842712474619;
            double d11 = d9;
            while (d11 <= d10 && !((d5 = d7 * (d = 1.0 / (1.0 - Math.exp(-0.2222222222222222 * (d11 * 1.414213562373095 * d6 + 1.5)))) * Math.exp(-d11 * d11 / 2.0) / (d11 * 1.414213562373095 * 1.772453850905516)) <= this.accuracy / 2.0)) {
                d11 = d11 == d9 ? d11 + 4.0 : d11 + 1.0;
            }
            if (d11 > d10) {
                d11 = d10;
            }
            this.right = (int)Math.ceil((double)n2 + d11 * 1.414213562373095 * d6 + 1.5);
            d11 = d = 1.0 / (1.414213562373095 * d6);
            do {
                d5 = d8 * Math.exp(-d11 * d11 / 2.0) / (d11 * 1.414213562373095 * 1.772453850905516);
                d11 += 1.0;
            } while (d5 > this.accuracy / 2.0);
            this.left = (int)((double)n2 - d11 * d6 - 1.5);
            double d12 = this.overflow / (1.0E10 * (double)(this.right - this.left));
            this.weights = new double[this.right - this.left + 1];
            this.weights[n2 - this.left] = d12;
            for (n = n2; n > this.left; --n) {
                this.weights[n - 1 - this.left] = (double)n / this.q_tmax * this.weights[n - this.left];
            }
            for (n = n2; n < this.right; ++n) {
                this.weights[n + 1 - this.left] = this.q_tmax / (double)(n + 1) * this.weights[n - this.left];
            }
            this.totalWeight = 0.0;
            n = this.left;
            int n3 = this.right;
            while (n < n3) {
                if (this.weights[n - this.left] <= this.weights[n3 - this.left]) {
                    this.totalWeight += this.weights[n - this.left];
                    ++n;
                    continue;
                }
                this.totalWeight += this.weights[n3 - this.left];
                --n3;
            }
            this.totalWeight += this.weights[n - this.left];
        }
    }

    public static void test() {
        double d = 0.0;
        FoxGlynn foxGlynn = null;
        try {
            double d2 = 1.0;
            double d3 = 1.0;
            foxGlynn = new FoxGlynn(d2 * d3, 1.0E-300, 1.0E300, 1.0E-6);
        }
        catch (PrismException prismException) {
            // empty catch block
        }
        double[] dArray = foxGlynn.getWeights();
        int n = foxGlynn.getLeftTruncationPoint();
        int n2 = foxGlynn.getRightTruncationPoint();
        d = foxGlynn.getTotalWeight();
        foxGlynn = null;
    }
}

