/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.iterable.ArrayIterator;
import common.iterable.FunctionalIterable;
import common.iterable.FunctionalPrimitiveIterable;
import java.util.Objects;

public abstract class IterableArray<E>
implements FunctionalIterable<E> {
    protected final int fromIndex;
    protected final int toIndex;

    protected IterableArray(int n, int n2, int n3) {
        Objects.checkFromToIndex(n, n2, n3);
        this.fromIndex = n;
        this.toIndex = n2;
    }

    @Override
    public long count() {
        return this.size();
    }

    @Override
    public abstract ArrayIterator<E> iterator();

    public int size() {
        return Math.max(0, this.toIndex - this.fromIndex);
    }

    public static class OfLong
    extends IterableArray<Long>
    implements FunctionalPrimitiveIterable.OfLong {
        protected final long[] elements;

        public OfLong(long ... lArray) {
            this(lArray, 0, lArray.length);
        }

        public OfLong(long[] lArray, int n, int n2) {
            super(n, n2, lArray.length);
            this.elements = lArray;
        }

        @Override
        public ArrayIterator.OfLong iterator() {
            return new ArrayIterator.OfLong(this.elements, this.fromIndex, this.toIndex);
        }
    }

    public static class OfDouble
    extends IterableArray<Double>
    implements FunctionalPrimitiveIterable.OfDouble {
        protected final double[] elements;

        public OfDouble(double ... dArray) {
            this(dArray, 0, dArray.length);
        }

        public OfDouble(double[] dArray, int n, int n2) {
            super(n, n2, dArray.length);
            this.elements = dArray;
        }

        @Override
        public ArrayIterator.OfDouble iterator() {
            return new ArrayIterator.OfDouble(this.elements, this.fromIndex, this.toIndex);
        }
    }

    public static class OfInt
    extends IterableArray<Integer>
    implements FunctionalPrimitiveIterable.OfInt {
        protected final int[] elements;

        public OfInt(int ... nArray) {
            this(nArray, 0, nArray.length);
        }

        public OfInt(int[] nArray, int n, int n2) {
            super(n, n2, nArray.length);
            this.elements = nArray;
        }

        @Override
        public ArrayIterator.OfInt iterator() {
            return new ArrayIterator.OfInt(this.elements, this.fromIndex, this.toIndex);
        }
    }

    public static class Of<E>
    extends IterableArray<E> {
        protected final E[] elements;

        @SafeVarargs
        public Of(E ... EArray) {
            this(EArray, 0, EArray.length);
        }

        public Of(E[] EArray, int n, int n2) {
            super(n, n2, EArray.length);
            this.elements = EArray;
        }

        @Override
        public ArrayIterator.Of<E> iterator() {
            return new ArrayIterator.Of<E>(this.elements, this.fromIndex, this.toIndex);
        }
    }
}

