/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.iterable.FunctionalIterable;
import common.iterable.FunctionalPrimitiveIterable;
import common.iterable.IteratorAdaptor;
import common.iterable.PrimitiveIterable;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;

public abstract class IterableAdaptor<E, I extends Iterable<E>>
implements FunctionalIterable<E> {
    protected final I iterable;

    public IterableAdaptor(I i) {
        Objects.requireNonNull(i);
        this.iterable = i;
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        this.iterable.forEach(consumer);
    }

    public static class OfLong
    extends IterableAdaptor<Long, PrimitiveIterable.OfLong>
    implements FunctionalPrimitiveIterable.OfLong {
        public OfLong(PrimitiveIterable.OfLong ofLong) {
            super(ofLong);
        }

        @Override
        public IteratorAdaptor.OfLong iterator() {
            return new IteratorAdaptor.OfLong(((PrimitiveIterable.OfLong)this.iterable).iterator());
        }

        @Override
        public void forEach(LongConsumer longConsumer) {
            ((PrimitiveIterable.OfLong)this.iterable).forEach(longConsumer);
        }
    }

    public static class OfInt
    extends IterableAdaptor<Integer, PrimitiveIterable.OfInt>
    implements FunctionalPrimitiveIterable.OfInt {
        public OfInt(PrimitiveIterable.OfInt ofInt) {
            super(ofInt);
        }

        @Override
        public IteratorAdaptor.OfInt iterator() {
            return new IteratorAdaptor.OfInt(((PrimitiveIterable.OfInt)this.iterable).iterator());
        }

        @Override
        public void forEach(IntConsumer intConsumer) {
            ((PrimitiveIterable.OfInt)this.iterable).forEach(intConsumer);
        }
    }

    public static class OfDouble
    extends IterableAdaptor<Double, PrimitiveIterable.OfDouble>
    implements FunctionalPrimitiveIterable.OfDouble {
        public OfDouble(PrimitiveIterable.OfDouble ofDouble) {
            super(ofDouble);
        }

        @Override
        public IteratorAdaptor.OfDouble iterator() {
            return new IteratorAdaptor.OfDouble(((PrimitiveIterable.OfDouble)this.iterable).iterator());
        }

        @Override
        public void forEach(DoubleConsumer doubleConsumer) {
            ((PrimitiveIterable.OfDouble)this.iterable).forEach(doubleConsumer);
        }
    }

    public static class Of<E>
    extends IterableAdaptor<E, Iterable<E>> {
        public Of(Iterable<E> iterable) {
            super(iterable);
        }

        @Override
        public IteratorAdaptor.Of<E> iterator() {
            return new IteratorAdaptor.Of(this.iterable.iterator());
        }
    }
}

