/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.CsvArgumentsProvider;
import org.junit.jupiter.params.provider.CsvFileSource;
import org.junit.jupiter.params.provider.CsvParserFactory;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvParser;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;

class CsvFileArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<CsvFileSource> {
    private final InputStreamProvider inputStreamProvider;
    private CsvFileSource annotation;
    private List<Source> sources;
    private Charset charset;
    private int numLinesToSkip;
    private CsvParser csvParser;

    CsvFileArgumentsProvider() {
        this(DefaultInputStreamProvider.INSTANCE);
    }

    CsvFileArgumentsProvider(InputStreamProvider inputStreamProvider) {
        this.inputStreamProvider = inputStreamProvider;
    }

    @Override
    public void accept(CsvFileSource annotation) {
        this.annotation = annotation;
        Stream<Source> resources = Arrays.stream(annotation.resources()).map(this.inputStreamProvider::classpathResource);
        Stream<Source> files = Arrays.stream(annotation.files()).map(this.inputStreamProvider::file);
        this.sources = Stream.concat(resources, files).collect(Collectors.toList());
        this.charset = this.getCharsetFrom(annotation);
        this.numLinesToSkip = annotation.numLinesToSkip();
        this.csvParser = CsvParserFactory.createParserFor(annotation);
    }

    private Charset getCharsetFrom(CsvFileSource annotation) {
        try {
            return Charset.forName(annotation.encoding());
        }
        catch (Exception ex) {
            throw new PreconditionViolationException("The charset supplied in " + annotation + " is invalid", ex);
        }
    }

    @Override
    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        return Preconditions.notEmpty(this.sources, "Resources or files must not be empty").stream().map(source -> source.open(context)).map(this::beginParsing).flatMap(this::toStream);
    }

    private CsvParser beginParsing(InputStream inputStream) {
        try {
            this.csvParser.beginParsing(inputStream, this.charset);
        }
        catch (Throwable throwable) {
            CsvArgumentsProvider.handleCsvException(throwable, this.annotation);
        }
        return this.csvParser;
    }

    private Stream<Arguments> toStream(CsvParser csvParser) {
        CsvParserIterator iterator = new CsvParserIterator(csvParser, this.annotation);
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).skip(this.numLinesToSkip).onClose(() -> {
            try {
                csvParser.stopParsing();
            }
            catch (Throwable throwable) {
                CsvArgumentsProvider.handleCsvException(throwable, this.annotation);
            }
        });
    }

    private static class DefaultInputStreamProvider
    implements InputStreamProvider {
        private static final DefaultInputStreamProvider INSTANCE = new DefaultInputStreamProvider();

        private DefaultInputStreamProvider() {
        }

        @Override
        public InputStream openClasspathResource(Class<?> baseClass, String path) {
            Preconditions.notBlank(path, () -> "Classpath resource [" + path + "] must not be null or blank");
            InputStream inputStream = baseClass.getResourceAsStream(path);
            return Preconditions.notNull(inputStream, () -> "Classpath resource [" + path + "] does not exist");
        }

        @Override
        public InputStream openFile(String path) {
            Preconditions.notBlank(path, () -> "File [" + path + "] must not be null or blank");
            try {
                return Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new JUnitException("File [" + path + "] could not be read", e);
            }
        }
    }

    static interface InputStreamProvider {
        public InputStream openClasspathResource(Class<?> var1, String var2);

        public InputStream openFile(String var1);

        default public Source classpathResource(String path) {
            return context -> this.openClasspathResource(context.getRequiredTestClass(), path);
        }

        default public Source file(String path) {
            return context -> this.openFile(path);
        }
    }

    private static interface Source {
        public InputStream open(ExtensionContext var1);
    }

    private static class CsvParserIterator
    implements Iterator<Arguments> {
        private final CsvParser csvParser;
        private final CsvFileSource annotation;
        private final Set<String> nullValues;
        private Object[] nextCsvRecord;

        CsvParserIterator(CsvParser csvParser, CsvFileSource annotation) {
            this.csvParser = csvParser;
            this.annotation = annotation;
            this.nullValues = CollectionUtils.toSet(annotation.nullValues());
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextCsvRecord != null;
        }

        @Override
        public Arguments next() {
            Arguments result = Arguments.arguments(this.nextCsvRecord);
            this.advance();
            return result;
        }

        private void advance() {
            String[] parsedLine = null;
            try {
                parsedLine = this.csvParser.parseNext();
                if (parsedLine != null && !this.nullValues.isEmpty()) {
                    for (int i2 = 0; i2 < parsedLine.length; ++i2) {
                        if (!this.nullValues.contains(parsedLine[i2])) continue;
                        parsedLine[i2] = null;
                    }
                }
            }
            catch (Throwable throwable) {
                CsvArgumentsProvider.handleCsvException(throwable, this.annotation);
            }
            this.nextCsvRecord = parsedLine;
        }
    }
}

