/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties.computation;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import parser.ast.Property;
import prism.ResultsCollection;
import prism.ResultsExporter;
import userinterface.properties.GUIExperiment;
import userinterface.properties.GUIMultiProperties;
import userinterface.util.GUIComputationEvent;

public class ExportResultsThread
extends Thread {
    private GUIMultiProperties parent;
    private GUIExperiment[] exps;
    private File file;
    private ResultsExporter.ResultsExportShape exportShape;

    public ExportResultsThread(GUIMultiProperties gUIMultiProperties, GUIExperiment gUIExperiment, File file) {
        this(gUIMultiProperties, new GUIExperiment[]{gUIExperiment}, file);
    }

    public ExportResultsThread(GUIMultiProperties gUIMultiProperties, GUIExperiment[] gUIExperimentArray, File file) {
        this(gUIMultiProperties, gUIExperimentArray, file, ResultsExporter.ResultsExportShape.LIST_PLAIN);
    }

    public ExportResultsThread(GUIMultiProperties gUIMultiProperties, GUIExperiment[] gUIExperimentArray, File file, ResultsExporter.ResultsExportShape resultsExportShape) {
        this.parent = gUIMultiProperties;
        this.exps = gUIExperimentArray;
        this.file = file;
        this.exportShape = resultsExportShape;
    }

    @Override
    public void run() {
        Object object;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExportResultsThread.this.parent.startProgress();
                ExportResultsThread.this.parent.notifyEventListeners(new GUIComputationEvent(0, ExportResultsThread.this.parent));
                ExportResultsThread.this.parent.setTaskBarText("Exporting results...");
            }
        });
        List<Property> list = Arrays.stream(this.exps).map(GUIExperiment::getProperty).collect(Collectors.toList());
        List<ResultsCollection> list2 = Arrays.stream(this.exps).map(GUIExperiment::getResults).collect(Collectors.toList());
        Object object2 = null;
        try {
            this.file.createNewFile();
            object = new PrintWriter(this.file);
            this.exportShape.getExporter().printResults(list2, list, (PrintWriter)object);
            ((PrintWriter)object).close();
            if (((PrintWriter)object).checkError()) {
                object2 = "Could not export results: unknown IO exception";
            }
        }
        catch (IOException iOException) {
            object2 = "Could not export results: " + iOException.getMessage();
        }
        if (object2 != null) {
            object = object2;
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ String val$msg;
                {
                    this.val$msg = string;
                }

                @Override
                public void run() {
                    ExportResultsThread.this.parent.stopProgress();
                    ExportResultsThread.this.parent.setTaskBarText("Exporting results... error.");
                    ExportResultsThread.this.parent.notifyEventListeners(new GUIComputationEvent(2, ExportResultsThread.this.parent));
                    ExportResultsThread.this.parent.error("Could not export results: " + this.val$msg);
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExportResultsThread.this.parent.stopProgress();
                ExportResultsThread.this.parent.setTaskBarText("Exporting results... done.");
                ExportResultsThread.this.parent.notifyEventListeners(new GUIComputationEvent(1, ExportResultsThread.this.parent));
            }
        });
    }
}

