/*
 * Decompiled with CFR 0.152.
 */
package userinterface.log;

import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import prism.PrismLog;

public class GUIVisualLogModel
extends PrismLog {
    public static final int NORMAL = 1;
    public static final int TIMING = 2;
    public static final int MEMORY = 4;
    public static final int ERROR = 8;
    public static final int DETAILS = 16;
    private int enabled;
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root");
    private DefaultMutableTreeNode current;
    private String buffer;
    private Stack theStack;
    private int currentIndent = 0;
    private DefaultTreeModel theModel = new DefaultTreeModel(this.root);

    public GUIVisualLogModel() {
        this.theStack = new Stack();
        this.theStack.push(this.root);
        this.buffer = "";
        this.current = null;
        this.enabled = 31;
    }

    public void indent() {
        try {
            this.theStack.push(this.current);
            ++this.currentIndent;
            this.current = null;
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Attempt to indent failed because no nodes on current level.");
        }
    }

    public void unIndent() {
        try {
            if (this.currentIndent > 0) {
                this.theStack.pop();
                --this.currentIndent;
                this.current = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setIndent(int n) {
        if (n <= this.currentIndent + 1) {
            if (n == this.currentIndent + 1) {
                this.indent();
            } else {
                if (n == this.currentIndent) {
                    return;
                }
                if (n >= 0) {
                    for (int i = this.currentIndent; i >= n + 1; --i) {
                        this.unIndent();
                    }
                }
            }
        }
    }

    public int getIndent() {
        return this.currentIndent;
    }

    public void enableType(int n) {
        this.enabled |= n;
    }

    public void disableType(int n) {
        this.enabled &= ~n;
    }

    public void println(int n, String string) {
        this.print(n, string);
        this.newLine();
    }

    public void print(int n, String string) {
        if ((this.enabled & n) != 0) {
            this.buffer = this.buffer + string;
        }
    }

    public void newLine() {
        if (!this.buffer.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.buffer, "\n");
            int n = stringTokenizer.countTokens();
            for (int i = 0; i < n; ++i) {
                String string = stringTokenizer.nextToken();
                this.current = new DefaultMutableTreeNode(string);
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.theStack.peek();
                SwingUtilities.invokeLater(new AddLogEntry(this.current, defaultMutableTreeNode));
            }
        }
        this.buffer = "";
    }

    public DefaultTreeModel getTheModel() {
        return this.theModel;
    }

    @Override
    public boolean ready() {
        return true;
    }

    @Override
    public long getFilePointer() {
        return -1L;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public void print(long l) {
        this.print(1, "" + l);
    }

    @Override
    public void print(int n) {
        this.print(1, "" + n);
    }

    @Override
    public void print(boolean bl) {
        this.print(1, "" + bl);
    }

    @Override
    public void print(char c) {
        this.print(1, "" + c);
    }

    @Override
    public void print(float f) {
        this.print(1, "" + f);
    }

    @Override
    public void print(double d) {
        this.print(1, "" + d);
    }

    @Override
    public void print(Object object) {
        this.print(1, String.valueOf(object));
    }

    @Override
    public void print(String string) {
        this.print(1, string);
    }

    @Override
    public void print(double[] dArray) {
        this.print(1, String.valueOf(dArray));
    }

    @Override
    public void println() {
        this.println(1, "");
    }

    class AddLogEntry
    extends Thread {
        private DefaultMutableTreeNode node;
        private DefaultMutableTreeNode parentOfNode;

        public AddLogEntry(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
            this.node = defaultMutableTreeNode;
            this.parentOfNode = defaultMutableTreeNode2;
        }

        @Override
        public void run() {
            GUIVisualLogModel.this.theModel.insertNodeInto(this.node, this.parentOfNode, this.parentOfNode.getChildCount());
        }
    }
}

