/*
 * Decompiled with CFR 0.152.
 */
package userinterface.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.data.xy.XYDataItem;
import userinterface.GUIPlugin;
import userinterface.GUIPrism;
import userinterface.graph.Graph;
import userinterface.graph.PrismXYSeries;
import userinterface.graph.SeriesSettings;

public class SeriesEditorDialog
extends JDialog {
    private Action okAction;
    private Action cancelAction;
    private GUIPrism gui;
    private List<SeriesEditor> editors;
    private boolean cancelled;
    private JPanel allPanel;
    private JPanel bottomPanel;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel editorPanel;
    private JButton okayButton;
    private JTabbedPane tabbedPane;
    private JToolBar toolBar;
    private GUIPlugin plugin;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeSeriesEditor(GUIPlugin gUIPlugin, JFrame jFrame, Graph graph, List<Graph.SeriesKey> list) {
        if (graph.getXAxisSettings().isLogarithmic() || graph.getYAxisSettings().isLogarithmic()) {
            gUIPlugin.message("One of your axes has a logarithmic scale. When a logarithmic scale is active we temporarily \nhide negative and zero values. For this reason it is not safe to edit values when either of \nyour axes is logarithmic. Please select numerical axes and switch back later.");
            return;
        }
        Object object = graph.getSeriesLock();
        synchronized (object) {
            SeriesEditorDialog seriesEditorDialog = new SeriesEditorDialog(gUIPlugin, jFrame, graph, list);
            seriesEditorDialog.setVisible(true);
        }
    }

    private SeriesEditorDialog(GUIPlugin gUIPlugin, JFrame jFrame, Graph graph, List<Graph.SeriesKey> list) {
        super(jFrame, "Graph Series Editor", true);
        this.plugin = gUIPlugin;
        this.editors = new ArrayList<SeriesEditor>();
        this.initComponents();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((SeriesEditor)SeriesEditorDialog.this.editors.get(SeriesEditorDialog.this.tabbedPane.getSelectedIndex())).cut();
            }
        };
        abstractAction.putValue("LongDescription", "Cut the current selection to the clipboard");
        abstractAction.putValue("Name", "Cut");
        abstractAction.putValue("SmallIcon", GUIPrism.getIconFromImage("smallCut.png"));
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((SeriesEditor)SeriesEditorDialog.this.editors.get(SeriesEditorDialog.this.tabbedPane.getSelectedIndex())).copy();
            }
        };
        abstractAction2.putValue("LongDescription", "Copies the current selection to the clipboard");
        abstractAction2.putValue("Name", "Copy");
        abstractAction2.putValue("SmallIcon", GUIPrism.getIconFromImage("smallCopy.png"));
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((SeriesEditor)SeriesEditorDialog.this.editors.get(SeriesEditorDialog.this.tabbedPane.getSelectedIndex())).paste();
            }
        };
        abstractAction3.putValue("LongDescription", "Pastes the clipboard to the current selection");
        abstractAction3.putValue("Name", "Paste");
        abstractAction3.putValue("SmallIcon", GUIPrism.getIconFromImage("smallPaste.png"));
        AbstractAction abstractAction4 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((SeriesEditor)SeriesEditorDialog.this.editors.get(SeriesEditorDialog.this.tabbedPane.getSelectedIndex())).delete();
            }
        };
        abstractAction4.putValue("LongDescription", "Deletes the current");
        abstractAction4.putValue("Name", "Delete");
        abstractAction4.putValue("SmallIcon", GUIPrism.getIconFromImage("smallDelete.png"));
        for (Graph.SeriesKey seriesKey : list) {
            SeriesSettings seriesSettings = graph.getGraphSeries(seriesKey);
            PrismXYSeries prismXYSeries = (PrismXYSeries)graph.getXYSeries(seriesKey);
            SeriesEditor seriesEditor = new SeriesEditor(graph, prismXYSeries, seriesSettings, abstractAction, abstractAction2, abstractAction3, abstractAction4);
            seriesEditor.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.tabbedPane.addTab(seriesSettings.getSeriesHeading(), seriesEditor);
            this.editors.add(seriesEditor);
        }
        this.getRootPane().setDefaultButton(this.okayButton);
        this.toolBar.add(abstractAction);
        this.toolBar.add(abstractAction2);
        this.toolBar.add(abstractAction3);
        this.toolBar.add(abstractAction4);
        this.add((Component)this.toolBar, "North");
        this.cancelled = false;
        super.setBounds(new Rectangle(550, 300));
        this.setResizable(true);
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.allPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.okayButton = new JButton();
        this.cancelButton = new JButton();
        this.editorPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.toolBar = new JToolBar();
        this.setDefaultCloseOperation(2);
        this.setTitle("Series Data Editor");
        this.setAlwaysOnTop(true);
        this.setMinimumSize(new Dimension(550, 350));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SeriesEditorDialog.this.closeDialog(windowEvent);
            }
        });
        this.allPanel.setLayout(new BorderLayout());
        this.allPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.bottomPanel.setLayout(new BorderLayout());
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.okayButton.setText("Okay");
        this.okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SeriesEditorDialog.this.okayButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.okayButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SeriesEditorDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.bottomPanel.add((Component)this.buttonPanel, "East");
        this.allPanel.add((Component)this.bottomPanel, "South");
        this.editorPanel.setLayout(new BorderLayout());
        this.tabbedPane.setTabPlacement(3);
        this.editorPanel.add((Component)this.tabbedPane, "Center");
        this.allPanel.add((Component)this.editorPanel, "Center");
        this.toolBar.setFloatable(false);
        this.allPanel.add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.allPanel, "Center");
    }

    private void okayButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private class SeriesEditor
    extends JPanel
    implements ActionListener {
        private int bufferSize = 30;
        private List<Double> xAxisBuffer;
        private List<Double> yAxisBuffer;
        private Graph graph;
        private SeriesSettings settings;
        private PrismXYSeries xySeries;
        private AbstractTableModel tableModel;
        private JTable table;

        private SeriesEditor(Graph graph, PrismXYSeries prismXYSeries, SeriesSettings seriesSettings, Action action, Action action2, Action action3, Action action4) {
            super.setLayout(new BorderLayout());
            this.graph = graph;
            this.settings = seriesSettings;
            this.xySeries = prismXYSeries;
            this.xAxisBuffer = new ArrayList<Double>(this.bufferSize);
            this.yAxisBuffer = new ArrayList<Double>(this.bufferSize);
            for (int i = 0; i < this.bufferSize; ++i) {
                this.xAxisBuffer.add(null);
                this.yAxisBuffer.add(null);
            }
            this.xySeries.addChangeListener(new SeriesChangeListener(){

                public void seriesChanged(SeriesChangeEvent seriesChangeEvent) {
                    SeriesEditor.this.tableModel.fireTableStructureChanged();
                }
            });
            this.tableModel = new AbstractTableModel(){

                @Override
                public int getColumnCount() {
                    return 2;
                }

                @Override
                public int getRowCount() {
                    return SeriesEditor.this.xySeries.getItemCount() + SeriesEditor.this.bufferSize;
                }

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return true;
                }

                @Override
                public Object getValueAt(int n, int n2) {
                    if (n >= SeriesEditor.this.xySeries.getItemCount()) {
                        int n3 = n - SeriesEditor.this.xySeries.getItemCount();
                        Double d = n2 == 0 ? (Double)SeriesEditor.this.xAxisBuffer.get(n3) : (Double)SeriesEditor.this.yAxisBuffer.get(n3);
                        return d == null ? "" : d;
                    }
                    XYDataItem xYDataItem = SeriesEditor.this.xySeries.getDataItem(n);
                    if (n2 == 0) {
                        return xYDataItem.getX();
                    }
                    return xYDataItem.getY();
                }

                @Override
                public String getColumnName(int n) {
                    if (n == 0) {
                        return SeriesEditor.this.graph.getXAxisSettings().getHeading();
                    }
                    return SeriesEditor.this.graph.getYAxisSettings().getHeading();
                }

                @Override
                public void setValueAt(Object object, int n, int n2) {
                    Double d = Double.NaN;
                    try {
                        d = Double.parseDouble(object.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (object.toString().trim().equals("")) {
                        d = null;
                    }
                    if (n >= SeriesEditor.this.xySeries.getItemCount()) {
                        Double d2;
                        int n3 = n - SeriesEditor.this.xySeries.getItemCount();
                        if (n2 == 0) {
                            SeriesEditor.this.xAxisBuffer.set(n3, d);
                        } else {
                            SeriesEditor.this.yAxisBuffer.set(n3, d);
                        }
                        Double d3 = d2 = n2 == 0 ? (Double)SeriesEditor.this.yAxisBuffer.get(n3) : (Double)SeriesEditor.this.xAxisBuffer.get(n3);
                        if (!(d == null || d2 == null || n2 == 0 && Double.isNaN(d) || n2 == 1 && d2.isNaN())) {
                            SeriesEditor.this.clearBufferRow(n3);
                            if (n2 == 0) {
                                SeriesEditor.this.xySeries.addOrUpdate((double)d, d2);
                            } else {
                                SeriesEditor.this.xySeries.addOrUpdate(d2, (double)d);
                            }
                        }
                    } else {
                        XYDataItem xYDataItem = SeriesEditor.this.xySeries.getDataItem(n);
                        if (d == null) {
                            d = Double.NaN;
                        }
                        if (n2 == 0) {
                            Object[] objectArray;
                            if (Double.isNaN(d)) {
                                objectArray = new Object[]{"Yes", "No"};
                                if (SeriesEditorDialog.this.plugin.question("Invalid value", "You have entered an invalid value on the x-axis. This \nwill result in deleting the datapoint. Do you want to continue?", objectArray, 1) == 1) {
                                    return;
                                }
                            }
                            objectArray = Double.valueOf(SeriesEditor.this.xySeries.getY(n).doubleValue());
                            SeriesEditor.this.xySeries.remove(n);
                            SeriesEditor.this.xySeries.addOrUpdate((double)d, (Number)objectArray);
                        } else {
                            SeriesEditor.this.xySeries.updateByIndex(n, d);
                        }
                    }
                    this.fireTableStructureChanged();
                }
            };
            this.table = new JTable(this.tableModel);
            InputMap inputMap = this.table.getInputMap();
            ActionMap actionMap = this.table.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "cut");
            inputMap.put(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "copy");
            inputMap.put(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "paste");
            inputMap.put(KeyStroke.getKeyStroke(127, 0), "delete");
            actionMap.put("cut", action);
            actionMap.put("copy", action2);
            actionMap.put("paste", action3);
            actionMap.put("delete", action4);
            this.table.getSelectionModel().setSelectionMode(1);
            this.table.setRowSelectionAllowed(true);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this.table);
            this.add((Component)jScrollPane, "Center");
        }

        public void addBufferRow() {
            this.xAxisBuffer.add(null);
            this.yAxisBuffer.add(null);
            ++this.bufferSize;
            this.tableModel.fireTableStructureChanged();
        }

        public boolean isBufferRow(int n) {
            return n >= this.xySeries.getItemCount();
        }

        public boolean isClearBufferRow(int n) {
            int n2 = n - this.xySeries.getItemCount();
            return this.isBufferRow(n) && this.xAxisBuffer.get(n2) == null && this.yAxisBuffer.get(n2) == null;
        }

        public void clearBufferRow(int n) {
            this.xAxisBuffer.set(n, null);
            this.yAxisBuffer.set(n, null);
            this.tableModel.fireTableStructureChanged();
        }

        public int firstClearBufferIndex() {
            for (int i = 0; i < this.bufferSize; ++i) {
                if (!this.isClearBufferRow(i + this.xySeries.getItemCount())) continue;
                return i + this.xySeries.getItemCount();
            }
            this.addBufferRow();
            return this.bufferSize + this.xySeries.getItemCount() - 1;
        }

        public void cut() {
            this.copy();
            this.delete();
        }

        public void copy() {
            int[] nArray = this.table.getSelectedRows();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n < this.xySeries.getItemCount()) {
                    XYDataItem xYDataItem = this.xySeries.getDataItem(n);
                    stringBuffer.append(String.valueOf(xYDataItem.getX()) + "\t" + String.valueOf(xYDataItem.getY()) + "\n");
                    continue;
                }
                int n2 = n - this.xySeries.getItemCount();
                String string = this.xAxisBuffer.get(n2) == null ? "" : this.xAxisBuffer.get(n2).toString();
                String string2 = this.yAxisBuffer.get(n2) == null ? "" : this.yAxisBuffer.get(n2).toString();
                stringBuffer.append(string + "\t" + string2 + "\n");
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(stringBuffer.toString());
            clipboard.setContents(stringSelection, null);
        }

        public void paste() {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(null);
            int[] nArray = this.table.getSelectedRows();
            int n = -1;
            if (nArray.length > 0 && this.isBufferRow(nArray[0])) {
                n = nArray[0];
            }
            try {
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        int n2 = string2.indexOf("\t");
                        if (n2 == -1) continue;
                        String string3 = string2.substring(0, n2).trim();
                        String string4 = string2.substring(n2, string2.length()).trim();
                        int n3 = n == -1 ? this.firstClearBufferIndex() : n;
                        this.tableModel.setValueAt("", n3, 0);
                        this.tableModel.setValueAt("", n3, 1);
                        this.tableModel.setValueAt(string3, n3, 0);
                        this.tableModel.setValueAt(string4, n3, 1);
                        if (n == -1 || ++n < this.tableModel.getRowCount()) continue;
                        this.addBufferRow();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void delete() {
            int[] nArray = this.table.getSelectedRows();
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n = nArray[i];
                if (n >= this.xySeries.getItemCount()) {
                    this.clearBufferRow(n - this.xySeries.getItemCount());
                    continue;
                }
                this.xySeries.remove(n);
            }
        }

        public SeriesSettings getSettings() {
            return this.settings;
        }

        public void setSettings(SeriesSettings seriesSettings) {
            this.settings = seriesSettings;
        }

        public PrismXYSeries getXySeries() {
            return this.xySeries;
        }

        public void setXySeries(PrismXYSeries prismXYSeries) {
            this.xySeries = prismXYSeries;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println(actionEvent);
            if (actionEvent.getActionCommand().equals("cut")) {
                this.cut();
            } else if (actionEvent.getActionCommand().equals("copy")) {
                this.copy();
            } else if (actionEvent.getActionCommand().equals("paste")) {
                this.paste();
            } else if (actionEvent.getActionCommand().equals("delete")) {
                this.delete();
            }
        }
    }
}

