/*
 * Decompiled with CFR 0.152.
 */
package userinterface.graph;

import java.util.LinkedList;
import java.util.List;
import org.jfree.data.general.SeriesException;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;

public class PrismXYSeries
extends XYSeries {
    private boolean logXAxis = false;
    private boolean logYAxis = false;
    private XYSeries discardedItems = new XYSeries((Comparable)((Object)"dummy"), true, false);

    public PrismXYSeries(Comparable comparable) {
        super(comparable, true, false);
    }

    private boolean checkValidity(XYDataItem xYDataItem) {
        if (Double.isInfinite(xYDataItem.getX().doubleValue()) || Double.isNaN(xYDataItem.getX().doubleValue())) {
            return false;
        }
        if (Double.isInfinite(xYDataItem.getY().doubleValue())) {
            xYDataItem.setY(Double.NaN);
        }
        return true;
    }

    public void setLogarithmicDomainAxis(boolean bl) {
        if (this.logXAxis != bl) {
            this.logXAxis = bl;
        }
        this.checkData();
    }

    public void setLogarithmicRangeAxis(boolean bl) {
        if (this.logYAxis != bl) {
            this.logYAxis = bl;
        }
        this.checkData();
    }

    public void add(double d, double d2) {
        this.add((Number)d, (Number)d2, true);
    }

    public void add(double d, double d2, boolean bl) {
        this.add((Number)d, (Number)d2, bl);
    }

    public void add(double d, Number number) {
        this.add((Number)d, number);
    }

    public void add(double d, Number number, boolean bl) {
        this.add((Number)d, number, bl);
    }

    public void add(Number number, Number number2) {
        this.add(number, number2, true);
    }

    public void add(Number number, Number number2, boolean bl) {
        XYDataItem xYDataItem = new XYDataItem(number, number2);
        this.add(xYDataItem, bl);
    }

    public void add(XYDataItem xYDataItem) {
        this.add(xYDataItem, true);
    }

    public void add(XYDataItem xYDataItem, boolean bl) {
        if (this.checkValidity(xYDataItem)) {
            if (this.checkDataItem(xYDataItem)) {
                if (this.discardedItems.indexOf(xYDataItem.getX()) >= 0) {
                    throw new SeriesException("X-value already exists.");
                }
                super.add(xYDataItem, bl);
            } else {
                if (super.indexOf(xYDataItem.getX()) >= 0) {
                    throw new SeriesException("X-value already exists.");
                }
                this.discardedItems.add(xYDataItem);
            }
        }
    }

    public XYDataItem addOrUpdate(Number number, Number number2) {
        XYDataItem xYDataItem = new XYDataItem(number, number2);
        XYDataItem xYDataItem2 = null;
        if (this.checkValidity(xYDataItem)) {
            int n = this.discardedItems.indexOf(xYDataItem.getX());
            int n2 = super.indexOf(xYDataItem.getX());
            if (n >= 0) {
                xYDataItem2 = this.discardedItems.remove(n);
            }
            if (n2 >= 0) {
                xYDataItem2 = super.remove(n2);
            }
            this.add(xYDataItem, true);
            return null;
        }
        return null;
    }

    public void update(int n, Number number) {
        this.updateByIndex(n, number);
    }

    public void update(Number number, Number number2) {
        XYDataItem xYDataItem = new XYDataItem(number, number2);
        XYDataItem xYDataItem2 = null;
        if (this.checkValidity(xYDataItem)) {
            int n = this.discardedItems.indexOf(xYDataItem.getX());
            int n2 = super.indexOf(xYDataItem.getX());
            if (n >= 0) {
                xYDataItem2 = this.discardedItems.remove(n);
            }
            if (n2 >= 0) {
                xYDataItem2 = super.remove(n2);
            }
            if (xYDataItem2 != null) {
                this.add(xYDataItem, true);
            } else {
                throw new SeriesException("No observation for x = " + String.valueOf(number));
            }
        }
    }

    public void updateByIndex(int n, Number number) {
        XYDataItem xYDataItem = this.getDataItem(n);
        XYDataItem xYDataItem2 = new XYDataItem(xYDataItem.getX(), number);
        if (this.checkValidity(xYDataItem2)) {
            if (this.checkDataItem(xYDataItem2)) {
                super.update(n, number);
            } else {
                super.remove(n);
                this.discardedItems.add(xYDataItem2);
            }
        }
    }

    private void checkData() {
        XYDataItem xYDataItem;
        boolean bl = false;
        int n = 0;
        while (n < this.discardedItems.getItemCount()) {
            xYDataItem = this.discardedItems.getDataItem(n);
            if (this.checkDataItem(xYDataItem)) {
                this.discardedItems.remove(n);
                super.add(xYDataItem);
                bl = true;
                continue;
            }
            ++n;
        }
        n = 0;
        while (n < super.getItemCount()) {
            xYDataItem = super.getDataItem(n);
            if (!this.checkDataItem(xYDataItem)) {
                super.remove(n);
                this.discardedItems.add(xYDataItem);
                bl = true;
                continue;
            }
            ++n;
        }
        if (bl && super.getNotify()) {
            this.fireSeriesChanged();
        }
    }

    public XYDataItem getDataItem(int n) {
        XYDataItem xYDataItem = super.getDataItem(n);
        if (this.logYAxis && xYDataItem.getY().doubleValue() <= 0.0) {
            return new XYDataItem(xYDataItem.getX(), (Number)Double.NaN);
        }
        return xYDataItem;
    }

    public List getItems() {
        LinkedList<XYDataItem> linkedList = new LinkedList<XYDataItem>();
        for (int i = 0; i < this.getItemCount(); ++i) {
            XYDataItem xYDataItem = super.getDataItem(i);
            if (this.logYAxis && xYDataItem.getY().doubleValue() <= 0.0) {
                linkedList.add(new XYDataItem(xYDataItem.getX(), (Number)Double.NaN));
                continue;
            }
            linkedList.add(new XYDataItem(xYDataItem.getX(), xYDataItem.getY()));
        }
        return linkedList;
    }

    public Number getY(int n) {
        Number number = super.getY(n);
        if (this.logYAxis && number.doubleValue() <= 0.0) {
            return Double.NaN;
        }
        return number;
    }

    public XYDataItem remove(Number number) {
        XYDataItem xYDataItem = null;
        int n = this.discardedItems.indexOf(number);
        int n2 = super.indexOf(number);
        if (n >= 0) {
            xYDataItem = this.discardedItems.remove(n);
        }
        if (n2 >= 0) {
            xYDataItem = super.remove(n2);
        }
        return xYDataItem;
    }

    private boolean checkDataItem(XYDataItem xYDataItem) {
        if (this.logXAxis && xYDataItem.getX().doubleValue() <= 0.0) {
            return false;
        }
        if (this.logYAxis && xYDataItem.getY().doubleValue() <= 0.0) {
            return true;
        }
        return true;
    }
}

