/*
 * Decompiled with CFR 0.152.
 */
package userinterface.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import settings.SettingOwner;
import settings.SettingTable;
import userinterface.GUIPlugin;
import userinterface.GUIPrism;
import userinterface.graph.AxisSettings;
import userinterface.graph.DisplaySettings;
import userinterface.graph.Graph;
import userinterface.graph.SeriesEditorDialog;
import userinterface.graph.SeriesSettings;
import userinterface.graph.SeriesSettingsList;

public class GraphOptionsPanel
extends JPanel
implements ListSelectionListener {
    private SettingTable graphPropertiesTable;
    private SettingTable axisPropertiesTable;
    private SettingTable displayPropertiesTable;
    private SettingTable seriesPropertiesTable;
    private JList seriesList;
    private JList axesList;
    private Graph theModel;
    private AxisSettings xAxisSettings;
    private AxisSettings yAxisSettings;
    private DisplaySettings displaySettings;
    private JFrame parent;
    private GUIPlugin plugin;
    private JButton addSeries;
    private JPanel axesBottomPanel;
    private JPanel axesInnerListPanel;
    private JPanel axesInnerTopPanel;
    private JLabel axesLabel;
    private JPanel axesListPanel;
    private JScrollPane axesListScrollPane;
    private JSplitPane axesOptionPanelSplitPane;
    private JPanel axesTopPanel;
    private JPanel axisOptionsPanel;
    private JPanel displayOptionsPanel;
    private JPanel graphOptionsPanel;
    private JPanel innerAxesOptionsPanel;
    private JPanel innerDisplayOptionsPanel;
    private JPanel innerGraphOptionsPanel;
    private JButton moveDown;
    private JButton moveUp;
    private JButton removeSeries;
    private JPanel seriesBottomPanel;
    private JPanel seriesButtonPanel;
    private JPanel seriesInnerListPanel;
    private JPanel seriesInnerTopPanel;
    private JLabel seriesLabel;
    private JPanel seriesListPanel;
    private JScrollPane seriesListScrollPane;
    private JSplitPane seriesOptionPanelSplitPane;
    private JPanel seriesOptionsPanel;
    private JPanel seriesTopPanel;
    private JButton viewData;

    public GraphOptionsPanel(GUIPlugin gUIPlugin, JFrame jFrame, Graph graph) {
        this.plugin = gUIPlugin;
        this.parent = jFrame;
        this.theModel = graph;
        ArrayList<SettingOwner> arrayList = new ArrayList<SettingOwner>();
        arrayList.add(graph);
        this.graphPropertiesTable = new SettingTable(jFrame);
        this.graphPropertiesTable.setOwners(arrayList);
        graph.setDisplay(this.graphPropertiesTable);
        this.xAxisSettings = graph.getXAxisSettings();
        this.yAxisSettings = graph.getYAxisSettings();
        this.displaySettings = graph.getDisplaySettings();
        String[] stringArray = new String[]{"x-Axis", "y-Axis"};
        this.axesList = new JList<String>(stringArray);
        this.axesList.setSelectedIndex(0);
        this.axesList.addListSelectionListener(this);
        arrayList = new ArrayList();
        arrayList.add(this.xAxisSettings);
        this.axisPropertiesTable = new SettingTable(jFrame);
        this.axisPropertiesTable.setOwners(arrayList);
        this.xAxisSettings.setDisplay(this.axisPropertiesTable);
        this.yAxisSettings.setDisplay(this.axisPropertiesTable);
        arrayList = new ArrayList();
        arrayList.add(this.displaySettings);
        this.displayPropertiesTable = new SettingTable(jFrame);
        this.displayPropertiesTable.setOwners(arrayList);
        this.displaySettings.setDisplay(this.displayPropertiesTable);
        this.seriesList = new JList(graph.getGraphSeriesList());
        this.seriesList.addListSelectionListener(this);
        this.seriesList.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = new JLabel(object == null ? "undefined" : object.toString());
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new FlowLayout(0, 5, 0));
                if (bl) {
                    jPanel.setBackground(jList.getSelectionBackground());
                    jPanel.setForeground(jList.getSelectionForeground());
                } else {
                    jPanel.setBackground(jList.getBackground());
                    jPanel.setForeground(jList.getForeground());
                }
                if (object instanceof SeriesSettings) {
                    SeriesSettings seriesSettings = (SeriesSettings)object;
                    jPanel.add(seriesSettings.getIcon());
                }
                jPanel.add(jLabel);
                return jPanel;
            }
        });
        this.seriesPropertiesTable = new SettingTable(jFrame);
        this.initComponents();
    }

    public void stopEditors() {
        this.graphPropertiesTable.stopEditing();
        this.axisPropertiesTable.stopEditing();
        this.seriesPropertiesTable.stopEditing();
        this.displayPropertiesTable.stopEditing();
    }

    private void initComponents() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.graphOptionsPanel = new JPanel();
        this.innerGraphOptionsPanel = new JPanel();
        this.axisOptionsPanel = new JPanel();
        this.innerAxesOptionsPanel = new JPanel();
        this.axesOptionPanelSplitPane = new JSplitPane();
        this.axesTopPanel = new JPanel();
        this.axesInnerTopPanel = new JPanel();
        this.axesLabel = new JLabel();
        this.axesListPanel = new JPanel();
        this.axesInnerListPanel = new JPanel();
        this.axesListScrollPane = new JScrollPane();
        this.axesBottomPanel = new JPanel();
        this.seriesOptionsPanel = new JPanel();
        this.seriesOptionPanelSplitPane = new JSplitPane();
        this.seriesTopPanel = new JPanel();
        this.seriesInnerTopPanel = new JPanel();
        this.seriesLabel = new JLabel();
        this.seriesListPanel = new JPanel();
        this.seriesInnerListPanel = new JPanel();
        this.seriesListScrollPane = new JScrollPane();
        this.seriesButtonPanel = new JPanel();
        this.addSeries = new JButton();
        this.removeSeries = new JButton();
        this.moveUp = new JButton();
        this.moveDown = new JButton();
        this.viewData = new JButton();
        this.seriesBottomPanel = new JPanel();
        this.displayOptionsPanel = new JPanel();
        this.innerDisplayOptionsPanel = new JPanel();
        this.setLayout(new BorderLayout());
        jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                GraphOptionsPanel.this.tabbedPanelStateChanged(changeEvent);
            }
        });
        this.graphOptionsPanel.setLayout(new BorderLayout());
        this.graphOptionsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.innerGraphOptionsPanel.setLayout(new BorderLayout());
        this.innerGraphOptionsPanel.add((Component)this.graphPropertiesTable, "Center");
        this.graphOptionsPanel.add((Component)this.innerGraphOptionsPanel, "Center");
        jTabbedPane.addTab("Graph", this.graphOptionsPanel);
        this.axisOptionsPanel.setLayout(new BorderLayout());
        this.axisOptionsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.innerAxesOptionsPanel.setLayout(new BorderLayout());
        this.axesOptionPanelSplitPane.setDividerLocation(80);
        this.axesOptionPanelSplitPane.setOrientation(0);
        this.axesTopPanel.setLayout(new BorderLayout());
        this.axesTopPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.axesInnerTopPanel.setLayout(new BorderLayout());
        this.axesLabel.setText("Select Axis:");
        this.axesInnerTopPanel.add((Component)this.axesLabel, "North");
        this.axesListPanel.setLayout(new GridBagLayout());
        this.axesInnerListPanel.setLayout(new BorderLayout());
        this.axesListScrollPane.setMaximumSize(new Dimension(Short.MAX_VALUE, 120));
        this.axesListScrollPane.setMinimumSize(new Dimension(20, 22));
        this.axesListScrollPane.setPreferredSize(new Dimension(3, 120));
        this.axesListScrollPane.setViewportView(this.axesList);
        this.axesInnerListPanel.add((Component)this.axesListScrollPane, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.75;
        gridBagConstraints.weighty = 1.0;
        this.axesListPanel.add((Component)this.axesInnerListPanel, gridBagConstraints);
        this.axesInnerTopPanel.add((Component)this.axesListPanel, "Center");
        this.axesTopPanel.add((Component)this.axesInnerTopPanel, "Center");
        this.axesOptionPanelSplitPane.setLeftComponent(this.axesTopPanel);
        this.axesBottomPanel.setLayout(new BorderLayout());
        this.axesBottomPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.axesBottomPanel.add((Component)this.axisPropertiesTable, "Center");
        this.axesOptionPanelSplitPane.setRightComponent(this.axesBottomPanel);
        this.innerAxesOptionsPanel.add((Component)this.axesOptionPanelSplitPane, "Center");
        this.axisOptionsPanel.add((Component)this.innerAxesOptionsPanel, "Center");
        jTabbedPane.addTab("Axes", this.axisOptionsPanel);
        this.seriesOptionsPanel.setLayout(new BorderLayout());
        this.seriesOptionsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.seriesOptionPanelSplitPane.setOrientation(0);
        this.seriesTopPanel.setLayout(new BorderLayout());
        this.seriesTopPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.seriesInnerTopPanel.setLayout(new BorderLayout());
        this.seriesLabel.setText("Select Series:");
        this.seriesInnerTopPanel.add((Component)this.seriesLabel, "North");
        this.seriesListPanel.setLayout(new GridBagLayout());
        this.seriesInnerListPanel.setLayout(new BorderLayout());
        this.seriesListScrollPane.setMaximumSize(new Dimension(Short.MAX_VALUE, 120));
        this.seriesListScrollPane.setMinimumSize(new Dimension(20, 22));
        this.seriesListScrollPane.setPreferredSize(new Dimension(3, 120));
        this.seriesListScrollPane.setViewportView(this.seriesList);
        this.seriesInnerListPanel.add((Component)this.seriesListScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.75;
        gridBagConstraints.weighty = 1.0;
        this.seriesListPanel.add((Component)this.seriesInnerListPanel, gridBagConstraints);
        this.seriesButtonPanel.setLayout(new GridLayout(5, 1, 5, 5));
        this.seriesButtonPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 105));
        this.addSeries.setText("Add");
        this.addSeries.setHorizontalAlignment(2);
        this.addSeries.setMinimumSize(new Dimension(5, 25));
        this.addSeries.setPreferredSize(new Dimension(5, 25));
        this.addSeries.setIcon(GUIPrism.getIconFromImage("smallAdd.png"));
        this.addSeries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphOptionsPanel.this.addSeriesActionPerformed(actionEvent);
            }
        });
        this.seriesButtonPanel.add(this.addSeries);
        this.removeSeries.setText("Remove");
        this.removeSeries.setHorizontalAlignment(2);
        this.removeSeries.setMinimumSize(new Dimension(5, 25));
        this.removeSeries.setPreferredSize(new Dimension(5, 25));
        this.removeSeries.setIcon(GUIPrism.getIconFromImage("smallRemove.png"));
        this.removeSeries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphOptionsPanel.this.removeSeriesActionPerformed(actionEvent);
            }
        });
        this.seriesButtonPanel.add(this.removeSeries);
        this.moveUp.setText("Move Up");
        this.moveUp.setHorizontalAlignment(2);
        this.moveUp.setMinimumSize(new Dimension(5, 25));
        this.moveUp.setPreferredSize(new Dimension(5, 25));
        this.moveUp.setIcon(GUIPrism.getIconFromImage("smallArrowUp.png"));
        this.moveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphOptionsPanel.this.moveUpActionPerformed(actionEvent);
            }
        });
        this.seriesButtonPanel.add(this.moveUp);
        this.moveDown.setText("Move Down");
        this.moveDown.setHorizontalAlignment(2);
        this.moveDown.setMinimumSize(new Dimension(5, 25));
        this.moveDown.setPreferredSize(new Dimension(5, 25));
        this.moveDown.setIcon(GUIPrism.getIconFromImage("smallArrowDown.png"));
        this.moveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphOptionsPanel.this.moveDownActionPerformed(actionEvent);
            }
        });
        this.seriesButtonPanel.add(this.moveDown);
        this.viewData.setText("Edit Data");
        this.viewData.setHorizontalAlignment(2);
        this.viewData.setIcon(GUIPrism.getIconFromImage("smallEditData.png"));
        this.viewData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphOptionsPanel.this.viewDataActionPerformed(actionEvent);
            }
        });
        this.seriesButtonPanel.add(this.viewData);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.seriesListPanel.add((Component)this.seriesButtonPanel, gridBagConstraints);
        this.seriesInnerTopPanel.add((Component)this.seriesListPanel, "Center");
        this.seriesTopPanel.add((Component)this.seriesInnerTopPanel, "Center");
        this.seriesOptionPanelSplitPane.setLeftComponent(this.seriesTopPanel);
        this.seriesBottomPanel.setLayout(new BorderLayout());
        this.seriesBottomPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.seriesBottomPanel.add((Component)this.seriesPropertiesTable, "Center");
        this.seriesOptionPanelSplitPane.setRightComponent(this.seriesBottomPanel);
        this.seriesOptionsPanel.add((Component)this.seriesOptionPanelSplitPane, "Center");
        jTabbedPane.addTab("Series", this.seriesOptionsPanel);
        this.displayOptionsPanel.setLayout(new BorderLayout());
        this.displayOptionsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.innerDisplayOptionsPanel.setLayout(new BorderLayout());
        this.innerDisplayOptionsPanel.add((Component)this.displayPropertiesTable, "Center");
        this.displayOptionsPanel.add((Component)this.innerDisplayOptionsPanel, "Center");
        jTabbedPane.addTab("Display", this.displayOptionsPanel);
        this.add((Component)jTabbedPane, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void viewDataActionPerformed(ActionEvent actionEvent) {
        Object object = this.theModel.getSeriesLock();
        synchronized (object) {
            int[] nArray = this.seriesList.getSelectedIndices();
            ArrayList<Graph.SeriesKey> arrayList = new ArrayList<Graph.SeriesKey>();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(((SeriesSettings)this.theModel.getGraphSeriesList().getElementAt(nArray[i])).getSeriesKey());
            }
            SeriesEditorDialog.makeSeriesEditor(this.plugin, this.parent, this.theModel, arrayList);
        }
    }

    private void tabbedPanelStateChanged(ChangeEvent changeEvent) {
        this.stopEditors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveDownActionPerformed(ActionEvent actionEvent) {
        Object object = this.theModel.getSeriesLock();
        synchronized (object) {
            int[] nArray = this.seriesList.getSelectedIndices();
            SeriesSettingsList seriesSettingsList = this.theModel.getGraphSeriesList();
            Vector<Graph.SeriesKey> vector = new Vector<Graph.SeriesKey>();
            for (int i = 0; i < nArray.length; ++i) {
                SeriesSettings seriesSettings = (SeriesSettings)seriesSettingsList.getElementAt(nArray[i]);
                vector.add(seriesSettings.getSeriesKey());
            }
            this.theModel.moveDown(vector);
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = nArray[i] < seriesSettingsList.getSize() - 1 ? nArray[i] + 1 : 0;
            }
            this.seriesList.setSelectedIndices(nArray2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveUpActionPerformed(ActionEvent actionEvent) {
        Object object = this.theModel.getSeriesLock();
        synchronized (object) {
            int[] nArray = this.seriesList.getSelectedIndices();
            SeriesSettingsList seriesSettingsList = this.theModel.getGraphSeriesList();
            Vector<Graph.SeriesKey> vector = new Vector<Graph.SeriesKey>();
            for (int i = 0; i < nArray.length; ++i) {
                SeriesSettings seriesSettings = (SeriesSettings)seriesSettingsList.getElementAt(nArray[i]);
                vector.add(seriesSettings.getSeriesKey());
            }
            this.theModel.moveUp(vector);
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = nArray[i] > 1 ? nArray[i] - 1 : 0;
            }
            this.seriesList.setSelectedIndices(nArray2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSeriesActionPerformed(ActionEvent actionEvent) {
        Object object = this.theModel.getSeriesLock();
        synchronized (object) {
            int[] nArray = this.seriesList.getSelectedIndices();
            SeriesSettingsList seriesSettingsList = this.theModel.getGraphSeriesList();
            Vector<Graph.SeriesKey> vector = new Vector<Graph.SeriesKey>();
            for (int i = 0; i < nArray.length; ++i) {
                SeriesSettings object2 = (SeriesSettings)seriesSettingsList.getElementAt(nArray[i]);
                vector.add(object2.getSeriesKey());
            }
            for (Graph.SeriesKey seriesKey : vector) {
                this.theModel.removeSeries(seriesKey);
            }
            seriesSettingsList.updateSeriesList();
        }
        this.seriesList.clearSelection();
    }

    private void addSeriesActionPerformed(ActionEvent actionEvent) {
        this.theModel.addSeries("New Series");
    }

    public void doEnables() {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.seriesList.getSelectedIndices().length; ++i) {
            if (this.seriesList.getSelectedIndices()[i] == 0) {
                bl = true;
            }
            if (this.seriesList.getSelectedIndices()[i] != this.theModel.getGraphSeriesList().getSize() - 1) continue;
            bl2 = true;
        }
        this.removeSeries.setEnabled(this.seriesList.getSelectedIndices().length >= 1);
        this.moveUp.setEnabled(!bl && this.seriesList.getSelectedIndices().length >= 1);
        this.moveDown.setEnabled(!bl2 && this.seriesList.getSelectedIndices().length >= 1);
        this.viewData.setEnabled(this.seriesList.getSelectedIndices().length >= 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.stopEditors();
        this.doEnables();
        if (listSelectionEvent.getSource() == this.axesList) {
            int[] nArray = this.axesList.getSelectedIndices();
            ArrayList<AxisSettings> arrayList = new ArrayList<AxisSettings>();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 0) {
                    arrayList.add(this.xAxisSettings);
                    continue;
                }
                if (nArray[i] != 1) continue;
                arrayList.add(this.yAxisSettings);
            }
            this.axisPropertiesTable.setOwners(arrayList);
        } else if (listSelectionEvent.getSource() == this.seriesList) {
            Object object = this.theModel.getSeriesLock();
            synchronized (object) {
                int[] nArray = this.seriesList.getSelectedIndices();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i = 0; i < nArray.length; ++i) {
                    arrayList.add(this.theModel.getGraphSeriesList().getElementAt(nArray[i]));
                }
                this.seriesPropertiesTable.setOwners(arrayList);
            }
        }
    }

    public void errorDialog(String string, String string2) {
        JOptionPane.showMessageDialog(this.parent, string, string2, 0);
    }
}

