/*
 * Decompiled with CFR 0.152.
 */
package userinterface;

import parser.Values;
import prism.PrismSettings;
import simulator.method.ACIconfidence;
import simulator.method.ACIiterations;
import simulator.method.ACIwidth;
import simulator.method.APMCapproximation;
import simulator.method.APMCconfidence;
import simulator.method.APMCiterations;
import simulator.method.CIconfidence;
import simulator.method.CIiterations;
import simulator.method.CIwidth;
import simulator.method.SPRTMethod;
import simulator.method.SimulationMethod;

public class SimulationInformation {
    private PrismSettings settings;
    private Method method;
    private Unknown unknown;
    private Values initialState;
    private double width;
    private double confidence;
    private int numSamples;
    private long maxPathLength;
    private boolean distributed;
    private boolean maxRewardGiven;

    public SimulationInformation(PrismSettings prismSettings) {
        this.settings = prismSettings;
        this.initialState = null;
        this.method = Method.CI;
        this.unknown = Unknown.WIDTH;
        this.width = prismSettings.getDouble("simulator.defaultWidth");
        this.confidence = prismSettings.getDouble("simulator.defaultConfidence");
        this.numSamples = prismSettings.getInteger("simulator.defaultNumSamples");
        this.maxPathLength = prismSettings.getLong("simulator.defaultMaxPath");
        this.distributed = false;
        this.maxRewardGiven = false;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethodByName(String string) {
        this.setMethod(Method.valueOf(string));
    }

    public String getMethodName() {
        return this.method.toString();
    }

    public void setUnknown(Unknown unknown) {
        this.unknown = unknown;
    }

    public void setUnknownByName(String string) {
        if (string.equals("Width") || string.equals("Approximation")) {
            this.setUnknown(Unknown.WIDTH);
        } else if (string.equals("Confidence")) {
            this.setUnknown(Unknown.CONFIDENCE);
        } else if (string.equals("Number of samples")) {
            this.setUnknown(Unknown.NUM_SAMPLES);
        }
    }

    public String getUnknownName() {
        switch (this.unknown.ordinal()) {
            case 0: {
                return this.method == Method.APMC ? "Approximation" : "Width";
            }
            case 1: {
                return "Confidence";
            }
            case 2: {
                return "Number of samples";
            }
        }
        return null;
    }

    public Unknown getUnknown() {
        return this.unknown;
    }

    public Values getInitialState() {
        return this.initialState;
    }

    public void setInitialState(Values values) {
        this.initialState = values;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public void setConfidence(double d) {
        this.confidence = d;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int n) {
        this.numSamples = n;
    }

    public long getMaxPathLength() {
        return this.maxPathLength;
    }

    public void setMaxPathLength(long l) {
        this.maxPathLength = l;
    }

    public void setPropReward(boolean bl) {
        this.maxRewardGiven = bl;
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    public void setDistributed(boolean bl) {
        this.distributed = bl;
    }

    public SimulationMethod createSimulationMethod() {
        double d = this.settings.getDouble("simulator.maxReward");
        boolean bl = this.settings.getBoolean("simulator.decide");
        int n = this.settings.getInteger("simulator.iterationsToDecide");
        switch (this.method.ordinal()) {
            case 0: {
                switch (this.unknown.ordinal()) {
                    case 0: {
                        return new CIwidth(this.confidence, this.numSamples);
                    }
                    case 1: {
                        return new CIconfidence(this.width, this.numSamples);
                    }
                    case 2: {
                        if (bl) {
                            return new CIiterations(this.confidence, this.width, n);
                        }
                        if (this.maxRewardGiven) {
                            return new CIiterations(this.confidence, this.width, d);
                        }
                        return new CIiterations(this.confidence, this.width);
                    }
                }
                return null;
            }
            case 1: {
                switch (this.unknown.ordinal()) {
                    case 0: {
                        return new ACIwidth(this.confidence, this.numSamples);
                    }
                    case 1: {
                        return new ACIconfidence(this.width, this.numSamples);
                    }
                    case 2: {
                        if (bl) {
                            return new ACIiterations(this.confidence, this.width, n);
                        }
                        if (this.maxRewardGiven) {
                            return new ACIiterations(this.confidence, this.width, d);
                        }
                        return new ACIiterations(this.confidence, this.width);
                    }
                }
                return null;
            }
            case 2: {
                switch (this.unknown.ordinal()) {
                    case 0: {
                        return new APMCapproximation(this.confidence, this.numSamples);
                    }
                    case 1: {
                        return new APMCconfidence(this.width, this.numSamples);
                    }
                    case 2: {
                        return new APMCiterations(this.confidence, this.width);
                    }
                }
                return null;
            }
            case 3: {
                return new SPRTMethod(this.confidence, this.confidence, this.width);
            }
        }
        return null;
    }

    public static enum Method {
        CI,
        ACI,
        APMC,
        SPRT;

    }

    public static enum Unknown {
        WIDTH,
        CONFIDENCE,
        NUM_SAMPLES;

    }
}

