/*
 * Decompiled with CFR 0.152.
 */
package symbolic.build;

import java.util.LinkedList;
import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import parser.State;
import parser.Values;
import parser.VarList;
import parser.ast.DeclarationType;
import prism.ModelGenerator;
import prism.ModelType;
import prism.Prism;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.RewardGenerator;
import symbolic.model.Model;
import symbolic.model.ModelSymbolic;
import symbolic.model.ModelVariablesDD;
import symbolic.model.NondetModel;
import symbolic.model.ProbModel;
import symbolic.model.StochModel;

public class ModelGenerator2MTBDD {
    private Prism prism;
    private PrismLog mainLog;
    private ModelGenerator<Double> modelGen;
    private RewardGenerator<Double> rewardGen;
    private ModelType modelType;
    private VarList varList;
    private int numLabels;
    private int numVars;
    private int numRewardStructs;
    private String[] rewardStructNames;
    private JDDNode trans;
    private JDDNode start;
    private JDDNode reach;
    private JDDVars allDDRowVars;
    private JDDVars allDDColVars;
    private JDDVars allDDNondetVars;
    private JDDVars[] varDDRowVars;
    private JDDVars[] varDDColVars;
    private ModelVariablesDD modelVariables;
    private Vector<String> synchs;
    private JDDNode transActions;
    private Vector<JDDNode> transPerAction;
    private JDDNode[] labelsArray;
    private JDDNode[] stateRewardsArray;
    private JDDNode[] transRewardsArray;
    private int maxNumChoices = 0;

    public ModelGenerator2MTBDD(Prism prism) {
        this.prism = prism;
        this.mainLog = prism.getMainLog();
    }

    public Model build(ModelGenerator<Double> modelGenerator, RewardGenerator<Double> rewardGenerator) throws PrismException {
        this.modelGen = modelGenerator;
        this.rewardGen = rewardGenerator;
        this.modelType = modelGenerator.getModelType();
        this.varList = modelGenerator.createVarList();
        this.numLabels = modelGenerator.getNumLabels();
        this.numVars = this.varList.getNumVars();
        this.modelVariables = new ModelVariablesDD();
        this.numRewardStructs = rewardGenerator.getNumRewardStructs();
        this.rewardStructNames = rewardGenerator.getRewardStructNames().toArray(new String[0]);
        return this.buildModel();
    }

    private Model buildModel() throws PrismException {
        ModelSymbolic modelSymbolic = null;
        if (this.modelType == ModelType.MDP) {
            this.maxNumChoices = 32;
        }
        this.allocateDDVars();
        this.buildTransAndRewards();
        if (this.modelType == ModelType.MDP) {
            JDDNode jDDNode = JDD.GetSupport(this.trans);
            jDDNode = JDD.ThereExists(jDDNode, this.allDDRowVars);
            JDDNode jDDNode2 = jDDNode = JDD.ThereExists(jDDNode, this.allDDColVars);
            JDDVars jDDVars = new JDDVars();
            while (!jDDNode2.equals(JDD.ONE)) {
                jDDVars.addVar(JDD.Var(jDDNode2.getIndex()));
                jDDNode2 = jDDNode2.getThen();
            }
            JDD.Deref(jDDNode);
            this.allDDNondetVars.derefAll();
            this.allDDNondetVars = jDDVars;
        }
        boolean bl = true;
        String[] stringArray = new String[]{"M"};
        Values values = this.modelGen.getConstantValues();
        if (this.modelType == ModelType.DTMC) {
            modelSymbolic = new ProbModel(this.trans, this.start, this.allDDRowVars, this.allDDColVars, this.modelVariables, this.varList, this.varDDRowVars, this.varDDColVars);
        } else if (this.modelType == ModelType.MDP) {
            modelSymbolic = new NondetModel(this.trans, this.start, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, this.modelVariables, this.varList, this.varDDRowVars, this.varDDColVars);
        } else if (this.modelType == ModelType.CTMC) {
            modelSymbolic = new StochModel(this.trans, this.start, this.allDDRowVars, this.allDDColVars, this.modelVariables, this.varList, this.varDDRowVars, this.varDDColVars);
        }
        modelSymbolic.setRewards(this.stateRewardsArray, this.transRewardsArray, this.rewardStructNames);
        modelSymbolic.setConstantValues(values);
        modelSymbolic.setSynchs(this.synchs);
        if (this.modelType != ModelType.MDP) {
            ((ProbModel)modelSymbolic).setTransPerAction(this.transPerAction.toArray(new JDDNode[0]));
        } else {
            ((NondetModel)modelSymbolic).setTransActions(this.transActions);
        }
        modelSymbolic.setReach(this.reach);
        modelSymbolic.filterReachableStates();
        if (this.prism.getExtraDDInfo()) {
            this.mainLog.print("Reach: " + JDD.GetNumNodes(modelSymbolic.getReach()) + " nodes\n");
        }
        modelSymbolic.findDeadlocks(this.prism.getFixDeadlocks());
        for (int i = 0; i < this.numLabels; ++i) {
            modelSymbolic.addLabelDD(this.modelGen.getLabelName(i), this.labelsArray[i]);
        }
        return modelSymbolic;
    }

    private void allocateDDVars() throws PrismException {
        int n;
        this.varDDRowVars = new JDDVars[this.numVars];
        this.varDDColVars = new JDDVars[this.numVars];
        for (n = 0; n < this.numVars; ++n) {
            this.varDDRowVars[n] = new JDDVars();
            this.varDDColVars[n] = new JDDVars();
        }
        if (this.modelType == ModelType.MDP) {
            this.allDDNondetVars = new JDDVars();
            for (n = 0; n < this.maxNumChoices; ++n) {
                this.allDDNondetVars.addVar(this.modelVariables.allocateVariable("l" + n));
            }
        }
        this.allDDRowVars = new JDDVars();
        this.allDDColVars = new JDDVars();
        for (n = 0; n < this.numVars; ++n) {
            DeclarationType declarationType = this.varList.getDeclarationType(n);
            if (declarationType.isUnbounded()) {
                throw new PrismNotSupportedException("Cannot build a model that contains a variable with unbounded range (try the explicit engine instead)");
            }
            int n2 = this.varList.getRangeLogTwo(n);
            for (int i = 0; i < n2; ++i) {
                JDDNode jDDNode = this.modelVariables.allocateVariable(this.varList.getName(n) + "." + i);
                JDDNode jDDNode2 = this.modelVariables.allocateVariable(this.varList.getName(n) + "'." + i);
                this.varDDRowVars[n].addVar(jDDNode);
                this.varDDColVars[n].addVar(jDDNode2);
            }
            this.allDDRowVars.copyVarsFrom(this.varDDRowVars[n]);
            this.allDDColVars.copyVarsFrom(this.varDDColVars[n]);
        }
    }

    private void buildTransAndRewards() throws PrismException {
        int n;
        this.synchs = new Vector();
        this.trans = JDD.Constant(0.0);
        if (this.modelType != ModelType.MDP) {
            this.transPerAction = new Vector();
            this.transPerAction.add(JDD.Constant(0.0));
        } else {
            this.transActions = JDD.Constant(0.0);
        }
        this.start = JDD.Constant(0.0);
        this.reach = JDD.Constant(0.0);
        this.labelsArray = new JDDNode[this.numLabels];
        for (n = 0; n < this.numLabels; ++n) {
            this.labelsArray[n] = JDD.Constant(0.0);
        }
        this.stateRewardsArray = new JDDNode[this.numRewardStructs];
        this.transRewardsArray = new JDDNode[this.numRewardStructs];
        for (n = 0; n < this.numRewardStructs; ++n) {
            this.stateRewardsArray[n] = JDD.Constant(0.0);
            this.transRewardsArray[n] = JDD.Constant(0.0);
        }
        LinkedList<State> linkedList = new LinkedList<State>();
        for (State object : this.modelGen.getInitialStates()) {
            linkedList.add(object);
            JDDNode jDDNode = this.encodeState(object, this.varDDRowVars);
            this.start = JDD.Or(this.start, jDDNode.copy());
            this.reach = JDD.Or(this.reach, jDDNode);
        }
        while (!linkedList.isEmpty()) {
            int n2;
            State state = (State)linkedList.removeFirst();
            JDDNode jDDNode = this.encodeState(state, this.varDDRowVars);
            this.modelGen.exploreState(state);
            int n3 = this.modelGen.getNumChoices();
            if (this.modelType == ModelType.MDP && n3 > this.maxNumChoices) {
                String string = "Too many nondeterministic choices (" + n3 + ") at state " + state.toString(this.modelGen);
                string = string + ". Maximum is currently hard-coded at " + this.maxNumChoices;
                throw new PrismException(string);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                Object object = this.modelGen.getChoiceAction(n2);
                String string = object == null ? null : object.toString();
                int n4 = this.modelGen.getNumTransitions(n2);
                for (int i = 0; i < n4; ++i) {
                    JDDNode jDDNode2;
                    int n5;
                    State state2 = this.modelGen.computeTransitionTarget(n2, i);
                    double d = this.modelGen.getTransitionProbability(n2, i);
                    JDDNode jDDNode3 = this.encodeState(state2, this.varDDRowVars);
                    if (!JDD.AreIntersecting(this.reach, jDDNode3)) {
                        linkedList.add(state2);
                        this.reach = JDD.Or(this.reach, jDDNode3.copy());
                    }
                    JDDNode jDDNode4 = JDD.Apply(3, jDDNode.copy(), JDD.PermuteVariables(jDDNode3.copy(), this.allDDRowVars, this.allDDColVars));
                    if (this.modelType == ModelType.MDP) {
                        jDDNode4 = JDD.Apply(3, jDDNode4, JDD.SetVectorElement(JDD.Constant(0.0), this.allDDNondetVars, n2, 1.0));
                    }
                    this.trans = JDD.Apply(1, this.trans, JDD.Apply(3, JDD.Constant(d), jDDNode4.copy()));
                    if (string != null && !"".equals(string)) {
                        n5 = this.synchs.indexOf(string);
                        if (n5 == -1) {
                            this.synchs.add(string);
                            n5 = this.synchs.size() - 1;
                        }
                        ++n5;
                    } else {
                        n5 = 0;
                    }
                    if (this.modelType != ModelType.MDP) {
                        if (n5 < this.transPerAction.size()) {
                            jDDNode2 = this.transPerAction.get(n5);
                        } else {
                            jDDNode2 = JDD.Constant(0.0);
                            this.transPerAction.add(jDDNode2);
                        }
                        jDDNode2 = JDD.Apply(1, jDDNode2, JDD.Apply(3, JDD.Constant(d), jDDNode4.copy()));
                        this.transPerAction.set(n5, jDDNode2);
                    } else {
                        jDDNode2 = JDD.ThereExists(jDDNode4.copy(), this.allDDColVars);
                        this.transActions = JDD.Apply(6, this.transActions, JDD.Apply(3, JDD.Constant(n5), jDDNode2));
                    }
                    for (int j = 0; j < this.numRewardStructs; ++j) {
                        double d2 = this.rewardGen.getStateActionReward(j, state, object);
                        this.transRewardsArray[j] = JDD.Apply(1, this.transRewardsArray[j], JDD.Apply(3, JDD.Constant(d2), jDDNode4.copy()));
                    }
                    JDD.Deref(jDDNode4);
                    JDD.Deref(jDDNode3);
                }
            }
            for (n2 = 0; n2 < this.numLabels; ++n2) {
                if (!this.modelGen.isLabelTrue(n2)) continue;
                this.labelsArray[n2] = JDD.Or(this.labelsArray[n2], jDDNode.copy());
            }
            for (n2 = 0; n2 < this.numRewardStructs; ++n2) {
                double d = this.rewardGen.getStateReward(n2, state);
                this.stateRewardsArray[n2] = JDD.Apply(1, this.stateRewardsArray[n2], JDD.Apply(3, JDD.Constant(d), jDDNode.copy()));
            }
            JDD.Deref(jDDNode);
        }
    }

    private JDDNode encodeState(State state, JDDVars[] jDDVarsArray) throws PrismException {
        int n = 0;
        JDDNode jDDNode = JDD.Constant(1.0);
        for (int i = 0; i < this.numVars; ++i) {
            try {
                n = this.varList.encodeToInt(i, state.varValues[i]);
            }
            catch (PrismLangException prismLangException) {
                throw new PrismException("Error during JDD encodeState for state value at index " + i);
            }
            jDDNode = JDD.Apply(3, jDDNode, JDD.SetVectorElement(JDD.Constant(0.0), jDDVarsArray[i], n, 1.0));
        }
        return jDDNode;
    }
}

