/*
 * Decompiled with CFR 0.152.
 */
package strat;

import explicit.ConstructStrategyProduct;
import explicit.NondetModel;
import explicit.Product;
import explicit.SuccessorsIterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import parser.State;
import prism.Model;
import prism.PrismException;
import prism.PrismLog;
import strat.MDStrategy;
import strat.Strategy;
import strat.StrategyExplicit;
import strat.StrategyExportOptions;
import strat.StrategyInfo;

public class FMDStrategyProduct<Value>
extends StrategyExplicit<Value> {
    private Product<?> product;
    private MDStrategy<Value> strat;

    public FMDStrategyProduct(Product<?> product, MDStrategy<Value> mDStrategy) {
        super((NondetModel)product.getOriginalModel());
        this.product = product;
        this.strat = mDStrategy;
    }

    @Override
    public StrategyInfo.Memory memory() {
        return StrategyInfo.Memory.FINITE;
    }

    @Override
    public Object getChoiceAction(int n, int n2) {
        int n3 = this.findMatchingProductState(n, n2);
        return n3 == -1 ? Strategy.UNDEFINED : this.strat.getChoiceAction(n3);
    }

    @Override
    public int getChoiceIndex(int n, int n2) {
        int n3 = this.findMatchingProductState(n, n2);
        return n3 == -1 ? -1 : this.strat.getChoiceIndex(n3);
    }

    private int findMatchingProductState(int n, int n2) {
        if (n2 == -1) {
            return -1;
        }
        int n3 = this.product.getProductModel().getNumStates();
        for (int i = 0; i < n3; ++i) {
            if (this.product.getModelState(i) != n || this.product.getAutomatonState(i) != n2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getMemorySize() {
        return this.product.getAutomatonSize();
    }

    @Override
    public int getInitialMemory(int n) {
        for (int n2 : this.product.getProductModel().getInitialStates()) {
            if (this.product.getModelState(n2) != n) continue;
            return this.product.getAutomatonState(n2);
        }
        return -1;
    }

    @Override
    public int getUpdatedMemory(int n, Object object, int n2) {
        if (n == -1) {
            return -1;
        }
        int n3 = this.product.getProductModel().getNumStates();
        for (int i = 0; i < n3; ++i) {
            int n4;
            if (this.product.getAutomatonState(i) != n || (n4 = this.findMatchingMemoryUpdate(i, n2)) == -1) continue;
            return n4;
        }
        return -1;
    }

    private int findMatchingMemoryUpdate(int n, int n2) {
        SuccessorsIterator successorsIterator = this.product.getProductModel().getSuccessors(n);
        while (successorsIterator.hasNext()) {
            int n3 = successorsIterator.nextInt();
            if (this.product.getModelState(n3) != n2) continue;
            return this.product.getAutomatonState(n3);
        }
        return -1;
    }

    @Override
    public explicit.Model<Value> constructInducedModel(StrategyExportOptions strategyExportOptions) throws PrismException {
        ConstructStrategyProduct constructStrategyProduct = new ConstructStrategyProduct();
        constructStrategyProduct.setMode(strategyExportOptions.getMode());
        explicit.Model model = constructStrategyProduct.constructProductModel(this.model, this);
        return model;
    }

    @Override
    public void exportActions(PrismLog prismLog, StrategyExportOptions strategyExportOptions) {
        List<State> list = this.model.getStatesList();
        boolean bl = strategyExportOptions.getShowStates() && list != null;
        int n = this.product.getProductModel().getNumStates();
        for (int i = 0; i < n; ++i) {
            int n2 = this.product.getModelState(i);
            int n3 = this.product.getAutomatonState(i);
            Object object = this.strat.getChoiceAction(i);
            if (object == UNDEFINED) continue;
            prismLog.println(String.valueOf(bl ? (Comparable)list.get(n2) : Integer.valueOf(n2)) + "," + n3 + "=" + (object == null ? "" : object.toString()));
        }
    }

    @Override
    public void exportIndices(PrismLog prismLog, StrategyExportOptions strategyExportOptions) {
        int n = this.product.getProductModel().getNumStates();
        for (int i = 0; i < n; ++i) {
            int n2 = this.product.getModelState(i);
            int n3 = this.product.getAutomatonState(i);
            prismLog.println(n2 + "," + n3 + "=" + this.strat.getChoiceIndex(i));
        }
    }

    @Override
    public void exportInducedModel(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        if (strategyExportOptions.getReachOnly()) {
            Model model = this.constructInducedModel(strategyExportOptions);
            model.exportToPrismExplicitTra(prismLog, strategyExportOptions.getModelPrecision());
        } else {
            this.strat.exportInducedModel(prismLog, strategyExportOptions);
        }
    }

    @Override
    public void exportDotFile(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        ConstructStrategyProduct constructStrategyProduct = new ConstructStrategyProduct();
        constructStrategyProduct.setMode(strategyExportOptions.getMode());
        explicit.Model model = constructStrategyProduct.constructProductModel(this.model, this);
        model.exportToDotFile(prismLog, null, strategyExportOptions.getShowStates(), strategyExportOptions.getModelPrecision());
    }

    @Override
    public void clear() {
        this.strat.clear();
    }

    public String toString() {
        return "[" + IntStream.range(0, this.getNumStates()).mapToObj(n -> IntStream.range(0, this.getMemorySize()).mapToObj(n2 -> n + "," + n2 + "=" + this.getChoiceActionString(n, n2)).collect(Collectors.joining(","))).collect(Collectors.joining(",")) + "]";
    }
}

