/*
 * Decompiled with CFR 0.152.
 */
package simulator.sampler;

import parser.ast.ExpressionTemporal;
import prism.ModelGenerator;
import prism.PrismException;
import simulator.Path;
import simulator.sampler.SamplerDouble;

public class SamplerRewardCumulCont
extends SamplerDouble {
    private double timeBound;
    private int rewardStructIndex;

    public SamplerRewardCumulCont(ExpressionTemporal expressionTemporal, int n) throws PrismException {
        if (expressionTemporal.getOperator() != 11) {
            throw new PrismException("Error creating Sampler");
        }
        this.timeBound = expressionTemporal.getUpperBound().evaluateDouble();
        this.rewardStructIndex = n;
        this.reset();
        this.resetStats();
    }

    @Override
    public boolean update(Path path, ModelGenerator modelGenerator) throws PrismException {
        if (this.valueKnown) {
            return true;
        }
        if (path.getTotalTime() >= this.timeBound) {
            this.valueKnown = true;
            this.value = path.getTotalCumulativeReward(this.rewardStructIndex);
            double d = path.getTotalTime() - this.timeBound;
            if (d > 0.0) {
                this.value -= path.getPreviousStateReward(this.rewardStructIndex) * d;
                this.value -= path.getPreviousTransitionReward(this.rewardStructIndex);
            }
        } else if (modelGenerator != null && modelGenerator.isDeadlock()) {
            this.valueKnown = true;
            this.value = path.getTotalCumulativeReward(this.rewardStructIndex);
            double d = this.timeBound - path.getTotalTime();
            this.value += path.getCurrentStateReward(this.rewardStructIndex) * d;
        }
        return this.valueKnown;
    }

    @Override
    public boolean needsBoundedNumSteps() {
        return true;
    }
}

