/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import cern.jet.random.Exponential;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import java.util.Date;

public class RandomNumberGenerator {
    private MersenneTwister random;
    private Uniform uniform;
    private Exponential exponential;

    public RandomNumberGenerator() {
        this((int)new Date().getTime());
    }

    public RandomNumberGenerator(int n) {
        this.random = new MersenneTwister(n);
        this.uniform = new Uniform((RandomEngine)this.random);
        this.exponential = new Exponential(1.0, (RandomEngine)this.random);
    }

    public int randomUnifInt(int n) {
        return this.uniform.nextIntFromTo(0, n - 1);
    }

    public double randomUnifDouble() {
        return this.random.nextDouble();
    }

    public double randomUnifDouble(double d) {
        return d * this.random.nextDouble();
    }

    public double randomExpDouble(double d) {
        return this.exponential.nextDouble(d);
    }
}

