/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import parser.State;
import prism.ModelGenerator;
import prism.ModelInfo;
import prism.RewardGenerator;
import simulator.LoopDetector;
import simulator.Path;

public class PathOnTheFly
extends Path {
    protected ModelInfo modelInfo;
    protected boolean continuousTime;
    protected int numRewardStructs;
    protected long size;
    protected boolean init;
    protected State previousState;
    protected State currentState;
    protected State previousObs;
    protected State currentObs;
    protected Object previousAction;
    protected String previousActionString;
    protected Object previousProbability;
    protected double totalTime;
    double timeInPreviousState;
    protected double[] totalRewards;
    protected double[] previousStateRewards;
    protected double[] previousTransitionRewards;
    protected double[] currentStateRewards;
    protected int currentStrategyMemory;
    protected Object currentStrategyDecision;
    protected LoopDetector loopDet;

    public PathOnTheFly(ModelInfo modelInfo, RewardGenerator rewardGenerator) {
        this.modelInfo = modelInfo;
        this.continuousTime = modelInfo.getModelType().continuousTime();
        this.numRewardStructs = rewardGenerator.getNumRewardStructs();
        this.previousState = new State(modelInfo.getNumVars());
        this.currentState = new State(modelInfo.getNumVars());
        this.previousObs = null;
        this.currentObs = null;
        if (modelInfo.getModelType().partiallyObservable()) {
            this.previousObs = new State(modelInfo.getNumObservables());
            this.currentObs = new State(modelInfo.getNumObservables());
        }
        this.totalRewards = new double[this.numRewardStructs];
        this.previousStateRewards = new double[this.numRewardStructs];
        this.previousTransitionRewards = new double[this.numRewardStructs];
        this.currentStateRewards = new double[this.numRewardStructs];
        this.clear();
        this.loopDet = new LoopDetector();
    }

    protected void clear() {
        this.size = 0L;
        this.init = false;
        this.previousState.clear();
        this.currentState.clear();
        this.totalTime = 0.0;
        this.timeInPreviousState = 0.0;
        for (int i = 0; i < this.numRewardStructs; ++i) {
            this.totalRewards[i] = 0.0;
            this.previousStateRewards[i] = 0.0;
            this.previousTransitionRewards[i] = 0.0;
            this.currentStateRewards[i] = 0.0;
        }
    }

    @Override
    public void initialise(State state, State state2, double[] dArray) {
        this.clear();
        this.init = true;
        this.currentState.copy(state);
        if (state2 != null) {
            this.currentObs.copy(state2);
        }
        for (int i = 0; i < this.numRewardStructs; ++i) {
            this.currentStateRewards[i] = dArray[i];
        }
        this.loopDet.initialise();
    }

    @Override
    public void addStep(int n, Object object, String string, Object object2, double[] dArray, State state, State state2, double[] dArray2, ModelGenerator modelGenerator) {
        this.addStep(1.0, n, object, string, object2, dArray, state, state2, dArray2, modelGenerator);
    }

    @Override
    public void addStep(double d, int n, Object object, String string, Object object2, double[] dArray, State state, State state2, double[] dArray2, ModelGenerator modelGenerator) {
        ++this.size;
        this.previousState.copy(this.currentState);
        this.currentState.copy(state);
        if (state2 != null) {
            this.previousObs.copy(this.currentObs);
            this.currentObs.copy(state2);
        }
        this.previousAction = object;
        this.previousActionString = string;
        this.previousProbability = object2;
        this.totalTime += d;
        this.timeInPreviousState = d;
        for (int i = 0; i < this.numRewardStructs; ++i) {
            if (this.continuousTime) {
                int n2 = i;
                this.totalRewards[n2] = this.totalRewards[n2] + (this.currentStateRewards[i] * d + dArray[i]);
            } else {
                int n3 = i;
                this.totalRewards[n3] = this.totalRewards[n3] + (this.currentStateRewards[i] + dArray[i]);
            }
            this.previousStateRewards[i] = this.currentStateRewards[i];
            this.previousTransitionRewards[i] = dArray[i];
            this.currentStateRewards[i] = dArray2[i];
        }
        this.loopDet.addStep(this, modelGenerator);
    }

    @Override
    public void setStrategyInfoForCurrentState(int n, Object object) {
        this.currentStrategyMemory = n;
        this.currentStrategyDecision = object;
    }

    @Override
    public boolean continuousTime() {
        return this.continuousTime;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long numStates() {
        return this.init ? this.size + 1L : 0L;
    }

    @Override
    public State getPreviousState() {
        return this.previousState;
    }

    @Override
    public State getCurrentState() {
        return this.currentState;
    }

    @Override
    public State getPreviousObservation() {
        return this.previousObs;
    }

    @Override
    public State getCurrentObservation() {
        return this.currentObs;
    }

    @Override
    public Object getPreviousAction() {
        return this.previousAction;
    }

    @Override
    public String getPreviousActionString() {
        return this.previousActionString;
    }

    @Override
    public Object getPreviousProbability() {
        return this.previousProbability;
    }

    @Override
    public double getTotalTime() {
        return this.totalTime;
    }

    @Override
    public double getTimeInPreviousState() {
        return this.timeInPreviousState;
    }

    @Override
    public double getTotalCumulativeReward(int n) {
        return this.totalRewards[n];
    }

    @Override
    public double getPreviousStateReward(int n) {
        return this.previousStateRewards[n];
    }

    @Override
    public double[] getPreviousStateRewards() {
        return this.previousStateRewards;
    }

    @Override
    public double getPreviousTransitionReward(int n) {
        return this.previousTransitionRewards[n];
    }

    @Override
    public double[] getPreviousTransitionRewards() {
        return this.previousTransitionRewards;
    }

    @Override
    public double getCurrentStateReward(int n) {
        return this.currentStateRewards[n];
    }

    @Override
    public double[] getCurrentStateRewards() {
        return this.currentStateRewards;
    }

    @Override
    public int getCurrentStrategyMemory() {
        return this.currentStrategyMemory;
    }

    @Override
    public Object getCurrentStrategyDecision() {
        return this.currentStrategyDecision;
    }

    @Override
    public boolean isLooping() {
        return this.loopDet.isLooping();
    }

    @Override
    public long loopStart() {
        return this.loopDet.loopStart();
    }

    @Override
    public long loopEnd() {
        return this.loopDet.loopEnd();
    }
}

