/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import common.Interval;
import java.util.ArrayList;
import java.util.List;
import param.Function;
import param.FunctionFactory;
import parser.EvaluateContext;
import parser.EvaluateContextState;
import parser.State;
import parser.Values;
import parser.VarList;
import parser.ast.ConstantList;
import parser.ast.DeclarationType;
import parser.ast.Expression;
import parser.ast.ExpressionConstant;
import parser.ast.ExpressionLiteral;
import parser.ast.LabelList;
import parser.ast.ModulesFile;
import parser.ast.RewardStruct;
import parser.type.Type;
import parser.type.TypeClock;
import parser.visitor.ASTTraverseModify;
import prism.Evaluator;
import prism.ModelGenerator;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismNotSupportedException;
import prism.RewardGenerator;
import simulator.TransitionList;
import simulator.Updater;

public class ModulesFileModelGenerator<Value>
implements ModelGenerator<Value>,
RewardGenerator<Value> {
    protected PrismComponent parent;
    protected Evaluator<Value> eval;
    protected Evaluator<Interval<Value>> evalInt;
    protected EvaluateContextState ec;
    protected ModulesFile originalModulesFile;
    protected ModulesFile modulesFile;
    protected ModelType modelType;
    protected Values mfConstants;
    protected VarList varList;
    protected LabelList labelList;
    protected List<String> labelNames;
    protected State exploreState;
    protected Updater<Value> updater;
    protected TransitionList<Value> transitionList;
    protected boolean transitionListBuilt;
    protected TransitionList<Interval<Value>> transitionListInt;
    protected Updater<Interval<Value>> updaterInt;
    protected boolean transitionListIntBuilt;
    protected Expression invariant;

    public static ModulesFileModelGenerator<?> create(ModulesFile modulesFile, PrismComponent prismComponent) throws PrismException {
        return ModulesFileModelGenerator.create(modulesFile, false, prismComponent);
    }

    public static ModulesFileModelGenerator<?> create(ModulesFile modulesFile, boolean bl, PrismComponent prismComponent) throws PrismException {
        return new ModulesFileModelGenerator(modulesFile, ModulesFileModelGenerator.createEvaluator(modulesFile, bl), prismComponent);
    }

    private static Evaluator<?> createEvaluator(ModulesFile modulesFile, boolean bl) throws PrismException {
        if (!bl) {
            return Evaluator.forDouble();
        }
        return Evaluator.forBigRational();
    }

    public static ModulesFileModelGenerator<Double> createForDoubles(ModulesFile modulesFile, PrismComponent prismComponent) throws PrismException {
        Evaluator<Double> evaluator = Evaluator.forDouble();
        return new ModulesFileModelGenerator<Double>(modulesFile, evaluator, prismComponent);
    }

    public static ModulesFileModelGenerator<Function> createForRationalFunctions(ModulesFile modulesFile, String[] stringArray, String[] stringArray2, String[] stringArray3, PrismComponent prismComponent) throws PrismException {
        FunctionFactory functionFactory = FunctionFactory.create(stringArray, stringArray2, stringArray3, prismComponent.getSettings());
        return ModulesFileModelGenerator.createForRationalFunctions(modulesFile, functionFactory, prismComponent);
    }

    public static ModulesFileModelGenerator<Function> createForRationalFunctions(ModulesFile modulesFile, PrismComponent prismComponent) throws PrismException {
        if (modulesFile.getModelType().uncertain()) {
            throw new PrismNotSupportedException("Exact " + String.valueOf((Object)modulesFile.getModelType()) + "s are not supported");
        }
        String[] stringArray = new String[]{"dummy"};
        String[] stringArray2 = new String[]{"0"};
        String[] stringArray3 = new String[]{"1"};
        FunctionFactory functionFactory = FunctionFactory.create(stringArray, stringArray2, stringArray3, prismComponent.getSettings());
        return ModulesFileModelGenerator.createForRationalFunctions(modulesFile, functionFactory, prismComponent);
    }

    public static ModulesFileModelGenerator<Function> createForRationalFunctions(ModulesFile modulesFile, FunctionFactory functionFactory, PrismComponent prismComponent) throws PrismException {
        Evaluator<Function> evaluator = Evaluator.forRationalFunction(functionFactory);
        return new ModulesFileModelGenerator<Function>(modulesFile, evaluator, prismComponent);
    }

    public ModulesFileModelGenerator(ModulesFile modulesFile) throws PrismException {
        this(modulesFile, null);
    }

    public ModulesFileModelGenerator(ModulesFile modulesFile, PrismComponent prismComponent) throws PrismException {
        this(modulesFile, Evaluator.forDouble(), prismComponent);
    }

    public ModulesFileModelGenerator(ModulesFile modulesFile, Evaluator<Value> evaluator, PrismComponent prismComponent) throws PrismException {
        this.parent = prismComponent;
        this.eval = evaluator;
        if (modulesFile.getModelType().uncertain()) {
            this.evalInt = evaluator.createIntervalEvaluator();
        }
        if (modulesFile.getSystemDefn() != null) {
            throw new PrismNotSupportedException("The system...endsystem construct is not currently supported");
        }
        this.modulesFile = modulesFile;
        this.originalModulesFile = modulesFile;
        this.modelType = modulesFile.getModelType();
        this.mfConstants = modulesFile.getConstantValues();
        if (this.mfConstants != null) {
            this.initialise();
        }
        this.ec = new EvaluateContextState(this.mfConstants, new State(modulesFile.getNumVars()));
        this.ec.setEvaluationMode(evaluator.evalMode());
    }

    private void initialise() throws PrismException {
        this.modulesFile = (ModulesFile)this.modulesFile.deepCopy();
        final ConstantList constantList = this.modulesFile.getConstantList();
        this.modulesFile = (ModulesFile)this.modulesFile.accept(new ASTTraverseModify(){

            @Override
            public Object visit(ExpressionConstant expressionConstant) throws PrismLangException {
                String string = expressionConstant.getName();
                int n = ModulesFileModelGenerator.this.mfConstants.getIndexOf(string);
                if (n != -1) {
                    return new ExpressionLiteral(expressionConstant.getType(), ModulesFileModelGenerator.this.mfConstants.getValue(n));
                }
                int n2 = constantList.getConstantIndex(expressionConstant.getName());
                if (n2 != -1 && constantList.getConstant(n2) != null) {
                    return constantList.getConstant(n2).accept(this);
                }
                return expressionConstant;
            }
        });
        if (!this.eval.exact()) {
            this.modulesFile = (ModulesFile)this.modulesFile.simplify();
        }
        this.varList = this.modulesFile.createVarList();
        this.labelList = this.modulesFile.getLabelList();
        this.labelNames = this.labelList.getLabelNames();
        if (!this.modelType.uncertain()) {
            this.updater = new Updater<Value>(this.modulesFile, this.varList, this.eval, this.parent);
            this.transitionList = new TransitionList<Value>(this.eval);
        } else {
            this.updaterInt = new Updater<Interval<Interval<Value>>>(this.modulesFile, this.varList, this.evalInt, this.parent);
            this.transitionListInt = new TransitionList<Interval<Interval<Value>>>(this.evalInt);
        }
        this.transitionListBuilt = false;
        this.transitionListIntBuilt = false;
    }

    @Override
    public ModelType getModelType() {
        return this.modelType;
    }

    @Override
    public void setSomeUndefinedConstants(EvaluateContext evaluateContext) throws PrismException {
        this.modulesFile = (ModulesFile)this.originalModulesFile.deepCopy();
        this.modulesFile.setSomeUndefinedConstants(evaluateContext);
        this.mfConstants = this.modulesFile.getConstantValues();
        this.ec.setConstantValues(this.mfConstants);
        this.initialise();
    }

    @Override
    public Values getConstantValues() {
        return this.mfConstants;
    }

    @Override
    public boolean containsUnboundedVariables() {
        return this.modulesFile.containsUnboundedVariables();
    }

    @Override
    public int getNumVars() {
        return this.modulesFile.getNumVars();
    }

    @Override
    public List<String> getVarNames() {
        return this.modulesFile.getVarNames();
    }

    @Override
    public List<Type> getVarTypes() {
        return this.modulesFile.getVarTypes();
    }

    @Override
    public DeclarationType getVarDeclarationType(int n) throws PrismException {
        return this.modulesFile.getVarDeclarationType(n);
    }

    @Override
    public int getVarModuleIndex(int n) {
        return this.modulesFile.getVarModuleIndex(n);
    }

    @Override
    public String getModuleName(int n) {
        return this.modulesFile.getModuleName(n);
    }

    @Override
    public VarList createVarList() throws PrismException {
        return this.varList;
    }

    @Override
    public boolean isVarObservable(int n) {
        return this.modulesFile.isVarObservable(n);
    }

    @Override
    public int getNumLabels() {
        return this.labelList.size();
    }

    @Override
    public String getActionStringDescription() {
        return "Module/[action]";
    }

    @Override
    public List<String> getLabelNames() {
        return this.labelNames;
    }

    @Override
    public String getLabelName(int n) throws PrismException {
        return this.labelList.getLabelName(n);
    }

    @Override
    public int getLabelIndex(String string) {
        return this.labelList.getLabelIndex(string);
    }

    @Override
    public List<String> getObservableNames() {
        return this.modulesFile.getObservableNames();
    }

    @Override
    public Evaluator<Value> getEvaluator() {
        return this.eval;
    }

    @Override
    public Evaluator<Interval<Value>> getIntervalEvaluator() {
        return this.evalInt;
    }

    @Override
    public boolean hasSingleInitialState() throws PrismException {
        return this.modulesFile.getInitialStates() == null;
    }

    @Override
    public State getInitialState() throws PrismException {
        if (this.modulesFile.getInitialStates() == null) {
            return this.modulesFile.getDefaultInitialState();
        }
        return this.getInitialStates().get(0);
    }

    @Override
    public List<State> getInitialStates() throws PrismException {
        ArrayList<State> arrayList = new ArrayList<State>();
        if (this.modulesFile.getInitialStates() == null) {
            State state = this.modulesFile.getDefaultInitialState();
            arrayList.add(state);
        } else {
            Expression expression = this.modulesFile.getInitialStates();
            List<State> list = this.varList.getAllStates();
            for (State state : list) {
                if (!expression.evaluateBoolean(this.ec.setState(state))) continue;
                arrayList.add(state);
            }
        }
        return arrayList;
    }

    @Override
    public void exploreState(State state) throws PrismException {
        this.exploreState = state;
        this.transitionListBuilt = false;
        this.transitionListIntBuilt = false;
    }

    @Override
    public int getNumChoices() throws PrismException {
        return this.getTransitionList().getNumChoices();
    }

    @Override
    public int getNumTransitions() throws PrismException {
        return this.getTransitionList().getNumTransitions();
    }

    @Override
    public int getNumTransitions(int n) throws PrismException {
        return this.getTransitionList().getChoice(n).size();
    }

    @Override
    public int getChoiceIndexOfTransition(int n) throws PrismException {
        return this.getTransitionList().getChoiceIndexOfTransition(n);
    }

    @Override
    public int getChoiceOffsetOfTransition(int n) throws PrismException {
        return this.getTransitionList().getChoiceOffsetOfTransition(n);
    }

    @Override
    public int getTotalIndexOfTransition(int n, int n2) throws PrismException {
        return this.getTransitionList().getTotalIndexOfTransition(n, n2);
    }

    @Override
    public Object getTransitionAction(int n, int n2) throws PrismException {
        TransitionList<?> transitionList = this.getTransitionList();
        int n3 = transitionList.getTransitionModuleOrActionIndex(transitionList.getTotalIndexOfTransition(n, n2));
        return n3 < 0 ? null : this.modulesFile.getSynch(n3 - 1);
    }

    @Override
    public String getTransitionActionString(int n, int n2) throws PrismException {
        TransitionList<?> transitionList = this.getTransitionList();
        int n3 = transitionList.getTransitionModuleOrActionIndex(transitionList.getTotalIndexOfTransition(n, n2));
        return this.getDescriptionForModuleOrActionIndex(n3);
    }

    @Override
    public Object getChoiceAction(int n) throws PrismException {
        TransitionList<?> transitionList = this.getTransitionList();
        int n2 = transitionList.getChoiceModuleOrActionIndex(n);
        return n2 < 0 ? null : this.modulesFile.getSynch(n2 - 1);
    }

    @Override
    public String getChoiceActionString(int n) throws PrismException {
        TransitionList<?> transitionList = this.getTransitionList();
        int n2 = transitionList.getChoiceModuleOrActionIndex(n);
        return this.getDescriptionForModuleOrActionIndex(n2);
    }

    private String getDescriptionForModuleOrActionIndex(int n) {
        if (n < 0) {
            return this.modulesFile.getModuleName(-n - 1);
        }
        if (n > 0) {
            return "[" + this.modulesFile.getSynchs().get(n - 1) + "]";
        }
        return "?";
    }

    @Override
    public Expression getChoiceClockGuard(int n) throws PrismException {
        TransitionList<?> transitionList = this.getTransitionList();
        return transitionList.getChoice(n).getClockGuard();
    }

    @Override
    public Value getTransitionProbability(int n, int n2) throws PrismException {
        TransitionList<Value> transitionList = this.getTransitionListScalars();
        if (transitionList != null) {
            return transitionList.getChoice(n).getProbability(n2);
        }
        throw new PrismException("Cannot get scalar transition probability for " + String.valueOf((Object)this.getModelType()));
    }

    @Override
    public Value getChoiceProbabilitySum(int n) throws PrismException {
        TransitionList<Value> transitionList = this.getTransitionListScalars();
        if (transitionList != null) {
            return transitionList.getChoice(n).getProbabilitySum();
        }
        throw new PrismException("Cannot get scalar transition probability for " + String.valueOf((Object)this.getModelType()));
    }

    @Override
    public Value getProbabilitySum() throws PrismException {
        TransitionList<Value> transitionList = this.getTransitionListScalars();
        if (transitionList != null) {
            return transitionList.getProbabilitySum();
        }
        throw new PrismException("Cannot get scalar transition probability for " + String.valueOf((Object)this.getModelType()));
    }

    @Override
    public Interval<Value> getTransitionProbabilityInterval(int n, int n2) throws PrismException {
        TransitionList<Interval<Value>> transitionList = this.getTransitionListIntervals();
        if (transitionList != null) {
            return transitionList.getChoice(n).getProbability(n2);
        }
        throw new PrismException("Cannot get transition probability interval for " + String.valueOf((Object)this.getModelType()));
    }

    @Override
    public String getTransitionUpdateString(int n, int n2) throws PrismException {
        TransitionList<?> transitionList = this.getTransitionList();
        return transitionList.getTransitionUpdateString(transitionList.getTotalIndexOfTransition(n, n2), this.exploreState);
    }

    @Override
    public String getTransitionUpdateStringFull(int n, int n2) throws PrismException {
        TransitionList<?> transitionList = this.getTransitionList();
        return transitionList.getTransitionUpdateStringFull(transitionList.getTotalIndexOfTransition(n, n2));
    }

    @Override
    public State computeTransitionTarget(int n, int n2) throws PrismException {
        return this.getTransitionList().getChoice(n).computeTarget(n2, this.exploreState, this.varList);
    }

    @Override
    public boolean isLabelTrue(int n) throws PrismException {
        Expression expression = this.labelList.getLabel(n);
        return expression.evaluateBoolean(this.ec.setState(this.exploreState));
    }

    @Override
    public Expression getClockInvariant() throws PrismException {
        int n;
        if (this.invariant == null) {
            n = this.modulesFile.getNumModules();
            for (int i = 0; i < n; ++i) {
                Expression expression = this.modulesFile.getModule(i).getInvariant();
                if (expression == null) continue;
                this.invariant = this.invariant == null ? expression : Expression.And(this.invariant, expression);
            }
        }
        if (this.invariant == null) {
            return null;
        }
        n = this.varList.getNumVars();
        State state = new State(this.exploreState);
        for (int i = 0; i < n; ++i) {
            if (!(this.varList.getType(i) instanceof TypeClock)) continue;
            state.varValues[i] = null;
        }
        return (Expression)this.invariant.deepCopy().evaluatePartially(this.ec.setState(state)).simplify();
    }

    @Override
    public State getObservation(State state) throws PrismException {
        if (!this.modelType.partiallyObservable()) {
            return null;
        }
        int n = this.getNumObservables();
        State state2 = new State(n);
        for (int i = 0; i < n; ++i) {
            Object object = this.modulesFile.getObservable(i).getDefinition().evaluate(this.ec.setState(state));
            state2.setValue(i, object);
        }
        return state2;
    }

    @Override
    public Evaluator<Value> getRewardEvaluator() {
        return this.eval;
    }

    @Override
    public List<String> getRewardStructNames() {
        return this.modulesFile.getRewardStructNames();
    }

    @Override
    public boolean rewardStructHasStateRewards(int n) {
        return this.modulesFile.rewardStructHasStateRewards(n);
    }

    @Override
    public boolean rewardStructHasTransitionRewards(int n) {
        return this.modulesFile.rewardStructHasTransitionRewards(n);
    }

    @Override
    public Value getStateReward(int n, State state) throws PrismException {
        RewardStruct rewardStruct = this.modulesFile.getRewardStruct(n);
        int n2 = rewardStruct.getNumItems();
        Value Value2 = this.eval.zero();
        for (int i = 0; i < n2; ++i) {
            Expression expression;
            boolean bl;
            if (rewardStruct.getRewardStructItem(i).isTransitionReward() || !(bl = (expression = rewardStruct.getStates(i)).evaluateBoolean(this.ec.setState(state)))) continue;
            Value Value3 = this.eval.evaluate(rewardStruct.getReward(i), this.modulesFile.getConstantValues(), state);
            if (!this.eval.isSymbolic()) {
                if (!this.eval.isFinite(Value3)) {
                    throw new PrismLangException("Reward structure is not finite at state " + String.valueOf(state), rewardStruct.getReward(i));
                }
                if (!this.eval.geq(Value3, this.eval.zero())) {
                    throw new PrismLangException("Reward structure is negative + (" + String.valueOf(Value3) + ") at state " + String.valueOf(state), this.originalModulesFile.getRewardStruct(n).getReward(i));
                }
            }
            Value2 = this.eval.add(Value2, Value3);
        }
        return Value2;
    }

    @Override
    public Value getStateActionReward(int n, State state, Object object) throws PrismException {
        RewardStruct rewardStruct = this.modulesFile.getRewardStruct(n);
        int n2 = rewardStruct.getNumItems();
        Value Value2 = this.eval.zero();
        for (int i = 0; i < n2; ++i) {
            boolean bl;
            if (!rewardStruct.getRewardStructItem(i).isTransitionReward()) continue;
            Expression expression = rewardStruct.getStates(i);
            String string = rewardStruct.getSynch(i);
            if (!(object == null ? string.isEmpty() : object.equals(string)) || !(bl = expression.evaluateBoolean(this.ec.setState(state)))) continue;
            Value Value3 = this.eval.evaluate(rewardStruct.getReward(i), this.modulesFile.getConstantValues(), state);
            if (!this.eval.isSymbolic()) {
                if (!this.eval.isFinite(Value3)) {
                    throw new PrismLangException("Reward structure is not finite at state " + String.valueOf(state), rewardStruct.getReward(i));
                }
                if (!this.eval.geq(Value3, this.eval.zero())) {
                    throw new PrismLangException("Reward structure is negative + (" + String.valueOf(Value3) + ") at state " + String.valueOf(state), this.originalModulesFile.getRewardStruct(n).getReward(i));
                }
            }
            Value2 = this.eval.add(Value2, Value3);
        }
        return Value2;
    }

    private TransitionList<?> getTransitionList() throws PrismException {
        return this.modelType.uncertain() ? this.getTransitionListIntervals() : this.getTransitionListScalars();
    }

    private TransitionList<Value> getTransitionListScalars() throws PrismException {
        if (this.modelType.uncertain()) {
            return null;
        }
        if (!this.transitionListBuilt) {
            this.updater.calculateTransitions(this.exploreState, this.transitionList);
            this.transitionListBuilt = true;
        }
        return this.transitionList;
    }

    private TransitionList<Interval<Value>> getTransitionListIntervals() throws PrismException {
        if (!this.modelType.uncertain()) {
            return null;
        }
        if (!this.transitionListIntBuilt) {
            this.updaterInt.calculateTransitions(this.exploreState, this.transitionListInt);
            this.transitionListIntBuilt = true;
        }
        return this.transitionListInt;
    }
}

