/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;

public class TableResizer
extends MouseInputAdapter {
    private int col;
    private boolean colSel;
    private boolean colSelectionAllowed;
    private int startWidth;
    private int startX;
    private JTable table;
    private boolean active;
    private boolean rowSelectionAllowed;
    private int row;
    private int startY;
    private int startHeight;
    private static final int PIXELS = 5;
    private Cursor lastCursor;
    private static Cursor S_resizeCursor = Cursor.getPredefinedCursor(9);
    private static Cursor E_resizeCursor = Cursor.getPredefinedCursor(11);

    public TableResizer(JTable jTable) {
        this.table = jTable;
        this.table.addMouseListener(this);
        this.table.addMouseMotionListener(this);
        this.row = -1;
        this.col = -1;
    }

    public void done() {
        if (this.table == null) {
            return;
        }
        this.table.removeMouseListener(this);
        this.table.removeMouseMotionListener(this);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (this.isMouseOverColMargin(point)) {
            if (this.lastCursor == null) {
                this.lastCursor = this.table.getCursor();
            }
            this.table.setCursor(E_resizeCursor);
        } else {
            this.table.setCursor(this.lastCursor);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (this.isMouseOverColMargin(point)) {
            this.active = true;
            this.startX = point.x;
            this.startWidth = this.table.getColumnModel().getColumn(this.col).getWidth();
            this.colSelectionAllowed = this.table.getColumnSelectionAllowed();
            this.table.setColumnSelectionAllowed(false);
            this.colSel = true;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (!this.active) {
            return;
        }
        if (this.colSel) {
            int n = mouseEvent.getX();
            if ((n = Math.max(10, n)) > this.table.getWidth() - 10) {
                n = this.table.getWidth() - 10;
            }
            this.table.getColumnModel().getColumn(this.col).setMinWidth(n);
            this.table.getColumnModel().getColumn(this.col).setMaxWidth(n);
            this.table.getColumnModel().getColumn(this.col).setPreferredWidth(n);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.active) {
            return;
        }
        if (this.colSel) {
            this.table.setColumnSelectionAllowed(this.colSelectionAllowed);
            this.col = -1;
            this.colSel = false;
        }
        this.active = false;
    }

    private boolean isMouseOverColMargin(Point point) {
        if (!this.table.isEnabled()) {
            return false;
        }
        this.row = this.table.rowAtPoint(point);
        this.col = this.table.columnAtPoint(point);
        if (this.row == -1 || this.col == -1) {
            return false;
        }
        Rectangle rectangle = this.table.getCellRect(this.row, this.col, true);
        return point.x >= rectangle.x + rectangle.width - 5;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Test");
        Object[][] objectArray = new String[][]{{"a", "b"}, {"c", "d"}, {"e", "f"}};
        Object[] objectArray2 = new String[]{"1", "2"};
        JTable jTable = new JTable(objectArray, objectArray2);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)jTable, "Center");
        jTable.setPreferredSize(new Dimension(200, 200));
        TableResizer tableResizer = new TableResizer(jTable);
        jTable.addMouseListener(tableResizer);
        jTable.addMouseMotionListener(tableResizer);
        jTable.setAutoResizeMode(2);
        jFrame.pack();
        jFrame.show();
    }
}

