/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.util.StringTokenizer;
import settings.NumericConstraint;
import settings.SettingException;

public class RangeConstraint
extends NumericConstraint {
    private double lower;
    private double upper;
    private boolean inclusiveLower;
    private boolean inclusiveUpper;

    public RangeConstraint(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        if (!string.startsWith(",")) {
            if (n == 2) {
                try {
                    this.lower = Double.parseDouble(stringTokenizer.nextToken());
                    this.upper = Double.parseDouble(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    this.lower = Double.NEGATIVE_INFINITY;
                    this.upper = Double.POSITIVE_INFINITY;
                }
            } else if (n == 1) {
                try {
                    this.lower = Double.parseDouble(stringTokenizer.nextToken());
                    this.upper = Double.POSITIVE_INFINITY;
                }
                catch (NumberFormatException numberFormatException) {
                    this.lower = Double.NEGATIVE_INFINITY;
                    this.upper = Double.POSITIVE_INFINITY;
                }
            } else {
                this.lower = Double.NEGATIVE_INFINITY;
                this.upper = Double.POSITIVE_INFINITY;
            }
        } else {
            try {
                this.upper = Double.parseDouble(stringTokenizer.nextToken());
                this.lower = Double.NEGATIVE_INFINITY;
            }
            catch (NumberFormatException numberFormatException) {
                this.lower = Double.NEGATIVE_INFINITY;
                this.upper = Double.POSITIVE_INFINITY;
            }
        }
        this.inclusiveLower = true;
        this.inclusiveUpper = true;
    }

    public RangeConstraint(double d, double d2, boolean bl, boolean bl2) {
        this.lower = d;
        this.upper = d2;
        this.inclusiveLower = bl;
        this.inclusiveUpper = bl2;
    }

    public RangeConstraint(int n, int n2, boolean bl, boolean bl2) {
        this.lower = n;
        this.upper = n2;
        this.inclusiveLower = bl;
        this.inclusiveUpper = bl2;
    }

    @Override
    public void checkValueDouble(double d) throws SettingException {
        if (this.inclusiveLower) {
            if (d < this.lower) {
                throw new SettingException("The value: " + d + " should be >=" + this.lower);
            }
        } else if (d <= this.lower) {
            throw new SettingException("The value: " + d + " should be >" + this.lower);
        }
        if (this.inclusiveUpper) {
            if (d > this.upper) {
                throw new SettingException("The value: " + d + "should be <=" + this.upper);
            }
        } else if (d >= this.upper) {
            throw new SettingException("The value: " + d + "should be <" + this.upper);
        }
    }

    @Override
    public void checkValueInteger(int n) throws SettingException {
        if (this.inclusiveLower) {
            if ((double)n < this.lower) {
                throw new SettingException("The value: " + n + " should be >=" + (int)this.lower);
            }
        } else if ((double)n <= this.lower) {
            throw new SettingException("The value: " + n + " should be >" + (int)this.lower);
        }
        if (this.inclusiveUpper) {
            if ((double)n > this.upper) {
                throw new SettingException("The value: " + n + "should be <=" + (int)this.upper);
            }
        } else if ((double)n >= this.upper) {
            throw new SettingException("The value: " + n + "should be <" + (int)this.upper);
        }
    }

    @Override
    public void checkValueLong(long l) throws SettingException {
        if (this.inclusiveLower) {
            if ((double)l < this.lower) {
                throw new SettingException("The value: " + l + " should be >=" + (long)this.lower);
            }
        } else if ((double)l <= this.lower) {
            throw new SettingException("The value: " + l + " should be >" + (long)this.lower);
        }
        if (this.inclusiveUpper) {
            if ((double)l > this.upper) {
                throw new SettingException("The value: " + l + "should be <=" + (long)this.upper);
            }
        } else if ((double)l >= this.upper) {
            throw new SettingException("The value: " + l + "should be <" + (long)this.upper);
        }
    }
}

