/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import settings.FontChooser;
import settings.FontColorPair;
import settings.Setting;
import settings.SettingEditor;

public class FontColorEditor
implements SettingEditor,
ActionListener,
FocusListener {
    private JLabel renderer;
    private JPanel panel;
    private Font font = new Font("monospaced", 2, 12);
    private JButton button;
    private JTable lastTable = null;
    private int tableRow = -1;
    private int tableCol = -1;
    private JPanel blank1;
    private boolean dialogFocus = false;
    private boolean modified = false;

    public FontColorEditor() {
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.renderer = new JLabel();
        this.renderer = new JLabel();
        this.blank1 = new JPanel();
        this.button = new JButton("...");
        this.button.setFont(new Font("serif", 0, 7));
        this.panel.add((Component)this.renderer, "Center");
        this.blank1.setLayout(new FlowLayout(1, 0, 0));
        this.blank1.setPreferredSize(new Dimension(18, 2));
        this.button.setPreferredSize(new Dimension(16, 12));
        this.blank1.add(this.button);
        this.panel.add((Component)this.blank1, "East");
        this.button.addActionListener(this);
        this.button.addFocusListener(this);
    }

    @Override
    public Object getEditorValue() {
        if (this.modified) {
            this.modified = false;
            return new FontColorPair(this.renderer.getFont(), this.renderer.getForeground());
        }
        return "$%^&*NOTCHANGED*&^%$";
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Setting setting, Object object, boolean bl, int n, int n2) {
        ArrayList arrayList;
        if (bl) {
            this.renderer.setForeground(jTable.getSelectionForeground());
            this.renderer.setBackground(jTable.getSelectionBackground());
            this.panel.setBackground(jTable.getSelectionBackground());
            this.blank1.setBackground(jTable.getSelectionBackground());
            this.button.setBackground(jTable.getSelectionBackground());
        } else {
            this.renderer.setForeground(jTable.getForeground());
            this.renderer.setBackground(jTable.getBackground());
            this.panel.setBackground(jTable.getBackground());
            this.blank1.setBackground(jTable.getBackground());
            this.button.setBackground(jTable.getBackground());
        }
        this.panel.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        if (object instanceof FontColorPair) {
            FontColorPair fontColorPair = (FontColorPair)object;
            this.renderer.setForeground(fontColorPair.c);
            this.renderer.setText(fontColorPair.f.getName() + " " + fontColorPair.f.getSize());
            this.renderer.setFont(fontColorPair.f);
            int n3 = Math.max(jTable.getRowHeight(), fontColorPair.f.getSize() + 3);
            if (n3 != jTable.getRowHeight(n)) {
                jTable.setRowHeight(n, n3);
            }
        } else if (object instanceof ArrayList && (arrayList = (ArrayList)object).size() > 0) {
            int n4;
            FontColorPair fontColorPair = null;
            boolean bl2 = true;
            for (n4 = 0; n4 < arrayList.size(); ++n4) {
                if (!(arrayList.get(n4) instanceof FontColorPair)) continue;
                FontColorPair fontColorPair2 = (FontColorPair)arrayList.get(n4);
                if (fontColorPair != null) {
                    if (!fontColorPair2.equals(fontColorPair)) {
                        bl2 = false;
                        break;
                    }
                    fontColorPair = fontColorPair2;
                    continue;
                }
                fontColorPair = fontColorPair2;
            }
            if (bl2) {
                this.renderer.setForeground(fontColorPair.c);
                this.renderer.setText(fontColorPair.f.getName() + " " + fontColorPair.f.getSize());
                this.renderer.setFont(fontColorPair.f);
                n4 = Math.max(jTable.getRowHeight(), fontColorPair.f.getSize() + 3);
                if (n4 != jTable.getRowHeight(n)) {
                    jTable.setRowHeight(n, n4);
                }
            } else {
                this.renderer.setText("(Different values)");
                this.renderer.setFont(new Font("monospaced", 2, 12));
                n4 = Math.max(jTable.getRowHeight(), fontColorPair.f.getSize() + 3);
                if (n4 != jTable.getRowHeight(n)) {
                    jTable.setRowHeight(n, n4);
                }
            }
        }
        this.lastTable = jTable;
        this.tableRow = n;
        this.tableCol = n2;
        return this.panel;
    }

    @Override
    public void stopEditing() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.dialogFocus = true;
        FontColorPair fontColorPair = FontChooser.getFont(new Frame(), this.renderer.getFont(), this.renderer.getForeground(), this.font, Color.black);
        if (fontColorPair != null) {
            this.renderer.setForeground(fontColorPair.c);
            this.renderer.setText(fontColorPair.f.getName() + " " + fontColorPair.f.getSize());
            this.renderer.setFont(fontColorPair.f);
            if (this.dialogFocus) {
                this.dialogFocus = false;
                if (this.lastTable != null) {
                    this.lastTable.editingStopped(new ChangeEvent(this));
                }
            } else if (this.lastTable != null) {
                this.lastTable.setValueAt(this.getEditorValue(), this.tableRow, this.tableCol);
                int n = Math.max(this.lastTable.getRowHeight(), fontColorPair.f.getSize() + 3);
                if (n != this.lastTable.getRowHeight(this.tableRow)) {
                    this.lastTable.setRowHeight(this.tableRow, n);
                }
            }
            this.modified = true;
        }
        if (this.lastTable != null) {
            this.lastTable.editingStopped(new ChangeEvent(this));
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.dialogFocus = false;
    }
}

