/*
 * Decompiled with CFR 0.152.
 */
package pta;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import parser.ParserUtils;
import parser.Values;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionVar;
import parser.type.TypeClock;
import parser.type.TypeInt;
import prism.PrismLangException;
import pta.Constraint;
import pta.DB;
import pta.DBM;
import pta.PTA;
import pta.Zone;

public class PTAUtils {
    public static void checkIsSimpleClockConstraint(Expression expression) throws PrismLangException {
        int n = 0;
        if (!Expression.isRelOp(expression)) {
            throw new PrismLangException("Invalid clock constraint \"" + String.valueOf(expression) + "\"", expression);
        }
        ExpressionBinaryOp expressionBinaryOp = (ExpressionBinaryOp)expression;
        int n2 = expressionBinaryOp.getOperator();
        Expression expression2 = expressionBinaryOp.getOperand1();
        Expression expression3 = expressionBinaryOp.getOperand2();
        if (!ExpressionBinaryOp.isRelOp(n2)) {
            throw new PrismLangException("Can't use operator " + expressionBinaryOp.getOperatorSymbol() + " in clock constraint \"" + String.valueOf(expression) + "\"", expression);
        }
        if (n2 == 6) {
            throw new PrismLangException("Can't use negation in clock constraint \"" + String.valueOf(expression) + "\"", expression);
        }
        if (expression2.getType() instanceof TypeClock) {
            if (!(expression2 instanceof ExpressionVar)) {
                throw new PrismLangException("Invalid clock expression \"" + String.valueOf(expression2) + "\"", expression2);
            }
            ++n;
        } else if (expression2.getType() instanceof TypeInt) {
            if (!expression2.isConstant()) {
                throw new PrismLangException("Invalid clock constraint \"" + String.valueOf(expression) + "\"", expression);
            }
        } else {
            throw new PrismLangException("Invalid clock constraint \"" + String.valueOf(expression) + "\"", expression);
        }
        if (expression3.getType() instanceof TypeClock) {
            if (!(expression3 instanceof ExpressionVar)) {
                throw new PrismLangException("Invalid clock expression \"" + String.valueOf(expression3) + "\"", expression3);
            }
            ++n;
        } else if (expression3.getType() instanceof TypeInt) {
            if (!expression3.isConstant()) {
                throw new PrismLangException("Invalid clock constraint \"" + String.valueOf(expression) + "\"", expression);
            }
        } else {
            throw new PrismLangException("Invalid clock constraint \"" + String.valueOf(expression) + "\"", expression);
        }
        if (n == 0) {
            throw new PrismLangException("Invalid clock constraint \"" + String.valueOf(expression) + "\"", expression);
        }
    }

    public static List<Constraint> exprToConstraint(Expression expression, Values values, PTA pTA) throws PrismLangException {
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        if (!Expression.isRelOp(expression)) {
            throw new PrismLangException("Invalid clock constraint \"" + String.valueOf(expression) + "\"", expression);
        }
        ExpressionBinaryOp expressionBinaryOp = (ExpressionBinaryOp)expression;
        Expression expression2 = expressionBinaryOp.getOperand1();
        Expression expression3 = expressionBinaryOp.getOperand2();
        if (expression2.getType() instanceof TypeClock) {
            if (expression3.getType() instanceof TypeClock) {
                int n = pTA.getClockIndex(((ExpressionVar)expression2).getName());
                if (n < 0) {
                    throw new PrismLangException("Unknown clock \"" + ((ExpressionVar)expression2).getName() + "\"", expression);
                }
                int n2 = pTA.getClockIndex(((ExpressionVar)expression3).getName());
                if (n2 < 0) {
                    throw new PrismLangException("Unknown clock \"" + ((ExpressionVar)expression3).getName() + "\"", expression);
                }
                switch (expressionBinaryOp.getOperator()) {
                    case 5: {
                        arrayList.add(Constraint.buildXGeqY(n, n2));
                        arrayList.add(Constraint.buildXLeqY(n, n2));
                        break;
                    }
                    case 6: {
                        throw new PrismLangException("Can't use negation in clock constraint \"" + String.valueOf(expression) + "\"", expression);
                    }
                    case 7: {
                        arrayList.add(Constraint.buildXGtY(n, n2));
                        break;
                    }
                    case 8: {
                        arrayList.add(Constraint.buildXGeqY(n, n2));
                        break;
                    }
                    case 9: {
                        arrayList.add(Constraint.buildXLtY(n, n2));
                        break;
                    }
                    case 10: {
                        arrayList.add(Constraint.buildXLeqY(n, n2));
                    }
                }
                return arrayList;
            }
            int n = pTA.getClockIndex(((ExpressionVar)expression2).getName());
            if (n < 0) {
                throw new PrismLangException("Unknown clock \"" + ((ExpressionVar)expression2).getName() + "\"", expression);
            }
            int n3 = expression3.evaluateInt(values);
            switch (expressionBinaryOp.getOperator()) {
                case 5: {
                    arrayList.add(Constraint.buildGeq(n, n3));
                    arrayList.add(Constraint.buildLeq(n, n3));
                    break;
                }
                case 6: {
                    throw new PrismLangException("Can't use negation in clock constraint \"" + String.valueOf(expression) + "\"", expression);
                }
                case 7: {
                    arrayList.add(Constraint.buildGt(n, n3));
                    break;
                }
                case 8: {
                    arrayList.add(Constraint.buildGeq(n, n3));
                    break;
                }
                case 9: {
                    arrayList.add(Constraint.buildLt(n, n3));
                    break;
                }
                case 10: {
                    arrayList.add(Constraint.buildLeq(n, n3));
                }
            }
            return arrayList;
        }
        if (expression3.getType() instanceof TypeClock) {
            int n = pTA.getClockIndex(((ExpressionVar)expression3).getName());
            if (n < 0) {
                throw new PrismLangException("Unknown clock \"" + ((ExpressionVar)expression3).getName() + "\"", expression);
            }
            int n4 = expression2.evaluateInt(values);
            switch (expressionBinaryOp.getOperator()) {
                case 5: {
                    arrayList.add(Constraint.buildGeq(n, n4));
                    arrayList.add(Constraint.buildLeq(n, n4));
                    break;
                }
                case 6: {
                    throw new PrismLangException("Can't use negation in clock constraint \"" + String.valueOf(expression) + "\"", expression);
                }
                case 7: {
                    arrayList.add(Constraint.buildLt(n, n4));
                    break;
                }
                case 8: {
                    arrayList.add(Constraint.buildLeq(n, n4));
                    break;
                }
                case 9: {
                    arrayList.add(Constraint.buildGt(n, n4));
                    break;
                }
                case 10: {
                    arrayList.add(Constraint.buildGeq(n, n4));
                }
            }
            return arrayList;
        }
        throw new PrismLangException("Invalid clock constraint \"" + String.valueOf(expression) + "\"", expression);
    }

    public static void exprConjToConstraintConsumer(Expression expression, Values values, PTA pTA, Consumer<Constraint> consumer) throws PrismLangException {
        List<Expression> list = ParserUtils.splitConjunction(expression);
        for (Expression expression2 : list) {
            if (Expression.isTrue(expression2) || Expression.isFalse(expression2)) continue;
            PTAUtils.checkIsSimpleClockConstraint(expression2);
        }
        for (Expression expression2 : list) {
            if (Expression.isTrue(expression2)) continue;
            for (Constraint constraint : PTAUtils.exprToConstraint(expression2, values, pTA)) {
                consumer.accept(constraint);
            }
        }
    }

    public static List<Constraint> exprConjToConstraintList(Expression expression, Values values, PTA pTA) throws PrismLangException {
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        PTAUtils.exprConjToConstraintConsumer(expression, values, pTA, constraint -> arrayList.add((Constraint)constraint));
        return arrayList;
    }

    public static Zone regionForPoint(double[] dArray, PTA pTA) {
        if (dArray[0] >= 2.0 && dArray[0] <= 2.2) {
            System.out.println("hmm");
        }
        int n = pTA.getNumClocks();
        DBM dBM = DBM.createTrue(pTA);
        for (int i = 1; i <= n; ++i) {
            double d = dArray[i - 1];
            int n2 = (int)Math.floor(d);
            int n3 = (int)Math.ceil(d);
            if (d == (double)n2) {
                ((Zone)dBM).addConstraint(Constraint.buildGeq(i, n2));
            } else {
                ((Zone)dBM).addConstraint(Constraint.buildGt(i, n2));
            }
            if (d == (double)n3) {
                ((Zone)dBM).addConstraint(Constraint.buildLeq(i, n3));
            } else {
                ((Zone)dBM).addConstraint(Constraint.buildLt(i, n3));
            }
            for (int j = 1; j <= n; ++j) {
                if (i == j) continue;
                double d2 = d - dArray[j - 1];
                int n4 = (int)Math.floor(d2);
                int n5 = (int)Math.ceil(d2);
                if (d2 == (double)n4) {
                    ((Zone)dBM).addConstraint(j, i, DB.createLeq(-n4));
                } else {
                    ((Zone)dBM).addConstraint(j, i, DB.createLt(-n4));
                }
                if (d2 == (double)n5) {
                    ((Zone)dBM).addConstraint(i, j, DB.createLeq(n5));
                    continue;
                }
                ((Zone)dBM).addConstraint(i, j, DB.createLt(n5));
            }
        }
        return dBM;
    }
}

