/*
 * Decompiled with CFR 0.152.
 */
package pta;

import explicit.MDP;
import explicit.MDPModelChecker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import prism.PrismException;
import pta.Constraint;
import pta.ForwardsReach;
import pta.PTA;
import pta.PTAAbstractRefine;
import pta.PTAParallel;
import pta.ReachabilityGraph;

public class PTAModelCheckerCL {
    ArrayList<String> ptaFiles;
    String targetLocString;
    String targetConstraintString;
    boolean min = false;
    boolean exportPTA = false;
    boolean mdpReach = false;
    String targetLocRegexp;
    Constraint targetConstraint;
    BitSet targetLocs;
    PTA pta;
    PTA pta2;
    PTAAbstractRefine abstractRefine;

    public static void main(String[] stringArray) {
        new PTAModelCheckerCL().go(stringArray);
    }

    public void go(String[] stringArray) {
        try {
            int n;
            this.abstractRefine = new PTAAbstractRefine(null);
            this.parseCommandLineArgs(stringArray);
            this.targetLocString = this.targetLocString.replaceAll("['\"]", "");
            this.targetConstraintString = this.targetConstraintString.replaceAll("['\"]", "");
            String[] stringArray2 = this.targetLocString.split(",");
            this.targetLocRegexp = "";
            for (String string : stringArray2) {
                if (!"".equals(this.targetLocRegexp)) {
                    this.targetLocRegexp = this.targetLocRegexp + "|";
                }
                this.targetLocRegexp = this.targetLocRegexp + "(" + string.replaceAll("\\*", "[a-zA-Z0-9_]*") + ")";
            }
            System.out.print("Command:");
            for (n = 0; n < stringArray.length; ++n) {
                System.out.print(" " + stringArray[n]);
            }
            System.out.println();
            this.abstractRefine.printSettings();
            this.processPTAFiles();
            System.out.println("\nBuilding PTA from \"" + this.ptaFiles.get(0) + "\"");
            this.pta = PTA.buildPTAFromDesFile(this.ptaFiles.get(0));
            System.out.println(this.pta.infoString());
            for (n = 1; n < this.ptaFiles.size(); ++n) {
                System.out.println("Building PTA from \"" + this.ptaFiles.get(n) + "\"");
                this.pta2 = PTA.buildPTAFromDesFile(this.ptaFiles.get(n));
                System.out.println(this.pta2.infoString());
                this.pta = new PTAParallel().compose(this.pta, this.pta2);
            }
            System.out.println("Final PTA: " + this.pta.infoString());
            this.pta.check();
            if (this.exportPTA) {
                this.pta.writeToDesFile("par.des");
            }
            if (this.targetConstraintString.equals("true")) {
                this.targetConstraint = null;
            } else {
                int n2 = this.pta.getOrAddClock(this.targetConstraintString.substring(0, 1));
                this.targetConstraint = this.targetConstraintString.indexOf(">=", 1) != -1 ? Constraint.buildGeq(n2, Integer.parseInt(this.targetConstraintString.substring(3))) : (this.targetConstraintString.indexOf("<=", 1) != -1 ? Constraint.buildLeq(n2, Integer.parseInt(this.targetConstraintString.substring(3))) : (this.targetConstraintString.indexOf(">", 1) != -1 ? Constraint.buildGt(n2, Integer.parseInt(this.targetConstraintString.substring(2))) : (this.targetConstraintString.indexOf("<", 1) != -1 ? Constraint.buildLt(n2, Integer.parseInt(this.targetConstraintString.substring(2))) : null)));
            }
            int n3 = this.pta.getNumLocations();
            this.targetLocs = new BitSet(n3);
            boolean bl = false;
            for (n = 0; n < n3; ++n) {
                if (!((String)this.pta.getLocationName(n)).matches(this.targetLocRegexp)) continue;
                this.targetLocs.set(n);
                bl |= true;
            }
            if (!bl) {
                throw new PrismException("No matches for PTA target location specification " + this.targetLocString);
            }
            System.out.print("\nTarget locations: " + this.targetLocString);
            System.out.println(" (" + this.targetLocs.cardinality() + " locations)");
            System.out.println("Target constraint: " + (this.targetConstraint == null ? "true" : this.targetConstraint.toString(this.pta)));
            if (!this.mdpReach) {
                this.abstractRefine.forwardsReachAbstractRefine(this.pta, this.targetLocs, this.targetConstraint, this.min);
            } else {
                ForwardsReach forwardsReach = new ForwardsReach();
                ReachabilityGraph reachabilityGraph = forwardsReach.buildForwardsGraph(this.pta, this.targetLocs, this.targetConstraint);
                MDP mDP = reachabilityGraph.buildMDP(forwardsReach.getInitialStates());
                new MDPModelChecker(null).computeReachProbs(mDP, forwardsReach.getTarget(), this.min);
            }
        }
        catch (PrismException prismException) {
            System.err.println("\nError: " + prismException.getMessage());
            System.exit(1);
        }
    }

    private void parseCommandLineArgs(String[] stringArray) throws PrismException {
        if (stringArray.length < 3) {
            System.err.println("Usage: ptamc [options] <des files> <target loc> <target constraint>");
            System.exit(1);
        }
        this.ptaFiles = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.charAt(0) == '-') {
                if ((string = string.substring(1)).equals("min")) {
                    this.min = true;
                    continue;
                }
                if (string.equals("max")) {
                    this.min = false;
                    continue;
                }
                if (string.equals("exportpta")) {
                    this.exportPTA = true;
                    continue;
                }
                if (string.equals("mdp")) {
                    this.mdpReach = true;
                    continue;
                }
                this.abstractRefine.parseOption(string);
                continue;
            }
            this.ptaFiles.add(string);
        }
        this.targetLocString = this.ptaFiles.get(this.ptaFiles.size() - 2);
        this.targetConstraintString = this.ptaFiles.get(this.ptaFiles.size() - 1);
        this.ptaFiles.remove(this.ptaFiles.size() - 1);
        this.ptaFiles.remove(this.ptaFiles.size() - 1);
    }

    private void processPTAFiles() throws PrismException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (String string : this.ptaFiles) {
            if (string.endsWith(".deslist")) {
                try {
                    String string2;
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if ((string2 = string2.trim()).equals("")) continue;
                        if (new File(string2).isAbsolute()) {
                            arrayList.add(string2);
                            continue;
                        }
                        if (new File(string).getParent() != null) {
                            arrayList.add(new File(string).getParent() + File.separator + string2);
                            continue;
                        }
                        arrayList.add(string2);
                    }
                    continue;
                }
                catch (IOException iOException) {
                    throw new PrismException("Could not read from file \"" + string + "\"");
                }
            }
            arrayList.add(string);
        }
        this.ptaFiles = arrayList;
    }
}

